/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class ReportDataServiceSelection {
    private String m_searchPath;
    private String m_original_selectionSpec;
    private boolean m_metricWatchRule;
    private ArrayList performancePatternThresholds = new ArrayList();
    private ArrayList performancePatternThresholdsIncludes = new ArrayList();
    private ArrayList performancePatternValues = new ArrayList();
    private String m_measure_value;
    private boolean m_measure_value_inclusive = false;
    private String m_measure_value1;
    private boolean m_measure_value_inclusive1 = false;
    private String m_measure_operator;
    private String m_selectionXML;
    private String m_contentLocale;
    private String m_burstID;
    private boolean m_case_insensitive = false;
    private static final String M_MEASURE_VALUE_XPATH = "/selection/measure_value";
    private static final String M_MEASURE_VALUE1_XPATH = "/selection/measure_value1";
    private static final String M_MEASURE_VALUE_INCLUSIVE_XPATH = "/selection/measure_value_inclusive";
    private static final String M_MEASURE_VALUE_INCLUSIVE1_XPATH = "/selection/measure_value_inclusive1";
    private static final String M_OPERATION_XPATH = "/selection/operation";
    private static final String M_SELECTION_XPATH = "/selection/selections";
    private static final String M_LOCALE_XPATH = "/selection/selections/@contentLocale";
    private static final String M_BURST_KEY_XPATH = "/selection/selections/burst-context";
    private static final String M_CASE_INSENSITIVE_XPATH = "/selection/case_insensitive";
    private static final String M_VERSION_TYPE = "/selection/version";
    private static final String M_SUB_TYPE_XPATH = "/selection/type";
    private static final String M_SUB_PERFPATTERN_XPATH = "/selection/perfPattern";
    private static final String M_SUB_PERFPATTERN_XPATH_STUB = "/selection/";
    public static final String M_PERFPATTERN_GOOD = "good";
    public static final String M_PERFPATTERN_AVERAGE = "average";
    public static final String M_PERFPATTERN_POOR = "poor";

    public ReportDataServiceSelection(String selectionsXML, String searchPath) {
        this.m_original_selectionSpec = selectionsXML;
        this.m_searchPath = searchPath;
    }

    public void process() throws AgentServiceException {
        SAXReader xmlReader = new SAXReader();
        StringReader stringReader = new StringReader(this.m_original_selectionSpec);
        Document doc = null;
        try {
            doc = xmlReader.read((Reader)stringReader);
        }
        catch (DocumentException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_CANNOT_PARSE_SELECTION_SPEC, new Object[]{this.m_searchPath, e.getLocalizedMessage()});
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_CANNOT_PARSE_SELECTION_SPEC, new Object[]{this.m_searchPath, e.getLocalizedMessage()});
        }
        String versionString = this.getStringValue(doc, M_VERSION_TYPE, AsvI18NCode.MSG_ASV_MISSING_VERSION);
        int version = 0;
        try {
            version = Integer.parseInt(versionString.substring(0, 1));
        }
        catch (NumberFormatException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_INVALID_VERSION, new Object[]{this.m_searchPath});
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_INVALID_VERSION, new Object[]{this.m_searchPath});
        }
        String sub_type = "nonMetric";
        if (version == 2) {
            sub_type = this.getStringValue(doc, M_SUB_TYPE_XPATH, AsvI18NCode.MSG_ASV_MISSING_METRIC_TYPE);
        }
        this.m_metricWatchRule = sub_type.equalsIgnoreCase("metric");
        if (this.m_metricWatchRule) {
            this.processMetricSelection(doc);
        } else {
            this.processNonMetricSelection(doc);
        }
        Node selectionsNode = doc.selectSingleNode(M_SELECTION_XPATH);
        if (selectionsNode == null) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_MISSING_SELECTION, new Object[]{this.m_searchPath});
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_MISSING_SELECTION, new Object[]{this.m_searchPath});
        }
        StringWriter stringWriter = new StringWriter();
        XMLWriter writer = new XMLWriter((Writer)stringWriter);
        try {
            writer.write(selectionsNode);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.m_selectionXML = stringWriter.getBuffer().toString();
        this.m_contentLocale = this.getStringValue(doc, M_LOCALE_XPATH, AsvI18NCode.MSG_ASV_MISSING_LOCALE);
        this.m_burstID = this.getStringValue(doc, M_BURST_KEY_XPATH, AsvI18NCode.MSG_ASV_MISSING_BURST_KEY);
    }

    private void processMetricSelection(Document doc) throws AgentServiceException {
        String performancePattern = this.getStringValue(doc, M_SUB_PERFPATTERN_XPATH, AsvI18NCode.MSG_ASV_MISSING_PERFORMANCE_PATTERN);
        if (performancePattern.equals("perfPattern_high")) {
            this.performancePatternThresholds.add(this.getStringValue(doc, "/selection/perfPattern_high_0", AsvI18NCode.MSG_ASV_MISSING_PERFORMANCE_PATTERN_VALUE));
            this.performancePatternThresholds.add(this.getStringValue(doc, "/selection/perfPattern_high_1", AsvI18NCode.MSG_ASV_MISSING_PERFORMANCE_PATTERN_VALUE));
            this.performancePatternThresholdsIncludes.add(this.getStringValue(doc, "/selection/perfPattern_high_0_include", AsvI18NCode.MSG_ASV_MISSING_PERFORMANCE_PATTERN_VALUE_INCLUDE));
            this.performancePatternThresholdsIncludes.add(this.getStringValue(doc, "/selection/perfPattern_high_1_include", AsvI18NCode.MSG_ASV_MISSING_PERFORMANCE_PATTERN_VALUE_INCLUDE));
            this.performancePatternValues.add(M_PERFPATTERN_POOR);
            this.performancePatternValues.add(M_PERFPATTERN_AVERAGE);
            this.performancePatternValues.add(M_PERFPATTERN_GOOD);
        } else if (performancePattern.equals("perfPattern_medium")) {
            this.performancePatternThresholds.add(this.getStringValue(doc, "/selection/perfPattern_medium_0", AsvI18NCode.MSG_ASV_MISSING_PERFORMANCE_PATTERN_VALUE));
            this.performancePatternThresholds.add(this.getStringValue(doc, "/selection/perfPattern_medium_1", AsvI18NCode.MSG_ASV_MISSING_PERFORMANCE_PATTERN_VALUE));
            this.performancePatternThresholds.add(this.getStringValue(doc, "/selection/perfPattern_medium_2", AsvI18NCode.MSG_ASV_MISSING_PERFORMANCE_PATTERN_VALUE));
            this.performancePatternThresholds.add(this.getStringValue(doc, "/selection/perfPattern_medium_3", AsvI18NCode.MSG_ASV_MISSING_PERFORMANCE_PATTERN_VALUE));
            this.performancePatternThresholdsIncludes.add(this.getStringValue(doc, "/selection/perfPattern_medium_0_include", AsvI18NCode.MSG_ASV_MISSING_PERFORMANCE_PATTERN_VALUE_INCLUDE));
            this.performancePatternThresholdsIncludes.add(this.getStringValue(doc, "/selection/perfPattern_medium_1_include", AsvI18NCode.MSG_ASV_MISSING_PERFORMANCE_PATTERN_VALUE_INCLUDE));
            this.performancePatternThresholdsIncludes.add(this.getStringValue(doc, "/selection/perfPattern_medium_2_include", AsvI18NCode.MSG_ASV_MISSING_PERFORMANCE_PATTERN_VALUE_INCLUDE));
            this.performancePatternThresholdsIncludes.add(this.getStringValue(doc, "/selection/perfPattern_medium_3_include", AsvI18NCode.MSG_ASV_MISSING_PERFORMANCE_PATTERN_VALUE_INCLUDE));
            this.performancePatternValues.add(M_PERFPATTERN_POOR);
            this.performancePatternValues.add(M_PERFPATTERN_AVERAGE);
            this.performancePatternValues.add(M_PERFPATTERN_GOOD);
            this.performancePatternValues.add(M_PERFPATTERN_AVERAGE);
            this.performancePatternValues.add(M_PERFPATTERN_POOR);
        } else if (performancePattern.equals("perfPattern_low")) {
            this.performancePatternThresholds.add(this.getStringValue(doc, "/selection/perfPattern_low_0", AsvI18NCode.MSG_ASV_MISSING_PERFORMANCE_PATTERN_VALUE));
            this.performancePatternThresholds.add(this.getStringValue(doc, "/selection/perfPattern_low_1", AsvI18NCode.MSG_ASV_MISSING_PERFORMANCE_PATTERN_VALUE));
            this.performancePatternThresholdsIncludes.add(this.getStringValue(doc, "/selection/perfPattern_low_0_include", AsvI18NCode.MSG_ASV_MISSING_PERFORMANCE_PATTERN_VALUE_INCLUDE));
            this.performancePatternThresholdsIncludes.add(this.getStringValue(doc, "/selection/perfPattern_low_1_include", AsvI18NCode.MSG_ASV_MISSING_PERFORMANCE_PATTERN_VALUE_INCLUDE));
            this.performancePatternValues.add(M_PERFPATTERN_GOOD);
            this.performancePatternValues.add(M_PERFPATTERN_AVERAGE);
            this.performancePatternValues.add(M_PERFPATTERN_POOR);
        }
    }

    private void processNonMetricSelection(Document doc) throws AgentServiceException {
        this.m_measure_value = this.getStringValue(doc, M_MEASURE_VALUE_XPATH, AsvI18NCode.MSG_ASV_MISSING_MEASURE_VALUE);
        this.m_measure_value1 = this.getStringValue(doc, M_MEASURE_VALUE1_XPATH, AsvI18NCode.MSG_ASV_MISSING_MEASURE_VALUE1);
        this.m_measure_operator = this.getStringValue(doc, M_OPERATION_XPATH, AsvI18NCode.MSG_ASV_MISSING_OPERATION);
        if (this.m_measure_operator.equals("between")) {
            this.m_measure_value_inclusive = this.getBooleanValue(doc, M_MEASURE_VALUE_INCLUSIVE_XPATH, AsvI18NCode.MSG_ASV_MISSING_MEASURE_VALUE_INCLUSIVE);
            this.m_measure_value_inclusive1 = this.getBooleanValue(doc, M_MEASURE_VALUE_INCLUSIVE1_XPATH, AsvI18NCode.MSG_ASV_MISSING_MEASURE_VALUE_INCLUSIVE);
        }
        this.m_case_insensitive = this.getBooleanValue(doc, M_CASE_INSENSITIVE_XPATH, AsvI18NCode.MSG_ASV_MISSING_CASE_INSENSITIVE);
    }

    public String getBurstID() {
        return this.m_burstID;
    }

    public String getContentLocale() {
        return this.m_contentLocale;
    }

    public String getMeasureOperator() {
        return this.m_measure_operator;
    }

    public String getMeasureValue() {
        return this.m_measure_value;
    }

    public String getMeasureValue1() {
        return this.m_measure_value1;
    }

    public boolean getMeasureValueInclusive() {
        return this.m_measure_value_inclusive;
    }

    public boolean getMeasureValueInclusive1() {
        return this.m_measure_value_inclusive1;
    }

    public String getSelectionXML() {
        return this.m_selectionXML;
    }

    public boolean getCaseInsensitive() {
        return this.m_case_insensitive;
    }

    public Boolean isMetricWatchRule() {
        return this.m_metricWatchRule;
    }

    public ArrayList getPerformancePatternThresholds() {
        return this.performancePatternThresholds;
    }

    public ArrayList getPerformancePatternThresholdsIncludes() {
        return this.performancePatternThresholdsIncludes;
    }

    public ArrayList getPerformancePatternValues() {
        return this.performancePatternValues;
    }

    private String getStringValue(Document doc, String xPath, I18NCode errorCode) throws AgentServiceException {
        Node node = doc.selectSingleNode(xPath);
        if (node == null) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, errorCode, new Object[]{this.m_searchPath});
            throw new AgentServiceException(errorCode, new Object[]{this.m_searchPath});
        }
        return node.getText();
    }

    private boolean getBooleanValue(Document doc, String xPath, I18NCode errorCode) {
        boolean ret_value = false;
        Node node = doc.selectSingleNode(xPath);
        if (node == null) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, errorCode, new Object[]{this.m_searchPath});
        } else {
            ret_value = Boolean.valueOf(node.getText());
        }
        return ret_value;
    }
}

