/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionInt;
import com.cognos.developer.schemas.bibus._3.DeliveryOption;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.RunOptionBoolean;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.RunOptionInt;
import com.cognos.developer.schemas.bibus._3.RunOptionProp;
import com.cognos.developer.schemas.bibus._3.RunOptionString;
import com.cognos.developer.schemas.bibus._3.RunOptionStringArray;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.util.OptionUtils;

public class ResolveOptionsUtil {
    private static int SECONDARY_THRESHOLD_DEFAULT = 60;

    public static Option[] resolveOptions(BaseStepObject stepTarget) {
        Option[] containerOptions = ResolveOptionsUtil.getOptions(stepTarget, 2);
        Option[] stepOptions = ResolveOptionsUtil.getOptions(stepTarget, 1);
        Option[] targetOptions = ResolveOptionsUtil.getOptions(stepTarget, 0);
        Option[] submitOptions = ResolveOptionsUtil.getSubmitOptions(stepTarget);
        Option[] resolvedOptions = targetOptions;
        resolvedOptions = OptionUtils.mergeOptions((Option[])resolvedOptions, (Option[])containerOptions);
        resolvedOptions = OptionUtils.mergeOptions((Option[])resolvedOptions, (Option[])stepOptions);
        resolvedOptions = OptionUtils.mergeOptions((Option[])resolvedOptions, (Option[])submitOptions, (boolean)true);
        resolvedOptions = OptionUtils.mergeOptions((Option[])ResolveOptionsUtil.makeWaitThresholdOptions(), (Option[])resolvedOptions);
        ResolveOptionsUtil.debugLogOptions(resolvedOptions);
        return resolvedOptions;
    }

    public static Option[] resolveConditionOptions(BaseAgent agent) {
        Option[] containerOptions = ResolveOptionsUtil.getOptions(agent, 2);
        Option[] stepOptions = ResolveOptionsUtil.getOptions(agent, 1);
        Option[] submitOptions = ResolveOptionsUtil.getSubmitOptions(agent);
        Option[] resolvedOptions = stepOptions;
        resolvedOptions = OptionUtils.mergeOptions((Option[])resolvedOptions, (Option[])containerOptions);
        resolvedOptions = OptionUtils.mergeOptions((Option[])resolvedOptions, (Option[])stepOptions);
        resolvedOptions = OptionUtils.mergeOptions((Option[])resolvedOptions, (Option[])submitOptions);
        resolvedOptions = OptionUtils.mergeOptions((Option[])ResolveOptionsUtil.makeWaitThresholdOptions(), (Option[])resolvedOptions);
        ResolveOptionsUtil.debugLogOptions(resolvedOptions);
        return resolvedOptions;
    }

    public static Option[] resolveSubmitOptions(BaseStepObject stepTarget) {
        return ResolveOptionsUtil.getSubmitOptions(stepTarget);
    }

    private static Option[] getOptions(BaseStepObject obj, int levels) {
        BaseStepObject ancestor = obj;
        for (int i = 0; i < levels; ++i) {
            ancestor = ancestor == null ? null : ancestor.getParent();
        }
        return ancestor == null ? null : ancestor.getOptions();
    }

    private static Option[] getSubmitOptions(BaseStepObject obj) {
        Option[] options = null;
        for (BaseStepObject ancestor = obj; ancestor != null && options == null; ancestor = ancestor.getParent()) {
            options = ancestor.getSubmitOptions();
        }
        return options;
    }

    private static Option[] makeWaitThresholdOptions() {
        Option[] options = new Option[2];
        AsynchOptionInt primaryWaitThresholdOption = new AsynchOptionInt();
        primaryWaitThresholdOption.setName(AsynchOptionEnum.primaryWaitThreshold);
        primaryWaitThresholdOption.setValue(10);
        AsynchOptionInt secondaryWaitThresholdOption = ResolveOptionsUtil.setSecondaryWaitThreshold();
        options[0] = primaryWaitThresholdOption;
        options[1] = secondaryWaitThresholdOption;
        return options;
    }

    private static AsynchOptionInt setSecondaryWaitThreshold() {
        AsynchOptionInt secondaryWaitThresholdOption = new AsynchOptionInt();
        secondaryWaitThresholdOption.setName(AsynchOptionEnum.secondaryWaitThreshold);
        secondaryWaitThresholdOption.setValue(SECONDARY_THRESHOLD_DEFAULT);
        try {
            String tmpStr = CRNProperties.getInstance().getProperty("secondary.threshold");
            if (tmpStr != null && tmpStr.trim().length() > 0) {
                secondaryWaitThresholdOption.setValue(Integer.valueOf(tmpStr).intValue());
            }
        }
        catch (PropertiesException e) {
            secondaryWaitThresholdOption.setValue(SECONDARY_THRESHOLD_DEFAULT);
        }
        return secondaryWaitThresholdOption;
    }

    private static void debugLogOptions(Option[] options) {
        if (options != null) {
            StringBuffer buffer = new StringBuffer(5000);
            buffer.append("******* Submitting report with options\n");
            for (int i = 0; i < options.length; ++i) {
                buffer.append(ResolveOptionsUtil.getOptionString(options[i]) + "\n");
            }
            buffer.append("******* end options\n");
            SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug(buffer.toString());
        }
    }

    private static String getOptionString(Option option) {
        if (option == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(OptionUtils.getOptionName((Option)option));
        buffer.append(" = ");
        buffer.append(ResolveOptionsUtil.getOptionValueString(option));
        return buffer.toString();
    }

    private static String getOptionValueString(Object option) {
        StringBuffer buffer = new StringBuffer(100);
        if (option instanceof RunOptionBoolean) {
            RunOptionBoolean bool = (RunOptionBoolean)option;
            buffer.append(String.valueOf(bool.isValue()));
        } else if (option instanceof RunOptionString) {
            RunOptionString string = (RunOptionString)option;
            buffer.append(string.getValue());
        } else if (option instanceof RunOptionEnum) {
            RunOptionEnum enumer = (RunOptionEnum)option;
            buffer.append(enumer.getValue());
        } else if (option instanceof RunOptionProp) {
            RunOptionProp prop = (RunOptionProp)option;
            buffer.append(ResolveOptionsUtil.getOptionValueString(prop.getValue()));
        } else if (option instanceof RunOptionInt) {
            RunOptionInt integer = (RunOptionInt)option;
            buffer.append(String.valueOf(integer.getValue()));
        } else if (option instanceof RunOptionStringArray) {
            String[] values;
            RunOptionStringArray array = (RunOptionStringArray)option;
            String[] stringArray = values = array != null ? array.getValue() : new String[]{};
            if (values == null) {
                values = new String[]{};
            }
            for (int i = 0; i < values.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(values[i]);
            }
        } else if (option instanceof DeliveryOption) {
            buffer.append(option.getClass().getName());
        } else {
            buffer.append(option != null ? option.getClass().getName() : "null");
        }
        return buffer.toString();
    }
}

