/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.AgentTask;
import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetKey;
import com.cognos.asv.resultset.ResultSetLineBuilder;
import com.cognos.asv.resultset.ResultSetTypeEnum;
import com.cognos.developer.schemas.bibus._3.BaseParameter;
import com.cognos.developer.schemas.bibus._3.BaseParameterAssignment;
import com.cognos.developer.schemas.bibus._3.BaseParameterAssignmentArrayProp;
import com.cognos.developer.schemas.bibus._3.BoundRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.ParameterAssignmentDataItem;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParameterValueArrayProp;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class ResolveParametersUtil {
    private static final String M_CREDENTIAL = "credential:";
    private static final String M_PASSWORD = ":password";

    public static ParameterValue[] resolveParameters(BaseStepObject stepTarget) throws AgentServiceException {
        return ResolveParametersUtil.resolveParameters(stepTarget, true);
    }

    public static ParameterValue[] resolveParameters(BaseStepObject stepTarget, boolean trimToConnectionParamters) throws AgentServiceException {
        ParameterValue[] containerParams = trimToConnectionParamters ? ResolveParametersUtil.getConnectionParameters(ResolveParametersUtil.getParameters(stepTarget, 2)) : ResolveParametersUtil.getParameters(stepTarget, 2);
        ParameterValue[] stepParams = ResolveParametersUtil.getParameters(stepTarget, 1);
        ParameterValue[] targetParams = ResolveParametersUtil.getParameters(stepTarget, 0);
        ParameterValue[] submitParams = trimToConnectionParamters ? ResolveParametersUtil.getConnectionParameters(ResolveParametersUtil.getSubmitParameters(stepTarget)) : ResolveParametersUtil.getSubmitParameters(stepTarget);
        ParameterValue[] resolvedparams = targetParams;
        resolvedparams = ResolveParametersUtil.mergeParameters(resolvedparams, containerParams);
        resolvedparams = ResolveParametersUtil.mergeParameters(resolvedparams, stepParams);
        resolvedparams = ResolveParametersUtil.mergeParameters(resolvedparams, submitParams);
        ResolveParametersUtil.debugLogParameterValues(resolvedparams);
        ResolveParametersUtil.removeNullValues(resolvedparams);
        return resolvedparams;
    }

    public static ParameterValue[] resolveConnectionParameters(BaseAgentTaskTarget stepTarget, ResultSet agentResultSet) throws AgentServiceException {
        AgentTask agentTask = stepTarget.getBaseTask();
        BaseParameterAssignmentArrayProp paramAssignmentsArrayProp = agentTask.getAgentTaskDefinition().getParameterAssignments();
        ParameterValueArrayProp parameterValueArrayProp = agentTask.getAgentTaskDefinition().getParameters();
        ParameterValue[] containerParams = ResolveParametersUtil.getConnectionParameters(ResolveParametersUtil.getParameters(stepTarget, 2));
        ParameterValue[] stepParams = ResolveParametersUtil.getConnectionParameters(parameterValueArrayProp == null ? null : parameterValueArrayProp.getValue());
        ParameterValue[] stepAssignmentConnectionParameters = paramAssignmentsArrayProp != null ? ResolveParametersUtil.buildConnectionParamsFromAssignments(paramAssignmentsArrayProp.getValue(), agentResultSet) : null;
        ParameterValue[] targetParams = ResolveParametersUtil.getConnectionParameters(ResolveParametersUtil.getParameters(stepTarget, 0));
        ParameterValue[] submitParams = ResolveParametersUtil.getConnectionParameters(ResolveParametersUtil.getSubmitParameters(stepTarget));
        ParameterValue[] resolvedparams = targetParams;
        resolvedparams = ResolveParametersUtil.mergeParameters(resolvedparams, containerParams);
        resolvedparams = ResolveParametersUtil.mergeParameters(resolvedparams, stepParams);
        resolvedparams = ResolveParametersUtil.mergeParameters(resolvedparams, stepAssignmentConnectionParameters);
        resolvedparams = ResolveParametersUtil.mergeParameters(resolvedparams, submitParams);
        ResolveParametersUtil.debugLogParameterValues(resolvedparams);
        ResolveParametersUtil.removeNullValues(resolvedparams);
        return resolvedparams;
    }

    public static ParameterValue[] trimToTargetParams(ParameterValue[] values, BaseAgentTaskTarget stepTarget, ResultSet agentResultSet) throws AgentServiceException {
        ArrayList<ParameterValue> parameters = new ArrayList<ParameterValue>();
        BaseParameter[] baseParameters = stepTarget.getTargetParameters(agentResultSet);
        for (int i = 0; values != null && i < values.length; ++i) {
            ParameterValue parameterValue = values[i];
            boolean found = false;
            for (int j = 0; baseParameters != null && j < baseParameters.length && !found; ++j) {
                ParameterNameKey parameterValueKey;
                BaseParameter baseParameter = baseParameters[j];
                ParameterNameKey baseParameterNameKey = new ParameterNameKey(baseParameter.getName());
                if (!baseParameterNameKey.equals(parameterValueKey = new ParameterNameKey(parameterValue.getName()))) continue;
                found = true;
            }
            if (!found) continue;
            parameters.add(parameterValue);
        }
        ParameterValue[] connectionParams = ResolveParametersUtil.resolveConnectionParameters(stepTarget, agentResultSet);
        parameters.addAll(Arrays.asList(connectionParams));
        return parameters.toArray(new ParameterValue[0]);
    }

    public static ParameterValue[] getConnectionParameters(ParameterValue[] parameterValues) {
        ArrayList<ParameterValue> connectionParameterValuesList = new ArrayList<ParameterValue>();
        for (int i = 0; parameterValues != null && i < parameterValues.length; ++i) {
            String name = parameterValues[i].getName();
            if (name == null || !name.startsWith(M_CREDENTIAL)) continue;
            connectionParameterValuesList.add(parameterValues[i]);
        }
        ParameterValue[] connectionParameterValues = new ParameterValue[connectionParameterValuesList.size()];
        return connectionParameterValuesList.toArray(connectionParameterValues);
    }

    public static ParameterValue[] buildConnectionParamsFromAssignments(BaseParameterAssignment[] assignments, ResultSet agentResultSet) {
        ArrayList<ParameterValue> connectionParameters = new ArrayList<ParameterValue>();
        if (assignments != null && !agentResultSet.isEmpty()) {
            for (int i = 0; i < assignments.length; ++i) {
                BaseParameterAssignment assignment = assignments[i];
                String parameterName = assignment.getParameterName();
                String dataItemName = ((ParameterAssignmentDataItem)assignment).getDataItemName().get_value();
                if (!parameterName.startsWith(M_CREDENTIAL)) continue;
                ParameterValue parameterValue = new ParameterValue();
                parameterValue.setName(parameterName);
                SimpleParmValueItem simpleParmValueItem = new SimpleParmValueItem();
                simpleParmValueItem.setInclusive(false);
                ResultSetLineBuilder lineBuilder = new ResultSetLineBuilder(agentResultSet, ResultSetTypeEnum.XML, dataItemName);
                String assignmentValue = lineBuilder.buildLine((ResultSetKey)agentResultSet.getData().next());
                simpleParmValueItem.setUse(assignmentValue);
                simpleParmValueItem.setDisplay(assignmentValue);
                parameterValue.setValue(new ParmValueItem[]{simpleParmValueItem});
                connectionParameters.add(parameterValue);
            }
        }
        return connectionParameters.toArray(new ParameterValue[0]);
    }

    private static ParameterValue[] getSubmitParameters(BaseStepObject obj) {
        ParameterValue[] parameters = null;
        for (BaseStepObject ancestor = obj; ancestor != null && parameters == null; ancestor = ancestor.getParent()) {
            parameters = ancestor.getSubmitParameters();
        }
        return parameters;
    }

    public static ParameterValue[] getConnectionParameters(BaseStepObject obj) throws AgentServiceException {
        ParameterValue[] connectionParameters = ResolveParametersUtil.getConnectionParameters(ResolveParametersUtil.getSubmitParameters(obj));
        if (connectionParameters == null || connectionParameters.length == 0) {
            BaseStepObject root = obj;
            while (root.getParent() != null) {
                root = root.getParent();
            }
            connectionParameters = ResolveParametersUtil.getConnectionParameters(root.getParameters());
        }
        return connectionParameters;
    }

    private static ParameterValue[] getParameters(BaseStepObject obj, int levels) throws AgentServiceException {
        BaseStepObject ancestor = obj;
        for (int i = 0; i < levels; ++i) {
            ancestor = ancestor == null ? null : ancestor.getParent();
        }
        return ancestor == null ? null : ancestor.getParameters();
    }

    private static void debugLogParameterValues(ParameterValue[] resolvedParameters) {
        if (SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).isLoggingAt(SDSLevel.DEBUG)) {
            if (resolvedParameters != null) {
                StringBuffer buffer = new StringBuffer(5000);
                buffer.append("******* Submitting report with params\n");
                for (int i = 0; i < resolvedParameters.length; ++i) {
                    buffer.append(ResolveParametersUtil.getParameterString(resolvedParameters[i]) + "\n");
                }
                buffer.append("******* end params\n");
                SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug(buffer.toString());
            } else {
                SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug("******* Submitting report with no params\n");
            }
        }
    }

    private static String getParameterString(ParameterValue parameter) {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(parameter.getName());
        buffer.append(" = ");
        ParmValueItem[] parmValues = parameter.getValue();
        for (int i = 0; i < parmValues.length; ++i) {
            if (i != 0) {
                buffer.append(" ");
            }
            if (parmValues[i] instanceof BoundRangeParmValueItem) {
                buffer.append(((BoundRangeParmValueItem)parmValues[i]).getStart().getDisplay());
                buffer.append(" to ");
                buffer.append(((BoundRangeParmValueItem)parmValues[i]).getEnd().getDisplay());
                continue;
            }
            if (parmValues[i] instanceof SimpleParmValueItem) {
                buffer.append(((SimpleParmValueItem)parmValues[i]).getDisplay());
                continue;
            }
            if (parmValues[i] == null) continue;
            buffer.append(parmValues[i].toString());
        }
        return buffer.toString();
    }

    private static void removeNullValues(ParameterValue[] values) {
        for (int i = 0; i < values.length; ++i) {
            ParmValueItem[] items = values[i].getValue();
            ArrayList<ParmValueItem> trimmedItems = new ArrayList<ParmValueItem>();
            for (int j = 0; j < items.length; ++j) {
                if (items[j] == null) continue;
                trimmedItems.add(items[j]);
            }
            values[i].setValue(trimmedItems.toArray(new ParmValueItem[trimmedItems.size()]));
        }
    }

    public static ParameterValue[] mergeParameters(ParameterValue[] low, ParameterValue[] high) {
        HashMap<ParameterNameKey, ParameterValue> paramMap = new HashMap<ParameterNameKey, ParameterValue>();
        if (low != null) {
            for (int i = 0; i < low.length; ++i) {
                paramMap.put(new ParameterNameKey(low[i].getName()), low[i]);
            }
        }
        if (high != null) {
            String highName = null;
            ParameterValue highValue = null;
            ParameterValue lowValue = null;
            boolean highValueIsSet = false;
            for (int i = 0; i < high.length; ++i) {
                highName = high[i].getName();
                highValue = high[i];
                lowValue = (ParameterValue)paramMap.get(new ParameterNameKey(highName));
                highValueIsSet = false;
                if (paramMap.containsKey(new ParameterNameKey(highName)) && (!ResolveParametersUtil.hasValue(highValue) && ResolveParametersUtil.hasValue(lowValue) || !ResolveParametersUtil.hasValueContent(highValue) && ResolveParametersUtil.hasValueContent(lowValue))) {
                    paramMap.put(new ParameterNameKey(highName), lowValue);
                    highValueIsSet = true;
                }
                if (highValueIsSet) continue;
                paramMap.put(new ParameterNameKey(highName), highValue);
            }
        }
        return paramMap.values().toArray(new ParameterValue[paramMap.size()]);
    }

    private static boolean hasValue(ParameterValue paramValue) {
        boolean hasValue = false;
        hasValue = paramValue != null && paramValue.getValue().length > 0;
        return hasValue;
    }

    private static boolean hasValueContent(ParameterValue paramValue) {
        boolean hasValue = false;
        hasValue = paramValue != null;
        ParmValueItem[] value = paramValue.getValue();
        boolean bl = hasValue = value != null;
        if (hasValue && value.length == 1) {
            SimpleParmValueItem oneVI;
            String str;
            if (value[0] instanceof SimpleParmValueItem && ((str = (oneVI = (SimpleParmValueItem)value[0]).getUse()) == null || str.length() == 0)) {
                hasValue = false;
            }
        } else {
            hasValue = true;
        }
        return hasValue;
    }

    public static ParameterValue[] appendParameters(ParameterValue[] merged, ParameterValue[] assignedParameters) {
        if (null == merged) {
            merged = assignedParameters;
        } else {
            ParmValueItem[] parmItem;
            int i;
            ArrayList<ParmValueItem> finalList = new ArrayList<ParmValueItem>();
            HashMap<String, ParmValueItem[]> paramMap = new HashMap<String, ParmValueItem[]>();
            for (i = 0; i < assignedParameters.length; ++i) {
                parmItem = assignedParameters[i].getValue();
                paramMap.put(assignedParameters[i].getName(), parmItem);
            }
            for (i = 0; i < merged.length; ++i) {
                parmItem = merged[i].getValue();
                if (paramMap.containsKey(merged[i].getName())) {
                    ParmValueItem[] obj = (ParmValueItem[])paramMap.get(merged[i].getName());
                    finalList.addAll(Arrays.asList(obj));
                    finalList.addAll(Arrays.asList(parmItem));
                    merged[i].setValue(finalList.toArray(new ParmValueItem[finalList.size()]));
                }
                finalList.clear();
            }
        }
        return merged;
    }

    private static class ParameterNameKey {
        private String key;

        public ParameterNameKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public boolean equals(Object rhs) {
            boolean ret_value = false;
            if (rhs instanceof ParameterNameKey) {
                ParameterNameKey rhsParam = (ParameterNameKey)rhs;
                if (this.key.startsWith(ResolveParametersUtil.M_CREDENTIAL) && rhsParam.key.startsWith(ResolveParametersUtil.M_CREDENTIAL)) {
                    String this_keyStart = this.key;
                    String rhs_keyStart = rhsParam.key;
                    if (this_keyStart.indexOf(ResolveParametersUtil.M_PASSWORD) != -1) {
                        this_keyStart = this_keyStart.substring(0, this_keyStart.indexOf(ResolveParametersUtil.M_PASSWORD));
                    }
                    if (rhs_keyStart.indexOf(ResolveParametersUtil.M_PASSWORD) != -1) {
                        rhs_keyStart = rhs_keyStart.substring(0, rhs_keyStart.indexOf(ResolveParametersUtil.M_PASSWORD));
                    }
                    ret_value = this_keyStart.equals(rhs_keyStart);
                } else {
                    ret_value = this.key.equals(rhsParam.key);
                }
            }
            return ret_value;
        }

        public int hashCode() {
            if (this.key.startsWith(ResolveParametersUtil.M_CREDENTIAL)) {
                String this_keyStart = this.key;
                if (this_keyStart.indexOf(ResolveParametersUtil.M_PASSWORD) != -1) {
                    this_keyStart = this_keyStart.substring(0, this_keyStart.indexOf(ResolveParametersUtil.M_PASSWORD));
                }
                return this_keyStart.hashCode();
            }
            return this.key.hashCode();
        }
    }
}

