/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetMessageBuilder;
import com.cognos.asv.resultset.ResultSetTypeEnum;
import com.cognos.developer.schemas.bibus._3.AgentOutputEnum;
import com.cognos.developer.schemas.bibus._3.AgentOutputEnumProp;
import com.cognos.developer.schemas.bibus._3.AnyURIProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseRSSTask;
import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.developer.schemas.bibus._3.ClassEnumProp;
import com.cognos.developer.schemas.bibus._3.MultilingualString;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.RssOption;
import com.cognos.developer.schemas.bibus._3.RssOptionAnyURI;
import com.cognos.developer.schemas.bibus._3.RssOptionEnum;
import com.cognos.developer.schemas.bibus._3.RssOptionSearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.RssOptionString;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.ShortcutAgentRSSTask;
import com.cognos.developer.schemas.bibus._3.ShortcutRSSTask;
import com.cognos.developer.schemas.bibus._3.UrlRSSTask;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.CafUtilities;
import com.cognos.jsmcommon.util.ObjectModelClassEnum;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.axis.AxisFault;

public class RssOptionsGenerator {
    private static int NAME_LENGTH = 255;
    private static int DESCRIPTION_LENGTH = 1024;

    public static final RssOption[] generateOptions(BaseAgent agent, BaseRSSTask rssTask, ResultSet rs, boolean createItem) throws AgentServiceException {
        return RssOptionsGenerator.generateOptions(agent, rssTask, rs, createItem, SeverityEnum.warn);
    }

    public static final RssOption[] generateOptions(BaseAgent agent, BaseRSSTask rssTask, ResultSet rs, boolean createItem, SeverityEnum severity) throws AgentServiceException {
        ArrayList<Object> rssOptions = new ArrayList<Object>();
        rssOptions.add(RssOptionsGenerator.generateItemStateOption(createItem));
        if (createItem) {
            if (ObjectModelUtil.compareSeverity((SeverityEnum)SeverityEnum.error, (SeverityEnum)severity) > 0) {
                if (rssTask.getDescription() != null) {
                    rssOptions.addAll(Arrays.asList(RssOptionsGenerator.createDescriptionOption(rssTask.getDescription().getValue(), rs)));
                }
                if (rssTask.getTitle() != null) {
                    rssOptions.addAll(Arrays.asList(RssOptionsGenerator.createNameOption(rssTask.getTitle().getValue(), rs)));
                }
                if (rssTask.getScreenTip() != null) {
                    rssOptions.addAll(Arrays.asList(RssOptionsGenerator.createScreenTipOption(rssTask.getScreenTip().getValue(), rs)));
                }
            }
            rssOptions.add(RssOptionsGenerator.createLinkOption(agent, rssTask));
        }
        RssOption[] options = new RssOption[rssOptions.size()];
        rssOptions.toArray(options);
        return options;
    }

    public static final I18NMessage[] validate(BaseRSSTask rssTask, JobBiBusHeaders headers) {
        String title_string;
        ArrayList<I18NMessage> validations = new ArrayList<I18NMessage>();
        MultilingualString[] titles = rssTask.getTitle().getValue();
        String string = title_string = titles != null && titles.length > 0 && titles[0] != null ? titles[0].getValue() : null;
        if (title_string == null || "".equals(title_string)) {
            title_string = rssTask.getDefaultName() != null ? rssTask.getDefaultName().getValue() : "?";
            validations.add(new I18NMessage(AsvI18NCode.MSG_ASV_NEWSITEM_MISSING_TITLE, new Object[]{title_string}, SeverityEnum.warn));
        }
        if (rssTask instanceof ShortcutRSSTask) {
            BaseClassArrayProp shortcutLink = ((ShortcutRSSTask)rssTask).getLink();
            SearchPathSingleObject link = ObjectModelUtil.getSearchPath((BaseClassArrayProp)shortcutLink, (int)0);
            if (link == null) {
                validations.add(new I18NMessage(AsvI18NCode.MSG_ASV_NEWSITEM_MISSING_LINK, new Object[]{title_string}, SeverityEnum.error));
            } else if (ObjectModelUtil.isAgentSearchPath((String)link.get_value())) {
                validations.add(new I18NMessage(AsvI18NCode.MSG_ASV_NEWSITEM_MISSING_LINK, new Object[]{title_string}, SeverityEnum.error));
            } else {
                I18NCode code = RssOptionsGenerator.validateLinkEntry(headers, link);
                if (code != null) {
                    validations.add(new I18NMessage(code, new Object[]{title_string}, SeverityEnum.error));
                }
            }
        }
        if (rssTask instanceof ShortcutAgentRSSTask) {
            AgentOutputEnumProp aoep = ((ShortcutAgentRSSTask)rssTask).getLink();
            AgentOutputEnum aoe = aoep.getValue();
            if (aoe == null || !"hotList".equals(aoe.getValue())) {
                validations.add(new I18NMessage(AsvI18NCode.MSG_ASV_NEWSITEM_MISSING_LINK, new Object[]{title_string}, SeverityEnum.error));
            }
        } else if (rssTask instanceof UrlRSSTask) {
            String uri = ObjectModelUtil.getUri((AnyURIProp)((UrlRSSTask)rssTask).getLink());
            if (uri == null) {
                validations.add(new I18NMessage(AsvI18NCode.MSG_ASV_NEWSITEM_MISSING_LINK, new Object[]{title_string}, SeverityEnum.warn));
            } else {
                I18NCode code = RssOptionsGenerator.validateURL(uri);
                if (code != null) {
                    validations.add(new I18NMessage(code, new Object[]{title_string}, SeverityEnum.error));
                }
            }
        }
        BaseClassArrayProp channel = rssTask.getChannel();
        SearchPathSingleObject channel_path = ObjectModelUtil.getSearchPath((BaseClassArrayProp)channel, (int)0);
        if (channel_path == null) {
            validations.add(new I18NMessage(AsvI18NCode.MSG_ASV_NEWSITEM_MISSING_LOCATION, new Object[]{title_string}, SeverityEnum.error));
        }
        I18NMessage[] messages = new I18NMessage[validations.size()];
        validations.toArray(messages);
        return messages;
    }

    public static I18NCode validateURL(String uri) {
        I18NCode code = null;
        if (!CafUtilities.isValidURL((String)uri)) {
            code = AsvI18NCode.MSG_ASV_NEWSITEM_INVALID_DOMAIN;
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static I18NCode validateLinkEntry(JobBiBusHeaders headers, SearchPathSingleObject link) {
        I18NCode msgCode = null;
        ContentManagerServiceClientPort port = null;
        try {
            if (headers == null) {
                headers = new JobBiBusHeaders(BiBusUtilities.extractBiBusHeader());
            }
            port = Client.instance().getContentManagerServiceClient(headers);
            port.setLogCategory(ASVCategory.RUNTIME);
            BaseClass base = ObjectModelUtil.getBaseClass((ContentManagerServiceClientPort)port, (SearchPathSingleObject)link, (PropEnum[])new PropEnum[]{PropEnum.objectClass, PropEnum.searchPath});
            ClassEnumProp typeProp = base.getObjectClass();
            ClassEnum type = typeProp.getValue();
            boolean result = RssOptionsGenerator.isValidType(type);
            if (!result) {
                msgCode = AsvI18NCode.MSG_ASV_NEWSITEM_INVALID_LINK;
            }
        }
        catch (AxisFault e) {
            msgCode = AsvI18NCode.MSG_ASV_NEWSITEM_INVALID_LINK;
        }
        catch (SDKClientException e) {
            msgCode = AsvI18NCode.MSG_ASV_NEWSITEM_INVALID_LINK;
        }
        catch (EMFSecurityException e) {
            msgCode = AsvI18NCode.MSG_ASV_NEWSITEM_INVALID_LINK;
        }
        finally {
            if (port != null) {
                port.close();
            }
        }
        return msgCode;
    }

    private static boolean isValidType(ClassEnum type) {
        boolean result = false;
        if (ObjectModelClassEnum.QUERY.equals((Object)type) || ObjectModelClassEnum.ANALYSIS.equals((Object)type) || ObjectModelClassEnum.REPORT_VIEW.equals((Object)type) || ObjectModelClassEnum.REPORT.equals((Object)type) || ObjectModelClassEnum.ACTIVE_REPORT.equals((Object)type) || ObjectModelClassEnum.DOCUMENT.equals((Object)type) || ObjectModelClassEnum.POWERPLAY8REPORT.equals((Object)type) || ObjectModelClassEnum.POWERPLAY8REPORTVIEW.equals((Object)type)) {
            result = true;
        }
        if (ObjectModelClassEnum.DOCUMENT_CONTENT.equals((Object)type)) {
            result = true;
        }
        return result;
    }

    public static RssOptionString generateItemStateOption(boolean createItem) {
        RssOptionString item_state = new RssOptionString();
        if (createItem) {
            item_state.setName(RssOptionEnum.createItem);
        } else {
            item_state.setName(RssOptionEnum.deleteItem);
        }
        item_state.setValue(String.valueOf(true));
        return item_state;
    }

    public static final RssOptionString[] createNameOption(MultilingualString[] multi_topicful, ResultSet rs) {
        return RssOptionsGenerator.createRssOptionStrings(RssOptionEnum.itemName, multi_topicful, true, NAME_LENGTH, rs, true);
    }

    public static final RssOptionString[] createDescriptionOption(MultilingualString[] multi_topicful, ResultSet rs) {
        return RssOptionsGenerator.createRssOptionStrings(RssOptionEnum.itemDescription, multi_topicful, false, DESCRIPTION_LENGTH, rs, false);
    }

    public static final RssOptionString[] createScreenTipOption(MultilingualString[] multi_topicful, ResultSet rs) {
        return RssOptionsGenerator.createRssOptionStrings(RssOptionEnum.itemScreenTip, multi_topicful, true, NAME_LENGTH, rs, true);
    }

    private static final RssOptionString[] createRssOptionStrings(RssOptionEnum name, MultilingualString[] multi_topicful, boolean singleRow, int max_chars, ResultSet rs, boolean strip_newlines) {
        if (multi_topicful == null) {
            return new RssOptionString[0];
        }
        RssOptionString[] rss_option_strings = new RssOptionString[multi_topicful.length];
        for (int i = 0; i < multi_topicful.length && i < 1; ++i) {
            rss_option_strings[i] = new RssOptionString();
            rss_option_strings[i].setName(name);
            String rss_string = strip_newlines ? RssOptionsGenerator.removeNewlines(multi_topicful[i].getValue()) : multi_topicful[i].getValue();
            rss_option_strings[i].setValue(RssOptionsGenerator.replaceTopics(rss_string, singleRow, max_chars, rs));
        }
        return rss_option_strings;
    }

    private static String removeNewlines(String line) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < line.length(); ++i) {
            if ("\n".equals(String.valueOf(line.charAt(i)))) continue;
            buffer.append(line.charAt(i));
        }
        return buffer.toString();
    }

    private static final RssOption createLinkOption(BaseAgent agent, BaseRSSTask baseRss) throws AgentServiceException {
        AnyURIProp link;
        String uri;
        RssOptionSearchPathSingleObject option = null;
        if (baseRss instanceof ShortcutRSSTask) {
            BaseClassArrayProp link2 = ((ShortcutRSSTask)baseRss).getLink();
            SearchPathSingleObject searchPath = ObjectModelUtil.getSearchPath((BaseClassArrayProp)link2, (int)0);
            if (searchPath != null) {
                RssOptionSearchPathSingleObject rssOption = new RssOptionSearchPathSingleObject();
                rssOption.setName(RssOptionEnum.itemTarget);
                rssOption.setValue(searchPath);
                option = rssOption;
            }
        } else if (baseRss instanceof ShortcutAgentRSSTask) {
            AgentOutputEnum aoe;
            AgentOutputEnumProp aoep = ((ShortcutAgentRSSTask)baseRss).getLink();
            AgentOutputEnum agentOutputEnum = aoe = aoep != null ? aoep.getValue() : null;
            if (AgentOutputEnum.hotList.equals((Object)aoe)) {
                SearchPathSingleObject agentsp = ObjectModelUtil.makeSearPathSingleObject((String)agent.getSearchPath());
                SearchPathSingleObject searchPath = ObjectModelUtil.changeAgentpathsToAgentOutputPaths((SearchPathSingleObject)agentsp, (String)"HTML");
                RssOptionSearchPathSingleObject rssOption = new RssOptionSearchPathSingleObject();
                rssOption.setName(RssOptionEnum.itemTarget);
                rssOption.setValue(searchPath);
                option = rssOption;
            }
        } else if (baseRss instanceof UrlRSSTask && (uri = ObjectModelUtil.getUri((AnyURIProp)(link = ((UrlRSSTask)baseRss).getLink()))) != null) {
            RssOptionAnyURI rssOption = new RssOptionAnyURI();
            rssOption.setName(RssOptionEnum.itemURI);
            rssOption.setValue(uri.trim());
            option = rssOption;
            if (!CafUtilities.isValidURL((String)uri)) {
                MultilingualString[] titles = baseRss.getTitle().getValue();
                String title_string = titles != null && titles.length > 0 && titles[0] != null ? titles[0].getValue() : null;
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_NEWSITEM_INVALID_DOMAIN, new Object[]{title_string}, null, SeverityEnum.error);
            }
        }
        return option;
    }

    private static final String replaceTopics(String line, boolean singleRow, int max_chars, ResultSet rs) {
        if (line == null || "".equals(line)) {
            return "";
        }
        ResultSetMessageBuilder mb = new ResultSetMessageBuilder(rs, ResultSetTypeEnum.HTML, line);
        line = mb.getMessage(singleRow);
        if (max_chars != -1 && line.length() > max_chars) {
            line = line.substring(0, max_chars);
            int trim_dot = line.length() - 3;
            while (line.length() >= trim_dot || line.endsWith(".")) {
                line = line.substring(0, line.length() - 2);
            }
            line = line + "...";
        }
        return line;
    }
}

