/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv;

import com.cognos.asv.ASVCategory;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseHistoryDetail;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.History;
import com.cognos.developer.schemas.bibus._3.HistoryDetailAgentService;
import com.cognos.developer.schemas.bibus._3.HistoryDetailReportService;
import com.cognos.developer.schemas.bibus._3.HistoryDetailRequestArguments;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.CommonHistoryHelper;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import java.util.ArrayList;

public class RunHistoryExtractor {
    ArrayList list = new ArrayList();
    private JobBiBusHeaders m_headers;

    public RunHistoryExtractor(String eventId, JobBiBusHeaders jobHeaders) throws EMFSecurityException, SDKClientException {
        this.m_headers = jobHeaders;
        History agentHistory = CommonHistoryHelper.getHistoryFromCM((String)("//history[@eventID='" + eventId + "']"), (BiBusHeader)jobHeaders.getBiBusHeader());
        History[] child_histories = this.getHistories("//history[@ownerEventID='" + eventId + "']");
        for (int i = 0; i < child_histories.length; ++i) {
            ParameterValue[] params = null;
            Option[] options = null;
            Output output = null;
            BaseClass parent = ObjectModelUtil.getBaseClass((BaseClass[])child_histories[i].getParent().getValue(), (int)0);
            BaseHistoryDetail[] details = CommonHistoryHelper.getHistoryDetailsFromCM((String)child_histories[i].getSearchPath().getValue(), (BiBusHeader)this.m_headers.getBiBusHeader());
            if (details[i] instanceof HistoryDetailReportService) {
                HistoryDetailReportService hdrs = (HistoryDetailReportService)details[i];
                output = (Output)ObjectModelUtil.getBaseClass((BaseClassArrayProp)hdrs.getOutput(), (int)0);
                this.list.add(hdrs);
                continue;
            }
            if (details[i] instanceof HistoryDetailAgentService) {
                HistoryDetailAgentService hdas = (HistoryDetailAgentService)details[i];
                this.list.add(hdas);
                continue;
            }
            if (!(details[i] instanceof HistoryDetailRequestArguments)) continue;
            HistoryDetailRequestArguments hdra = (HistoryDetailRequestArguments)details[i];
            options = hdra.getOptions().getValue();
            params = hdra.getParameters().getValue();
            this.list.add(hdra);
        }
    }

    public Object getData() {
        return this.list;
    }

    private History[] getHistories(String path) throws EMFSecurityException, SDKClientException {
        ArrayList<History> histories = new ArrayList<History>();
        PropEnum[] props = new PropEnum[]{PropEnum.searchPath, PropEnum.storeID, PropEnum.status, PropEnum.eventID, PropEnum.ownerEventID, PropEnum.parent};
        if (path == null) {
            return new History[0];
        }
        ContentManagerServiceClientPort cmPort = null;
        try {
            cmPort = Client.instance().getContentManagerServiceClient(this.m_headers);
            cmPort.setLogCategory(ASVCategory.RUNTIME);
            BaseClass[] replys = cmPort.query(path, props, new Sort[0], new QueryOptions());
            for (int i = 0; replys != null && i < replys.length; ++i) {
                if (replys == null || replys.length != 1 || !(replys[i] instanceof History)) continue;
                histories.add((History)replys[i]);
            }
        }
        catch (EMFSecurityException ex) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug("CamSecurityException when retrieving history with path [" + path + "].");
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug(ex.getMessage());
            throw ex;
        }
        catch (SDKClientException ex) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug("SDKClientException when retrieving history with path [" + path + "].");
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.INFO, (LocalizableException)((Object)ex));
            throw ex;
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
        return histories.toArray(new History[0]);
    }
}

