/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv;

import com.cognos.asv.BaseStepObject;
import com.cognos.jsmcommon.tse.SequenceSpec;
import com.cognos.jsmcommon.util.HashList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class TseRunSpec {
    ArrayList<Task> orderedList = new ArrayList();
    ArrayList<Task> childTasks = new ArrayList();

    public Task addTask(BaseStepObject step, SequenceSpec spec) {
        return this.addTask(step, spec, null);
    }

    public Task addTask(BaseStepObject step, SequenceSpec spec, SequenceSpec parentSpec) {
        Task def = new Task(step, spec);
        if (parentSpec != null) {
            parentSpec.AddChild(spec);
            this.childTasks.add(def);
        } else {
            this.orderedList.add(def);
        }
        return def;
    }

    public boolean isEmpty() {
        return this.orderedList.size() == 0;
    }

    public int size() {
        return this.orderedList.size();
    }

    public Iterator<Task> iterator() {
        this.processDependencies();
        return this.orderedList.iterator();
    }

    public List<Task> getAllTasks() {
        ArrayList<Task> all = new ArrayList<Task>();
        for (Task task : this.orderedList) {
            all.add(task);
            all.addAll(this.getAllChildTasks(task));
        }
        return all;
    }

    public List<Task> getAllChildTasks(Task parent) {
        ArrayList<Task> all = new ArrayList<Task>();
        Task childTask = null;
        while (parent.spec.getChildren() != null && parent.spec.getChildren().size() > 0) {
            for (SequenceSpec childSpec : parent.spec.getChildren()) {
                childTask = this.findChildTaskBySequenceSpec(childSpec);
                if (childTask == null) continue;
                all.add(childTask);
            }
            parent = childTask;
        }
        return all;
    }

    private Task findChildTaskBySequenceSpec(SequenceSpec spec) {
        for (Task childTask : this.childTasks) {
            if (childTask.spec != spec) continue;
            return childTask;
        }
        return null;
    }

    public void processDependencies() {
        HashList tasksByStoreId = new HashList();
        List<Task> allTasks = this.getAllTasks();
        for (int i = 0; i < allTasks.size(); ++i) {
            Task task = allTasks.get(i);
            String storeId = task.step.getStoreID() != null ? task.step.getStoreID().get_value() : "";
            task.spec.setId(String.valueOf(i));
            tasksByStoreId.put((Object)storeId, (Object)task);
        }
        for (Task task : allTasks) {
            String[] dependentStoreIds = task.step.getDependentStepIds();
            task.spec.setDependentIds(this.getReplacementDependencyIds(tasksByStoreId, dependentStoreIds));
        }
    }

    private String[] getReplacementDependencyIds(HashList tasksByStoreId, String[] dependentStoreIds) {
        ArrayList<String> childIds = new ArrayList<String>();
        for (int i = 0; dependentStoreIds != null && i < dependentStoreIds.length; ++i) {
            String depStoreId = dependentStoreIds[i];
            if (depStoreId == null || !tasksByStoreId.containsKey((Object)depStoreId)) continue;
            List children = tasksByStoreId.get((Object)depStoreId);
            for (Task childTask : children) {
                childIds.add(childTask.spec.getId());
            }
        }
        return childIds.toArray(new String[0]);
    }

    public static class Task {
        public final SequenceSpec spec;
        public final BaseStepObject step;

        Task(BaseStepObject step, SequenceSpec spec) {
            this.spec = spec;
            this.step = step;
        }
    }
}

