/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.agent;

import com.cognos.asv.AgentServiceException;
import com.cognos.asv.PreviewResultHandler;
import com.cognos.asv.actions.AgentAction;
import com.cognos.asv.agent.Agent;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.asv.condition.CMAgentCondition;
import com.cognos.asv.condition.TransientAgentCondition;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.developer.schemas.bibus._3.AgentDefinitionView;
import com.cognos.developer.schemas.bibus._3.AuthoredReport;
import com.cognos.developer.schemas.bibus._3.BaseAgentDefinition;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ReportView;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.ValidationResultHandler;

public class AgentView
extends BaseAgent {
    private Agent m_agent;
    public ReportView m_viewReportView;

    public AgentView(AgentDefinitionView agentViewDefinition, ReportView viewReportView, Agent agent, JobBiBusHeaders headers) {
        super((BaseAgentDefinition)agentViewDefinition, headers);
        this.m_agent = agent;
        this.m_viewReportView = viewReportView;
    }

    public AgentDefinitionView getAgentDefinitionView() {
        return (AgentDefinitionView)this.getBaseClass();
    }

    @Override
    public ParameterValue[] getParameters() {
        ParameterValue[] params = new ParameterValue[]{};
        if (this.m_viewReportView != null && this.m_viewReportView.getParameters() != null) {
            params = this.m_viewReportView.getParameters().getValue();
        }
        return params;
    }

    @Override
    public Option[] getOptions() {
        Option[] baseAgentOptions = null;
        if (this.m_agent.getAgentDefinition() != null && this.m_agent.getAgentDefinition().getOptions() != null) {
            baseAgentOptions = this.m_agent.getAgentDefinition().getOptions().getValue();
        }
        Option[] agentViewOptions = null;
        if (this.getAgentDefinitionView() != null) {
            agentViewOptions = this.getAgentDefinitionView().getOptions().getValue();
        }
        return OptionUtils.mergeOptions(baseAgentOptions, agentViewOptions);
    }

    @Override
    public String getSequencing() {
        return this.m_agent.getSequencing();
    }

    @Override
    public String getEventKey() {
        return this.m_agent.getEventKey();
    }

    @Override
    public void preview(PreviewResultHandler previewResult) throws AgentServiceException {
        AuthoredReport conditionReport = this.m_agent.getConditionReport();
        String specification = null;
        if (!(conditionReport instanceof AuthoredReport)) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR);
        }
        specification = conditionReport.getSpecification().getValue();
        this.setDataSource(new TransientAgentCondition(this, specification));
        super.preview(previewResult);
    }

    @Override
    public void run(AgentAction action) throws AgentServiceException {
        this.setDataSource(new CMAgentCondition(this));
        super.run(action);
    }

    @Override
    public void validate(ValidationResultHandler validateResult) throws AgentServiceException {
        AuthoredReport conditionReport = this.m_agent.getConditionReport();
        String specification = null;
        if (!(conditionReport instanceof AuthoredReport)) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR);
        }
        specification = conditionReport.getSpecification().getValue();
        this.setDataSource(new TransientAgentCondition(this, specification));
        super.validate(validateResult);
    }

    @Override
    protected void postProcessTasks() {
    }

    public Agent getBaseAgent() {
        return this.m_agent;
    }

    public ReportView getReportView() {
        return this.m_viewReportView;
    }
}

