/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.agent;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.AgentTask;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.BaseStepObjectContainer;
import com.cognos.asv.PreviewResultHandler;
import com.cognos.asv.PromptPageGenerator;
import com.cognos.asv.actions.AgentAction;
import com.cognos.asv.actions.PreviewAgentAction;
import com.cognos.asv.actions.QueueAgentAction;
import com.cognos.asv.actions.ValidateAgentAction;
import com.cognos.asv.agent.ReportIdNamePOJO;
import com.cognos.asv.condition.AgentCondition;
import com.cognos.asv.condition.AgentHotlist;
import com.cognos.asv.history.AgentHistoryDetail;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetEmpty;
import com.cognos.asv.resultset.ResultSetSortTopic;
import com.cognos.asv.taskTargets.AgentMemoTarget;
import com.cognos.asv.taskTargets.AgentReportTarget;
import com.cognos.asv.taskTargets.memo.ResultSetDeliveryOptionsBuilder;
import com.cognos.developer.schemas.bibus._3.AgentOutputHotList;
import com.cognos.developer.schemas.bibus._3.AgentState;
import com.cognos.developer.schemas.bibus._3.AsynchOption;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionSearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.AsynchOptionStringArray;
import com.cognos.developer.schemas.bibus._3.BaseAgentDefinition;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.lock.ResourceLock;
import com.cognos.jsmcommon.lock.ResourceLockException;
import com.cognos.jsmcommon.lock.ResourceLockManager;
import com.cognos.jsmcommon.lock.jvm.JvmResourceLockFactory;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.RecursionDetector;
import com.cognos.jsmcommon.util.ThreadProperties;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import com.cognos.jsmcommon.util.datasource.NCDataSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class BaseAgent
extends BaseStepObjectContainer {
    public static final String RUN_SEQUENTIAL = "sequential";
    public static final String RUN_PARALLEL = "parallel";
    private ResultSet m_resultSet;
    private AgentCondition m_dataSource = null;
    private AgentState m_agentState;
    private NCDataSource m_eventOutput = null;
    private AgentOutputHotList m_agentOutputHotList = null;
    private boolean m_isTaskPromting = false;
    private PromptPageGenerator m_promptPageGenerator;
    private ResultSetSortTopic[] m_sortTopicsList = new ResultSetSortTopic[0];
    private ArrayList m_attachedReportIds = null;
    final String nameTag = "@name='";

    public BaseAgent(BaseAgentDefinition baseClass, JobBiBusHeaders headers) {
        super((BaseClass)baseClass, null, headers);
        this.m_resultSet = ResultSetEmpty.getResultSetNoMetadata(LocaleUtil.getLocale((String)this.getHeaders().getUserPreferenceContentLocale()));
    }

    public abstract String getSequencing();

    public abstract String getEventKey();

    protected abstract void postProcessTasks();

    public boolean isReportAttached(String searchPath) {
        if (this.m_attachedReportIds == null) {
            this.m_attachedReportIds = new ArrayList();
            ArrayList<BaseStepObject> memoTasks = new ArrayList<BaseStepObject>();
            ArrayList<ReportIdNamePOJO> reportIdNamePOJOList = new ArrayList<ReportIdNamePOJO>();
            List<BaseStepObject> subSteps = this.getSubSteps();
            for (BaseStepObject next : subSteps) {
                if (!(next instanceof BaseStepObjectContainer)) continue;
                BaseStepObjectContainer container = (BaseStepObjectContainer)next;
                List<BaseStepObject> steps = container.getSubSteps();
                for (int j = 0; j < steps.size(); ++j) {
                    BaseStepObject obj = steps.get(j);
                    if (obj instanceof AgentMemoTarget) {
                        memoTasks.add(next);
                    }
                    if (!(obj instanceof AgentReportTarget)) continue;
                    reportIdNamePOJOList.add(new ReportIdNamePOJO(container.getSearchPathStoreID(), container.getBaseClass().getDefaultName().getValue()));
                }
            }
            boolean isAttached = false;
            for (ReportIdNamePOJO reportIdNamePOJO : reportIdNamePOJOList) {
                String reportId = reportIdNamePOJO.getId();
                String reportName = reportIdNamePOJO.getName();
                for (int i = 0; i < memoTasks.size(); ++i) {
                    List<BaseStepObject> steps = ((BaseStepObjectContainer)memoTasks.get(i)).getSubSteps();
                    AgentMemoTarget memoTask = (AgentMemoTarget)steps.get(0);
                    isAttached = memoTask.isAttached(reportId);
                    if (!isAttached) {
                        isAttached = memoTask.isAttached(reportName);
                    }
                    if (!isAttached) continue;
                    this.m_attachedReportIds.add(reportId);
                }
            }
        }
        return this.m_attachedReportIds.contains(searchPath);
    }

    public void checkForRecursion() throws AgentServiceException {
        try {
            RecursionDetector.testForRecursion((Guid)this.getBaseClass().getStoreID().getValue(), (Option[])this.getSubmitOptions(), (JobBiBusHeaders)this.getHeaders());
        }
        catch (SDKClientException e) {
            throw new AgentServiceException((LocalizableException)((Object)e));
        }
        catch (EMFSecurityException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e});
        }
        catch (SDSServiceException sds) {
            throw new AgentServiceException((LocalizableException)((Object)sds));
        }
    }

    @Override
    public void cancel() {
        if (this.m_dataSource != null) {
            this.m_dataSource.cancel();
        }
        super.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run(AgentAction noAction) throws AgentServiceException {
        ResourceLock lock;
        block22: {
            lock = null;
            if (!this.isCancelled()) break block22;
            this.setStatus(EventStatus.CANCELLED);
            try {
                QueueAgentAction action = new QueueAgentAction();
                action.queueAgentFailureTasks(this);
                return;
            }
            catch (TaskPersistLayerException ex) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{ex});
            }
        }
        ResourceLockManager lockManager = (ResourceLockManager)ThreadProperties.getObject((String)"resource.lock.manager");
        lock = lockManager != null ? lockManager.getResourceLock(this.getStoreID().get_value()) : JvmResourceLockFactory.instance().getLock(this.getStoreID().get_value());
        try {
            lock.lock();
            this.m_dataSource.run();
            AgentHotlist hotlist = new AgentHotlist(this);
            hotlist.buildHotlist(this.m_resultSet);
        }
        finally {
            try {
                if (lock.isLocked()) {
                    lock.unlock();
                }
            }
            catch (Exception e) {
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.INFO, (Throwable)e);
                SDSLogger.getLogger((SDSCategory)JSMCommonCategory.AUDIT).debug("error unlocking " + this.getStoreID().get_value());
            }
        }
        this.postProcessTasks();
        if (this.m_resultSet.isEmpty()) {
            new AgentHistoryDetail(this).addMessage(AsvI18NCode.MSG_ASV_CONDITION_NOT_MET, null, SeverityEnum.info);
        }
        this.addAgentOutputHistoryDetail(this.getAgentOutputHotlist());
        QueueAgentAction action = new QueueAgentAction();
        action.queueAgentTasks(this, this.getSequencing().equals(RUN_PARALLEL));
        try {
            QueueAgentAction action2 = new QueueAgentAction();
            action2.queueAgentFailureTasks(this);
            return;
        }
        catch (TaskPersistLayerException ex) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{ex});
        }
        catch (ResourceLockException ex) {
            try {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_SIMULTANEOUS_AGENT_RUN, new Object[]{ex.getMessage()}, SeverityEnum.warn);
                catch (AgentServiceException ex2) {
                    throw ex2;
                }
                catch (Exception ex3) {
                    throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{ex3});
                }
            }
            catch (Throwable throwable) {
                try {
                    QueueAgentAction action3 = new QueueAgentAction();
                    action3.queueAgentFailureTasks(this);
                    throw throwable;
                }
                catch (TaskPersistLayerException ex4) {
                    throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{ex4});
                }
            }
        }
    }

    @Override
    public void validate(ValidationResultHandler validateResult) throws AgentServiceException {
        try {
            if (this.isCancelled()) {
                this.setStatus(EventStatus.CANCELLED);
                return;
            }
            this.m_dataSource.validate(validateResult);
            this.forceFullResultsOnTasks();
            ValidateAgentAction vaa = new ValidateAgentAction(validateResult);
            vaa.executeInSeries(this);
            vaa.validateAgentTaskDependencies(this);
        }
        catch (AgentServiceException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_VALIDATION_FAIL, new Object[]{t});
        }
    }

    @Override
    public void preview(PreviewResultHandler previewResult) throws AgentServiceException {
        try {
            if (this.isCancelled()) {
                this.setStatus(EventStatus.CANCELLED);
                return;
            }
            this.m_dataSource.run();
            this.forceFullResultsOnTasks();
            PreviewAgentAction paa = new PreviewAgentAction(previewResult);
            paa.execute(this);
        }
        catch (AgentServiceException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{t});
        }
    }

    public void setResultSet(ResultSet result_set) {
        this.m_resultSet = result_set;
    }

    public ResultSet getResultSet() {
        return this.m_resultSet;
    }

    protected void queueStepsForExecution(boolean parallel) throws AgentServiceException, TaskPersistLayerException {
        QueueAgentAction action = new QueueAgentAction();
        action.queueAgentTasks(this, parallel);
    }

    private void addAgentOutputHistoryDetail(AgentOutputHotList hotlist) throws AgentServiceException {
        if (hotlist == null) {
            String msg = "Agent hotlist is null (agent run)";
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{msg});
        }
        new AgentHistoryDetail(this).addOutputDetail(hotlist);
    }

    public AsynchOptionSearchPathSingleObject getHistoryLocation() {
        AsynchOption historyOption = (AsynchOption)OptionUtils.findFirstOptionWithNameEnum((Option[])this.getSubmitOptions(), (Object)AsynchOptionEnum.historyLocation);
        return historyOption instanceof AsynchOptionSearchPathSingleObject ? (AsynchOptionSearchPathSingleObject)historyOption : null;
    }

    public AsynchOptionStringArray getRunContextID() {
        AsynchOption contextIDOption = (AsynchOption)OptionUtils.findFirstOptionWithNameEnum((Option[])this.getSubmitOptions(), (Object)AsynchOptionEnum.runContext);
        return contextIDOption instanceof AsynchOptionStringArray ? (AsynchOptionStringArray)contextIDOption : null;
    }

    public TaskID getParentTaskID() {
        AsynchOptionStringArray contextIDs = this.getRunContextID();
        return TaskID.fromEventId((String)contextIDs.getValue()[contextIDs.getValue().length - 1]);
    }

    public boolean parentTaskIDExists() {
        return this.getRunContextID() != null;
    }

    public void setAgentState(AgentState agentState) {
        this.m_agentState = agentState;
    }

    public AgentState getAgentState() {
        return this.m_agentState;
    }

    public void onTaskFailed(AgentTask task) throws AgentServiceException {
        if (this.getResultSet().numDataItems() > 0) {
            String name = "";
            BaseClass taskStepBaseClass = task.getCurrentStep().getBaseClass();
            TokenProp defName = taskStepBaseClass.getDefaultName();
            if (null != defName) {
                name = defName.getValue();
            } else {
                String taskName;
                name = taskName = taskStepBaseClass.getSearchPath().getValue();
                if (taskName.indexOf("@name='") > "@name='".length()) {
                    name = taskName.substring(taskName.lastIndexOf("@name='") + "@name='".length(), taskName.length() - 2);
                }
            }
            AgentHistoryDetail hist = new AgentHistoryDetail(this);
            hist.addMessage(AsvI18NCode.MSG_ASV_TASK_FAILED, new Object[]{name}, SeverityEnum.info);
        }
    }

    public void setEventOutput(NCDataSource output) {
        this.m_eventOutput = output;
    }

    public boolean usesEventOutput() {
        return this.usesEventOutput(this);
    }

    private boolean usesEventOutput(BaseStepObjectContainer parentBso) {
        boolean uses = false;
        Iterator<BaseStepObject> steps = parentBso.getSubSteps().iterator();
        while (!uses && steps.hasNext()) {
            BaseStepObject bso = steps.next();
            if (bso instanceof AgentMemoTarget) {
                if (!ResultSetDeliveryOptionsBuilder.usesEventOutput(((AgentMemoTarget)bso).getOptions())) continue;
                uses = true;
                continue;
            }
            if (!(bso instanceof BaseStepObjectContainer)) continue;
            uses = this.usesEventOutput((BaseStepObjectContainer)bso);
        }
        return uses;
    }

    public NCDataSource getEventOutput() {
        return this.m_eventOutput;
    }

    public void setSortTopics(ResultSetSortTopic[] topicsList) {
        this.m_sortTopicsList = topicsList;
    }

    public ResultSetSortTopic[] getSortTopics() {
        return this.m_sortTopicsList;
    }

    public void setAgentOutputHotlist(AgentOutputHotList hotlist) {
        this.m_agentOutputHotList = hotlist;
    }

    public AgentOutputHotList getAgentOutputHotlist() {
        return this.m_agentOutputHotList;
    }

    public boolean isTaskPromting() {
        return this.m_isTaskPromting;
    }

    public void setTaskPromting(boolean isTaskPromting) {
        this.m_isTaskPromting = isTaskPromting;
    }

    public PromptPageGenerator getPromptPageGenerator() {
        return this.m_promptPageGenerator;
    }

    public void setPromptPageGenerator(PromptPageGenerator promptPageGenerator) {
        this.m_promptPageGenerator = promptPageGenerator;
    }

    private void forceFullResultsOnTasks() {
        for (BaseStepObject step : this.getSubSteps()) {
            ((AgentTask)step).setResultSet(this.m_resultSet);
        }
    }

    protected void setDataSource(AgentCondition dataSource) {
        this.m_dataSource = dataSource;
    }
}

