/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.agent;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.AgentTask;
import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.PreviewResultHandler;
import com.cognos.asv.ReportDataServiceSelection;
import com.cognos.asv.actions.AgentAction;
import com.cognos.asv.agent.AuthoredAgent;
import com.cognos.asv.condition.ReportDataServiceCondition;
import com.cognos.asv.history.AgentHistoryDetail;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetDataValue;
import com.cognos.asv.resultset.ResultSetKey;
import com.cognos.asv.resultset.ResultSetTopic;
import com.cognos.asv.taskTargets.AgentBaseRssTarget;
import com.cognos.asv.taskTargets.AgentHumanTaskTarget;
import com.cognos.asv.taskTargets.AgentMemoTarget;
import com.cognos.developer.schemas.bibus._3.AuthoredAgentDefinition;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionEnum;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionMemoPart;
import com.cognos.developer.schemas.bibus._3.DocumentContent;
import com.cognos.developer.schemas.bibus._3.HumanTask;
import com.cognos.developer.schemas.bibus._3.Memo;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartComposite;
import com.cognos.developer.schemas.bibus._3.MemoPartObject;
import com.cognos.developer.schemas.bibus._3.MemoPartObjectLinks;
import com.cognos.developer.schemas.bibus._3.ObjectLink;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OptionArrayProp;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParameterValueArrayProp;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.ReportDataServiceAgentDefinition;
import com.cognos.developer.schemas.bibus._3.RunOptionBoolean;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.ShortcutRSSTask;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.SmtpContentDispositionEnum;
import com.cognos.developer.schemas.bibus._3.SmtpContentTypeEnum;
import com.cognos.developer.schemas.bibus._3.SubscriptionOptionEnum;
import com.cognos.developer.schemas.bibus._3.SubscriptionOptionSearchPathSingleObject;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;

public class ReportDataServiceAgent
extends AuthoredAgent {
    private BaseClass m_periodicalProducer;
    private ReportDataServiceSelection m_selection;
    private static final String DEFAULT_ATTACH_FORMAT = "MHT";
    private static final String DEFAULT_LINK_FORMAT = "HTML";

    public ReportDataServiceAgent(ReportDataServiceAgentDefinition agentDefinition, JobBiBusHeaders headers, BaseClass periodicalProducer) {
        super((AuthoredAgentDefinition)agentDefinition, headers);
        this.m_periodicalProducer = periodicalProducer;
        String selectionXML = this.getReportDataServiceAgentDefinition().getReport().getValue().getValue().get_value();
        this.m_selection = new ReportDataServiceSelection(selectionXML, this.getReportDataServiceAgentDefinition().getSearchPath().getValue());
    }

    @Override
    public ParameterValue[] getParameters() throws AgentServiceException {
        return null;
    }

    @Override
    public Option[] getOptions() {
        return null;
    }

    public ReportDataServiceAgentDefinition getReportDataServiceAgentDefinition() {
        return (ReportDataServiceAgentDefinition)this.getBaseClass();
    }

    @Override
    public void preview(PreviewResultHandler previewResult) throws AgentServiceException {
        throw new IllegalStateException("not implemented");
    }

    @Override
    public void run(AgentAction action) throws AgentServiceException {
        this.m_selection.process();
        BaseClass[] matchingDocumentContent = this.findMatchingDocumentContent();
        if (this.m_periodicalProducer != null) {
            if (matchingDocumentContent != null && matchingDocumentContent.length > 0) {
                this.preProcessTasks(matchingDocumentContent);
                this.setDataSource(new ReportDataServiceCondition(this, this.m_selection, this.m_periodicalProducer));
                super.run(action);
            } else {
                new AgentHistoryDetail(this).addMessage(AsvI18NCode.MSG_ASV_NO_MATCHING_DOCUMENT_CONTENT_DETAIL, null, SeverityEnum.info);
                try {
                    this.queueStepsForExecution(this.getSequencing().equals("parallel"));
                }
                catch (Exception ex) {
                    throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{ex});
                }
            }
        } else {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_NULL_PERIODICAL_PRODUCER);
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_NULL_PERIODICAL_PRODUCER);
        }
    }

    @Override
    public void validate(ValidationResultHandler validateResult) throws AgentServiceException {
        throw new IllegalStateException("not implemented");
    }

    private BaseClass[] findMatchingDocumentContent() throws AgentServiceException {
        BaseClass[] permissableDocumentContent;
        BaseClass[] matchingDocumentContent = null;
        BaseClass[] documentContentObjs = this.findDocumentContent();
        if (documentContentObjs != null && documentContentObjs.length > 0 && ((permissableDocumentContent = this.findPermissableDocumentContents(documentContentObjs)) != null || permissableDocumentContent.length > 0)) {
            matchingDocumentContent = this.findDocumentContentMatchingLocale(permissableDocumentContent);
        }
        return matchingDocumentContent;
    }

    private void preProcessTasks(BaseClass[] documentContentObjs) {
        for (AgentTask agentTask : this.getSubSteps()) {
            for (BaseAgentTaskTarget baseAgentTaskTarget : agentTask.getSubSteps()) {
                if (baseAgentTaskTarget instanceof AgentMemoTarget) {
                    this.processMemoTarget(baseAgentTaskTarget, documentContentObjs);
                    continue;
                }
                if (baseAgentTaskTarget instanceof AgentBaseRssTarget) {
                    this.processRSSTarget(baseAgentTaskTarget, documentContentObjs);
                    continue;
                }
                if (!(baseAgentTaskTarget instanceof AgentHumanTaskTarget)) continue;
                this.processHumanTask(baseAgentTaskTarget, documentContentObjs);
            }
        }
    }

    private void processHumanTask(BaseAgentTaskTarget humanTarget, BaseClass[] documentContentObjs) {
        HumanTask humanTask = (HumanTask)humanTarget.getBaseClass();
        String format = this.getHeaders().getUserPreferenceOutputFormat();
        DocumentContent linkContent = this.findMatchingDocumentContent(documentContentObjs, format, this.m_selection.getContentLocale());
        if (linkContent == null && format != null && !format.equals(DEFAULT_LINK_FORMAT)) {
            linkContent = this.findMatchingDocumentContent(documentContentObjs, DEFAULT_LINK_FORMAT, this.m_selection.getContentLocale());
        }
        if (linkContent == null) {
            linkContent = this.findFirstUsableDocumentContent(documentContentObjs, this.m_selection.getContentLocale());
        }
        if (linkContent == null) {
            String searchPath = this.getSearchPath();
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_NO_MATCHING_DOCUMENT_CONTENT_TASK, new Object[]{searchPath});
        } else {
            ParmValueItem humanTaskParmValue;
            ParmValueItem[] parmValueItemArray;
            ParameterValue humanTaskCall;
            ParameterValue[] parameterValueArray;
            ParameterValueArrayProp parameterValueArrayProp = humanTask.getParameters();
            if (parameterValueArrayProp != null && (parameterValueArray = parameterValueArrayProp.getValue()) != null && parameterValueArray.length == 1 && (humanTaskCall = parameterValueArray[0]) != null && (parmValueItemArray = humanTaskCall.getValue()) != null && parmValueItemArray.length == 1 && (humanTaskParmValue = parmValueItemArray[0]) != null && humanTaskParmValue instanceof SimpleParmValueItem) {
                SimpleParmValueItem simpleParmValueItem = (SimpleParmValueItem)humanTaskParmValue;
                String useValue = simpleParmValueItem.getUse();
                Document doc = null;
                try {
                    doc = DocumentHelper.parseText((String)useValue);
                    Node linkItem = doc.selectSingleNode("/*[local-name()='createNotificationManualTask']/*[local-name()='manualTask']/*[local-name()='linksList']/*[local-name()='link']");
                    if (linkItem != null) {
                        Node linkID = linkItem.selectSingleNode("./*[local-name()='id']");
                        String searchPath = "storeID('" + linkContent.getStoreID().getValue().get_value() + "')";
                        linkID.setText(searchPath);
                        Node linkDisplay = linkItem.selectSingleNode("./*[local-name()='display']");
                        linkDisplay.setText(this.m_periodicalProducer.getDefaultName().getValue());
                    }
                    simpleParmValueItem.setUse(doc.asXML());
                }
                catch (DocumentException documentException) {
                    // empty catch block
                }
            }
        }
    }

    private void processRSSTarget(BaseAgentTaskTarget rssTarget, BaseClass[] documentContentObjs) {
        ShortcutRSSTask rssTask = (ShortcutRSSTask)rssTarget.getBaseClass();
        String format = this.getHeaders().getUserPreferenceOutputFormat();
        DocumentContent linkContent = this.findMatchingDocumentContent(documentContentObjs, format, this.m_selection.getContentLocale());
        if (linkContent == null && format != null && !format.equals(DEFAULT_LINK_FORMAT)) {
            linkContent = this.findMatchingDocumentContent(documentContentObjs, DEFAULT_LINK_FORMAT, this.m_selection.getContentLocale());
        }
        if (linkContent == null) {
            linkContent = this.findFirstUsableDocumentContent(documentContentObjs, this.m_selection.getContentLocale());
        }
        if (linkContent == null) {
            String searchPath = this.getSearchPath();
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_NO_MATCHING_DOCUMENT_CONTENT_NEWSITEM, new Object[]{searchPath});
        }
        BaseClassArrayProp baseClassArrayProp = new BaseClassArrayProp();
        baseClassArrayProp.setValue(new BaseClass[]{linkContent});
        rssTask.setLink(baseClassArrayProp);
    }

    private void processMemoTarget(BaseAgentTaskTarget memoTarget, BaseClass[] documentContentObjs) {
        String searchPath;
        String format;
        Memo memo = (Memo)memoTarget.getBaseClass();
        OptionArrayProp memoOptionArrayProp = memo.getOptions();
        Option[] memoOptionArray = memoOptionArrayProp.getValue();
        DocumentContent attachmentContent = null;
        DocumentContent linkContent = null;
        RunOptionBoolean emailAsAttachment = (RunOptionBoolean)OptionUtils.findFirstOptionWithNameEnum((Option[])memoOptionArray, (Object)RunOptionEnum.emailAsAttachment);
        RunOptionBoolean emailAsURL = (RunOptionBoolean)OptionUtils.findFirstOptionWithNameEnum((Option[])memoOptionArray, (Object)RunOptionEnum.emailAsURL);
        DeliveryOptionMemoPart deliveryOptionMemoPart = (DeliveryOptionMemoPart)OptionUtils.findFirstOptionWithNameEnum((Option[])memoOptionArray, (Object)DeliveryOptionEnum.memoPart);
        if (emailAsAttachment != null && emailAsAttachment.isValue()) {
            memoOptionArray = OptionUtils.removeOptionsWithNameEnum((Option[])memoOptionArray, (Object)RunOptionEnum.emailAsAttachment);
            format = this.getHeaders().getUserPreferenceOutputFormat();
            format = DEFAULT_LINK_FORMAT.equals(format) ? DEFAULT_ATTACH_FORMAT : format;
            attachmentContent = this.findMatchingDocumentContent(documentContentObjs, format, this.m_selection.getContentLocale());
            if (attachmentContent == null && format != null && !format.equals(DEFAULT_ATTACH_FORMAT)) {
                attachmentContent = this.findMatchingDocumentContent(documentContentObjs, DEFAULT_ATTACH_FORMAT, this.m_selection.getContentLocale());
            }
            if (attachmentContent == null) {
                attachmentContent = this.findFirstUsableDocumentContent(documentContentObjs, this.m_selection.getContentLocale());
            }
            if (attachmentContent == null) {
                searchPath = this.getSearchPath();
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_NO_MATCHING_DOCUMENT_CONTENT_ATTACHMENT, new Object[]{searchPath});
            }
        }
        if (emailAsURL != null && emailAsURL.isValue()) {
            memoOptionArray = OptionUtils.removeOptionsWithNameEnum((Option[])memoOptionArray, (Object)RunOptionEnum.emailAsURL);
            format = this.getHeaders().getUserPreferenceOutputFormat();
            linkContent = this.findMatchingDocumentContent(documentContentObjs, format, this.m_selection.getContentLocale());
            if (linkContent == null && format != DEFAULT_LINK_FORMAT) {
                linkContent = this.findMatchingDocumentContent(documentContentObjs, DEFAULT_LINK_FORMAT, this.m_selection.getContentLocale());
            }
            if (linkContent == null) {
                linkContent = this.findFirstUsableDocumentContent(documentContentObjs, this.m_selection.getContentLocale());
            }
            if (linkContent == null) {
                searchPath = this.getSearchPath();
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_NO_MATCHING_DOCUMENT_CONTENT_LINK, new Object[]{searchPath});
            }
        }
        memo.getOptions().setValue(memoOptionArray);
        if (linkContent != null || attachmentContent != null) {
            if (deliveryOptionMemoPart == null) {
                deliveryOptionMemoPart = new DeliveryOptionMemoPart();
                deliveryOptionMemoPart.setName(DeliveryOptionEnum.memoPart);
                MemoPartComposite memoPartComposite = new MemoPartComposite();
                memoPartComposite.setContentDisposition(SmtpContentDispositionEnum.inline);
                memoPartComposite.setContentType(SmtpContentTypeEnum.mixed);
                ArrayList<Object> parts = new ArrayList<Object>();
                if (linkContent != null) {
                    MemoPartObjectLinks memoPartObjectLinks = this.buildMemoPartObjectLink(linkContent);
                    parts.add(memoPartObjectLinks);
                }
                if (attachmentContent != null) {
                    MemoPartObject memoPartObject = this.buildMemoPartObject(attachmentContent);
                    parts.add(memoPartObject);
                }
                memoPartComposite.setParts(parts.toArray(new MemoPart[parts.size()]));
                deliveryOptionMemoPart.setValue((MemoPart)memoPartComposite);
                memoOptionArrayProp.setValue(OptionUtils.mergeOptions((Option[])memoOptionArray, (Option[])new Option[]{deliveryOptionMemoPart}));
            } else {
                MemoPart memoPart = deliveryOptionMemoPart.getValue();
                if (memoPart instanceof MemoPartComposite) {
                    MemoPartComposite memoPartComposite = (MemoPartComposite)memoPart;
                    MemoPartComposite email = new MemoPartComposite();
                    email.setContentDisposition(SmtpContentDispositionEnum.inline);
                    email.setContentType(SmtpContentTypeEnum.mixed);
                    ArrayList<Object> parts = new ArrayList<Object>();
                    parts.add(memoPartComposite);
                    if (attachmentContent != null) {
                        MemoPartObject memoPartObject = this.buildMemoPartObject(attachmentContent);
                        parts.add(memoPartObject);
                    }
                    if (linkContent != null) {
                        MemoPartObjectLinks memoPartObjectLinks = this.buildMemoPartObjectLink(linkContent);
                        parts.add(memoPartObjectLinks);
                    }
                    email.setParts(parts.toArray(new MemoPart[parts.size()]));
                    deliveryOptionMemoPart.setValue((MemoPart)email);
                }
            }
        }
    }

    private MemoPartObjectLinks buildMemoPartObjectLink(DocumentContent HTMLContent) {
        MemoPartObjectLinks memoPartObjectLinks = new MemoPartObjectLinks();
        memoPartObjectLinks.setContentDisposition(SmtpContentDispositionEnum.inline);
        ObjectLink objectLink = new ObjectLink();
        objectLink.setObjectClass(ClassEnum.fromString((String)"documentContent"));
        SearchPathSingleObject searchPathSingleObject = new SearchPathSingleObject();
        searchPathSingleObject.set_value(HTMLContent.getSearchPath().getValue());
        objectLink.setSearchPath(searchPathSingleObject);
        memoPartObjectLinks.setLinks(new ObjectLink[]{objectLink});
        return memoPartObjectLinks;
    }

    private MemoPartObject buildMemoPartObject(DocumentContent MHTContent) {
        MemoPartObject memoPartObject = new MemoPartObject();
        memoPartObject.setContentDisposition(SmtpContentDispositionEnum.attachment);
        SearchPathSingleObject searchPathSingleObject = new SearchPathSingleObject();
        searchPathSingleObject.set_value(MHTContent.getSearchPath().getValue());
        memoPartObject.setSearchPath(searchPathSingleObject);
        return memoPartObject;
    }

    private BaseClass[] findPermissableDocumentContents(BaseClass[] documentContentObjs) {
        ArrayList<DocumentContent> permissableDocumentContents = new ArrayList<DocumentContent>();
        for (int i = 0; i < documentContentObjs.length; ++i) {
            DocumentContent documentContent = (DocumentContent)documentContentObjs[i];
            if (documentContent == null || !AuthenticatorFactory.getInstance().hasPermission((BaseClass)documentContent, "read")) continue;
            permissableDocumentContents.add(documentContent);
        }
        return permissableDocumentContents.toArray(new BaseClass[permissableDocumentContents.size()]);
    }

    private BaseClass[] findDocumentContentMatchingLocale(BaseClass[] documentContentObjs) {
        ArrayList<DocumentContent> documentContentMatchingLocale = new ArrayList<DocumentContent>();
        TreeSet<String> availableFormats = new TreeSet<String>();
        for (int i = 0; i < documentContentObjs.length; ++i) {
            DocumentContent documentContent = (DocumentContent)documentContentObjs[i];
            if (documentContent == null) continue;
            availableFormats.add(documentContent.getFormat().getValue());
        }
        for (String format : availableFormats) {
            DocumentContent bestDocumentContent = this.findMatchingDocumentContent(documentContentObjs, format, this.m_selection.getContentLocale());
            if (bestDocumentContent == null) continue;
            documentContentMatchingLocale.add(bestDocumentContent);
        }
        return documentContentMatchingLocale.toArray(new BaseClass[documentContentMatchingLocale.size()]);
    }

    private DocumentContent findMatchingDocumentContent(BaseClass[] documentContentObjs, String format, String locale) {
        ArrayList<DocumentContent> matchingFormatDocuments = new ArrayList<DocumentContent>();
        for (int i = 0; i < documentContentObjs.length; ++i) {
            DocumentContent documentContent = (DocumentContent)documentContentObjs[i];
            if (documentContent == null || !documentContent.getFormat().getValue().equalsIgnoreCase(format)) continue;
            matchingFormatDocuments.add(documentContent);
        }
        return this.findBestMatchingLocale(matchingFormatDocuments, locale);
    }

    private DocumentContent findFirstUsableDocumentContent(BaseClass[] documentContentObjs, String locale) {
        ArrayList<DocumentContent> matchingFormatDocuments = new ArrayList<DocumentContent>();
        for (int i = 0; i < documentContentObjs.length; ++i) {
            DocumentContent documentContent = (DocumentContent)documentContentObjs[i];
            if (documentContent == null || documentContent.getFormat().getValue().equalsIgnoreCase("layoutDataXML")) continue;
            matchingFormatDocuments.add(documentContent);
        }
        return this.findBestMatchingLocale(matchingFormatDocuments, locale);
    }

    private DocumentContent findBestMatchingLocale(List documentContentObjects, String searchLocale) {
        DocumentContent sChoice2Match = null;
        int iDivLoc = searchLocale.indexOf(45);
        String sLangPart = iDivLoc == -1 ? searchLocale : searchLocale.substring(0, iDivLoc);
        for (DocumentContent documentContent : documentContentObjects) {
            String locale = documentContent.getLocale().getValue();
            if (searchLocale.equals(locale)) {
                return documentContent;
            }
            if (sChoice2Match != null || !locale.startsWith(sLangPart)) continue;
            sChoice2Match = documentContent;
        }
        return sChoice2Match;
    }

    private BaseClass[] findDocumentContent() throws AgentServiceException {
        BaseClass[] documentContentObjects = null;
        SubscriptionOptionSearchPathSingleObject documentVersionId = (SubscriptionOptionSearchPathSingleObject)OptionUtils.findFirstOptionWithNameEnum((Option[])this.getSubmitOptions(), (Object)SubscriptionOptionEnum.documentVersion);
        StringBuffer searchPath = new StringBuffer(documentVersionId.getValue().get_value());
        searchPath.append("/documentContent");
        if (this.m_selection.getBurstID() != null && this.m_selection.getBurstID().length() > 0) {
            searchPath.append("[@burstID='" + this.m_selection.getBurstID() + "']");
        }
        ContentManagerServiceClientPort contentManager = null;
        try {
            contentManager = Client.instance().getContentManagerServiceClient(this.getHeaders());
            documentContentObjects = contentManager.query(searchPath.toString(), new PropEnum[]{PropEnum.searchPath, PropEnum.storeID, PropEnum.format, PropEnum.locale, PropEnum.permissions}, null, null);
        }
        catch (SDKClientException e) {
            throw new AgentServiceException((LocalizableException)((Object)e));
        }
        catch (EMFSecurityException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e});
        }
        finally {
            if (contentManager != null) {
                contentManager.close();
            }
        }
        return documentContentObjects;
    }

    @Override
    protected void postProcessTasks() {
        for (AgentTask agentTask : this.getSubSteps()) {
            for (BaseAgentTaskTarget baseAgentTaskTarget : agentTask.getSubSteps()) {
                if (!(baseAgentTaskTarget instanceof AgentHumanTaskTarget)) continue;
                this.postProcessHumanTask(baseAgentTaskTarget);
            }
        }
    }

    private void postProcessHumanTask(BaseAgentTaskTarget humanTarget) {
        ParmValueItem humanTaskParmValue;
        ParmValueItem[] parmValueItemArray;
        ParameterValue humanTaskCall;
        ParameterValue[] parameterValueArray;
        HumanTask humanTask = (HumanTask)humanTarget.getBaseClass();
        ParameterValueArrayProp parameterValueArrayProp = humanTask.getParameters();
        if (parameterValueArrayProp != null && (parameterValueArray = parameterValueArrayProp.getValue()) != null && parameterValueArray.length == 1 && (humanTaskCall = parameterValueArray[0]) != null && (parmValueItemArray = humanTaskCall.getValue()) != null && parmValueItemArray.length == 1 && (humanTaskParmValue = parmValueItemArray[0]) != null && humanTaskParmValue instanceof SimpleParmValueItem) {
            SimpleParmValueItem simpleParmValueItem = (SimpleParmValueItem)humanTaskParmValue;
            String useValue = simpleParmValueItem.getUse();
            Document doc = null;
            try {
                ResultSet rs;
                Iterator resultSetIterator;
                doc = DocumentHelper.parseText((String)useValue);
                Node iconNode = doc.selectSingleNode("/*[local-name()='createNotificationManualTask']/*[local-name()='manualTask']/*[local-name()='taskIconPath']");
                if (iconNode != null && this.m_selection.isMetricWatchRule().booleanValue() && (resultSetIterator = (rs = this.getResultSet()).getData()).hasNext()) {
                    ResultSetKey rsKey = (ResultSetKey)resultSetIterator.next();
                    ResultSetDataValue poorDataValue = rs.getDataValue(rsKey, new ResultSetTopic("poor", "[poor]"));
                    ResultSetDataValue averageDataValue = rs.getDataValue(rsKey, new ResultSetTopic("average", "[average]"));
                    ResultSetDataValue goodDataValue = rs.getDataValue(rsKey, new ResultSetTopic("good", "[good]"));
                    String iconImagePath = null;
                    if (poorDataValue.getRawValue().equals("true")) {
                        iconImagePath = "ps/portal/images/watchwiz/traffic_3_sm.gif";
                    } else if (averageDataValue.getRawValue().equals("true")) {
                        iconImagePath = "ps/portal/images/watchwiz/traffic_5_sm.gif";
                    } else if (goodDataValue.getRawValue().equals("true")) {
                        iconImagePath = "ps/portal/images/watchwiz/traffic_7_sm.gif";
                    }
                    iconNode.setText(iconImagePath);
                }
                simpleParmValueItem.setUse(doc.asXML());
            }
            catch (DocumentException documentException) {
                // empty catch block
            }
        }
    }
}

