/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.condition;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentConditionException;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.ResolveOptionsUtil;
import com.cognos.asv.ResolveParametersUtil;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.asv.condition.AgentCondition;
import com.cognos.asv.condition.ReportServerCondition;
import com.cognos.asv.condition.ReportSpecificationParser;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetHTML;
import com.cognos.asv.resultset.ResultSetHTMLParser;
import com.cognos.asv.resultset.ResultSetPaged;
import com.cognos.asv.resultset.ResultSetParser;
import com.cognos.asv.resultset.ResultSetProcessed;
import com.cognos.asv.resultset.ResultSetTypeEnum;
import com.cognos.developer.schemas.bibus._3.AnyTypeProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BooleanProp;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OrderEnum;
import com.cognos.developer.schemas.bibus._3.Output;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.ReportVersion;
import com.cognos.developer.schemas.bibus._3.ReportView;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.developer.schemas.bibus._3.UpdateOptions;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.AsyncConversation;
import com.cognos.jsmcommon.util.DataSizeChecker;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class CMAgentCondition
extends AgentCondition {
    private AsyncConversation m_conversation = new AsyncConversation();

    public CMAgentCondition(BaseAgent agent) {
        super(agent);
    }

    @Override
    public synchronized void cancel() {
        this.m_conversation.cancel();
    }

    @Override
    public void validate(ValidationResultHandler validateResult) throws AgentServiceException {
        I18NMessage[] messages = new I18NMessage[]{};
        try {
            this.run();
        }
        catch (AgentConditionException e) {
            messages = new I18NMessage[]{new I18NMessage(e.getI18NCode(), e.getParams(), e.getSeverity())};
        }
        validateResult.addValidationMessages(messages);
    }

    @Override
    public void run() throws AgentConditionException {
        if (this.getAgent().isCancelled()) {
            return;
        }
        try {
            String conditionSpec;
            String previousConditionSpec = "";
            ResultSet previous_rs = this.createResultSet(this.getReportPath() + "/reportVersion[last()]/output");
            if (previous_rs != null) {
                previousConditionSpec = this.getLastSavedVersionSpec();
                this.updateReportViewNameToLatestBaseAgentName();
            }
            this.evaluateCondition();
            if (this.getAgent().isCancelled()) {
                return;
            }
            ResultSet rs = this.createResultSet(this.getReportPath() + "/reportVersion[last()]/output");
            if (null != rs && (conditionSpec = this.getLastSavedVersionSpec()) != null) {
                ReportSpecificationParser conditionSpecParser = new ReportSpecificationParser(conditionSpec);
                ReportSpecificationParser previousConditionSpecParser = new ReportSpecificationParser(previousConditionSpec);
                if (!conditionSpecParser.specEqualTo(previousConditionSpecParser)) {
                    SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug("Detected conditon change [agent:" + this.getAgent().getSearchPath() + "] - event monitoring reset");
                    previous_rs = null;
                }
                try {
                    this.getAgent().setSortTopics(conditionSpecParser.getSortTopics());
                }
                catch (AgentServiceException e) {
                    SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.INFO, (LocalizableException)e);
                }
            }
            ResultSetProcessed p_rs = new ResultSetProcessed(previous_rs, rs, this.getAgent().getEventKey());
            this.getAgent().setResultSet(p_rs);
        }
        catch (AgentConditionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AgentConditionException(AsvI18NCode.MSG_ASV_CONDITION_INVALID, new Object[]{e});
        }
    }

    private void evaluateCondition() throws AgentConditionException {
        try {
            Option[] options = ResolveOptionsUtil.resolveConditionOptions(this.getAgent());
            ParameterValue[] parameters = ResolveParametersUtil.resolveParameters(this.getAgent(), false);
            ReportServerCondition rsvpCondition = new ReportServerCondition(this.m_conversation, this.getAgent(), options, parameters);
            rsvpCondition.run(this.getReportPath());
        }
        catch (LocalizableException e) {
            throw new AgentConditionException(AsvI18NCode.MSG_ASV_CONDITION_INVALID, new Object[]{e});
        }
        finally {
            this.hideReportVersion();
        }
    }

    private String getReportPath() {
        return this.getAgentStateSearchPath() + "/reportView";
    }

    private String getReportVersionPath() {
        return this.getAgentStateSearchPath() + "/reportView/reportVersion[last()]";
    }

    private String getAgentStateSearchPath() {
        return ObjectModelUtil.getSearchPath((Guid)this.getAgent().getAgentState().getStoreID().getValue()).get_value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLastSavedVersionSpec() throws Exception {
        String reportVersionSpec = null;
        PropEnum[] reportVersionProps = new PropEnum[]{PropEnum.searchPath, PropEnum.specification};
        ContentManagerServiceClientPort cmsp = Client.instance().getContentManagerServiceClient(this.getAgent().getHeaders());
        try {
            QueryOptions query_options = new QueryOptions();
            BaseClass[] bases = cmsp.query(this.getReportPath() + "/reportVersion[last()]", reportVersionProps, null, query_options);
            if (bases != null && bases.length > 0) {
                for (int i = 0; i < bases.length; ++i) {
                    ReportVersion reportVersion = (ReportVersion)bases[i];
                    AnyTypeProp specProp = reportVersion.getSpecification();
                    reportVersionSpec = specProp.getValue();
                }
            }
        }
        finally {
            cmsp.close();
        }
        return reportVersionSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReportViewNameToLatestBaseAgentName() throws Exception {
        ContentManagerServiceClientPort cmPort = Client.instance().getContentManagerServiceClient(this.getAgent().getHeaders());
        try {
            cmPort = Client.instance().getContentManagerServiceClient(this.getAgent().getHeaders());
            TokenProp agentName = this.getAgent().getBaseClass().getDefaultName();
            ReportView reportVersion = new ReportView();
            StringProp searchPathProp = new StringProp();
            searchPathProp.setValue(this.getReportPath());
            reportVersion.setSearchPath(searchPathProp);
            reportVersion.setDefaultName(agentName);
            cmPort.update(new BaseClass[]{reportVersion}, new UpdateOptions());
        }
        finally {
            cmPort.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap getLastSavedVersion(String theSearchPath) throws Exception {
        HashMap<String, ByteArrayInputStream> outputs = null;
        Sort reportVersionSort = new Sort();
        reportVersionSort.setOrder(OrderEnum.descending);
        reportVersionSort.setPropName(PropEnum.creationTime);
        ContentManagerServiceClientPort cmsp = Client.instance().getContentManagerServiceClient(this.getAgent().getHeaders());
        try {
            QueryOptions query_options = new QueryOptions();
            query_options.setDataEncoding(EncodingEnum.base64);
            query_options.setMaxDataBytes(DataSizeChecker.getAgentConditionDataSize());
            PropEnum[] outputProps = new PropEnum[]{PropEnum.data, PropEnum.dataSize, PropEnum.dataType, PropEnum.format};
            BaseClass[] outputBases = cmsp.query(theSearchPath, outputProps, null, query_options);
            if (null != outputBases && outputBases.length > 0) {
                outputs = new HashMap<String, ByteArrayInputStream>();
                Output output = null;
                String format = null;
                byte[] bytes = null;
                ByteArrayInputStream is = null;
                for (int i = 0; i < outputBases.length; ++i) {
                    output = (Output)outputBases[i];
                    format = output.getFormat().getValue();
                    bytes = output.getData().getValue();
                    is = new ByteArrayInputStream(bytes);
                    outputs.put(format, is);
                }
            }
        }
        finally {
            cmsp.close();
        }
        return outputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hideReportVersion() {
        String searchPath = this.getReportVersionPath();
        ContentManagerServiceClientPort cmPort = null;
        try {
            cmPort = Client.instance().getContentManagerServiceClient(this.getAgent().getHeaders());
            ReportVersion toBeHidden = new ReportVersion();
            StringProp searchPathProp = new StringProp();
            searchPathProp.setValue(searchPath);
            toBeHidden.setSearchPath(searchPathProp);
            BooleanProp isHidden = new BooleanProp();
            isHidden.setValue(true);
            toBeHidden.setHidden(isHidden);
            cmPort.update(new BaseClass[]{toBeHidden}, new UpdateOptions());
        }
        catch (SDKClientException ex) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_UNABLE_TO_HIDE_OUTPUT);
        }
        catch (EMFSecurityException ex) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_UNABLE_TO_HIDE_OUTPUT);
        }
        finally {
            if (cmPort != null) {
                cmPort.close();
            }
        }
    }

    protected ResultSet createResultSet(String path) throws AgentConditionException, Exception {
        HashMap data = this.getLastSavedVersion(path);
        if (null == data) {
            return null;
        }
        ResultSetPaged rs = null;
        ResultSet rsXML = null;
        ResultSetHTML rsHTML = null;
        for (Map.Entry entry : data.entrySet()) {
            Object parser;
            String format = (String)entry.getKey();
            InputStream is = (InputStream)entry.getValue();
            if (format.equals(ResultSetTypeEnum.HTML.getValue())) {
                parser = new ResultSetHTMLParser(LocaleUtil.getLocale((String)this.getAgent().getHeaders().getUserPreferenceContentLocale()));
                rsHTML = ((ResultSetHTMLParser)parser).parse(is);
                continue;
            }
            if (!format.equals(ResultSetTypeEnum.XML.getValue())) continue;
            parser = new ResultSetParser(LocaleUtil.getLocale((String)this.getAgent().getHeaders().getUserPreferenceContentLocale()));
            rsXML = ((ResultSetParser)parser).parse(is);
        }
        if (null != rsHTML && null != rsXML) {
            ResultSetPaged pagedResultSet = new ResultSetPaged();
            pagedResultSet.addPage(ResultSetTypeEnum.HTML, rsHTML);
            pagedResultSet.addPage(ResultSetTypeEnum.XML, rsXML);
            pagedResultSet.setPage(ResultSetTypeEnum.XML);
            rs = pagedResultSet;
        } else {
            rs = rsXML;
        }
        return rs;
    }
}

