/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.condition;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentConditionException;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.ReportDataServiceSelection;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.asv.condition.AgentCondition;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.resultset.MetadataItem;
import com.cognos.asv.resultset.ResultSetDataValue;
import com.cognos.asv.resultset.ResultSetProcessed;
import com.cognos.asv.resultset.ResultSetXML;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.SubscriptionOptionEnum;
import com.cognos.developer.schemas.bibus._3.SubscriptionOptionSearchPathSingleObject;
import com.cognos.developer.schemas.rds.bibus.ReportDataServiceLocator;
import com.cognos.developer.schemas.rds.bibus.ReportDataServicePort;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.soap.util.AxisUtils;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import com.ibm.www.xmlns.prod.cognos.layoutData._201310.Cell;
import com.ibm.www.xmlns.prod.cognos.layoutData._201310.FilterResult;
import com.ibm.www.xmlns.prod.cognos.layoutData._201310.FilterResultSet;
import com.ibm.www.xmlns.prod.cognos.layoutData._201310.FilterTypeEnum;
import com.ibm.www.xmlns.prod.cognos.layoutData._201310.ReportElement;
import com.ibm.www.xmlns.prod.cognos.layoutData._201310.TFValueTypeEnum;
import com.ibm.www.xmlns.prod.cognos.layoutData._201310.TextFrame;
import com.ibm.www.xmlns.prod.cognos.rds.types._201310.CCSAuthenticationFault;
import com.ibm.www.xmlns.prod.cognos.rds.types._201310.CCSGeneralFault;
import com.ibm.www.xmlns.prod.cognos.rds.types._201310.CCSPromptFault;
import com.ibm.www.xmlns.prod.cognos.rds.types._201310.Filter;
import com.ibm.www.xmlns.prod.cognos.rds.types._201310.GetOutputRequest;
import com.ibm.www.xmlns.prod.cognos.rds.types._201310.GetOutputResponse;
import com.ibm.www.xmlns.prod.cognos.rds.types._201310.GetReportDataRequest;
import com.ibm.www.xmlns.prod.cognos.rds.types._201310.LDXOutputType;
import com.ibm.www.xmlns.prod.cognos.rds.types._201310.OutputType;
import com.ibm.www.xmlns.prod.cognos.rds.types._201310.SessionTypeStatus;
import com.ibm.www.xmlns.prod.cognos.rds.types._201310.SourceTypeEnum;
import com.ibm.www.xmlns.prod.cognos.rds.types._201310.VersionSelection;
import com.ibm.www.xmlns.prod.cognos.rds.types._201310.VersionTypeEnum;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;

public class ReportDataServiceCondition
extends AgentCondition {
    private BaseClass m_periodicalProducer;
    private ReportDataServiceSelection m_selection;
    private static final String M_GREATER_THAN = "greater_than";
    private static final String M_GREATER_THAN_EQUAL = "greater_than_equal";
    private static final String M_LESS_THAN = "less_than";
    private static final String M_LESS_THAN_EQUAL = "less_than_equal";
    private static final String M_EQUAL = "equal";
    private static final String M_NOT_EQUAL = "not_equal";
    private static final String M_BETWEEN = "between";
    private static final String M_CONTAINS = "contains";
    private static final String M_BEGINS = "begins";
    private static final String M_ENDS = "ends";
    private static final String M_MATCH = "match";
    private static final String M_NOT_CONTAINS = "not_contains";
    private static final String M_NOT_BEGIN = "not_begin";
    private static final String M_NOT_END = "not_end";
    private static final String M_NOT_MATCH = "not_match";
    private static final double eps = 1.0E-10;
    private static ReportDataServiceLocator loc = new ReportDataServiceLocator();

    public ReportDataServiceCondition(BaseAgent agent, ReportDataServiceSelection selection, BaseClass periodicalProducer) {
        super(agent);
        this.m_selection = selection;
        this.m_periodicalProducer = periodicalProducer;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void run() throws AgentConditionException {
        GetOutputResponse getOutputResponseRDS = this.executeRDS();
        ArrayList unfilteredResults = this.getUnfilteredResults(getOutputResponseRDS);
        if (this.m_selection.isMetricWatchRule().booleanValue()) {
            this.runMetric(unfilteredResults);
        } else {
            this.runNonMetric(unfilteredResults);
        }
    }

    private void runMetric(ArrayList unfilteredResults) throws AgentConditionException {
        int i;
        ArrayList thresholdValues = this.m_selection.getPerformancePatternThresholds();
        int numberOfthresholds = thresholdValues.size();
        double[] thresholdDoubles = new double[numberOfthresholds];
        String thresholdValue = "";
        try {
            for (int i2 = 0; i2 < numberOfthresholds; ++i2) {
                thresholdValue = (String)thresholdValues.get(i2);
                thresholdDoubles[i2] = Double.parseDouble(thresholdValue);
            }
        }
        catch (NumberFormatException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_CANNOT_PARSE_THRESHOLD, new Object[]{thresholdValue, e.getLocalizedMessage()});
            throw new AgentConditionException(AsvI18NCode.MSG_ASV_CANNOT_PARSE_THRESHOLD, new Object[]{thresholdValue, e.getLocalizedMessage()});
        }
        ArrayList thresholdTolerances = this.m_selection.getPerformancePatternThresholdsIncludes();
        int numberOfTolerances = thresholdTolerances.size();
        boolean[] toleranceBooleans = new boolean[numberOfTolerances];
        String includeTolerance = "";
        try {
            for (i = 0; i < numberOfTolerances; ++i) {
                includeTolerance = (String)thresholdTolerances.get(i);
                toleranceBooleans[i] = Boolean.parseBoolean(includeTolerance);
            }
        }
        catch (NumberFormatException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_CANNOT_PARSE_THRESHOLD_TOLERANCE, new Object[]{includeTolerance, e.getLocalizedMessage()});
            throw new AgentConditionException(AsvI18NCode.MSG_ASV_CANNOT_PARSE_THRESHOLD_TOLERANCE, new Object[]{includeTolerance, e.getLocalizedMessage()});
        }
        for (i = 0; i < numberOfthresholds; ++i) {
            if (toleranceBooleans[i]) {
                int n = i;
                thresholdDoubles[n] = thresholdDoubles[n] + 1.0E-10;
                continue;
            }
            int n = i;
            thresholdDoubles[n] = thresholdDoubles[n] - 1.0E-10;
        }
        ResultSetXML previousResultSet = new ResultSetXML(this.getAgent().getHeaders().getLocale());
        previousResultSet.addMetadataItem("measure_value", "xs:double", "100");
        previousResultSet.addMetadataItem("average", "xs:boolean", "100");
        previousResultSet.addMetadataItem("good", "xs:boolean", "100");
        previousResultSet.addMetadataItem("poor", "xs:boolean", "100");
        previousResultSet.addMetadataItem("averageORgood", "xs:boolean", "100");
        previousResultSet.addMetadataItem("averageORpoor", "xs:boolean", "100");
        previousResultSet.addMetadataItem("goodORpoor", "xs:boolean", "100");
        previousResultSet.addMetadataItem("averageORgoodORpoor", "xs:boolean", "100");
        ResultSetXML currentResultSet = new ResultSetXML(this.getAgent().getHeaders().getLocale());
        currentResultSet.addMetadataItem("measure_value", "xs:double", "100");
        currentResultSet.addMetadataItem("average", "xs:boolean", "100");
        currentResultSet.addMetadataItem("good", "xs:boolean", "100");
        currentResultSet.addMetadataItem("poor", "xs:boolean", "100");
        currentResultSet.addMetadataItem("averageORgood", "xs:boolean", "100");
        currentResultSet.addMetadataItem("averageORpoor", "xs:boolean", "100");
        currentResultSet.addMetadataItem("goodORpoor", "xs:boolean", "100");
        currentResultSet.addMetadataItem("averageORgoodORpoor", "xs:boolean", "100");
        Iterator unfilteredResultsIt = unfilteredResults.iterator();
        if (unfilteredResultsIt.hasNext()) {
            ResultSetDataValue potentialValue = (ResultSetDataValue)unfilteredResultsIt.next();
            double potentialDouble = 0.0;
            try {
                potentialDouble = Double.parseDouble(potentialValue.getRawValue());
            }
            catch (NumberFormatException e) {
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.DEBUG, AsvI18NCode.MSG_ASV_CANNOT_PARSE_RETURNED_MEASURE, new Object[]{potentialValue.getRawValue(), e.getLocalizedMessage()});
            }
            String metricResult = null;
            ArrayList metricValues = this.m_selection.getPerformancePatternValues();
            if (potentialDouble < thresholdDoubles[0]) {
                metricResult = (String)metricValues.get(0);
            }
            for (int i3 = 0; i3 < thresholdDoubles.length - 1; ++i3) {
                if (!(thresholdDoubles[i3] <= potentialDouble) || !(potentialDouble < thresholdDoubles[i3 + 1])) continue;
                metricResult = (String)metricValues.get(i3 + 1);
            }
            if (potentialDouble >= thresholdDoubles[thresholdDoubles.length - 1]) {
                metricResult = (String)metricValues.get(metricValues.size() - 1);
            }
            currentResultSet.addRow();
            Iterator it = currentResultSet.getMetadata();
            while (it.hasNext()) {
                MetadataItem metadataItem = (MetadataItem)it.next();
                if (metadataItem.name().equals("measure_value")) {
                    currentResultSet.addValue(potentialValue);
                    continue;
                }
                if (metadataItem.name().indexOf(metricResult) != -1) {
                    currentResultSet.addValue("true");
                    continue;
                }
                currentResultSet.addValue("false");
            }
        }
        ResultSetProcessed resultSetProcessed = new ResultSetProcessed(previousResultSet, currentResultSet, null);
        this.getAgent().setResultSet(resultSetProcessed);
    }

    private void runNonMetric(ArrayList unfilteredResults) throws AgentConditionException {
        ArrayList filteredResults = null;
        filteredResults = this.numericOperator() ? this.filterResultsNumeric(unfilteredResults) : this.filterResultsString(unfilteredResults);
        ResultSetXML previousResultSet = new ResultSetXML(this.getAgent().getHeaders().getLocale());
        previousResultSet.addMetadataItem("measure_value", "xs:double", "100");
        ResultSetXML currentResultSet = new ResultSetXML(this.getAgent().getHeaders().getLocale());
        currentResultSet.addMetadataItem("measure_value", "xs:double", "100");
        Iterator it = filteredResults.iterator();
        while (it.hasNext()) {
            currentResultSet.addRow();
            currentResultSet.addValue((ResultSetDataValue)it.next());
        }
        ResultSetProcessed resultSetProcessed = new ResultSetProcessed(previousResultSet, currentResultSet, null);
        this.getAgent().setResultSet(resultSetProcessed);
    }

    @Override
    public void validate(ValidationResultHandler validateResult) throws AgentServiceException {
    }

    private GetOutputResponse executeRDS() throws AgentConditionException {
        SubscriptionOptionSearchPathSingleObject documentVersionOption = (SubscriptionOptionSearchPathSingleObject)OptionUtils.findFirstOptionWithNameEnum((Option[])this.getAgent().getSubmitOptions(), (Object)SubscriptionOptionEnum.documentVersion);
        String documentVersionStoreID = documentVersionOption.getValue().get_value();
        String urlString = null;
        try {
            urlString = CRNProperties.getInstance().getProperty("internalDispatcher");
        }
        catch (PropertiesException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.DEBUG, AsvI18NCode.MSG_ASV_CANNOT_DETERMINE_INTERNAL_DISPATCHER, new Object[]{e.getLocalizedMessage()});
            throw new AgentConditionException(AsvI18NCode.MSG_ASV_CANNOT_DETERMINE_INTERNAL_DISPATCHER, (LocalizableException)((Object)e));
        }
        GetOutputResponse getOuputResponse = null;
        ReportDataServicePort svc = null;
        try {
            URL cognos8 = new URL(urlString);
            svc = loc.getReportDataServiceBinding(cognos8);
            ((Stub)svc).setTimeout(0);
            BiBusHeader rdsHeader = BiBusUtilities.getDeepCopy((BiBusHeader)this.getAgent().getHeaders().getBiBusHeader());
            if (rdsHeader.getTracking() != null) {
                rdsHeader.getTracking().setConversationContext(null);
            }
            AxisUtils.setHeader((Stub)((Stub)svc), (BiBusHeader)rdsHeader);
            GetReportDataRequest req = new GetReportDataRequest();
            req.setSourceID(this.m_periodicalProducer.getSearchPath().getValue());
            req.setSourceType(SourceTypeEnum.searchPath);
            req.setVersion(new VersionSelection());
            req.getVersion().setSearchPath(documentVersionStoreID);
            req.getVersion().setVersionType(VersionTypeEnum.VERSION_NAME);
            Filter[] filters = new Filter[]{new Filter()};
            filters[0].setFilterType(FilterTypeEnum.CONTEXT_SPEC);
            filters[0].setFilterValue(this.m_selection.getSelectionXML());
            req.setFilters(filters);
            getOuputResponse = svc.getReportData(req);
            getOuputResponse = this.waitForOutput(getOuputResponse, svc);
        }
        catch (MalformedURLException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_RDS_CALL_ERROR, new Object[]{e.getLocalizedMessage()});
            throw new AgentConditionException(AsvI18NCode.MSG_ASV_RDS_CALL_ERROR, new Object[]{e.getLocalizedMessage()});
        }
        catch (RemoteException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_RDS_CALL_ERROR, new Object[]{e.getLocalizedMessage()});
            throw new AgentConditionException(AsvI18NCode.MSG_ASV_RDS_CALL_ERROR, new Object[]{e.getLocalizedMessage()});
        }
        catch (ServiceException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_RDS_CALL_ERROR, new Object[]{e.getLocalizedMessage()});
            throw new AgentConditionException(AsvI18NCode.MSG_ASV_RDS_CALL_ERROR, new Object[]{e.getLocalizedMessage()});
        }
        catch (Throwable t) {
            String responseMessage = t.getLocalizedMessage();
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_RDS_ERROR, new Object[]{responseMessage});
            throw new AgentConditionException(AsvI18NCode.MSG_ASV_RDS_ERROR, new Object[]{responseMessage});
        }
        return getOuputResponse;
    }

    private GetOutputResponse waitForOutput(GetOutputResponse resp, ReportDataServicePort svc) throws RemoteException, CCSAuthenticationFault, CCSPromptFault, CCSGeneralFault {
        int i = 0;
        while (resp.getSession().getStatus() == SessionTypeStatus.working) {
            if (i == 0) {
                this.copyHeaders(svc);
                ++i;
            }
            resp = svc.getOutput(new GetOutputRequest(resp.getSession(), null));
        }
        return resp;
    }

    private void copyHeaders(ReportDataServicePort svc) {
        Stub stub = (Stub)svc;
        stub.setHeader(stub.getResponseHeaders()[0]);
    }

    private ArrayList getUnfilteredResults(GetOutputResponse getOutputResponseRDS) {
        ReportElement[] selected;
        FilterResult filterResult;
        FilterResult[] filterResultArray;
        FilterResultSet filterResultSet;
        LDXOutputType contentOutput;
        OutputType output;
        ArrayList<ResultSetDataValue> unfilteredResults = new ArrayList<ResultSetDataValue>();
        if (getOutputResponseRDS != null && (output = getOutputResponseRDS.getOutput()) != null && (contentOutput = output.getLDXOutput()) != null && (filterResultSet = contentOutput.getFilterResultSet()) != null && (filterResultArray = filterResultSet.getFilterResult()) != null && filterResultArray.length == 1 && (filterResult = filterResultSet.getFilterResult(0)) != null && (selected = filterResult.getReportElement()) != null) {
            for (int j = 0; j < selected.length; ++j) {
                Cell selCell = selected[j].getCell();
                if (null == selCell) continue;
                ReportElement[] items = selCell.getItem();
                for (int i = 0; items != null && i < items.length; ++i) {
                    TFValueTypeEnum valtype;
                    TextFrame txt = items[i].getTxt();
                    if (txt == null) continue;
                    String unformatted = txt.getVal();
                    String formatted = txt.getFmtVal();
                    if (formatted == null) {
                        formatted = unformatted;
                    }
                    if ((valtype = txt.getValTyp()) != TFValueTypeEnum.number) continue;
                    ResultSetDataValue dataValue = new ResultSetDataValue(unformatted, formatted);
                    unfilteredResults.add(dataValue);
                }
            }
        }
        return unfilteredResults;
    }

    private ArrayList filterResultsNumeric(ArrayList unfilteredResults) throws AgentConditionException {
        ArrayList<ResultSetDataValue> filteredResults = new ArrayList<ResultSetDataValue>();
        String operator = this.m_selection.getMeasureOperator();
        double threshold = 0.0;
        double threshold1 = 0.0;
        try {
            threshold = Double.parseDouble(this.m_selection.getMeasureValue());
            if (operator.equals(M_BETWEEN)) {
                threshold1 = Double.parseDouble(this.m_selection.getMeasureValue1());
            }
        }
        catch (NumberFormatException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_CANNOT_PARSE_MEASURE, new Object[]{this.m_selection.getMeasureValue(), e.getLocalizedMessage()});
            throw new AgentConditionException(AsvI18NCode.MSG_ASV_CANNOT_PARSE_MEASURE, new Object[]{this.m_selection.getMeasureValue(), e.getLocalizedMessage()});
        }
        for (ResultSetDataValue potentialValue : unfilteredResults) {
            double potentialDouble = 0.0;
            try {
                potentialDouble = Double.parseDouble(potentialValue.getRawValue());
            }
            catch (NumberFormatException e) {
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.DEBUG, AsvI18NCode.MSG_ASV_CANNOT_PARSE_RETURNED_MEASURE, new Object[]{potentialValue.getRawValue(), e.getLocalizedMessage()});
                continue;
            }
            if (operator.equals(M_GREATER_THAN)) {
                if (!(potentialDouble > threshold + 1.0E-10)) continue;
                filteredResults.add(potentialValue);
                continue;
            }
            if (operator.equals(M_GREATER_THAN_EQUAL)) {
                if (!(potentialDouble >= threshold - 1.0E-10)) continue;
                filteredResults.add(potentialValue);
                continue;
            }
            if (operator.equals(M_LESS_THAN)) {
                if (!(potentialDouble + 1.0E-10 < threshold)) continue;
                filteredResults.add(potentialValue);
                continue;
            }
            if (operator.equals(M_LESS_THAN_EQUAL)) {
                if (!(potentialDouble - 1.0E-10 <= threshold)) continue;
                filteredResults.add(potentialValue);
                continue;
            }
            if (operator.equals(M_EQUAL)) {
                if (!(Math.abs(potentialDouble - threshold) <= 1.0E-10)) continue;
                filteredResults.add(potentialValue);
                continue;
            }
            if (operator.equals(M_NOT_EQUAL)) {
                if (!(Math.abs(potentialDouble - threshold) > 1.0E-10)) continue;
                filteredResults.add(potentialValue);
                continue;
            }
            if (operator.equals(M_BETWEEN)) {
                threshold += this.m_selection.getMeasureValueInclusive() ? -1.0E-10 : 1.0E-10;
                threshold1 += this.m_selection.getMeasureValueInclusive1() ? 1.0E-10 : -1.0E-10;
                if (!(threshold < potentialDouble) || !(potentialDouble < threshold1)) continue;
                filteredResults.add(potentialValue);
                continue;
            }
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_UNRECOGNIZED_OPERATOR, new Object[]{operator});
            throw new AgentConditionException(AsvI18NCode.MSG_ASV_UNRECOGNIZED_OPERATOR, new Object[]{operator});
        }
        return filteredResults;
    }

    private ArrayList filterResultsString(ArrayList unfilteredResults) throws AgentConditionException {
        ArrayList<ResultSetDataValue> filteredResults = new ArrayList<ResultSetDataValue>();
        String measure = this.m_selection.getMeasureValue();
        String operator = this.m_selection.getMeasureOperator();
        boolean ignoreCase = this.m_selection.getCaseInsensitive();
        for (ResultSetDataValue potentialValue : unfilteredResults) {
            String potentialValueString = potentialValue.getRawValue();
            if (operator.equals(M_CONTAINS)) {
                if (!ReportDataServiceCondition.contains(ignoreCase, potentialValueString, measure)) continue;
                filteredResults.add(potentialValue);
                continue;
            }
            if (operator.equals(M_BEGINS)) {
                if (!ReportDataServiceCondition.begins(ignoreCase, potentialValueString, measure)) continue;
                filteredResults.add(potentialValue);
                continue;
            }
            if (operator.equals(M_ENDS)) {
                if (!ReportDataServiceCondition.ends(ignoreCase, potentialValueString, measure)) continue;
                filteredResults.add(potentialValue);
                continue;
            }
            if (operator.equals(M_MATCH)) {
                if (!ReportDataServiceCondition.match(ignoreCase, potentialValueString, measure)) continue;
                filteredResults.add(potentialValue);
                continue;
            }
            if (operator.equals(M_NOT_CONTAINS)) {
                if (ReportDataServiceCondition.contains(ignoreCase, potentialValueString, measure)) continue;
                filteredResults.add(potentialValue);
                continue;
            }
            if (operator.equals(M_NOT_BEGIN)) {
                if (ReportDataServiceCondition.begins(ignoreCase, potentialValueString, measure)) continue;
                filteredResults.add(potentialValue);
                continue;
            }
            if (operator.equals(M_NOT_END)) {
                if (ReportDataServiceCondition.ends(ignoreCase, potentialValueString, measure)) continue;
                filteredResults.add(potentialValue);
                continue;
            }
            if (operator.equals(M_NOT_MATCH)) {
                if (ReportDataServiceCondition.match(ignoreCase, potentialValueString, measure)) continue;
                filteredResults.add(potentialValue);
                continue;
            }
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_UNRECOGNIZED_OPERATOR, new Object[]{operator});
            throw new AgentConditionException(AsvI18NCode.MSG_ASV_UNRECOGNIZED_OPERATOR, new Object[]{operator});
        }
        return filteredResults;
    }

    private boolean numericOperator() {
        boolean ret_value = false;
        String operator = this.m_selection.getMeasureOperator();
        if (operator.equals(M_GREATER_THAN) || operator.equals(M_GREATER_THAN_EQUAL) || operator.equals(M_LESS_THAN) || operator.equals(M_LESS_THAN_EQUAL) || operator.equals(M_EQUAL) || operator.equals(M_NOT_EQUAL) || operator.equals(M_BETWEEN)) {
            ret_value = true;
        }
        return ret_value;
    }

    private static boolean contains(boolean ignoreCase, String a, String b) {
        if (a.length() < b.length()) {
            return false;
        }
        int isz = a.length() - b.length();
        for (int i = 0; i <= isz; ++i) {
            if (!a.substring(i, b.length() + i).regionMatches(ignoreCase, 0, b, 0, b.length())) continue;
            return true;
        }
        return false;
    }

    private static boolean begins(boolean ignoreCase, String a, String b) {
        if (a.length() < b.length()) {
            return false;
        }
        return a.substring(0, b.length()).regionMatches(ignoreCase, 0, b, 0, b.length());
    }

    private static boolean ends(boolean ignoreCase, String a, String b) {
        if (a.length() < b.length()) {
            return false;
        }
        return a.substring(a.length() - b.length(), a.length()).regionMatches(ignoreCase, 0, b, 0, b.length());
    }

    private static boolean match(boolean ignoreCase, String a, String b) {
        return a.regionMatches(ignoreCase, 0, b, 0, b.length());
    }

    public static void main(String[] argv) {
    }
}

