/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.condition;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentMonitorUtil;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.util.ManagedAttachmentPart;
import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportStatus;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchRequest;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.DataEnum;
import com.cognos.developer.schemas.bibus._3.EncodingEnum;
import com.cognos.developer.schemas.bibus._3.FormFieldVar;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ReportServiceReportSpecification;
import com.cognos.developer.schemas.bibus._3.RunOption;
import com.cognos.developer.schemas.bibus._3.RunOptionBoolean;
import com.cognos.developer.schemas.bibus._3.RunOptionData;
import com.cognos.developer.schemas.bibus._3.RunOptionEncoding;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.RunOptionInt;
import com.cognos.developer.schemas.bibus._3.RunOptionStringArray;
import com.cognos.developer.schemas.bibus._3.Specification;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.ports.BatchReportServiceClientPort;
import com.cognos.jsmcommon.soap.client.ports.ServiceAPI;
import com.cognos.jsmcommon.soap.util.AsyncConversation;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.OptionUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import org.apache.axis.attachments.AttachmentPart;

public class ReportServerCondition {
    private AsyncConversation m_conversation;
    private BiBusHeader m_header;
    private Option[] m_options;
    private ParameterValue[] m_parameters;
    private BaseAgent m_agent;

    ReportServerCondition(AsyncConversation conversation, BaseAgent agent, Option[] options, ParameterValue[] parameters) {
        this.m_conversation = conversation;
        this.m_agent = agent;
        this.m_header = agent.getHeaders().getBiBusHeader();
        this.m_options = options;
        this.m_parameters = parameters;
    }

    AsynchReply run(String searchPath) throws LocalizableException {
        BiBusHeader header = this.addRawXMLFormfieldToHeader(this.m_header);
        Option[] options = this.getConditionOptionsForReport(this.m_options);
        return AgentMonitorUtil.run(this.m_conversation, Client.ServiceEnum.MONITOR_SERVICE, searchPath, new JobBiBusHeaders(header), this.m_agent.getBaseClass(), this.m_parameters, options);
    }

    InputStream runSpecification(String reportSpecification) throws LocalizableException {
        InputStream result = null;
        BiBusHeader header = this.addRawXMLFormfieldToHeader(this.m_header);
        Option[] options = this.getConditionOptionsForSpecification(this.m_options);
        ReportServiceReportSpecification reportServiceReportSpecification = new ReportServiceReportSpecification();
        Specification specification = new Specification();
        specification.set_value(reportSpecification);
        reportServiceReportSpecification.setValue(specification);
        BatchReportServiceClientPort servicePort = Client.instance().getBatchReportServiceClient(new JobBiBusHeaders(header));
        try {
            Object[] attachments;
            AsynchReply reply = servicePort.runSpecification((AsynchSpecification)reportServiceReportSpecification, this.m_parameters, options);
            AsynchRequest request = reply.getPrimaryRequest();
            reply = this.m_conversation.doWaitConversation((ServiceAPI)servicePort, reply);
            AsynchDetail[] details = reply.getDetails();
            AsynchDetailReportStatusEnum status = null;
            if (details != null && details.length > 0) {
                for (int i = 0; i < details.length && status == null; ++i) {
                    if (!(details[i] instanceof AsynchDetailReportStatus)) continue;
                    AsynchDetailReportStatus asyncDetailReportStatus = (AsynchDetailReportStatus)details[i];
                    status = asyncDetailReportStatus.getStatus();
                }
            }
            if (status != null && status == AsynchDetailReportStatusEnum.responseReady) {
                reply = servicePort.getOutput(reply.getPrimaryRequest(), this.m_parameters, this.m_options);
            }
            if (null != (attachments = servicePort.getBinding().getAttachments()) && attachments.length == 1) {
                result = new ManagedAttachmentPart((AttachmentPart)attachments[0]).getInputStream();
            }
            servicePort.release(request);
        }
        catch (EMFSecurityException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e});
        }
        catch (IOException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e});
        }
        finally {
            if (servicePort != null) {
                servicePort.close();
            }
        }
        return result;
    }

    private static Object deepCopy(Object object) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ObjectOutputStream outputStrm = new ObjectOutputStream(outputStream);
            outputStrm.writeObject(object);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
            ObjectInputStream objInputStream = new ObjectInputStream(inputStream);
            return objInputStream.readObject();
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, (Throwable)e);
            return null;
        }
    }

    protected Option[] getConditionOptionsForReport(Option[] options) {
        ArrayList<Object> addedOptions = new ArrayList<Object>();
        Option[] condition_options = new Option[options.length];
        for (int i = 0; i < options.length; ++i) {
            Option a;
            condition_options[i] = a = (Option)ReportServerCondition.deepCopy(options[i]);
        }
        RunOptionStringArray outputFormat = (RunOptionStringArray)OptionUtils.findFirstOptionWithNameEnum((Option[])condition_options, (Object)RunOptionEnum.outputFormat);
        RunOptionBoolean saveOutput = (RunOptionBoolean)OptionUtils.findFirstOptionWithNameEnum((Option[])condition_options, (Object)RunOptionEnum.saveOutput);
        RunOptionBoolean archive = (RunOptionBoolean)OptionUtils.findFirstOptionWithNameEnum((Option[])condition_options, (Object)RunOptionEnum.archive);
        if (archive != null) {
            archive.setValue(false);
        }
        if (outputFormat != null) {
            outputFormat.setValue(new String[]{"rawXML"});
        } else {
            outputFormat = new RunOptionStringArray();
            outputFormat.setName(RunOptionEnum.outputFormat);
            outputFormat.setValue(new String[]{"rawXML"});
            addedOptions.add(outputFormat);
        }
        if (saveOutput != null) {
            saveOutput.setValue(true);
        } else {
            saveOutput = new RunOptionBoolean();
            saveOutput.setName(RunOptionEnum.saveOutput);
            saveOutput.setValue(true);
            addedOptions.add(saveOutput);
        }
        RunOptionInt verticalElements = new RunOptionInt();
        verticalElements.setName(RunOptionEnum.verticalElements);
        verticalElements.setValue(Integer.MAX_VALUE);
        addedOptions.add(verticalElements);
        RunOptionBoolean promptElementsValue = new RunOptionBoolean();
        promptElementsValue.setName(RunOptionEnum.prompt);
        promptElementsValue.setValue(false);
        addedOptions.add(promptElementsValue);
        RunOptionBoolean selectionBasedFeatures = new RunOptionBoolean();
        selectionBasedFeatures.setName(RunOptionEnum.selectionBasedFeatures);
        selectionBasedFeatures.setValue(false);
        addedOptions.add(selectionBasedFeatures);
        return OptionUtils.mergeOptions((Option[])condition_options, (Option[])addedOptions.toArray(new RunOption[addedOptions.size()]));
    }

    protected Option[] getConditionOptionsForSpecification(Option[] options) {
        ArrayList<Object> addedOptions = new ArrayList<Object>();
        Option[] condition_options = new Option[options.length];
        System.arraycopy(options, 0, condition_options, 0, options.length);
        RunOptionStringArray outputFormat = (RunOptionStringArray)OptionUtils.findFirstOptionWithNameEnum((Option[])condition_options, (Object)RunOptionEnum.outputFormat);
        RunOptionBoolean saveOutput = (RunOptionBoolean)OptionUtils.findFirstOptionWithNameEnum((Option[])condition_options, (Object)RunOptionEnum.saveOutput);
        if (outputFormat != null) {
            outputFormat.setValue(new String[]{"rawXML"});
        } else {
            outputFormat = new RunOptionStringArray();
            outputFormat.setName(RunOptionEnum.outputFormat);
            outputFormat.setValue(new String[]{"rawXML"});
            addedOptions.add(outputFormat);
        }
        if (saveOutput != null) {
            saveOutput.setValue(false);
        } else {
            saveOutput = new RunOptionBoolean();
            saveOutput.setName(RunOptionEnum.saveOutput);
            saveOutput.setValue(false);
            addedOptions.add(saveOutput);
        }
        RunOptionBoolean promptElementsValue = new RunOptionBoolean();
        promptElementsValue.setName(RunOptionEnum.prompt);
        promptElementsValue.setValue(false);
        addedOptions.add(promptElementsValue);
        RunOptionBoolean selectionBasedFeatures = new RunOptionBoolean();
        selectionBasedFeatures.setName(RunOptionEnum.selectionBasedFeatures);
        selectionBasedFeatures.setValue(false);
        addedOptions.add(selectionBasedFeatures);
        RunOptionData runOptionData = new RunOptionData();
        runOptionData.setName(RunOptionEnum.data);
        runOptionData.setValue(DataEnum.previewWithLimitedData);
        addedOptions.add(runOptionData);
        RunOptionEncoding encoding = new RunOptionEncoding();
        encoding.setName(RunOptionEnum.attachmentEncoding);
        encoding.setValue(EncodingEnum.MIME);
        addedOptions.add(encoding);
        RunOptionInt runOptionInt = new RunOptionInt();
        runOptionInt.setName(RunOptionEnum.verticalElements);
        int maxPreviewItems = CRNProperties.getInstance().getIntProperty("emf.preview.max.items", 50);
        runOptionInt.setValue(maxPreviewItems);
        addedOptions.add(runOptionInt);
        return OptionUtils.mergeOptions((Option[])condition_options, (Option[])addedOptions.toArray(new RunOption[addedOptions.size()]));
    }

    protected BiBusHeader addRawXMLFormfieldToHeader(BiBusHeader oldHeader) {
        BiBusHeader header = BiBusUtilities.getDeepCopy((BiBusHeader)oldHeader);
        FormFieldVar[] vars = header.getHdrSession().getFormFieldVars();
        if (vars == null) {
            vars = new FormFieldVar[]{};
        }
        FormFieldVar[] newVars = new FormFieldVar[vars.length + 1];
        newVars[0] = new FormFieldVar();
        newVars[0].setName("xslRawXmlUrl");
        newVars[0].setValue("asvResultset.xslt");
        System.arraycopy(vars, 0, newVars, 1, vars.length);
        header.getHdrSession().setFormFieldVars(newVars);
        return header;
    }
}

