/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.factory;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentTask;
import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.FaultedAgentTask;
import com.cognos.asv.agent.Agent;
import com.cognos.asv.agent.AgentView;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.asv.agent.ReportDataServiceAgent;
import com.cognos.asv.factory.AgentObjects;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.taskTargets.AgentBaseRssTarget;
import com.cognos.asv.taskTargets.AgentContentTaskTarget;
import com.cognos.asv.taskTargets.AgentDataIntegrationTask;
import com.cognos.asv.taskTargets.AgentExportDeploymentTarget;
import com.cognos.asv.taskTargets.AgentHumanTaskTarget;
import com.cognos.asv.taskTargets.AgentImportDeploymentTarget;
import com.cognos.asv.taskTargets.AgentIndexUpdateTask;
import com.cognos.asv.taskTargets.AgentJobDefinitionTarget;
import com.cognos.asv.taskTargets.AgentMemoTarget;
import com.cognos.asv.taskTargets.AgentMigrationTarget;
import com.cognos.asv.taskTargets.AgentPlanningMacroTarget;
import com.cognos.asv.taskTargets.AgentPowerplayTarget;
import com.cognos.asv.taskTargets.AgentReportTarget;
import com.cognos.asv.taskTargets.AgentSQLTarget;
import com.cognos.asv.taskTargets.AgentTaskTarget;
import com.cognos.asv.taskTargets.AgentWebServiceTarget;
import com.cognos.asv.taskTargets.UnknownTarget;
import com.cognos.developer.schemas.bibus._3.AgentDefinition;
import com.cognos.developer.schemas.bibus._3.AgentDefinitionView;
import com.cognos.developer.schemas.bibus._3.AgentState;
import com.cognos.developer.schemas.bibus._3.AgentTaskDefinition;
import com.cognos.developer.schemas.bibus._3.Analysis;
import com.cognos.developer.schemas.bibus._3.AuthoredReport;
import com.cognos.developer.schemas.bibus._3.BaseAgentDefinition;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseDataIntegrationTask;
import com.cognos.developer.schemas.bibus._3.BasePowerPlay8Report;
import com.cognos.developer.schemas.bibus._3.BaseRSSTask;
import com.cognos.developer.schemas.bibus._3.BaseReport;
import com.cognos.developer.schemas.bibus._3.ContentTask;
import com.cognos.developer.schemas.bibus._3.ExportDeployment;
import com.cognos.developer.schemas.bibus._3.HumanTask;
import com.cognos.developer.schemas.bibus._3.ImportDeployment;
import com.cognos.developer.schemas.bibus._3.IndexUpdateTask;
import com.cognos.developer.schemas.bibus._3.InteractiveReport;
import com.cognos.developer.schemas.bibus._3.JobDefinition;
import com.cognos.developer.schemas.bibus._3.Memo;
import com.cognos.developer.schemas.bibus._3.MigrationTask;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.PlanningMacroTask;
import com.cognos.developer.schemas.bibus._3.PowerPlay8Report;
import com.cognos.developer.schemas.bibus._3.PowerPlay8ReportView;
import com.cognos.developer.schemas.bibus._3.Query;
import com.cognos.developer.schemas.bibus._3.Report;
import com.cognos.developer.schemas.bibus._3.ReportDataServiceAgentDefinition;
import com.cognos.developer.schemas.bibus._3.ReportView;
import com.cognos.developer.schemas.bibus._3.Schedule;
import com.cognos.developer.schemas.bibus._3.StoredProcedureTask;
import com.cognos.developer.schemas.bibus._3.WebServiceTask;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import java.util.ArrayList;

public class AgentFactory {
    private AgentObjects m_agentObjects;
    private JobBiBusHeaders m_jobBusHeaders;
    private Option[] m_submit_options;
    private ParameterValue[] m_submit_parameters;

    public AgentFactory(JobBiBusHeaders jobBusHeaders, AgentObjects ao, Option[] submit_options, ParameterValue[] submit_params) {
        this.setAgentObjects(ao);
        this.setHeaders(jobBusHeaders);
        this.setSubmitOptions(submit_options);
        this.setSubmitParameters(submit_params);
    }

    public BaseAgent getRunnableObject() {
        BaseAgent baseAgent = this.getBaseAgent();
        this.buildAgentTaskDefinitions(baseAgent);
        baseAgent.setAgentState((AgentState)this.m_agentObjects.getAgentState());
        baseAgent.setSubmitOptions(this.getSubmitOptions());
        baseAgent.setSubmitParameters(this.getSubmitParameters());
        return baseAgent;
    }

    private BaseAgent getBaseAgent() {
        BaseAgent agentRunnable = null;
        BaseClass runnable = this.m_agentObjects.getRunnable();
        if (runnable instanceof AgentDefinitionView) {
            AgentDefinitionView view = (AgentDefinitionView)runnable;
            AgentDefinition runnableBase = (AgentDefinition)this.m_agentObjects.getRunnableBase();
            if (runnableBase != null && view != null) {
                ReportView reportView = (ReportView)this.m_agentObjects.getRunnableReport();
                AuthoredReport report = (AuthoredReport)this.m_agentObjects.getRunnableBaseReport();
                Agent agent = new Agent(runnableBase, report, this.getHeaders());
                agentRunnable = new AgentView(view, reportView, agent, this.getHeaders());
            }
        } else if (runnable instanceof AgentDefinition) {
            AgentDefinition agent = (AgentDefinition)this.m_agentObjects.getRunnable();
            AuthoredReport report = (AuthoredReport)this.m_agentObjects.getRunnableReport();
            agentRunnable = new Agent(agent, report, this.getHeaders());
        } else if (runnable instanceof ReportDataServiceAgentDefinition) {
            BaseClass[] baseClassArray;
            BaseClassArrayProp baseClassArrayProp;
            ReportDataServiceAgentDefinition agentDefinition = (ReportDataServiceAgentDefinition)this.m_agentObjects.getRunnable();
            BaseClass periodicalProducer = null;
            if (this.m_agentObjects.getSchedule() != null && (baseClassArrayProp = ((Schedule)this.m_agentObjects.getSchedule()).getPeriodicalProducer()) != null && (baseClassArray = baseClassArrayProp.getValue()) != null && baseClassArray.length == 1) {
                periodicalProducer = baseClassArray[0];
            }
            agentRunnable = new ReportDataServiceAgent(agentDefinition, this.getHeaders(), periodicalProducer);
        }
        return agentRunnable;
    }

    private void buildAgentTaskDefinitions(BaseAgent agent) {
        BaseClass[] baseClassesTasks = this.getAgentObjects().getAgentTasks();
        BaseClass[] baseClassesTargets = this.getAgentObjects().getAgentTargets();
        ArrayList<BaseStepObject> agentStepsList = new ArrayList<BaseStepObject>();
        if (baseClassesTasks != null) {
            for (int j = 0; j < baseClassesTasks.length; ++j) {
                AgentTaskDefinition agentTaskDefinition = (AgentTaskDefinition)baseClassesTasks[j];
                BaseClass agentTaskDefinitionTarget = baseClassesTargets[j];
                AgentTask agentStep = new AgentTask(agentTaskDefinition, (BaseStepObject)agent, agent.getHeaders());
                agentStepsList.add(agentStep);
                BaseClass[] taskObjects = agentTaskDefinition.getTaskObject().getValue();
                String agentTaskDefnPath = agentTaskDefinition.getDefaultName() != null ? agentTaskDefinition.getDefaultName().getValue() : "";
                try {
                    if (taskObjects == null || taskObjects.length == 0) {
                        FaultedAgentTask fat = new FaultedAgentTask(AsvI18NCode.MSG_ASV_MISSING_TASK_OBJECT, new Object[]{agentTaskDefnPath});
                        agentStep.addStep(fat);
                        continue;
                    }
                    this.buildAgentTaskDefinitionsTarget(agentStep, agentTaskDefinitionTarget);
                    continue;
                }
                catch (NullPointerException e) {
                    SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug(agentTaskDefnPath + ":" + e.getMessage());
                }
            }
        }
        agent.addSteps(agentStepsList);
    }

    private void buildAgentTaskDefinitionsTarget(AgentTask agentStep, BaseClass baseClass) {
        BaseAgentTaskTarget target = null;
        String sp = ObjectModelUtil.getSearchPath((BaseClass)baseClass);
        if (baseClass == null || baseClass.getSearchPath() == null || baseClass.getSearchPath().getValue() == null || baseClass.getSearchPath().getValue().trim().length() == 0) {
            target = new UnknownTarget(baseClass, agentStep, agentStep.getHeaders());
        } else if (baseClass instanceof BaseAgentDefinition) {
            target = new AgentTaskTarget((BaseAgentDefinition)baseClass, (BaseStepObject)agentStep, agentStep.getHeaders());
        } else if (baseClass instanceof Report || baseClass instanceof ReportView || baseClass instanceof Query || baseClass instanceof Analysis || baseClass instanceof InteractiveReport) {
            target = new AgentReportTarget((BaseReport)baseClass, (BaseStepObject)agentStep, agentStep.getHeaders());
        } else if (baseClass instanceof PowerPlay8Report || baseClass instanceof PowerPlay8ReportView) {
            target = new AgentPowerplayTarget((BasePowerPlay8Report)baseClass, (BaseStepObject)agentStep, agentStep.getHeaders());
        } else if (baseClass instanceof JobDefinition) {
            target = new AgentJobDefinitionTarget((JobDefinition)baseClass, (BaseStepObject)agentStep, agentStep.getHeaders());
        } else if (baseClass instanceof ImportDeployment) {
            target = new AgentImportDeploymentTarget((ImportDeployment)baseClass, (BaseStepObject)agentStep, agentStep.getHeaders());
        } else if (baseClass instanceof ExportDeployment) {
            target = new AgentExportDeploymentTarget((ExportDeployment)baseClass, (BaseStepObject)agentStep, agentStep.getHeaders());
        } else if (baseClass instanceof ContentTask) {
            target = new AgentContentTaskTarget((ContentTask)baseClass, (BaseStepObject)agentStep, agentStep.getHeaders());
        } else if (baseClass instanceof StoredProcedureTask) {
            target = new AgentSQLTarget((StoredProcedureTask)baseClass, (BaseStepObject)agentStep, agentStep.getHeaders());
        } else if (baseClass instanceof WebServiceTask) {
            target = new AgentWebServiceTarget((WebServiceTask)baseClass, (BaseStepObject)agentStep, agentStep.getHeaders());
        } else if (baseClass instanceof HumanTask) {
            target = new AgentHumanTaskTarget((HumanTask)baseClass, (BaseStepObject)agentStep, agentStep.getHeaders());
        } else if (baseClass instanceof Memo) {
            target = new AgentMemoTarget((Memo)baseClass, (BaseStepObject)agentStep, agentStep.getHeaders());
        } else if (baseClass instanceof BaseRSSTask) {
            target = new AgentBaseRssTarget((BaseRSSTask)baseClass, (BaseStepObject)agentStep, agentStep.getHeaders());
        } else if (baseClass instanceof BaseDataIntegrationTask) {
            target = new AgentDataIntegrationTask((BaseDataIntegrationTask)baseClass, (BaseStepObject)agentStep, agentStep.getHeaders());
        } else if (baseClass instanceof IndexUpdateTask) {
            target = new AgentIndexUpdateTask((IndexUpdateTask)baseClass, (BaseStepObject)agentStep, agentStep.getHeaders());
        } else if (baseClass instanceof PlanningMacroTask) {
            target = new AgentPlanningMacroTarget((PlanningMacroTask)baseClass, (BaseStepObject)agentStep, agentStep.getHeaders());
        } else if (baseClass instanceof MigrationTask) {
            target = new AgentMigrationTarget((MigrationTask)baseClass, (BaseStepObject)agentStep, agentStep.getHeaders());
        }
        agentStep.addStep(target);
    }

    private JobBiBusHeaders getHeaders() {
        return this.m_jobBusHeaders;
    }

    private void setHeaders(JobBiBusHeaders jobBusHeaders) {
        this.m_jobBusHeaders = jobBusHeaders;
    }

    private AgentObjects getAgentObjects() {
        return this.m_agentObjects;
    }

    private void setAgentObjects(AgentObjects agentObjects) {
        this.m_agentObjects = agentObjects;
    }

    private Option[] getSubmitOptions() {
        return this.m_submit_options;
    }

    private void setSubmitOptions(Option[] submit_options) {
        this.m_submit_options = submit_options;
    }

    private ParameterValue[] getSubmitParameters() {
        return this.m_submit_parameters;
    }

    private void setSubmitParameters(ParameterValue[] submit_parameters) {
        this.m_submit_parameters = submit_parameters;
    }
}

