/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.factory;

import com.cognos.asv.AgentServiceException;
import com.cognos.asv.RunHistoryExtractor;
import com.cognos.asv.agent.Agent;
import com.cognos.asv.factory.AgentFactory;
import com.cognos.asv.factory.AgentObjects;
import com.cognos.asv.factory.TaskRunSorter;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.developer.schemas.bibus._3.MonitorServiceEventID;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.NCTaskQueueTable;
import com.cognos.jsmcommon.tse.TSEObjectFactory;
import com.cognos.jsmcommon.tse.TaskID;
import com.cognos.jsmcommon.tse.TaskPersistLayerException;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.tse.TaskStateRecord;
import com.cognos.jsmcommon.tse.TaskStateTable;
import com.cognos.jsmcommon.util.ObjectModelClassEnum;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import java.util.ArrayList;

public class AgentLocator {
    private TaskRunSorter m_sorter;

    public AgentLocator(MonitorServiceEventID eventId, JobBiBusHeaders headers) throws AgentServiceException {
        String agent_search = null;
        try {
            TaskStateRecord state = TSEObjectFactory.getInstance().createTaskStateRecord();
            TaskStateRecord[] ancestorList = state.findAncestors(TaskID.fromEventId((String)eventId.getEventID()));
            ArrayList records = null;
            for (int i = ancestorList.length - 1; i >= 0 && agent_search == null; --i) {
                agent_search = this.getAgentRunnablePath(ancestorList[i]);
                if (agent_search == null) continue;
                records = this.extractAgentTaskRuns(ancestorList[i].taskID);
            }
            if (records == null || records.size() == 0 || agent_search == null) {
                RunHistoryExtractor rhe = new RunHistoryExtractor(eventId.getEventID(), headers);
                Object thing = rhe.getData();
                this.m_sorter = new TaskRunSorter();
            } else {
                AgentObjects agent_objects = new AgentObjects();
                agent_objects.cacheObjectsfromCM(agent_search, headers);
                AgentFactory factory = new AgentFactory(headers, agent_objects, new Option[0], new ParameterValue[0]);
                this.m_sorter = new TaskRunSorter(agent_objects, (Agent)factory.getRunnableObject(), records.toArray(new TaskRecord[records.size()]));
            }
        }
        catch (TaskPersistLayerException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
        }
        catch (IllegalArgumentException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
        }
        catch (Exception e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, e);
        }
    }

    public TaskRunSorter getTaskRunSorter() {
        return this.m_sorter;
    }

    private String getAgentRunnablePath(TaskStateRecord theRecord) throws TaskPersistLayerException {
        String agentPath = null;
        TaskRecord record = NCTaskQueueTable.getInstance().find(theRecord.taskID, false);
        if (null != record && ObjectModelClassEnum.AGENT.toString().equals(record.getObjectClass())) {
            agentPath = ObjectModelUtil.getSearchPathFromGuid((String)record.getTaskStoreId()).get_value();
        }
        return agentPath;
    }

    private ArrayList extractAgentTaskRuns(TaskID id) throws TaskPersistLayerException {
        TaskStateTable.StepInfo[] childs = TaskStateTable.getChildren((TaskID)id, null);
        ArrayList<TaskRecord> records = new ArrayList<TaskRecord>();
        for (int i = 0; i < childs.length; ++i) {
            TaskRecord record = NCTaskQueueTable.getInstance().find(childs[i].taskId, true);
            records.add(record);
        }
        return records;
    }
}

