/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.factory;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.developer.schemas.bibus._3.AccessEnum;
import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.AgentDefinition;
import com.cognos.developer.schemas.bibus._3.AgentDefinitionView;
import com.cognos.developer.schemas.bibus._3.AgentState;
import com.cognos.developer.schemas.bibus._3.AgentTaskDefinition;
import com.cognos.developer.schemas.bibus._3.AuthoredAgentDefinition;
import com.cognos.developer.schemas.bibus._3.AuthoredReport;
import com.cognos.developer.schemas.bibus._3.BaseAgentDefinition;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BaseRSSTask;
import com.cognos.developer.schemas.bibus._3.BaseReport;
import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.GuidProp;
import com.cognos.developer.schemas.bibus._3.HumanTask;
import com.cognos.developer.schemas.bibus._3.Memo;
import com.cognos.developer.schemas.bibus._3.MultilingualString;
import com.cognos.developer.schemas.bibus._3.MultilingualStringProp;
import com.cognos.developer.schemas.bibus._3.MultilingualToken;
import com.cognos.developer.schemas.bibus._3.MultilingualTokenProp;
import com.cognos.developer.schemas.bibus._3.NmtokenArrayProp;
import com.cognos.developer.schemas.bibus._3.OrderEnum;
import com.cognos.developer.schemas.bibus._3.ParameterValueArrayProp;
import com.cognos.developer.schemas.bibus._3.Permission;
import com.cognos.developer.schemas.bibus._3.Policy;
import com.cognos.developer.schemas.bibus._3.PolicyArrayProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.RefProp;
import com.cognos.developer.schemas.bibus._3.Report;
import com.cognos.developer.schemas.bibus._3.ReportDataServiceAgentDefinition;
import com.cognos.developer.schemas.bibus._3.ReportView;
import com.cognos.developer.schemas.bibus._3.RetentionRule;
import com.cognos.developer.schemas.bibus._3.RetentionRuleArrayProp;
import com.cognos.developer.schemas.bibus._3.Schedule;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.StoredProcedureTask;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.developer.schemas.bibus._3.UiClass;
import com.cognos.developer.schemas.bibus._3.UpdateActionEnum;
import com.cognos.developer.schemas.bibus._3.UpdateOptions;
import com.cognos.developer.schemas.bibus._3.WebServiceTask;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.AuthenticatorFactory;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;

public class AgentObjects {
    private static final String GET_RETENTIONS_METHOD = "getRetentions";
    private static final String SET_RETENTIONS_METHOD = "setRetentions";
    private BaseClass m_runnable;
    private BaseClass m_runnableReport;
    private BaseClass m_runnableBase;
    private BaseClass m_runnableBaseReport;
    private BaseClass m_stateReportView;
    private BaseClass[] m_agentTasks;
    private BaseClass[] m_agentTargets;
    private BaseClass m_schedule;
    private BaseClass m_agentState;
    private String m_search_path;
    private static final Sort[] ASV_SORT;
    private static final PropEnum[] ASV_SP_PROPS;
    private static final PropEnum[] ASV_PERMISSION_PROPS;
    private static final PropEnum[] ASV_TASK_PROPS;
    private static final PropEnum[] ASV_PROPS;

    public AgentObjects() {
    }

    public AgentObjects(AgentDefinition agent, AuthoredReport report, AgentTaskDefinition[] agentTasks, Schedule schedule) {
        this.setAgent((BaseAgentDefinition)agent);
        this.setSchedule(schedule);
        this.setReport(report);
        this.setAgentTasks(agentTasks);
        this.setAgentTargets();
    }

    public void cacheObjectsfromCM(JobBiBusHeaders jobBusHeaders) {
        ContentManagerServiceClientPort contentManager = null;
        try {
            contentManager = Client.instance().getContentManagerServiceClient(jobBusHeaders);
            if (this.m_agentTargets != null && this.m_agentTargets.length > 0) {
                this.buildNonAgentTaskDefinitionTargets(contentManager);
            }
            this.calculateCMProperties(LocaleUtil.getLocale((String)jobBusHeaders.getUserPreferenceContentLocale()));
        }
        finally {
            if (contentManager != null) {
                contentManager.close();
            }
        }
    }

    public void populateTargetStoreIdsForValidate() {
        if (this.m_agentTargets == null) {
            return;
        }
        for (int i = 0; i < this.m_agentTargets.length; ++i) {
            BaseClass target = this.m_agentTargets[i];
            if (target.getStoreID() != null && target.getStoreID().getValue() != null && !"".equals(target.getStoreID().getValue())) continue;
            GuidProp gp = new GuidProp();
            Guid guid = new Guid(target.getSearchPath().getValue());
            gp.setValue(guid);
            target.setStoreID(gp);
        }
    }

    public void cacheObjectsfromCM(String searchPath, JobBiBusHeaders jobBusHeaders) throws AgentServiceException {
        this.m_search_path = searchPath;
        ContentManagerServiceClientPort contentManager = null;
        try {
            contentManager = Client.instance().getContentManagerServiceClient(jobBusHeaders);
            this.getBaseRunnable(searchPath, contentManager);
        }
        catch (SDKClientException e) {
            throw new AgentServiceException((LocalizableException)((Object)e));
        }
        catch (EMFSecurityException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e});
        }
        finally {
            if (contentManager != null) {
                contentManager.close();
            }
        }
    }

    public BaseClass getAgentState() {
        return this.m_agentState;
    }

    public BaseClass[] getAgentTargets() {
        return this.m_agentTargets;
    }

    public BaseClass[] getAgentTasks() {
        return this.m_agentTasks;
    }

    public BaseClass getRunnableReport() {
        return this.m_runnableReport;
    }

    public BaseClass getRunnable() {
        return this.m_runnable;
    }

    public BaseClass getRunnableBase() {
        return this.m_runnableBase;
    }

    public BaseClass getRunnableBaseReport() {
        return this.m_runnableBaseReport;
    }

    public BaseClass getSchedule() {
        return this.m_schedule;
    }

    private void setAgentTasks(AgentTaskDefinition[] agentTasks) {
        this.m_agentTasks = agentTasks;
    }

    private void setReport(AuthoredReport report) {
        this.m_runnableReport = report;
    }

    private void setSchedule(Schedule schedule) {
        this.m_schedule = schedule;
    }

    private void setAgent(BaseAgentDefinition agent) {
        this.m_runnable = agent;
    }

    private void setAgentTargets() {
        if (this.m_agentTasks != null && this.m_agentTasks.length > 0) {
            this.m_agentTargets = new BaseClass[this.m_agentTasks.length];
            for (int i = 0; i < this.m_agentTasks.length; ++i) {
                BaseClass[] baseClassArr;
                BaseClassArrayProp taskObject = ((AgentTaskDefinition)this.m_agentTasks[i]).getTaskObject();
                if (taskObject == null || (baseClassArr = taskObject.getValue()) == null || baseClassArr.length <= 0) continue;
                this.m_agentTargets[i] = baseClassArr[0];
            }
        }
    }

    private void calculateCMProperties(Locale locale) {
        this.calculateUIClassProps(new BaseClass[]{this.m_runnable}, locale);
        this.calculateUIClassProps(new BaseClass[]{this.m_runnableBase}, locale);
        this.calculateUIClassProps(this.m_agentTasks, locale);
        this.calculateUIClassProps(this.m_agentTargets, locale);
    }

    private void calculateUIClassProps(BaseClass[] objects, Locale locale) {
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                StringProp screenTip;
                TokenProp name;
                if (objects[i] == null || !(objects[i] instanceof UiClass)) continue;
                UiClass uiClass = (UiClass)objects[i];
                StringProp description = uiClass.getDefaultDescription();
                if (description != null && (uiClass.getDescription() == null || uiClass.getDescription().getValue() == null || uiClass.getDescription().getValue().length == 0)) {
                    MultilingualStringProp multilingualStringProp = new MultilingualStringProp();
                    MultilingualString multilingualString = new MultilingualString();
                    multilingualString.setLocale(locale.toString());
                    multilingualString.setValue(description.getValue());
                    multilingualStringProp.setValue(new MultilingualString[]{multilingualString});
                    uiClass.setDescription(multilingualStringProp);
                }
                if ((name = uiClass.getDefaultName()) != null && (uiClass.getName() == null || uiClass.getName().getValue() == null || uiClass.getName().getValue().length == 0)) {
                    MultilingualTokenProp multilingualTokenProp = new MultilingualTokenProp();
                    MultilingualToken multilingualToken = new MultilingualToken();
                    multilingualToken.setLocale(locale.toString());
                    multilingualToken.setValue(name.getValue());
                    multilingualTokenProp.setValue(new MultilingualToken[]{multilingualToken});
                    uiClass.setName(multilingualTokenProp);
                }
                if ((screenTip = uiClass.getDefaultScreenTip()) == null || uiClass.getScreenTip() != null && uiClass.getScreenTip().getValue() != null && uiClass.getScreenTip().getValue().length != 0) continue;
                MultilingualStringProp multilingualStringProp = new MultilingualStringProp();
                MultilingualString multilingualString = new MultilingualString();
                multilingualString.setLocale(locale.toString());
                multilingualString.setValue(screenTip.getValue());
                multilingualStringProp.setValue(new MultilingualString[]{multilingualString});
                uiClass.setScreenTip(multilingualStringProp);
            }
        }
    }

    private void getBaseRunnable(String searchPath, ContentManagerServiceClientPort contentManager) throws SDKClientException, EMFSecurityException {
        BaseClass baseRunnable;
        boolean shouldUseTrusted = this.getPermissionsForRunnableUsingClassPath(searchPath, contentManager);
        if (shouldUseTrusted) {
            contentManager.signNextRequest("ASV");
        }
        if ((baseRunnable = this.getObjectFromCM(searchPath, contentManager)) != null) {
            QueryOptions taskDefOpt;
            RefProp taskObjectRefs;
            if (baseRunnable instanceof BaseAgentDefinition) {
                this.getPermissionsForRunnable(baseRunnable, contentManager);
                String statePath = "/transientStateFolder/agentState[containsReferences(@definition, " + searchPath + ")]";
                QueryRequest request = this.newRequest(statePath, ASV_PERMISSION_PROPS, null);
                if (shouldUseTrusted) {
                    contentManager.signNextRequest("ASV");
                }
                this.m_agentState = contentManager.query(request);
                if (this.m_agentState == null) {
                    this.m_agentState = this.createAgentState(baseRunnable, contentManager);
                }
                NmtokenArrayProp baseAgentPermissions = baseRunnable.getPermissions();
                NmtokenArrayProp agentStatePermissions = this.m_agentState.getPermissions();
                if (baseAgentPermissions != null && !baseAgentPermissions.equals((Object)agentStatePermissions)) {
                    this.updatePoliciesAndOwner(this.m_agentState, baseRunnable, contentManager);
                }
            }
            QueryRequest[] requests = null;
            if (baseRunnable instanceof AgentDefinitionView) {
                AgentDefinitionView view = (AgentDefinitionView)baseRunnable;
                BaseClass baseAgentDef = ObjectModelUtil.getBaseClass((BaseClassArrayProp)view.getBase(), (int)0);
                if (baseAgentDef != null) {
                    this.m_runnable = view;
                    String agentDefinitionPath = ObjectModelUtil.getSearchPath((Guid)baseAgentDef.getStoreID().getValue()).get_value();
                    requests = new QueryRequest[6];
                    requests[0] = this.newRequest(ObjectModelUtil.getSearchPath((Guid)view.getStoreID().getValue()).get_value() + "/reportView", ASV_PROPS, null);
                    requests[1] = this.newRequest(agentDefinitionPath, ASV_PROPS, null);
                    requests[2] = this.newRequest(agentDefinitionPath + "/report", ASV_PROPS, null);
                    requests[3] = this.newRequest(agentDefinitionPath + "/agentTaskDefinition", ASV_TASK_PROPS, ASV_SORT);
                    RefProp taskObjectRefs2 = new RefProp();
                    taskObjectRefs2.setRefPropName(PropEnum.taskObject);
                    taskObjectRefs2.setProperties(ASV_PROPS);
                    QueryOptions taskDefOpt2 = new QueryOptions();
                    taskDefOpt2.setRefProps(new RefProp[]{taskObjectRefs2});
                    requests[3].setOptions(taskDefOpt2);
                    requests[4] = this.newRequest(agentDefinitionPath + "/schedule", ASV_PROPS, null);
                    requests[5] = this.newRequest(ObjectModelUtil.getSearchPath((Guid)this.m_agentState.getStoreID().getValue()) + "/reportView", ASV_PERMISSION_PROPS, null);
                } else {
                    AuditProperties ap = new AuditProperties("Execute", searchPath, "AgentService", "Warning");
                    SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_UNKNOWN_OBJECT, (Map)ap);
                }
            } else if (baseRunnable instanceof AgentDefinition) {
                this.m_runnable = baseRunnable;
                requests = new QueryRequest[4];
                requests[0] = this.newRequest(ObjectModelUtil.getSearchPath((Guid)this.m_runnable.getStoreID().getValue()).get_value() + "/report", ASV_PROPS, null);
                requests[1] = this.newRequest(ObjectModelUtil.getSearchPath((Guid)this.m_runnable.getStoreID().getValue()).get_value() + "/agentTaskDefinition", ASV_TASK_PROPS, ASV_SORT);
                taskObjectRefs = new RefProp();
                taskObjectRefs.setRefPropName(PropEnum.taskObject);
                taskObjectRefs.setProperties(ASV_PROPS);
                taskDefOpt = new QueryOptions();
                taskDefOpt.setRefProps(new RefProp[]{taskObjectRefs});
                requests[1].setOptions(taskDefOpt);
                requests[2] = this.newRequest(ObjectModelUtil.getSearchPath((Guid)this.m_runnable.getStoreID().getValue()).get_value() + "/schedule", ASV_PROPS, null);
                requests[3] = this.newRequest(ObjectModelUtil.getSearchPath((Guid)this.m_agentState.getStoreID().getValue()).get_value() + "/reportView", ASV_PERMISSION_PROPS, null);
            } else if (baseRunnable instanceof ReportDataServiceAgentDefinition) {
                this.m_runnable = baseRunnable;
                requests = new QueryRequest[2];
                requests[0] = this.newRequest(ObjectModelUtil.getSearchPath((Guid)this.m_runnable.getStoreID().getValue()).get_value() + "/agentTaskDefinition", ASV_TASK_PROPS, ASV_SORT);
                taskObjectRefs = new RefProp();
                taskObjectRefs.setRefPropName(PropEnum.taskObject);
                taskObjectRefs.setProperties(ASV_PROPS);
                taskDefOpt = new QueryOptions();
                taskDefOpt.setRefProps(new RefProp[]{taskObjectRefs});
                requests[0].setOptions(taskDefOpt);
                requests[1] = this.newRequest(ObjectModelUtil.getSearchPath((Guid)this.m_runnable.getStoreID().getValue()).get_value() + "/schedule", ASV_PROPS, null);
                RefProp periodicalObjectRefs = new RefProp();
                periodicalObjectRefs.setRefPropName(PropEnum.periodicalProducer);
                periodicalObjectRefs.setProperties(ASV_PROPS);
                QueryOptions periodicalObjectOpt = new QueryOptions();
                periodicalObjectOpt.setRefProps(new RefProp[]{periodicalObjectRefs});
                requests[1].setOptions(periodicalObjectOpt);
            } else {
                this.m_runnable = baseRunnable;
            }
            if (requests != null) {
                if (shouldUseTrusted) {
                    contentManager.signNextRequest("ASV");
                }
                QueryReply[] reply = contentManager.queryMultiple(requests);
                if (baseRunnable instanceof AgentDefinitionView) {
                    this.m_runnableReport = this.getReply(reply[0]);
                    this.m_runnableBase = this.getReply(reply[1]);
                    this.m_runnableBaseReport = this.getReply(reply[2]);
                    this.m_agentTasks = this.getReplies(reply[3]);
                    this.m_schedule = this.getReply(reply[4]);
                    this.m_stateReportView = this.getReply(reply[5]);
                } else if (baseRunnable instanceof AgentDefinition) {
                    this.m_runnableReport = this.getReply(reply[0]);
                    this.m_agentTasks = this.getReplies(reply[1]);
                    this.m_schedule = this.getReply(reply[2]);
                    this.m_stateReportView = this.getReply(reply[3]);
                } else if (baseRunnable instanceof ReportDataServiceAgentDefinition) {
                    this.m_agentTasks = this.getReplies(reply[0]);
                    this.m_schedule = this.getReply(reply[1]);
                }
                if (this.m_agentTasks != null) {
                    this.buildAgentTaskDefinitionTargets(contentManager);
                }
                this.checkTaskRetentionRules(contentManager);
                if (this.m_runnable instanceof BaseAgentDefinition && !(this.m_runnable instanceof ReportDataServiceAgentDefinition)) {
                    if (this.m_stateReportView == null) {
                        BaseClass basis_runnable = null;
                        if (this.m_runnable instanceof AgentDefinition) {
                            basis_runnable = this.m_runnable;
                        } else if (this.m_runnable instanceof AgentDefinitionView) {
                            basis_runnable = this.m_runnableBase;
                        }
                        this.updatePoliciesForWrite(this.m_runnable);
                        this.m_stateReportView = this.createAgentStateReportView(this.m_runnable, basis_runnable, (AgentState)this.m_agentState, contentManager);
                    } else {
                        this.updatePoliciesAndOwner(this.m_stateReportView, this.m_runnable, contentManager);
                    }
                }
            }
        } else {
            AuditProperties ap = new AuditProperties("Execute", searchPath, "AgentService", "Warning");
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_UNKNOWN_OBJECT, (Map)ap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePoliciesAndOwner(BaseClass targetObj, BaseClass sourceObj, ContentManagerServiceClientPort contentManager) throws SDKClientException, EMFSecurityException {
        targetObj.setPolicies(sourceObj.getPolicies());
        targetObj.setOwner(sourceObj.getOwner());
        StringProp targetObjSearchPath = targetObj.getSearchPath();
        try {
            StringProp targetObjStoreIDSearchPath = new StringProp();
            targetObjStoreIDSearchPath.setValue(ObjectModelUtil.getSearchPath((Guid)targetObj.getStoreID().getValue()).get_value());
            targetObj.setSearchPath(targetObjStoreIDSearchPath);
            contentManager.signNextRequest("ASV");
            contentManager.update(new BaseClass[]{targetObj}, null);
        }
        finally {
            targetObj.setSearchPath(targetObjSearchPath);
        }
    }

    private void updatePoliciesForWrite(BaseClass baseClass) {
        Policy[] policies;
        PolicyArrayProp policyArrayProp = baseClass.getPolicies();
        if (policyArrayProp != null && (policies = policyArrayProp.getValue()) != null) {
            for (int i = 0; i < policies.length; ++i) {
                Permission[] permissions;
                Policy policy = policies[i];
                if (policy == null || (permissions = policy.getPermissions()) == null) continue;
                boolean addWritePermission = true;
                for (int j = 0; j < permissions.length && addWritePermission; ++j) {
                    Permission permission = permissions[j];
                    if (!permission.getName().equals("write")) continue;
                    addWritePermission = false;
                    if (!permission.getAccess().equals((Object)AccessEnum.deny)) continue;
                    permission.setAccess(AccessEnum.grant);
                }
                if (!addWritePermission) continue;
                int size = permissions.length;
                Permission[] newPermissions = new Permission[size + 1];
                System.arraycopy(permissions, 0, newPermissions, 0, size);
                newPermissions[size] = new Permission();
                newPermissions[size].setName("write");
                newPermissions[size].setAccess(AccessEnum.grant);
                policy.setPermissions(newPermissions);
            }
        }
    }

    private void updateRetention(RetentionRuleArrayProp agentDefinitionRetentions, BaseClass baseClass, ContentManagerServiceClientPort contentManager) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, InstantiationException, SDKClientException, EMFSecurityException {
        if (baseClass == null) {
            return;
        }
        Class<?> taskClass = baseClass.getClass();
        Method getRetentionsMethod = taskClass.getMethod(GET_RETENTIONS_METHOD, null);
        if (getRetentionsMethod != null) {
            RetentionRuleArrayProp taskDefinitionRetentions = (RetentionRuleArrayProp)getRetentionsMethod.invoke((Object)baseClass, null);
            RetentionRule taskDefinitionHistoryRetention = this.getHistoryRetention(taskDefinitionRetentions);
            RetentionRule agentDefinitionHistoryRetention = this.getHistoryRetention(agentDefinitionRetentions);
            if (taskDefinitionHistoryRetention != null && !taskDefinitionHistoryRetention.equals((Object)agentDefinitionHistoryRetention)) {
                this.updateHistoryRetention(taskDefinitionRetentions, agentDefinitionHistoryRetention);
                BaseClass tmpTask = (BaseClass)taskClass.newInstance();
                Class[] parameterTypes = new Class[]{RetentionRuleArrayProp.class};
                Method setRetentionsMethod = taskClass.getMethod(SET_RETENTIONS_METHOD, parameterTypes);
                if (setRetentionsMethod != null) {
                    setRetentionsMethod.invoke((Object)tmpTask, agentDefinitionRetentions);
                    StringProp taskStoreIDSearchPath = new StringProp();
                    taskStoreIDSearchPath.setValue(ObjectModelUtil.getSearchPath((Guid)baseClass.getStoreID().getValue()).get_value());
                    tmpTask.setSearchPath(taskStoreIDSearchPath);
                    UpdateOptions options = new UpdateOptions();
                    options.setReturnProperties(new PropEnum[]{PropEnum.retentions});
                    SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug("Agent RetentionRules have changed - Updating task RetentionRules [" + tmpTask.getSearchPath().getValue() + "]");
                    contentManager.signNextRequest("ASV");
                    BaseClass[] reply = contentManager.update(new BaseClass[]{tmpTask}, options);
                    if (reply != null && reply.length > 0 && reply[0] != null) {
                        BaseClass updatedTask = reply[0];
                        RetentionRuleArrayProp updatedRetentions = (RetentionRuleArrayProp)getRetentionsMethod.invoke((Object)updatedTask, null);
                        setRetentionsMethod.invoke((Object)baseClass, updatedRetentions);
                    }
                }
            }
        }
    }

    private RetentionRule getHistoryRetention(RetentionRuleArrayProp retentionRules) {
        RetentionRule[] retentionRuleArray;
        RetentionRule historyRule = null;
        if (retentionRules != null && (retentionRuleArray = retentionRules.getValue()) != null) {
            for (int i = 0; i < retentionRuleArray.length; ++i) {
                RetentionRule retentionRule = retentionRuleArray[i];
                if (retentionRule == null || !retentionRule.getObjectClass().equals((Object)ClassEnum.fromString((String)"history"))) continue;
                historyRule = retentionRule;
                break;
            }
        }
        return historyRule;
    }

    private void updateHistoryRetention(RetentionRuleArrayProp retentionRules, RetentionRule historyRule) {
        RetentionRule[] retentionRuleArray;
        if (retentionRules != null && (retentionRuleArray = retentionRules.getValue()) != null) {
            for (int i = 0; i < retentionRuleArray.length; ++i) {
                RetentionRule retentionRule = retentionRuleArray[i];
                if (retentionRule == null || !retentionRule.getObjectClass().equals((Object)ClassEnum.fromString((String)"history"))) continue;
                retentionRuleArray[i] = historyRule;
                break;
            }
        }
    }

    private void checkTaskRetentionRules(ContentManagerServiceClientPort contentManager) throws SDKClientException, EMFSecurityException {
        RetentionRuleArrayProp agentDefinitionRetentions = null;
        BaseClass agent = null;
        if (this.m_runnable instanceof AgentDefinition) {
            agent = this.m_runnable;
            agentDefinitionRetentions = ((AgentDefinition)this.m_runnable).getRetentions();
        } else if (this.m_runnable instanceof AgentDefinitionView) {
            agent = this.m_runnableBase;
            agentDefinitionRetentions = ((AgentDefinitionView)this.m_runnable).getRetentions();
        } else if (this.m_runnable instanceof ReportDataServiceAgentDefinition) {
            agent = this.m_runnable;
            agentDefinitionRetentions = ((ReportDataServiceAgentDefinition)this.m_runnable).getRetentions();
        }
        if (agentDefinitionRetentions == null) {
            return;
        }
        try {
            this.updateRetention(agentDefinitionRetentions, this.m_stateReportView, contentManager);
            if (this.m_agentTargets == null) {
                return;
            }
            for (int i = 0; i < this.m_agentTargets.length; ++i) {
                if (!this.isAgentParentOfTask(agent, this.m_agentTargets[i])) continue;
                this.updateRetention(agentDefinitionRetentions, this.m_agentTargets[i], contentManager);
            }
        }
        catch (InstantiationException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
        }
        catch (SecurityException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
        }
        catch (IllegalArgumentException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
        }
        catch (NoSuchMethodException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
        }
        catch (IllegalAccessException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
        }
        catch (InvocationTargetException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
        }
    }

    private boolean isAgentParentOfTask(BaseClass agent, BaseClass task) {
        BaseClass[] value;
        boolean isParent = false;
        if (task.getParent() != null && (value = task.getParent().getValue()) != null && value.length > 0 && value[0] != null && value[0] instanceof AuthoredAgentDefinition) {
            isParent = agent.getSearchPath().equals((Object)value[0].getSearchPath());
        }
        return isParent;
    }

    private QueryRequest newRequest(String path, PropEnum[] props, Sort[] sort) {
        QueryRequest qr = new QueryRequest();
        qr.setSearch(path);
        qr.setOptions(null);
        qr.setSortBy(sort);
        qr.setProperties(props);
        return qr;
    }

    private void buildAgentTaskDefinitionTargets(ContentManagerServiceClientPort contentManager) throws SDKClientException, EMFSecurityException {
        ArrayList<BaseClass> targets = new ArrayList<BaseClass>();
        if (this.m_agentTasks != null) {
            for (int i = 0; i < this.m_agentTasks.length; ++i) {
                AgentTaskDefinition agentTaskDefinition = (AgentTaskDefinition)this.m_agentTasks[i];
                BaseClass[] taskObjects = agentTaskDefinition.getTaskObject().getValue();
                if (taskObjects != null && taskObjects.length > 0) {
                    this.retrieveDefaultParameterValues(contentManager, taskObjects);
                    targets.addAll(Arrays.asList(taskObjects));
                    continue;
                }
                targets.add(new BrokenTarget());
            }
            this.m_agentTargets = targets.toArray(new BaseClass[targets.size()]);
        }
    }

    private void buildNonAgentTaskDefinitionTargets(ContentManagerServiceClientPort contentManager) {
        ArrayList<BaseClass> targets = new ArrayList<BaseClass>();
        for (int i = 0; i < this.m_agentTargets.length; ++i) {
            BaseClass baseClass = this.m_agentTargets[i];
            if (baseClass instanceof Memo || baseClass instanceof StoredProcedureTask || baseClass instanceof WebServiceTask || baseClass instanceof BaseRSSTask || baseClass instanceof HumanTask) {
                targets.add(baseClass);
                continue;
            }
            String sp = ObjectModelUtil.getSearchPath((BaseClass)baseClass);
            if (sp == null || "".equals(sp)) {
                targets.add(baseClass);
                continue;
            }
            BaseClass target = null;
            try {
                target = this.getObjectFromCM(sp, contentManager);
                this.retrieveDefaultParameterValues(contentManager, new BaseClass[]{target});
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (target == null) {
                target = baseClass;
            }
            targets.add(target);
        }
        this.m_agentTargets = targets.toArray(new BaseClass[targets.size()]);
    }

    private void getPermissionsForRunnable(BaseClass runnable, ContentManagerServiceClientPort contentManager) throws SDKClientException, EMFSecurityException {
        QueryRequest req = new QueryRequest();
        req.setSearch(ObjectModelUtil.getSearchPath((Guid)runnable.getStoreID().getValue()).get_value());
        req.setProperties(ASV_PERMISSION_PROPS);
        contentManager.signNextRequest("ASV");
        BaseClass baseClass = contentManager.query(req);
        if (baseClass != null) {
            runnable.setPolicies(baseClass.getPolicies());
            runnable.setOwner(baseClass.getOwner());
        }
    }

    private boolean getPermissionsForRunnableUsingClassPath(String searchPath, ContentManagerServiceClientPort contentManager) throws SDKClientException, EMFSecurityException {
        boolean shouldUseTrusted = false;
        QueryRequest req = new QueryRequest();
        req.setSearch(searchPath);
        req.setProperties(ASV_PERMISSION_PROPS);
        BaseClass baseClass = contentManager.query(req);
        if (baseClass != null) {
            NmtokenArrayProp ppp = baseClass.getPermissions();
            boolean hasExecutePermission = AuthenticatorFactory.getInstance().hasPermission(ppp, "execute");
            boolean hasTraversePermission = AuthenticatorFactory.getInstance().hasPermission(ppp, "traverse");
            if (!hasExecutePermission || !hasTraversePermission) {
                shouldUseTrusted = true;
            }
        }
        return shouldUseTrusted;
    }

    private BaseClass createAgentState(BaseClass runnable, ContentManagerServiceClientPort contentManager) throws SDKClientException, EMFSecurityException {
        AgentState state = new AgentState();
        AgentDefinition definition = new AgentDefinition();
        definition.setSearchPath(runnable.getSearchPath());
        BaseClassArrayProp stateArray = new BaseClassArrayProp();
        stateArray.setValue(new BaseClass[]{definition});
        state.setDefinition(stateArray);
        state.setPolicies(runnable.getPolicies());
        state.setOwner(runnable.getOwner());
        state.setTenantID(runnable.getTenantID());
        AddOptions options = new AddOptions();
        options.setUpdateAction(UpdateActionEnum.fail);
        options.setReturnProperties(ASV_PERMISSION_PROPS);
        RetentionRule rule1 = new RetentionRule();
        rule1.setObjectClass(ClassEnum.fromString((String)"agentOutputHotList"));
        rule1.setProp(PropEnum.creationTime);
        rule1.setMaxObjects(BigInteger.valueOf(2L));
        RetentionRuleArrayProp ruleProp = new RetentionRuleArrayProp();
        ruleProp.setValue(new RetentionRule[]{rule1});
        state.setRetentions(ruleProp);
        contentManager.signNextRequest("ASV");
        return (AgentState)contentManager.add("/transientStateFolder", (BaseClass)state, options);
    }

    private ReportView createAgentStateReportView(BaseClass runnable, BaseClass runnable_base, AgentState agentState, ContentManagerServiceClientPort contentManager) throws SDKClientException, EMFSecurityException {
        Report report = new Report();
        StringProp searchPathProp = new StringProp();
        searchPathProp.setValue(runnable_base.getSearchPath().getValue() + "/report");
        report.setSearchPath(searchPathProp);
        ReportView view = new ReportView();
        TokenProp tp = new TokenProp();
        tp.setValue(runnable.getDefaultName().getValue());
        view.setDefaultName(tp);
        BaseClassArrayProp array = new BaseClassArrayProp();
        array.setValue(new BaseClass[]{report});
        view.setBase(array);
        view.setPolicies(runnable.getPolicies());
        view.setOwner(runnable.getOwner());
        if (runnable instanceof AgentDefinition || runnable instanceof AgentDefinitionView) {
            RetentionRuleArrayProp agentDefinitionRetentions = ((BaseAgentDefinition)runnable).getRetentions();
            view.setRetentions(agentDefinitionRetentions);
        }
        AddOptions options = new AddOptions();
        options.setUpdateAction(UpdateActionEnum.fail);
        options.setReturnProperties(new PropEnum[]{PropEnum.searchPath});
        String path = ObjectModelUtil.getSearchPath((Guid)agentState.getStoreID().getValue()).get_value();
        contentManager.signNextRequest("ASV");
        return (ReportView)contentManager.add(path, (BaseClass)view, options);
    }

    private BaseClass getReply(QueryReply reply) {
        BaseClass ret_value = null;
        BaseClass[] classes = reply.getQueryResult();
        if (classes != null && classes.length != 0 && classes[0] != null) {
            ret_value = classes[0];
        }
        return ret_value;
    }

    private void retrieveDefaultParameterValues(ContentManagerServiceClientPort cm, BaseClass[] taskBaseClasses) throws SDKClientException, EMFSecurityException {
        for (int i = 0; i < taskBaseClasses.length; ++i) {
            ParameterValueArrayProp parameters;
            BaseClass taskBaseClass = taskBaseClasses[i];
            if (!(taskBaseClass instanceof BaseAgentDefinition)) continue;
            BaseAgentDefinition agentDefinition = (BaseAgentDefinition)taskBaseClass;
            String searchPath = ObjectModelUtil.getSearchPath((Guid)agentDefinition.getStoreID().getValue()).get_value();
            if (taskBaseClass instanceof AgentDefinition) {
                searchPath = searchPath + "/report";
            } else if (taskBaseClass instanceof AgentDefinitionView) {
                searchPath = searchPath + "/reportView";
            }
            QueryRequest request = new QueryRequest();
            request.setSearch(searchPath);
            request.setOptions(null);
            request.setSortBy(null);
            request.setProperties(new PropEnum[]{PropEnum.parameters});
            BaseReport taskReport = null;
            taskReport = (BaseReport)cm.query(request);
            if (taskReport == null || (parameters = taskReport.getParameters()).getValue() == null) continue;
            agentDefinition.setParameters(parameters);
        }
    }

    private BaseClass[] getReplies(QueryReply reply) {
        BaseClass[] ret_value = new BaseClass[]{};
        BaseClass[] classes = reply.getQueryResult();
        if (classes != null && classes.length != 0) {
            ret_value = classes;
        }
        return ret_value;
    }

    public String getSearchPath() {
        String searchPath = "";
        if (this.m_runnable != null && this.m_runnable.getSearchPath() != null) {
            searchPath = this.m_runnable.getSearchPath().getValue();
        } else if (searchPath != null) {
            searchPath = this.m_search_path;
        } else if (this.m_runnableBase != null) {
            searchPath = this.m_runnableBase.getSearchPath().getValue();
        }
        return searchPath;
    }

    public BaseClass getObjectFromCM(String searchPath, ContentManagerServiceClientPort contentManager) throws SDKClientException, EMFSecurityException {
        BaseClass[] baseClasses = contentManager.query(searchPath, ASV_PROPS, null, null);
        return baseClasses != null && baseClasses.length > 0 ? baseClasses[0] : null;
    }

    public ReportView getStateReportView() {
        return (ReportView)this.m_stateReportView;
    }

    static {
        Sort sort = new Sort();
        sort.setPropName(PropEnum.displaySequence);
        sort.setOrder(OrderEnum.ascending);
        ASV_SORT = new Sort[]{sort};
        ASV_SP_PROPS = new PropEnum[]{PropEnum.searchPath, PropEnum.storeID};
        ASV_PERMISSION_PROPS = new PropEnum[]{PropEnum.searchPath, PropEnum.storeID, PropEnum.owner, PropEnum.policies, PropEnum.permissions, PropEnum.retentions};
        ASV_TASK_PROPS = new PropEnum[]{PropEnum.defaultName, PropEnum.eventTypes, PropEnum.eventKey, PropEnum.searchPath, PropEnum.storeID, PropEnum.parameters, PropEnum.parameterAssignments, PropEnum.runOptions, PropEnum.options, PropEnum.taskObject, PropEnum.packageBase, PropEnum.parent, PropEnum.permissions, PropEnum.allowNotification, PropEnum.notificationListIsEmpty, PropEnum.filterDataItemName, PropEnum.runCondition, PropEnum.screenTip, PropEnum.objectClass};
        ASV_PROPS = new PropEnum[]{PropEnum.ancestors, PropEnum.base, PropEnum.bindingName, PropEnum.defaultName, PropEnum.description, PropEnum.eventKey, PropEnum.inputMessageName, PropEnum.metadataModel, PropEnum.metadataModelPackage, PropEnum.operationName, PropEnum.options, PropEnum.outputMessageName, PropEnum.packageBase, PropEnum.parameters, PropEnum.parent, PropEnum.periodicalProducer, PropEnum.permissions, PropEnum.policies, PropEnum.report, PropEnum.retentions, PropEnum.screenTip, PropEnum.searchPath, PropEnum.storeID, PropEnum.sequencing, PropEnum.serviceName, PropEnum.storedProcedureName, PropEnum.title, PropEnum.uri, PropEnum.allowNotification, PropEnum.notificationListIsEmpty, PropEnum.mostRecentEventList, PropEnum.link, PropEnum.channel, PropEnum.objectClass};
    }

    private static class BrokenTarget
    extends BaseClass {
    }
}

