/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.factory;

import com.cognos.asv.BaseStepObject;
import com.cognos.asv.FaultedAsvRunnable;
import com.cognos.asv.factory.AgentFactory;
import com.cognos.asv.factory.AgentObjects;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.taskTargets.humanTask.HumanTaskRunnable;
import com.cognos.asv.taskTargets.storedProcedureTask.StoredProcedureTaskRunnable;
import com.cognos.asv.taskTargets.webServiceTask.WebServiceTaskRunnable;
import com.cognos.developer.schemas.bibus._3.BaseAgentDefinition;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.HumanTask;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.StoredProcedureTask;
import com.cognos.developer.schemas.bibus._3.WebServiceTask;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;

public abstract class AsvRunnableAbstractFactory {
    public static BaseStepObject getRunnable(AgentObjects agentObjectCache, JobBiBusHeaders jobBusHeaders, Option[] submit_options, ParameterValue[] submit_params) {
        BaseStepObject runnable = null;
        BaseClass baseClass = agentObjectCache.getRunnable();
        if (baseClass == null) {
            I18NMessage message = new I18NMessage(AsvI18NCode.MSG_ASV_MISSING_OBJECT, new Object[]{agentObjectCache.getSearchPath()}, SeverityEnum.error);
            runnable = new FaultedAsvRunnable(message, jobBusHeaders);
        } else if (baseClass instanceof BaseAgentDefinition) {
            AgentFactory factory = new AgentFactory(jobBusHeaders, agentObjectCache, submit_options, submit_params);
            runnable = factory.getRunnableObject();
        } else if (baseClass instanceof WebServiceTask) {
            runnable = new WebServiceTaskRunnable((WebServiceTask)baseClass, null, jobBusHeaders);
            runnable.setSubmitOptions(submit_options);
            runnable.setSubmitParameters(submit_params);
        } else if (baseClass instanceof HumanTask) {
            runnable = new HumanTaskRunnable((HumanTask)baseClass, null, jobBusHeaders);
            runnable.setSubmitOptions(submit_options);
            runnable.setSubmitParameters(submit_params);
        } else if (baseClass instanceof StoredProcedureTask) {
            runnable = new StoredProcedureTaskRunnable((StoredProcedureTask)baseClass, null, jobBusHeaders);
            runnable.setSubmitOptions(submit_options);
            runnable.setSubmitParameters(submit_params);
        } else {
            I18NMessage message = new I18NMessage(AsvI18NCode.MSG_ASV_MISSING_OBJECT, new Object[]{agentObjectCache.getSearchPath()}, SeverityEnum.error);
            runnable = new FaultedAsvRunnable(message, jobBusHeaders);
        }
        return runnable;
    }
}

