/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.factory;

import com.cognos.asv.AgentTaskComparator;
import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.BaseStepObjectContainer;
import com.cognos.asv.TaskRun;
import com.cognos.asv.TaskRunInfo;
import com.cognos.asv.agent.Agent;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.asv.factory.AgentObjects;
import com.cognos.asv.taskTargets.AgentReportTarget;
import com.cognos.developer.schemas.bibus._3.BaseReport;
import com.cognos.developer.schemas.bibus._3.ClassEnumProp;
import com.cognos.developer.schemas.bibus._3.ReportView;
import com.cognos.jsmcommon.tse.BiBusRunSpec;
import com.cognos.jsmcommon.tse.TaskRecord;
import com.cognos.jsmcommon.util.ObjectModelClassEnum;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class TaskRunSorter {
    private BaseAgent m_agent;
    private List m_taskRuns = new ArrayList();
    private static Set MULTI_RUN_AGENT_TASKS = new HashSet();

    public TaskRunSorter() {
    }

    public TaskRunSorter(AgentObjects agent_objects, BaseAgent agent, TaskRecord[] agentChildren) {
        Stack<TaskRecord> taskRunInfoStack = new Stack<TaskRecord>();
        for (int i = agentChildren.length - 1; i >= 0; --i) {
            taskRunInfoStack.push(agentChildren[i]);
        }
        this.m_agent = agent;
        List<BaseStepObject> subSteps = agent.getSubSteps();
        ArrayList<BaseStepObject> sortedSteps = new ArrayList<BaseStepObject>();
        sortedSteps.addAll(subSteps);
        Collections.sort(sortedSteps, new AgentTaskComparator());
        try {
            if (agent instanceof Agent) {
                ReportView view = agent_objects.getStateReportView();
                ClassEnumProp classEnumProp = new ClassEnumProp();
                classEnumProp.setValue(ObjectModelClassEnum.REPORT_VIEW.getClassEnum());
                view.setObjectClass(classEnumProp);
                view.setDefaultName(ObjectModelUtil.makeTokenProp((String)"Condition"));
                AgentReportTarget art = new AgentReportTarget((BaseReport)view, (BaseStepObject)agent, this.m_agent.getHeaders());
                this.addTaskRun(art, taskRunInfoStack);
            }
            for (Object e : sortedSteps) {
                if (!(e instanceof BaseStepObjectContainer)) continue;
                List<BaseStepObject> steps = ((BaseStepObjectContainer)e).getSubSteps();
                for (int j = 0; j < steps.size(); ++j) {
                    BaseStepObject obj = steps.get(j);
                    if (!(obj instanceof BaseAgentTaskTarget)) continue;
                    this.addTaskRun((BaseAgentTaskTarget)obj, taskRunInfoStack);
                }
            }
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
    }

    private void addTaskRun(BaseAgentTaskTarget target, Stack taskRunInfoStack) throws EmptyStackException {
        String targetBaseclass = target.getBaseClass().getObjectClass().getValue().getValue();
        String targetStoreId = target.getBaseClass().getStoreID().getValue().get_value();
        if (MULTI_RUN_AGENT_TASKS.contains(target.getBaseClass().getObjectClass().getValue().getValue())) {
            ArrayList<TaskRunInfo> runInfo = new ArrayList<TaskRunInfo>();
            TaskRecord record = (TaskRecord)taskRunInfoStack.peek();
            while (record != null && record.getObjectClass().equals(targetBaseclass) && record.getTaskStoreId().equals(targetStoreId)) {
                taskRunInfoStack.pop();
                BiBusRunSpec runSpec = (BiBusRunSpec)record.getRunSpec();
                String eventID = runSpec.eventID;
                if (eventID == null) {
                    eventID = record.getTaskId().getID();
                }
                runInfo.add(new TaskRunInfo(runSpec.options, runSpec.parameters, eventID));
                if (!taskRunInfoStack.isEmpty()) {
                    record = (TaskRecord)taskRunInfoStack.peek();
                    continue;
                }
                record = null;
            }
            if (runInfo.size() > 0) {
                this.m_taskRuns.add(new TaskRun((BaseStepObject)target, runInfo.toArray(new TaskRunInfo[runInfo.size()])));
            } else {
                this.m_taskRuns.add(new TaskRun((BaseStepObject)target, true));
            }
        } else {
            TaskRecord record = (TaskRecord)taskRunInfoStack.peek();
            if (record.getObjectClass().equals(targetBaseclass) && record.getTaskStoreId().equals(targetStoreId)) {
                taskRunInfoStack.pop();
                BiBusRunSpec runSpec = (BiBusRunSpec)record.getRunSpec();
                String eventID = runSpec.eventID;
                if (eventID == null) {
                    eventID = record.getTaskId().getID();
                }
                TaskRunInfo runInfo = new TaskRunInfo(runSpec.options, runSpec.parameters, eventID);
                this.m_taskRuns.add(new TaskRun((BaseStepObject)target, new TaskRunInfo[]{runInfo}));
            } else {
                this.m_taskRuns.add(new TaskRun((BaseStepObject)target, true));
            }
        }
    }

    public BaseAgent getAgent() {
        return this.m_agent;
    }

    public List getTaskRuns() {
        return this.m_taskRuns;
    }

    static {
        MULTI_RUN_AGENT_TASKS.add("memo");
    }
}

