/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.mht;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.asv.ASVCategory;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.mht.MHTResourceInfo;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Hashtable;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;

public class MHTResourceCache {
    private static final String M_MHT_PROTOCOL_HTTP = "http";
    private static final String M_MHT_PROTOCOL_HTTPS = "https";
    private static MHTResourceCache m_instance = new MHTResourceCache();
    private Hashtable m_cache = new Hashtable();
    private CAMFactory m_camf = null;

    private MHTResourceCache() {
    }

    public static MHTResourceCache getInstance() {
        return m_instance;
    }

    public boolean loadResource(String resourcePath) {
        SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug("MHTResourceCache looking for resource: " + resourcePath);
        if (!this.resourceLoaded(resourcePath)) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug("MHTResourceCache: resource not in cache so trying to load from: " + resourcePath);
            try {
                int max_redirects = 10;
                int redirect_count = 0;
                boolean can_redirect = false;
                MHTResourceInfo resourceInfo = null;
                String currentResourcePath = resourcePath;
                do {
                    URL resourceURL = this.buildResourceURL(currentResourcePath);
                    SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug("MHTResourceCache: resource url: " + resourceURL.toString());
                    resourceInfo = this.loadResourceFromWeb(resourceURL);
                    if (resourceInfo.getResponseCode() == 200) {
                        this.m_cache.put(resourcePath, resourceInfo);
                        SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug("MHTResourceCache: resource loaded and added to cache: " + resourcePath);
                        continue;
                    }
                    boolean bl = can_redirect = ++redirect_count < 10 && (currentResourcePath = resourceInfo.getResourceHeader("Location")) != null;
                } while (can_redirect && !this.resourceLoaded(resourcePath));
            }
            catch (MalformedURLException e) {
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_MHT_RESOURCE_LOAD_FAILED, new Object[]{e.getMessage()});
            }
            catch (HttpException e) {
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_MHT_RESOURCE_LOAD_FAILED, new Object[]{e.getMessage()});
            }
            catch (IOException e) {
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_MHT_RESOURCE_LOAD_FAILED, new Object[]{e.getMessage()});
            }
            catch (CAMCryptoException e) {
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_MHT_RESOURCE_LOAD_FAILED, new Object[]{e.getMessage()});
            }
        }
        return this.resourceLoaded(resourcePath);
    }

    public byte[] getResourceData(String resourcePath) {
        byte[] resourceData = null;
        if (this.resourceLoaded(resourcePath)) {
            resourceData = ((MHTResourceInfo)this.m_cache.get(resourcePath)).getResourceData();
        }
        return resourceData;
    }

    public String getResourceHeader(String resourcePath, String headerIdentifier) {
        String header = null;
        if (this.resourceLoaded(resourcePath)) {
            header = ((MHTResourceInfo)this.m_cache.get(resourcePath)).getResourceHeader(headerIdentifier);
        }
        return header;
    }

    private URL buildResourceURL(String resourcePath) throws MalformedURLException {
        URL resourceURL = null;
        try {
            if (resourcePath.startsWith("..")) {
                String internalDispatcherURI = CRNProperties.getInstance().getProperty("internalDispatcher");
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug("MHTResourceCache looking for resource: via " + internalDispatcherURI);
                int lastSlash = internalDispatcherURI.lastIndexOf("/");
                if (lastSlash != -1) {
                    internalDispatcherURI = internalDispatcherURI.substring(0, lastSlash + 1);
                }
                URI uri = new URI(internalDispatcherURI + resourcePath);
                uri = uri.normalize();
                resourceURL = uri.toURL();
            } else {
                resourceURL = new URL(resourcePath);
            }
        }
        catch (PropertiesException propertiesException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return resourceURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MHTResourceInfo loadResourceFromWeb(URL resourceURL) throws CAMCryptoException, HttpException, IOException {
        MHTResourceInfo ret_value = null;
        String protocol = resourceURL.getProtocol();
        int port = resourceURL.getPort();
        boolean isHTTPS = false;
        if (protocol.toLowerCase().equals(M_MHT_PROTOCOL_HTTP) && port == -1) {
            port = 80;
        }
        if (protocol.toLowerCase().equals(M_MHT_PROTOCOL_HTTPS)) {
            isHTTPS = true;
            if (port == -1) {
                port = 443;
            }
        }
        String host = resourceURL.getHost();
        HttpClient httpClient = null;
        GetMethod httpMethod = null;
        try {
            CAMFactory camf = this.getCamFactory();
            httpClient = camf.createHttpClient(host, port, isHTTPS);
            camf.createGenericTrustedSession();
            httpMethod = new GetMethod(resourceURL.toString());
            int methodResponseCode = httpClient.executeMethod((HttpMethod)httpMethod);
            if (methodResponseCode == 200) {
                byte[] responseBody = httpMethod.getResponseBody();
                Header[] responseHeaders = httpMethod.getResponseHeaders();
                ret_value = new MHTResourceInfo(methodResponseCode, responseHeaders, responseBody);
            } else {
                Header[] responseHeaders = httpMethod.getResponseHeaders();
                ret_value = new MHTResourceInfo(methodResponseCode, responseHeaders);
            }
        }
        finally {
            if (httpMethod != null) {
                httpMethod.releaseConnection();
            }
        }
        return ret_value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CAMFactory getCamFactory() throws CAMCryptoException {
        Class<MHTResourceCache> clazz = MHTResourceCache.class;
        synchronized (MHTResourceCache.class) {
            if (this.m_camf == null) {
                this.m_camf = new CAMFactory();
                byte[] initDoc = "<initializeDocument><serviceID>SDS</serviceID></initializeDocument>".getBytes();
                this.m_camf.initialize(initDoc);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.m_camf;
        }
    }

    private boolean resourceLoaded(String resourcePath) {
        return this.m_cache.containsKey(resourcePath);
    }
}

