/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.parameters;

import com.cognos.asv.AgentTask;
import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.resultset.MetadataItem;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetLinePieces;
import com.cognos.asv.resultset.ResultSetTopic;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseParameter;
import com.cognos.developer.schemas.bibus._3.BaseParameterAssignment;
import com.cognos.developer.schemas.bibus._3.BaseParameterAssignmentArrayProp;
import com.cognos.developer.schemas.bibus._3.ParameterAssignmentDataItem;
import com.cognos.developer.schemas.bibus._3.ParameterCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.RunConditionEnum;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.StoredProcedureTask;
import com.cognos.developer.schemas.bibus._3.WebServiceTask;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.tse.HistoryTopicsEnum;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class MissingParameterHandler {
    private ValidationResultHandler m_handler;
    ArrayList m_missingParams = new ArrayList();
    private HashMap m_paramMap = new HashMap();

    public MissingParameterHandler(ValidationResultHandler handler, BaseParameter[] allparams) {
        this.m_handler = handler;
        for (int i = 0; allparams != null && i < allparams.length; ++i) {
            this.m_paramMap.put(allparams[i].getName(), allparams[i]);
        }
    }

    private void missingParameter(String parameterName, String taskName) {
        this.m_handler.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_UNRESOLVED_PARAMETER, new Object[]{taskName, parameterName}, SeverityEnum.warn));
        BaseParameter param = (BaseParameter)this.m_paramMap.get(parameterName);
        this.m_missingParams.add(param);
    }

    private boolean checkNoValue(Map generatedParamMap, String name) {
        boolean noValue = !generatedParamMap.containsKey(name);
        ParameterValue value = null;
        noValue = noValue || (value = (ParameterValue)generatedParamMap.get(name)) == null;
        noValue = noValue || value.getValue() == null;
        boolean bl = noValue = noValue || value.getValue().length == 0;
        if (!noValue) {
            ParmValueItem[] parmVals = value.getValue();
            for (int j = 0; j < parmVals.length; ++j) {
                String parmValue = ObjectModelUtil.getParameterValue((ParmValueItem)parmVals[j]);
                noValue = parmValue == null || "".equals(parmValue);
            }
        }
        return noValue;
    }

    public void validateMissingParameters(AgentTask callingTask, BaseParameter[] targetParameters, ParameterValue[] parameterValues, ResultSet agentResultSet) {
        this.getMissingParameters(callingTask, targetParameters, parameterValues, agentResultSet);
    }

    private void checkValidateParameterMultiValues(AgentTask callingTask, BaseParameter[] targetParameters, ParameterValue[] parameterValues, String task_name) {
        BaseAgentTaskTarget target = callingTask.getTarget();
        BaseClass base = target.getBaseClass();
        if (base != null) {
            boolean checkMultiValues;
            boolean bl = checkMultiValues = !(base instanceof WebServiceTask) && !(base instanceof StoredProcedureTask);
            if (checkMultiValues) {
                this.validateParametersMultivalued(targetParameters, parameterValues, task_name);
            }
        }
    }

    private Map makeParameterMap(ParameterValue[] parameterValues) {
        HashMap<String, ParameterValue> generatedParamMap = new HashMap<String, ParameterValue>();
        for (int i = 0; parameterValues != null && i < parameterValues.length; ++i) {
            generatedParamMap.put(parameterValues[i].getName(), parameterValues[i]);
        }
        return generatedParamMap;
    }

    public void getMissingParameters(AgentTask callingTask, BaseParameter[] targetParameters, ParameterValue[] parameterValues, ResultSet agentResultSet) {
        String task_name = callingTask.getAgentTaskDefinition().getDefaultName().getValue();
        Set asignmentParameters = this.checkAssignmentTopics(callingTask, agentResultSet);
        Map generatedParamMap = this.makeParameterMap(parameterValues);
        boolean emptyAssignmentMessages = false;
        for (int i = 0; targetParameters != null && i < targetParameters.length; ++i) {
            String name = targetParameters[i].getName();
            boolean noValue = this.checkNoValue(generatedParamMap, name);
            if (!noValue || ObjectModelUtil.hasCapability((BaseParameter)targetParameters[i], (ParameterCapabilityEnum)ParameterCapabilityEnum.optional)) continue;
            if (asignmentParameters.contains(name)) {
                emptyAssignmentMessages = true;
                continue;
            }
            this.m_handler.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_UNRESOLVED_PARAMETER, new Object[]{task_name, name}, SeverityEnum.warn));
        }
        if (emptyAssignmentMessages) {
            if (agentResultSet.numDataItems() > 0) {
                this.m_handler.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_UNABLE_TO_DRILL, new Object[]{task_name}, SeverityEnum.warn));
            } else {
                this.m_handler.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_NO_DATA_CANT_VALIDATE_ARGUMENTS, new Object[]{task_name}, SeverityEnum.info));
            }
        }
        this.checkValidateParameterMultiValues(callingTask, targetParameters, parameterValues, task_name);
    }

    private Set checkAssignmentTopics(AgentTask callingTask, ResultSet agentResultSet) {
        String task_name = callingTask.getAgentTaskDefinition().getDefaultName().getValue();
        BaseParameterAssignment[] assignments = new BaseParameterAssignment[]{};
        BaseParameterAssignmentArrayProp bpaap = callingTask.getAgentTaskDefinition().getParameterAssignments();
        if (bpaap != null && bpaap.getValue() != null) {
            assignments = bpaap.getValue();
        }
        HashSet<String> assignmentParameters = new HashSet<String>();
        for (int i = 0; i < assignments.length; ++i) {
            if (assignments[i] == null) continue;
            assignmentParameters.add(assignments[i].getParameterName());
        }
        HashSet<String> topics = new HashSet<String>();
        boolean runOnFailure = callingTask.getTaskRunCondition().equals((Object)RunConditionEnum.runOnFailure);
        if (runOnFailure) {
            Locale locale = LocaleUtil.getLocale((String)callingTask.getHeaders().getUserPreferenceContentLocale());
            for (HistoryTopicsEnum historyTypes : HistoryTopicsEnum.getTopics()) {
                topics.add(historyTypes.getTopic(locale));
            }
        } else {
            Iterator metaDataIter = agentResultSet.getMetadata();
            while (metaDataIter.hasNext()) {
                MetadataItem item = (MetadataItem)metaDataIter.next();
                if (item == null) continue;
                topics.add(item.expression());
            }
        }
        for (int i = 0; i < assignments.length; ++i) {
            if (assignments[i] == null || !(assignments[i] instanceof ParameterAssignmentDataItem)) continue;
            ParameterAssignmentDataItem assignment = (ParameterAssignmentDataItem)assignments[i];
            ResultSetLinePieces pieces = new ResultSetLinePieces(assignment.getDataItemName() != null ? assignment.getDataItemName().get_value() : "");
            if (pieces.isConstant() || runOnFailure) {
                if (topics.contains(pieces.get(0))) continue;
                this.missingParameter(assignment.getParameterName(), task_name);
                continue;
            }
            if (pieces.getTopics().size() == 0) {
                this.missingParameter(assignment.getParameterName(), task_name);
                continue;
            }
            for (ResultSetTopic assignmentTopic : pieces.getTopics()) {
                if (topics.contains(assignmentTopic.reference())) continue;
                this.missingParameter(assignment.getParameterName(), task_name);
            }
        }
        return assignmentParameters;
    }

    private void validateParametersMultivalued(BaseParameter[] parameters, ParameterValue[] resolvedParameters, String taskName) {
        int i;
        HashMap<String, ParameterValue> generatedParamMap = new HashMap<String, ParameterValue>();
        for (i = 0; resolvedParameters != null && i < resolvedParameters.length; ++i) {
            generatedParamMap.put(resolvedParameters[i].getName(), resolvedParameters[i]);
        }
        for (i = 0; parameters != null && i < parameters.length; ++i) {
            ParmValueItem[] values;
            ParameterValue pv;
            if (ObjectModelUtil.hasCapability((BaseParameter)parameters[i], (ParameterCapabilityEnum)ParameterCapabilityEnum.multivalued) || (pv = (ParameterValue)generatedParamMap.get(parameters[i].getName())) == null || (values = pv.getValue()) == null || values.length <= 1) continue;
            this.m_handler.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_TOO_MANY_PARAMETERS, new Object[]{taskName, parameters[i].getName()}, SeverityEnum.warn));
        }
    }
}

