/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.reportTemplates;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import java.io.File;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class TemplateTransformer {
    private static HashMap m_templateMap = new HashMap();
    private static final String PATH = File.separator + ".." + File.separator + "templates" + File.separator + "rsvp" + File.separator + "xsl" + File.separator;
    public static final String V5HTML_PATH = PATH + "V5html.xsl";
    public static final String ASVPROMPT_PATH = PATH + "asvPromptPage.xsl";
    private String m_templateFile;
    private Transformer m_transformer = null;
    private Properties m_props;

    public TemplateTransformer() {
        this.m_templateFile = V5HTML_PATH;
    }

    public TemplateTransformer(String template, Properties props) {
        this.m_templateFile = template;
        this.m_props = props;
    }

    public String transformData(Reader reader) throws AgentServiceException {
        StringWriter htmlWriter = new StringWriter();
        this.transformData(reader, htmlWriter);
        return htmlWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void transformData(Reader reader, Writer htmlWriter) throws AgentServiceException {
        String errorMsg = null;
        try {
            Transformer transformer = this.getTransformer();
            transformer.transform(new StreamSource(reader), new StreamResult(htmlWriter));
            if (errorMsg == null) return;
        }
        catch (TransformerConfigurationException e) {
            errorMsg = e.getMessage();
            if (errorMsg == null) return;
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_XSL_TRANSFORM_ERROR, new Object[]{errorMsg});
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_XSL_TRANSFORM_ERROR, new Object[]{errorMsg});
        }
        catch (TransformerException e2) {
            errorMsg = e2.getMessage();
            if (errorMsg == null) return;
            {
                catch (Throwable throwable) {
                    if (errorMsg == null) throw throwable;
                    SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_XSL_TRANSFORM_ERROR, new Object[]{errorMsg});
                    throw new AgentServiceException(AsvI18NCode.MSG_ASV_XSL_TRANSFORM_ERROR, new Object[]{errorMsg});
                }
            }
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_XSL_TRANSFORM_ERROR, new Object[]{errorMsg});
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_XSL_TRANSFORM_ERROR, new Object[]{errorMsg});
        }
        SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_XSL_TRANSFORM_ERROR, new Object[]{errorMsg});
        throw new AgentServiceException(AsvI18NCode.MSG_ASV_XSL_TRANSFORM_ERROR, new Object[]{errorMsg});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transformer getTransformer() throws TransformerConfigurationException {
        if (!m_templateMap.containsKey(this.m_templateFile)) {
            HashMap hashMap = m_templateMap;
            synchronized (hashMap) {
                if (!m_templateMap.containsKey(this.m_templateFile)) {
                    TransformerFactory tFactory = TransformerFactory.newInstance();
                    Templates template = tFactory.newTemplates(new StreamSource(new File(CRNProperties.getInstance().getBinDir() + this.m_templateFile)));
                    m_templateMap.put(this.m_templateFile, template);
                }
            }
        }
        Templates template = (Templates)m_templateMap.get(this.m_templateFile);
        return this.setProps(template.newTransformer());
    }

    private Transformer setProps(Transformer transformer) {
        if (this.m_props == null) {
            return transformer;
        }
        Enumeration<?> enumeration = this.m_props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            transformer.setParameter(name, this.m_props.getProperty(name));
        }
        return transformer;
    }
}

