/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset;

import com.cognos.asv.resultset.ResultSetDataValue;
import com.cognos.asv.resultset.ResultSetDrill;
import com.cognos.asv.resultset.ResultSetDrillValue;
import com.cognos.asv.resultset.ResultSetXML;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class Handler
extends DefaultHandler {
    private static final String XS_NIL = "xs:nil";
    private static final String PARAMETER = "parameter";
    private static final String OBJECT_PATH = "objectPath";
    private static final String PARAMETER_NAME = "parameterName";
    private static final String DRILL_VALUE = "drillValue";
    private static final String DRILL_POSITION = "drillPosition";
    private static final String DRILLTHROUGH = "drillthrough";
    private static final String PRESENTATION_VALUE = "presentationValue";
    private static final String RAW_VALUE = "rawValue";
    private static final String LENGTH = "length";
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String ITEM = "item";
    private static final String MUN = "mun";
    private static final String DRILL = "drill";
    private static final String VALUE = "value";
    private static final String ROW = "row";
    private Stack m_stack = new Stack();
    private ResultSetXML m_resultSet;
    private StringBuffer rawValue = new StringBuffer();
    private StringBuffer presentationValue = new StringBuffer();
    private ArrayList drillValues = null;
    private HashMap drills = new HashMap();
    private boolean m_isNull = false;
    private int drillCount = 0;
    private boolean rawValueExists = false;
    private boolean oldReport = false;
    private boolean isPresentationValue = false;

    public Handler(ResultSetXML resultSet) {
        this.m_resultSet = resultSet;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.oldReport && !this.rawValueExists) {
            this.m_resultSet.setVersion("0.9");
        } else {
            this.m_resultSet.setVersion("1.0");
        }
        super.endDocument();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String data = new String(ch, start, length);
        if (((String)this.m_stack.peek()).equals(VALUE)) {
            this.appendValue(data);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (((String)this.m_stack.peek()).equals(qName)) {
            if (((String)this.m_stack.peek()).equals(VALUE)) {
                ResultSetDataValue rsDataValue = null;
                rsDataValue = this.m_isNull ? new ResultSetDataValue() : new ResultSetDataValue(this.rawValue.toString(), this.presentationValue.toString());
                this.m_resultSet.addValue(rsDataValue);
                if (this.drillValues != null) {
                    rsDataValue.setDrillValues(this.drillValues.toArray(new ResultSetDrillValue[0]));
                }
                this.drillValues = null;
                this.rawValue.setLength(0);
                this.presentationValue.setLength(0);
                this.m_isNull = false;
            } else if (((String)this.m_stack.peek()).equals(DRILL)) {
                ++this.drillCount;
            } else if (((String)this.m_stack.peek()).equals(PRESENTATION_VALUE)) {
                this.isPresentationValue = false;
            }
            this.m_stack.pop();
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.m_stack.push(qName);
        if (((String)this.m_stack.peek()).equals(ROW)) {
            this.m_resultSet.addRow();
        } else if (((String)this.m_stack.peek()).equals(ITEM)) {
            String name = attributes.getValue(NAME);
            String type = attributes.getValue(TYPE);
            String length = attributes.getValue(LENGTH);
            String mun = attributes.getValue(MUN);
            this.m_resultSet.addMetadataItem(name, type, length, mun);
        } else if (((String)this.m_stack.peek()).equals(VALUE)) {
            this.drillValues = new ArrayList();
            String nill = attributes.getValue(XS_NIL);
            if (attributes.getValue(RAW_VALUE) != null) {
                this.rawValue.append(attributes.getValue(RAW_VALUE));
                this.rawValueExists = true;
            }
            if (attributes.getValue(PRESENTATION_VALUE) != null) {
                this.presentationValue.append(attributes.getValue(PRESENTATION_VALUE));
                this.isPresentationValue = true;
            }
            if (nill != null) {
                this.m_isNull = true;
            }
        } else if (((String)this.m_stack.peek()).equals(DRILLTHROUGH)) {
            String drillPos = attributes.getValue(DRILL_POSITION);
            String drillValue = attributes.getValue(DRILL_VALUE);
            String paramName = attributes.getValue(PARAMETER_NAME);
            ResultSetDrillValue rsDrillValue = new ResultSetDrillValue(drillPos, paramName, drillValue);
            ResultSetDrill drill = this.getDrill(drillPos);
            rsDrillValue.setDrill(drill);
            this.drillValues.add(rsDrillValue);
        } else if (((String)this.m_stack.peek()).equals(DRILL)) {
            String objectPath = attributes.getValue(OBJECT_PATH);
            ResultSetDrill drill = this.getDrill(this.drillCount);
            drill.setDrillPath(objectPath);
        } else if (((String)this.m_stack.peek()).equals(PARAMETER)) {
            String name = attributes.getValue(NAME);
            String type = attributes.getValue(TYPE);
            ResultSetDrill drill = this.getDrill(this.drillCount);
            drill.addDrillParameters(name, type);
        }
    }

    private void appendValue(String data) {
        if (!this.isPresentationValue) {
            this.presentationValue.append(data);
            this.oldReport = true;
        }
    }

    private ResultSetDrill getDrill(int drillPos) {
        return this.getDrill(String.valueOf(drillPos));
    }

    private ResultSetDrill getDrill(String drillPos) {
        ResultSetDrill drill = null;
        if (this.drills.containsKey(drillPos)) {
            drill = (ResultSetDrill)this.drills.get(drillPos);
        } else {
            drill = new ResultSetDrill();
            this.drills.put(drillPos, drill);
        }
        return drill;
    }
}

