/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset;

import com.cognos.asv.resultset.MetadataItem;
import com.cognos.asv.resultset.ResultSetDataValue;
import com.cognos.asv.resultset.ResultSetKey;
import com.cognos.asv.resultset.ResultSetTopic;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public abstract class ResultSet {
    public static final String VERSION_0_9 = "0.9";
    public static final String VERSION_1_0 = "1.0";
    public static final ResultSetTopic KEY_TOPIC = new ResultSetTopic("key()", "[key()]");
    public static final ResultSetTopic STATUS_TOPIC = new ResultSetTopic("status()", "[status()]");
    private String m_version = "1.0";

    public abstract int numQueryItems();

    public abstract int numDataItems();

    public abstract Iterator getMetadata();

    public abstract Iterator getData();

    public abstract ResultSetDataValue getDataValue(ResultSetKey var1, ResultSetTopic var2);

    public abstract MetadataItem getMetadataValue(ResultSetTopic var1);

    public boolean isEmpty() {
        return this.numDataItems() == 0;
    }

    public Set generateKeySet() {
        return (Set)this.asCollection(new TreeSet());
    }

    public Collection asCollection(Collection collection) {
        Iterator it = this.getData();
        while (it.hasNext()) {
            collection.add(it.next());
        }
        return collection;
    }

    public boolean nullRow(ResultSetKey key) {
        boolean nullRow = true;
        Iterator metadataIt = this.getMetadata();
        while (metadataIt.hasNext() && nullRow) {
            MetadataItem metadataItem = (MetadataItem)metadataIt.next();
            ResultSetDataValue dataValue = this.getDataValue(key, metadataItem.makeTopic());
            nullRow = nullRow && dataValue.isNull();
        }
        return nullRow;
    }

    void setVersion(String version) {
        this.m_version = version;
    }

    String getVersion() {
        return this.m_version;
    }
}

