/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset;

import com.cognos.asv.resultset.MetadataItem;
import com.cognos.asv.resultset.ResultSetDataValue;
import com.cognos.asv.resultset.ResultSetKey;
import com.cognos.asv.resultset.ResultSetTable;
import com.cognos.asv.resultset.ResultSetTopic;
import com.cognos.asv.resultset.ResultSetTypeEnum;
import com.cognos.asv.resultset.html.DA;
import com.cognos.asv.resultset.html.DR;
import com.cognos.asv.resultset.html.DRI;
import com.cognos.asv.resultset.html.HTMLBase;
import com.cognos.asv.resultset.html.OHL;
import com.cognos.asv.resultset.html.OIMG;
import com.cognos.asv.resultset.html.OTI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;

public class ResultSetHTML
extends ResultSetTable {
    private ArrayList m_da = new ArrayList();
    private Hashtable m_dri_titles = new Hashtable();
    private Hashtable m_dri_columns = new Hashtable();

    public ResultSetHTML(Locale request_locale) {
        this.setLocale(request_locale);
    }

    public void addDA(DA da) {
        this.m_da.add(da);
    }

    public void addDR(DR dr) {
        String layoutClass;
        if (dr.hasAttribute("layoutClass") && (layoutClass = dr.getAttribute("layoutClass")).equals("listColumns") && dr.numDRIs() > 0) {
            DRI dri = dr.getDRI(0);
            String driLayoutClass = dri.getAttribute("layoutClass");
            if (driLayoutClass.equals("listColumnTitle")) {
                this.addMetaData(dr);
            } else if (driLayoutClass.equals("listColumnBody")) {
                this.addData(dr);
            }
        }
    }

    private void addMetaData(DR dr) {
        int isz = dr.numDRIs();
        for (int i = 0; i < isz; ++i) {
            DRI dri = dr.getDRI(i);
            HTMLBase base = dri.getBASE();
            if (!(base instanceof OTI)) continue;
            String name = ((OTI)base).getValue();
            this.m_metadata.add(new MetadataItem(name, null, null));
            this.m_metadata_keys.put(name, new Integer(this.m_metadata.size() - 1));
            this.m_dri_titles.put(name, dri);
        }
    }

    private void addData(DR dr) {
        ArrayList<ResultSetDataValue> list = new ArrayList<ResultSetDataValue>();
        int isz = dr.numDRIs();
        for (int i = 0; i < isz; ++i) {
            DRI dri = dr.getDRI(i);
            HTMLBase base = dri.getBASE();
            String name = null;
            if (base instanceof OTI) {
                name = ((OTI)base).getValue();
            } else if (base instanceof OIMG) {
                name = ((OIMG)base).getAttribute("source");
            } else if (base instanceof OHL) {
                name = ((OHL)base).getOTI().getValue();
            }
            list.add(new ResultSetDataValue(name, name));
            this.m_dri_columns.put(((MetadataItem)this.m_metadata.get(i)).name(), dri);
        }
        this.m_rows.add(list);
    }

    public String getTopicValue(ResultSetKey key, ResultSetTopic topic) {
        if (topic.equals(KEY_TOPIC)) {
            return key.getKey();
        }
        ResultSetDataValue rsdv = this.getDataValue(key.getRowNumber(), topic);
        if (rsdv.isNull()) {
            return rsdv.getNullMessage(this.getLocale());
        }
        return rsdv.getPresentationValue();
    }

    public String getTopicValue(ResultSetKey key, ResultSetTopic topic, ResultSetTypeEnum type) {
        return this.getTopicValue(key, topic);
    }

    @Override
    public ResultSetDataValue getDataValue(ResultSetKey key, ResultSetTopic topic) {
        if (topic.equals(KEY_TOPIC)) {
            return new ResultSetDataValue(key.getKey(), key.getKey());
        }
        ResultSetDataValue value = this.getDataValue(key.getRowNumber(), topic);
        value.setLocale(this.getLocale());
        return value;
    }

    public HTMLBase getColumnTitle(String topic) {
        if (this.m_dri_titles.containsKey(topic)) {
            return (HTMLBase)this.m_dri_titles.get(topic);
        }
        return null;
    }

    public HTMLBase getColumnData(String topic, String value) {
        if (this.m_dri_columns.containsKey(topic)) {
            HTMLBase columnData = (HTMLBase)this.m_dri_columns.get(topic);
            columnData.setValue(value);
            return columnData;
        }
        return null;
    }
}

