/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset;

import com.cognos.asv.formatters.FormatterPair;
import com.cognos.asv.formatters.IdentityFormatter;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetKey;
import com.cognos.asv.resultset.ResultSetLinePieces;
import com.cognos.asv.resultset.ResultSetTopic;
import com.cognos.asv.resultset.ResultSetTypeEnum;

public class ResultSetLineBuilder {
    private ResultSetLinePieces m_pieces = null;
    private ResultSet m_rs = null;
    private ResultSetTypeEnum m_type = null;
    private String m_template;
    private FormatterPair m_transforms;

    public ResultSetLineBuilder(ResultSet rs, ResultSetTypeEnum type, String template) {
        this(rs, type, template, new FormatterPair(new IdentityFormatter(), new IdentityFormatter()));
    }

    public ResultSetLineBuilder(ResultSet rs, ResultSetTypeEnum type, String template, FormatterPair transforms) {
        this.m_rs = rs;
        this.m_pieces = new ResultSetLinePieces(template, transforms.decoder());
        this.m_type = type;
        this.m_template = template;
        this.m_transforms = transforms;
    }

    public int sizeLine(ResultSetKey key) {
        int size = 0;
        for (int k = 0; k < this.m_pieces.size(); ++k) {
            Object piece = this.m_pieces.get(k);
            if (piece instanceof String) {
                size += ((String)piece).length();
                continue;
            }
            if (!(piece instanceof ResultSetTopic)) continue;
            ResultSetTopic topic = (ResultSetTopic)piece;
            String topic_value = this.m_rs.getDataValue(key, topic).getTopicValue(this.m_type);
            topic_value = this.m_transforms.encode(topic_value);
            size += topic_value.length();
        }
        return size;
    }

    public void buildLine(ResultSetKey key, StringBuffer buffer) {
        for (int k = 0; k < this.m_pieces.size(); ++k) {
            Object piece = this.m_pieces.get(k);
            if (piece instanceof String) {
                buffer.append(piece);
                continue;
            }
            if (!(piece instanceof ResultSetTopic)) continue;
            ResultSetTopic topic = (ResultSetTopic)piece;
            String topic_value = this.m_rs.getDataValue(key, topic).getTopicValue(this.m_type);
            topic_value = this.m_transforms.encode(topic_value);
            buffer.append(topic_value);
        }
    }

    public String buildLine(ResultSetKey key) {
        StringBuffer buffer = new StringBuffer(this.m_template.length());
        this.buildLine(key, buffer);
        return buffer.toString();
    }

    public boolean isConstant() {
        return this.m_pieces.isConstant();
    }

    public void setFormatterPair(FormatterPair formatter) {
        this.m_transforms = formatter;
    }

    public ResultSetLinePieces getLinePieces() {
        return this.m_pieces;
    }
}

