/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset;

import com.cognos.asv.formatters.EllipsisFormatter;
import com.cognos.asv.formatters.FormatterPair;
import com.cognos.asv.formatters.IdentityFormatter;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetDistinctTopicFiltered;
import com.cognos.asv.resultset.ResultSetKey;
import com.cognos.asv.resultset.ResultSetLineBuilder;
import com.cognos.asv.resultset.ResultSetLinePieces;
import com.cognos.asv.resultset.ResultSetTypeEnum;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;

public class ResultSetMessageBuilder {
    private ResultSet m_rs = null;
    private ResultSetTypeEnum m_type = null;
    private String m_message;
    private FormatterPair m_transforms;

    public ResultSetMessageBuilder(ResultSet rs, ResultSetTypeEnum type, String message) {
        this(rs, type, message, new FormatterPair(new IdentityFormatter(), new IdentityFormatter()));
    }

    public ResultSetMessageBuilder(ResultSet rs, ResultSetTypeEnum type, String message, FormatterPair transforms) {
        this.m_rs = rs;
        this.m_type = type;
        this.m_message = message;
        this.m_transforms = transforms;
    }

    public String getMessage() {
        return this.getMessage(false);
    }

    public String getMessage(boolean singleLine) {
        StringBuffer buffer = new StringBuffer(this.m_message.length());
        StringReader string_reader = new StringReader(this.m_message);
        BufferedReader line_reader = new BufferedReader(string_reader);
        String line = null;
        boolean first = true;
        block0: while ((line = this.getNextLine(line_reader)) != null) {
            if (!first && !singleLine) {
                buffer.append("\n");
            }
            first = false;
            ResultSetLinePieces linePieces = new ResultSetLinePieces(line, this.m_transforms.decoder());
            if (linePieces.isConstant()) {
                buffer.append(linePieces.get(0));
                continue;
            }
            ResultSetDistinctTopicFiltered lineRS = new ResultSetDistinctTopicFiltered(this.m_rs, linePieces.getTopicString());
            ResultSetLineBuilder lineBuilder = new ResultSetLineBuilder(lineRS, this.m_type, line, this.m_transforms);
            ResultSetKey[] keys = lineRS.asCollection(new ArrayList()).toArray(new ResultSetKey[0]);
            for (int i = 0; i < keys.length; ++i) {
                if (singleLine && keys.length > 1) {
                    lineBuilder.setFormatterPair(new FormatterPair(new EllipsisFormatter(this.m_transforms.encoder()), this.m_transforms.decoder()));
                    buffer.append(lineBuilder.buildLine(keys[i]));
                    continue block0;
                }
                if (i < keys.length - 1) {
                    buffer.append(lineBuilder.buildLine(keys[i]));
                    buffer.append("\n");
                    continue;
                }
                buffer.append(lineBuilder.buildLine(keys[i]));
            }
        }
        return buffer.toString();
    }

    public boolean isConstant() {
        ResultSetLinePieces pieces = new ResultSetLinePieces(this.m_message);
        return pieces.isConstant();
    }

    private String getNextLine(BufferedReader line_reader) {
        String CONT_MARKER = "\\";
        String DOUBLE_SLASH = "\\\\";
        boolean more = true;
        String ret_value = null;
        while (more) {
            String line = null;
            try {
                line = line_reader.readLine();
                if (line != null) {
                    if (line.endsWith("\\\\")) {
                        line = line.substring(0, line.length() - 1);
                        more = false;
                    } else if (line.endsWith("\\")) {
                        line = line.substring(0, line.length() - 1);
                        line = line + "\n";
                    } else {
                        more = false;
                    }
                } else {
                    more = false;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ret_value = ret_value == null ? line : ret_value + (line == null ? "" : line);
        }
        return ret_value;
    }
}

