/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset;

import com.cognos.asv.resultset.MetadataItem;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetDataValue;
import com.cognos.asv.resultset.ResultSetFilterEnum;
import com.cognos.asv.resultset.ResultSetIntersection;
import com.cognos.asv.resultset.ResultSetKey;
import com.cognos.asv.resultset.ResultSetLinePieces;
import com.cognos.asv.resultset.ResultSetTopic;
import com.cognos.asv.resultset.ResultSetTypeEnum;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ResultSetProcessed
extends ResultSet {
    private ResultSet m_rs;
    private ResultSet m_p_rs;
    private String m_indexKey = null;
    private Set m_discontinued;
    private Set m_ongoing;
    private Set m_changed;
    private Set m_new;
    private Set m_cached_keys;
    private Hashtable m_old_changed;

    public ResultSetProcessed(ResultSet previousResultSet, ResultSet currentResultSet, String indexKey) {
        this.m_indexKey = indexKey;
        this.m_p_rs = previousResultSet;
        this.m_rs = currentResultSet;
        this.process();
    }

    @Override
    public int numQueryItems() {
        return this.m_rs.numQueryItems() + 1;
    }

    @Override
    public int numDataItems() {
        return this.m_cached_keys.size();
    }

    @Override
    public Iterator getData() {
        return this.m_cached_keys.iterator();
    }

    @Override
    public Iterator getMetadata() {
        ArrayList metadata = new ArrayList();
        Iterator it = this.m_rs.getMetadata();
        while (it.hasNext()) {
            Object obj = it.next();
            metadata.add(obj);
        }
        metadata.add(new MetadataItem(ResultSet.STATUS_TOPIC.name(), "xs:string", "20"));
        return metadata.iterator();
    }

    public String getTopicValue(ResultSetKey key, ResultSetTopic topic, ResultSetTypeEnum type) {
        return this.getDataValue(key, topic).getTopicValue(type);
    }

    @Override
    public MetadataItem getMetadataValue(ResultSetTopic topic) {
        MetadataItem ret_value = null;
        ret_value = topic.equals(ResultSet.STATUS_TOPIC) ? new MetadataItem(ResultSet.STATUS_TOPIC.name(), "xs:string", "20") : this.m_rs.getMetadataValue(topic);
        return ret_value;
    }

    private void process() {
        LinkedHashSet omega = new LinkedHashSet();
        LinkedHashSet alpha = (LinkedHashSet)this.m_rs.asCollection(new LinkedHashSet());
        if (this.m_p_rs != null) {
            this.m_p_rs.asCollection(omega);
        }
        Iterator metadataIt = this.m_rs.getMetadata();
        StringBuffer fullKey = new StringBuffer("");
        while (metadataIt.hasNext()) {
            MetadataItem metadataItem = (MetadataItem)metadataIt.next();
            fullKey.append(metadataItem.expression());
        }
        String indexKey = this.m_indexKey;
        if (null == indexKey || indexKey.length() <= 0) {
            indexKey = fullKey.toString();
        }
        Map alphaTemp = this.generateMap(alpha, indexKey);
        Map omegaTemp = this.generateMap(omega, indexKey);
        this.m_new = this.diff(alphaTemp, omegaTemp);
        this.m_discontinued = this.diff(omegaTemp, alphaTemp);
        Map currentTemp = this.intersect(alphaTemp, omegaTemp);
        this.m_ongoing = new LinkedHashSet();
        this.m_changed = new LinkedHashSet();
        this.m_old_changed = new Hashtable();
        if (currentTemp.keySet().size() > 0) {
            ResultSetLinePieces linePieces = new ResultSetLinePieces(fullKey.toString());
            Iterator it = currentTemp.keySet().iterator();
            while (it.hasNext()) {
                ResultSetKey full_omega_key;
                ResultSetIntersection intersection = (ResultSetIntersection)currentTemp.get(it.next());
                ResultSetKey alpha_key = intersection.alpha();
                ResultSetKey omega_key = intersection.omega();
                ResultSetKey full_alpha_key = this.generateKey(alpha_key, linePieces);
                if (full_alpha_key.equals(full_omega_key = this.generateKey(omega_key, linePieces))) {
                    this.m_ongoing.add(alpha_key);
                    continue;
                }
                this.m_changed.add(alpha_key);
                this.m_old_changed.put(alpha_key.getKey(), omega_key);
            }
        }
        this.m_cached_keys = new LinkedHashSet();
        this.m_cached_keys.addAll(this.m_discontinued);
        this.m_cached_keys.addAll(alphaTemp.keySet());
    }

    private Map generateMap(Set a, String indexKey) {
        LinkedHashMap<ResultSetKey, ResultSetKey> map = new LinkedHashMap<ResultSetKey, ResultSetKey>();
        ResultSetLinePieces linePieces = new ResultSetLinePieces(indexKey);
        for (ResultSetKey oldKey : a) {
            ResultSetKey newKey = this.generateKey(oldKey, linePieces);
            if (map.containsKey(newKey)) continue;
            map.put(newKey, newKey);
        }
        return map;
    }

    private Set diff(Map alpha, Map omega) {
        LinkedHashSet ret_value = new LinkedHashSet();
        for (Object obj : alpha.keySet()) {
            if (omega.containsKey(obj)) continue;
            ret_value.add(obj);
        }
        return ret_value;
    }

    private Map intersect(Map alpha, Map omega) {
        LinkedHashMap<ResultSetKey, ResultSetIntersection> ret_value = new LinkedHashMap<ResultSetKey, ResultSetIntersection>();
        for (Map.Entry entry : alpha.entrySet()) {
            ResultSetKey key = (ResultSetKey)entry.getKey();
            if (!omega.containsKey(key)) continue;
            ret_value.put(key, new ResultSetIntersection((ResultSetKey)entry.getValue(), (ResultSetKey)omega.get(key)));
        }
        return ret_value;
    }

    private ResultSetKey generateKey(ResultSetKey key, ResultSetLinePieces linePieces) {
        Set topicPieces = linePieces.getTopics();
        StringBuffer buffer = new StringBuffer("");
        for (ResultSetTopic topic : topicPieces) {
            ResultSetDataValue dataValue = key.getResultSet().getDataValue(key, topic);
            if (this.m_p_rs != null && "0.9".equals(this.m_p_rs.getVersion())) {
                buffer.append(dataValue.getTopicValue(ResultSetTypeEnum.HTML));
            } else {
                buffer.append(dataValue.getTopicValue());
            }
            buffer.append(";");
        }
        return new ResultSetKey(key.getResultSet(), key.getRowNumber(), buffer.toString());
    }

    @Override
    public ResultSetDataValue getDataValue(ResultSetKey key, ResultSetTopic topic) {
        String ret_value = null;
        ResultSetDataValue rsdv = null;
        boolean previous = false;
        if (topic.previous() && this.m_changed.contains(key)) {
            key = (ResultSetKey)this.m_old_changed.get(key.getKey());
            previous = true;
        }
        if (topic.equals(ResultSet.STATUS_TOPIC)) {
            if (this.m_discontinued.contains(key)) {
                ret_value = ResultSetFilterEnum.DELETED.getValue();
            } else if (this.m_ongoing.contains(key)) {
                ret_value = ResultSetFilterEnum.UNCHANGED.getValue();
            } else if (this.m_changed.contains(key)) {
                ret_value = ResultSetFilterEnum.CHANGED.getValue();
            } else if (this.m_new.contains(key)) {
                ret_value = ResultSetFilterEnum.NEW.getValue();
            }
            rsdv = new ResultSetDataValue(ret_value, ret_value);
        } else {
            rsdv = this.m_discontinued.contains(key) || previous ? this.m_p_rs.getDataValue(key, topic) : this.m_rs.getDataValue(key, topic);
        }
        return rsdv;
    }

    @Override
    public boolean nullRow(ResultSetKey key) {
        boolean nullRow = true;
        Iterator metadataIt = this.getMetadata();
        while (metadataIt.hasNext() && nullRow) {
            MetadataItem metadataItem = (MetadataItem)metadataIt.next();
            if (metadataItem.name().equals(ResultSet.STATUS_TOPIC.name())) continue;
            ResultSetDataValue dataValue = this.getDataValue(key, metadataItem.makeTopic());
            nullRow = nullRow && dataValue.isNull();
        }
        return nullRow;
    }
}

