/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset;

import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.resultset.IllegalTopicException;
import com.cognos.asv.resultset.MetadataItem;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetDataValue;
import com.cognos.asv.resultset.ResultSetKey;
import com.cognos.asv.resultset.ResultSetTopic;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.util.LocaleUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;

public abstract class ResultSetTable
extends ResultSet {
    private Locale m_locale;
    protected ArrayList m_metadata = new ArrayList();
    protected Hashtable m_metadata_keys = new Hashtable();
    protected ArrayList m_rows = new ArrayList();

    @Override
    public Iterator getData() {
        LinkedList<ResultSetKey> list = new LinkedList<ResultSetKey>();
        for (int i = 0; i < this.numDataItems(); ++i) {
            list.add(this.generateKey(i));
        }
        return list.iterator();
    }

    @Override
    public Iterator getMetadata() {
        return this.m_metadata.iterator();
    }

    @Override
    public int numQueryItems() {
        return this.m_metadata.size();
    }

    @Override
    public int numDataItems() {
        return this.m_rows.size();
    }

    protected ResultSetDataValue getDataValue(int row, ResultSetTopic topic) {
        ResultSetDataValue ret_value = null;
        if (topic.name().length() > 0) {
            if (this.m_metadata_keys.containsKey(topic.name())) {
                ret_value = this.getDataValue(row, (Integer)this.m_metadata_keys.get(topic.name()));
            }
            if (ret_value == null) {
                throw new IllegalTopicException(I18NUtil.getMessage((I18NCode)AsvI18NCode.MSG_AGS_UNKNOWN_TOPIC, (Object[])new Object[]{topic.name()}, (Locale)LocaleUtil.createContentLocale((String)this.m_locale.toString())));
            }
        }
        return ret_value;
    }

    @Override
    public MetadataItem getMetadataValue(ResultSetTopic topic) {
        MetadataItem ret_value = null;
        if (topic.name().length() > 0) {
            if (this.m_metadata_keys.containsKey(topic.name())) {
                ret_value = (MetadataItem)this.m_metadata.get((Integer)this.m_metadata_keys.get(topic.name()));
            } else {
                throw new IllegalStateException(I18NUtil.getMessage((I18NCode)AsvI18NCode.MSG_AGS_UNKNOWN_TOPIC, (Object[])new Object[]{topic.name()}, (Locale)LocaleUtil.createContentLocale((String)this.m_locale.toString())));
            }
        }
        return ret_value;
    }

    protected ResultSetDataValue getDataValue(int row, int column) {
        ResultSetDataValue value = null;
        if (row < this.numDataItems() && column < this.numQueryItems()) {
            value = (ResultSetDataValue)((ArrayList)this.m_rows.get(row)).get(column);
        }
        return value;
    }

    protected ResultSetKey generateKey(int i) {
        String key = "";
        for (int j = 0; j < this.numQueryItems(); ++j) {
            key = key + this.getDataValue(i, j).getRawValue() + ";";
        }
        return new ResultSetKey(this, i, key);
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    protected void setLocale(Locale locale) {
        this.m_locale = locale;
    }
}

