/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset;

import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.resultset.MetadataItem;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetDataValue;
import com.cognos.asv.resultset.ResultSetDelegate;
import com.cognos.asv.resultset.ResultSetKey;
import com.cognos.asv.resultset.ResultSetParser;
import com.cognos.asv.resultset.ResultSetTopic;
import com.cognos.asv.resultset.ResultSetXML;
import com.cognos.developer.schemas.bibus._3.BaseParameter;
import com.cognos.developer.schemas.bibus._3.Parameter;
import com.cognos.developer.schemas.bibus._3.ParameterDataTypeEnum;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

public class ResultSetTaskParameters
extends ResultSetDelegate {
    private HashMap m_promptMetadata = new HashMap();
    private HashMap m_totalMetadata = new HashMap();

    public ResultSetTaskParameters(ResultSet rs, BaseParameter[] params) {
        super(rs);
        this.populateMetaData(params);
    }

    @Override
    public int numQueryItems() {
        return this.m_totalMetadata.size();
    }

    @Override
    public Iterator getMetadata() {
        return this.m_totalMetadata.values().iterator();
    }

    @Override
    public ResultSetDataValue getDataValue(ResultSetKey key, ResultSetTopic topic) {
        ResultSetDataValue value = null;
        if (this.m_promptMetadata.containsKey(topic.name())) {
            value = this.getMetaValue(topic, key);
        } else if (this.m_totalMetadata.containsKey(topic.name())) {
            value = super.getDataValue(key, topic);
        } else {
            throw new IllegalStateException(I18NUtil.getMessage((I18NCode)AsvI18NCode.MSG_AGS_UNKNOWN_TOPIC, (Object[])new Object[]{topic.name()}, (Locale)Locale.getDefault()));
        }
        return value;
    }

    public static ResultSetTaskParameters makeTestresultSet() {
        String data = "<root><dataset xmlns:rsext='xalan://com.cognos.reportserver.ext.RSExt' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:xs='http://www.w3.org/2001/XMLSchema-instance' xmlns:bus='http://developer.cognos.com/schemas/bibus/3/' version='1.0'><metadata><item name='au_fname' type='xsdString'/><item name='au_lname' type='xsdString'/></metadata><data><row><value rawValue='Michel' presentationValue='Michel'/><value rawValue='DeFrance' presentationValue='DeFrance'/></row><row><value rawValue='Innes' presentationValue='Innes'/><value rawValue='del Castillo' presentationValue='del Castillo'/></row><row><value rawValue='Ann' presentationValue='Ann'/><value rawValue='Dull' presentationValue='Dull'/></row></data><drills/></dataset></root>";
        ResultSetParser parser = new ResultSetParser(Locale.getDefault());
        ByteArrayInputStream sis = new ByteArrayInputStream(data.getBytes());
        ResultSetXML rs = parser.parse(sis);
        Parameter param = new Parameter();
        param.setName("test parameter");
        param.setType(ParameterDataTypeEnum.xsdString);
        BaseParameter[] params = new BaseParameter[]{param};
        ResultSetTaskParameters rstp = new ResultSetTaskParameters(rs, params);
        return rstp;
    }

    private ResultSetDataValue getMetaValue(ResultSetTopic topic, ResultSetKey key) {
        ResultSetDataValue value = null;
        String type = ObjectModelUtil.getPromptType((String)((MetadataItem)this.m_totalMetadata.get(topic.name())).type(), (String)topic.name());
        value = new ResultSetDataValue(type, type);
        value.setPrompting(true);
        return value;
    }

    private void populateMetaData(BaseParameter[] params) {
        Iterator iterator = super.getMetadata();
        while (iterator.hasNext()) {
            MetadataItem element = (MetadataItem)iterator.next();
            if (element.name().equals(ResultSet.STATUS_TOPIC.name())) continue;
            this.m_totalMetadata.put(element.name(), element);
        }
        for (int i = 0; i < params.length; ++i) {
            this.m_totalMetadata.put(params[i].getName(), new MetadataItem(params[i].getName(), params[i].getType().getValue(), "50"));
            this.m_promptMetadata.put(params[i].getName(), new MetadataItem(params[i].getName(), params[i].getType().getValue(), "50"));
        }
    }

    @Override
    public MetadataItem getMetadataValue(ResultSetTopic topic) {
        return (MetadataItem)this.m_totalMetadata.get(topic.name());
    }
}

