/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset;

import com.cognos.asv.resultset.MetadataItem;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetDataValue;
import com.cognos.asv.resultset.ResultSetKey;
import com.cognos.jsmcommon.util.XMLUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ResultSetToRawRS {
    private ResultSet m_rs;
    private boolean m_do_prompting;
    private HashMap m_userData;

    public ResultSetToRawRS(ResultSet rs) {
        this(rs, false);
    }

    public ResultSetToRawRS(ResultSet rs, boolean prompt, HashMap userData) {
        this.m_rs = rs;
        this.m_do_prompting = prompt;
        this.m_userData = userData;
    }

    public ResultSetToRawRS(ResultSet rs, boolean prompt) {
        this(rs, prompt, null);
    }

    public void convert(Writer writer) throws IOException {
        MetadataItem metadataItem;
        writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.write("<Document>");
        writer.write("<META-DATA>");
        Iterator metadataIt = this.m_rs.getMetadata();
        while (metadataIt.hasNext()) {
            metadataItem = (MetadataItem)metadataIt.next();
            writer.write("<DA");
            writer.write(" refItem=\"" + metadataItem.name() + "\" type=\"\" idGroup=\"\"");
            writer.write("/>\n");
        }
        writer.write("</META-DATA>");
        writer.write("<DATA>");
        writer.write("<PAGE name=\"Page1\" resetPageCount=\"false\" resetPageNumber=\"false\" layoutClass=\"page\" generateRepromptButton=\"" + String.valueOf(this.m_do_prompting) + "\">");
        writer.write("<FORM resetPageCount=\"false\" resetPageNumber=\"false\" layoutClass=\"pageHeader\"/>");
        writer.write("<FORM resetPageCount=\"false\" resetPageNumber=\"false\" layoutClass=\"pageBody\" defaultPromptControl=\"true\">");
        writer.write("<LIST cellHeightBehavior=\"minimal\" keepWithFooter=\"false\" keepWithHeader=\"false\" keepWithNext=\"false\" keepWithPrevious=\"false\" pageBreak=\"false\" refQuery=\"Query1\" repeatEveryPage=\"false\" resetPageCount=\"false\" resetPageNumber=\"false\" showColumnTitles=\"startOfList\" style=\"border-collapse:collapse\" layoutClass=\"list\">");
        writer.write("<MR>");
        writer.write("<MRI/>");
        writer.write("</MR>");
        writer.write("<DR layoutClass=\"listColumnTitles\">");
        metadataIt = this.m_rs.getMetadata();
        while (metadataIt.hasNext()) {
            metadataItem = (MetadataItem)metadataIt.next();
            writer.write("<DRI _areaType=\"detail\" keepTogether=\"false\" showContinuation=\"false\" layoutClass=\"listColumnTitle\">");
            writer.write("<OTI _areaType=\"detail\" content=\"label\" keepTogether=\"false\" keepWithNext=\"false\" keepWithPrevious=\"false\" pageBreak=\"false\" queryItemRef=\"true\" refItem=\"" + metadataItem.name() + "\" repeatEveryPage=\"false\" resetPageCount=\"false\" resetPageNumber=\"false\" showContinuation=\"false\" layoutClass=\"textItem\">" + metadataItem.name() + "</OTI>");
            writer.write("</DRI>");
        }
        writer.write("</DR>");
        Iterator keysetIt = this.m_rs.getData();
        while (keysetIt.hasNext()) {
            ResultSetKey key = (ResultSetKey)keysetIt.next();
            writer.write("<DR layoutClass=\"listColumns\">\n");
            Iterator topicNameIt = this.m_rs.getMetadata();
            while (topicNameIt.hasNext()) {
                MetadataItem metadataItem2 = (MetadataItem)topicNameIt.next();
                ResultSetDataValue value = this.m_rs.getDataValue(key, metadataItem2.makeTopic());
                writer.write("<DRI _areaType=\"detail\" keepTogether=\"false\" showContinuation=\"false\" layoutClass=\"listColumnBody\">");
                if (this.m_do_prompting && value.isPrompting()) {
                    writer.write("<OTI _areaType=\"detail\" content=\"value\" idUsage=\"true\" keepTogether=\"false\" keepWithNext=\"false\" keepWithPrevious=\"false\" pageBreak=\"false\" queryItemRef=\"true\" refItem=\"" + metadataItem2.name() + "\" repeatEveryPage=\"false\" resetPageCount=\"false\" resetPageNumber=\"false\" showContinuation=\"false\" layoutClass=\"block\">" + value.getPresentationValue() + "</OTI>");
                } else {
                    writer.write("<OTI _areaType=\"detail\" content=\"value\" idUsage=\"true\" keepTogether=\"false\" keepWithNext=\"false\" keepWithPrevious=\"false\" pageBreak=\"false\" queryItemRef=\"true\" refItem=\"" + metadataItem2.name() + "\" repeatEveryPage=\"false\" resetPageCount=\"false\" resetPageNumber=\"false\" showContinuation=\"false\" layoutClass=\"textItem\">" + value.getPresentationValue() + "</OTI>");
                }
                writer.write("</DRI>");
            }
            writer.write("</DR>\n");
        }
        if (this.m_do_prompting) {
            writer.write("<OTD defaultPromptFooter=\"true\" layoutClass=\"pageFooter\" />");
        }
        writer.write("</LIST>");
        writer.write("</FORM>");
        writer.write("<FORM resetPageCount=\"false\" resetPageNumber=\"false\" layoutClass=\"pageFooter\" defaultPromptControl=\"true\"/>");
        writer.write("</PAGE>");
        writer.write("</DATA>");
        if (this.m_userData != null && this.m_userData.size() > 0) {
            writer.write("<optionList>");
            Map.Entry[] entries = this.m_userData.entrySet().toArray(new Map.Entry[0]);
            for (int i = 0; i < entries.length; ++i) {
                writer.write("<userData name=\"" + entries[i].getKey() + "\" value=\"" + XMLUtils.escapeOnce((String)entries[i].getValue().toString()) + "\"/>");
            }
            writer.write("</optionList>");
        }
        writer.write("<styleOptions>");
        writer.write("<cssUrl>../cr1/default_layout.css</cssUrl>");
        writer.write("</styleOptions>");
        writer.write("<productLocale>en</productLocale>");
        writer.write("<runLocale>en-gb</runLocale>");
        writer.write("</Document>");
    }
}

