/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset;

import com.cognos.asv.resultset.MetadataItem;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetKey;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

public class ResultSetToXML {
    private ResultSet m_rs;

    public ResultSetToXML(ResultSet rs) {
        this.m_rs = rs;
    }

    public void convert(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        writer.write("<dataset xmlns=\"http://developer.cognos.com/schemas/xmldata/1/\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\">\n");
        writer.write("<!-- \n");
        writer.write("<dataset\n");
        writer.write("  xmlns=\"http://developer.cognos.com/schemas/xmldata/1/\"\n");
        writer.write("\txmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        writer.write("\txs:schemaLocation=\"http://developer.cognos.com/schemas/xmldata/1/ xmldata.xsd\">\n");
        writer.write("  -->\n");
        writer.write("<metadata>\n");
        Iterator metadataIt = this.m_rs.getMetadata();
        while (metadataIt.hasNext()) {
            MetadataItem metadataItem = (MetadataItem)metadataIt.next();
            writer.write("<item");
            writer.write(" name=\"" + metadataItem.name() + "\"");
            writer.write(" type=\"" + metadataItem.type() + "\"");
            if (metadataItem.length() != null) {
                writer.write(" length=\"" + metadataItem.length() + "\"");
            }
            writer.write("/>\n");
        }
        writer.write("</metadata>\n");
        writer.write("<data>\n");
        Iterator keysetIt = this.m_rs.getData();
        while (keysetIt.hasNext()) {
            ResultSetKey key = (ResultSetKey)keysetIt.next();
            writer.write("<row>\n");
            Iterator topicNameIt = this.m_rs.getMetadata();
            while (topicNameIt.hasNext()) {
                MetadataItem metadataItem = (MetadataItem)topicNameIt.next();
                writer.write("<value>");
                writer.write(this.m_rs.getDataValue(key, metadataItem.makeTopic()).getTopicValue());
                writer.write("</value>\n");
            }
            writer.write("</row>\n");
        }
        writer.write("</data>\n");
        writer.write("</dataset>\n");
    }
}

