/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset;

import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetKey;
import com.cognos.asv.resultset.ResultSetLineBuilder;
import com.cognos.asv.resultset.ResultSetPartition;
import com.cognos.asv.resultset.ResultSetPartitionIterator;
import com.cognos.asv.resultset.ResultSetTypeEnum;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class ResultSetTopicPartition
extends ResultSetPartitionIterator {
    private ResultSetPartitionIterator m_parent;
    private ResultSet m_rs;
    private String m_topicLine;
    private LinkedHashMap m_partitions = new LinkedHashMap();
    private Iterator m_it;
    private ResultSetPartition m_partition;

    public ResultSetTopicPartition(ResultSetPartitionIterator parent, ResultSet rs, String topicLine) {
        this.m_parent = parent;
        this.m_rs = rs;
        this.m_topicLine = topicLine;
    }

    @Override
    public boolean hasNext() {
        boolean ret_value = false;
        if (this.m_it != null) {
            ret_value = this.m_it.hasNext();
            if (!ret_value) {
                ret_value = this.m_parent.hasNext();
            }
        } else {
            ret_value = this.m_parent.hasNext();
        }
        return ret_value;
    }

    @Override
    public void next() {
        if (this.m_it != null && this.m_it.hasNext()) {
            String descriptor = (String)this.m_it.next();
            Collection keys = (Collection)this.m_partitions.get(descriptor);
            this.m_partition = new ResultSetPartition(this.m_rs, descriptor, keys);
        } else {
            this.m_parent.next();
            ResultSetPartition partition = this.m_parent.partition();
            this.process(partition);
            this.next();
        }
    }

    @Override
    public ResultSetPartition partition() {
        return this.m_partition;
    }

    private void process(ResultSetPartition partition) {
        this.m_partitions.clear();
        ResultSetLineBuilder lineBuilder = new ResultSetLineBuilder(this.m_rs, ResultSetTypeEnum.HTML, this.m_topicLine);
        if (lineBuilder.getLinePieces().isConstant()) {
            this.m_partitions.put(this.m_topicLine, partition.asCollection(new LinkedList()));
        } else {
            Collection keys = partition.keys();
            for (ResultSetKey key : keys) {
                List<ResultSetKey> partitionKeyList;
                String line = lineBuilder.buildLine(key);
                if (this.m_partitions.containsKey(line)) {
                    partitionKeyList = (List)this.m_partitions.get(line);
                    partitionKeyList.add(key);
                    continue;
                }
                partitionKeyList = new LinkedList<ResultSetKey>();
                partitionKeyList.add(key);
                this.m_partitions.put(line, partitionKeyList);
            }
        }
        this.m_it = this.m_partitions.keySet().iterator();
    }
}

