/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset;

import com.cognos.asv.resultset.MetadataItem;
import com.cognos.asv.resultset.ResultSetDataValue;
import com.cognos.asv.resultset.ResultSetKey;
import com.cognos.asv.resultset.ResultSetTable;
import com.cognos.asv.resultset.ResultSetTopic;
import com.cognos.asv.resultset.ResultSetTypeEnum;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

public class ResultSetXML
extends ResultSetTable {
    public ResultSetXML(Locale request_locale) {
        this.setLocale(request_locale);
    }

    public void addMetadataItem(String name, String type, String length) {
        this.addMetadataItem(name, type, length, null);
    }

    public void addMetadataItem(String name, String type, String length, String mun) {
        MetadataItem mdi = new MetadataItem(name, type, length, mun);
        this.m_metadata.add(mdi);
        this.m_metadata_keys.put(name, new Integer(this.m_metadata.size() - 1));
    }

    public void addRow() {
        this.m_rows.add(new ArrayList());
    }

    public void addValue(String value) {
        ((ArrayList)this.m_rows.get(this.m_rows.size() - 1)).add(new ResultSetDataValue(value, value));
    }

    public void addValue(ResultSetDataValue resultSetDataValue) {
        ((ArrayList)this.m_rows.get(this.m_rows.size() - 1)).add(resultSetDataValue);
    }

    @Override
    public Iterator getMetadata() {
        return this.m_metadata.iterator();
    }

    public String getTopicValue(ResultSetKey key, ResultSetTopic topic) {
        if (topic.equals(KEY_TOPIC)) {
            return key.getKey();
        }
        ResultSetDataValue rsdv = this.getDataValue(key.getRowNumber(), topic);
        if (rsdv.isNull()) {
            return rsdv.getNullMessage(this.getLocale());
        }
        return rsdv.getRawValue();
    }

    public String getTopicValue(ResultSetKey key, ResultSetTopic topic, ResultSetTypeEnum type) {
        if (topic.equals(KEY_TOPIC)) {
            return key.getKey();
        }
        ResultSetDataValue rsdv = this.getDataValue(key.getRowNumber(), topic);
        if (rsdv.isNull()) {
            return rsdv.getNullMessage(this.getLocale());
        }
        if (type.equals(ResultSetTypeEnum.HTML)) {
            return rsdv.getPresentationValue();
        }
        return rsdv.getRawValue();
    }

    @Override
    public ResultSetDataValue getDataValue(ResultSetKey key, ResultSetTopic topic) {
        if (topic.equals(KEY_TOPIC)) {
            return new ResultSetDataValue(key.getKey(), key.getKey());
        }
        ResultSetDataValue value = this.getDataValue(key.getRowNumber(), topic);
        value.setLocale(this.getLocale());
        return value;
    }
}

