/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.resultset.linepieces;

import java.util.regex.Pattern;

public final class NCElementType {
    public static final NCElementType TOPIC_START = new NCElementType(0, "Topic Start", "\\[", "[");
    public static final NCElementType TOPIC_END = new NCElementType(1, "topic end", "\\]", "]");
    public static final NCElementType PREVIOUS_START = new NCElementType(2, "previous start", "previous\\(", "previous(");
    public static final NCElementType FUNCTION_END = new NCElementType(3, "previous end", "\\)", ")");
    public static final NCElementType TEXT = new NCElementType(4, "text");
    public static final NCElementType ESCAPED_TOPIC_START = new NCElementType(5, "escaped topic start", "\\\\\\[", "\\[");
    public static final NCElementType ESCAPED_TOPIC_END = new NCElementType(6, "escaped topic end", "\\\\]", "\\]");
    public static final NCElementType DOUBLE_TOPIC_END = new NCElementType(7, "double topic end", "\\]\\]", "]]");
    public static final NCElementType CAPTION_START = new NCElementType(8, "caption start", "caption\\(", "caption(");
    private int m_type;
    private String m_name;
    private String m_text;
    private Pattern m_pattern;

    private NCElementType(int type, String name, String patternString, String text) {
        this.m_type = type;
        this.m_name = name;
        this.m_text = text;
        this.m_pattern = Pattern.compile(patternString, 2);
    }

    private NCElementType(int type, String name) {
        this.m_type = type;
        this.m_name = name;
        this.m_text = "";
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj != null && obj instanceof NCElementType) {
            NCElementType theOther = (NCElementType)obj;
            result = this.m_type == theOther.m_type;
        }
        return result;
    }

    public Pattern getPattern() {
        return this.m_pattern;
    }

    public String getText() {
        return this.m_text;
    }

    public int hashCode() {
        return this.m_type;
    }

    public String toString() {
        return this.m_name;
    }
}

