/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.streams;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class StringByteArrayInputStream
extends InputStream {
    private String m_encoding;
    private String m_source;
    private static final int M_BLOCK_SIZE = 10240;
    private int m_block_pos = -1;
    private byte[] m_byte_buffer;
    private int m_buffer_pos = -1;

    public StringByteArrayInputStream(String source, String encoding) {
        this.m_source = source;
        this.m_encoding = encoding;
    }

    @Override
    public int read() throws IOException {
        if (this.m_buffer_pos == -1 || this.m_buffer_pos == this.m_byte_buffer.length) {
            this.fillBuffer();
        }
        if (this.m_buffer_pos == -1) {
            return -1;
        }
        return this.m_byte_buffer[this.m_buffer_pos++];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.m_buffer_pos == -1 || this.m_buffer_pos == this.m_byte_buffer.length) {
            this.fillBuffer();
        }
        if (this.m_buffer_pos == -1) {
            return -1;
        }
        int length = Math.min(len, this.m_byte_buffer.length - this.m_buffer_pos);
        System.arraycopy(this.m_byte_buffer, this.m_buffer_pos, b, off, length);
        this.m_buffer_pos += length;
        return length;
    }

    private void fillBuffer() {
        ++this.m_block_pos;
        if (this.m_block_pos * 10240 >= this.m_source.length()) {
            this.m_buffer_pos = -1;
            return;
        }
        int start_pos = this.m_block_pos * 10240;
        int num_chars = Math.min(10240, this.m_source.length() - start_pos);
        String subString = this.m_source.substring(start_pos, start_pos + num_chars);
        try {
            this.m_byte_buffer = subString.getBytes(this.m_encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Illegal encoding " + e.getMessage());
        }
        this.m_buffer_pos = 0;
    }
}

