/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets;

import com.cognos.asv.AgentServiceException;
import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.IAGSWSDLConstants;
import com.cognos.asv.PreviewResultHandler;
import com.cognos.asv.ResolveOptionsUtil;
import com.cognos.asv.TaskRun;
import com.cognos.asv.TaskRunInfo;
import com.cognos.asv.actions.AgentAction;
import com.cognos.asv.actions.QueueBurstAgentAction;
import com.cognos.asv.i18n.AgsI18NCode;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.resultset.ResultSet;
import com.cognos.asv.resultset.ResultSetIgnoreIllegalTopics;
import com.cognos.asv.resultset.ResultSetNoEvents;
import com.cognos.asv.resultset.ResultSetPartition;
import com.cognos.asv.resultset.ResultSetPartitionIterator;
import com.cognos.asv.resultset.ResultSetSinglePartition;
import com.cognos.asv.resultset.ResultSetTopicPartition;
import com.cognos.asv.taskTargets.humanTask.HumanTaskBuilder;
import com.cognos.asv.taskTargets.humanTask.HumanTaskRunnable;
import com.cognos.asv.xhtml.descriptors.TaskRunDescriptor;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseParameter;
import com.cognos.developer.schemas.bibus._3.HumanTask;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.run.commands.CmdSpec;
import com.cognos.jsmcommon.tse.run.commands.SetTaskStateCmdSpec;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;

public class AgentHumanTaskTarget
extends BaseAgentTaskTarget
implements IAGSWSDLConstants {
    private TaskRunDescriptor.TASK_TYPE taskType;

    AgentHumanTaskTarget() {
        super(null, null, null);
    }

    public AgentHumanTaskTarget(HumanTask humanTask, BaseStepObject jobStep, JobBiBusHeaders headers) {
        super((BaseClass)humanTask, jobStep, headers);
    }

    private HumanTask getBaseHumanTask() {
        return (HumanTask)this.getBaseClass();
    }

    @Override
    public ParameterValue[] getParameters() {
        return this.getBaseHumanTask().getParameters() != null ? this.getBaseHumanTask().getParameters().getValue() : null;
    }

    @Override
    public Option[] getOptions() {
        return this.getBaseHumanTask().getOptions() != null ? this.getBaseHumanTask().getOptions().getValue() : null;
    }

    @Override
    public void validate(ValidationResultHandler validateResult) throws AgentServiceException {
        if (this.isCancelled()) {
            this.setStatus(EventStatus.CANCELLED);
            return;
        }
        HumanTaskBuilder humanTaskBuilder = new HumanTaskBuilder(this.getParameters(), this.getHeaders(), this.getParent(), this.getStoreID(), true);
        humanTaskBuilder.parse();
        this.taskType = humanTaskBuilder.getType();
        ResultSetTopicPartition topicPartition = this.buildResultSetTopicPartition(humanTaskBuilder, false);
        ArrayList taskRuns = this.buildMultipleTaskRuns(humanTaskBuilder, topicPartition);
        Iterator it = taskRuns.iterator();
        if ("parallel".equals(this.getBaseAgent().getSequencing()) && humanTaskBuilder.getTaskCount() > 1) {
            validateResult.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_INVALID_SEQUENCING, new Object[0], SeverityEnum.error));
        }
        while (it.hasNext()) {
            try {
                Object obj = it.next();
                if (obj instanceof Exception) {
                    throw (Exception)obj;
                }
                if (!(obj instanceof TaskRunInfo)) continue;
                TaskRunInfo taskRun = (TaskRunInfo)obj;
                HumanTaskRunnable runnable = new HumanTaskRunnable((HumanTask)this.getBaseClass(), null, this.getHeaders());
                runnable.setSubmitOptions(taskRun.options());
                runnable.setSubmitParameters(taskRun.parameters());
                runnable.validate(validateResult);
            }
            catch (LocalizableException e) {
                validateResult.addValidationMessage(new I18NMessage(e.getI18NCode(), e.getParams(), SeverityEnum.warn));
            }
            catch (Throwable t) {
                validateResult.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_VALIDATION_FAIL, new Object[]{t.getLocalizedMessage()}, SeverityEnum.error));
            }
        }
    }

    @Override
    public void preview(PreviewResultHandler previewResult) throws AgentServiceException {
        if (this.isCancelled()) {
            this.setStatus(EventStatus.CANCELLED);
            return;
        }
        HumanTaskBuilder humanTaskBuilder = new HumanTaskBuilder(this.getParameters(), this.getHeaders(), this.getParent(), this.getStoreID(), true);
        humanTaskBuilder.parse();
        this.taskType = humanTaskBuilder.getType();
        ResultSetTopicPartition finalPartition = this.buildResultSetTopicPartition(humanTaskBuilder, true);
        ArrayList taskBuilds = this.buildMultipleTaskRuns(humanTaskBuilder, finalPartition);
        ArrayList<TaskRunInfo> taskRuns = new ArrayList<TaskRunInfo>();
        Iterator it = taskBuilds.iterator();
        while (it.hasNext()) {
            try {
                Object obj = it.next();
                if (obj instanceof Exception) {
                    throw (Exception)obj;
                }
                if (!(obj instanceof TaskRunInfo)) continue;
                TaskRunInfo taskRun = (TaskRunInfo)obj;
                taskRuns.add(taskRun);
            }
            catch (LocalizableException e) {
                previewResult.addTaskRun(new TaskRun((BaseStepObject)this, true));
                this.setStatus(EventStatus.FAILED);
                AgentServiceException ase = e instanceof AgentServiceException ? (AgentServiceException)e : new AgentServiceException(e);
                throw ase;
            }
            catch (Throwable e) {
                previewResult.addTaskRun(new TaskRun((BaseStepObject)this, true));
                this.setStatus(EventStatus.FAILED);
                String msg = "[" + e.getClass().getName() + "] " + e.getLocalizedMessage();
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{msg}, e);
            }
        }
        previewResult.addTaskRun(new TaskRun((BaseStepObject)this, taskRuns.toArray(new TaskRunInfo[0])));
    }

    @Override
    public void run(AgentAction action) throws AgentServiceException {
        if (this.isCancelled()) {
            this.setStatus(EventStatus.CANCELLED);
            return;
        }
        HumanTaskBuilder humanTaskBuilder = new HumanTaskBuilder(this.getParameters(), this.getHeaders(), this.getParent(), this.getStoreID(), false);
        humanTaskBuilder.parse();
        this.taskType = humanTaskBuilder.getType();
        Boolean bursting = (Boolean)action.getProperty("BURST_FLAG");
        if (bursting != null && bursting.booleanValue()) {
            this.runOneRow(action, humanTaskBuilder);
        } else {
            this.runBurst(action, humanTaskBuilder);
        }
    }

    private void runBurst(AgentAction action, HumanTaskBuilder humanTaskBuilder) throws AgentServiceException {
        ResultSetTopicPartition topicPartition = this.buildResultSetTopicPartition(humanTaskBuilder, true);
        QueueBurstAgentAction burstAction = new QueueBurstAgentAction(action, this);
        burstAction.queueAgentTasks(topicPartition);
    }

    private void runOneRow(AgentAction action, HumanTaskBuilder humanTaskBuilder) throws AgentServiceException {
        ArrayList taskRuns = this.buildSingleTaskRunFromPartition(humanTaskBuilder);
        this.addTSECommandSpecs(humanTaskBuilder);
        Iterator it = taskRuns.iterator();
        while (it.hasNext()) {
            try {
                Object obj = it.next();
                if (obj instanceof Exception) {
                    throw (Exception)obj;
                }
                if (!(obj instanceof TaskRunInfo)) continue;
                TaskRunInfo taskRun = (TaskRunInfo)obj;
                action.runAgentTaskTarget(Client.ServiceEnum.MONITOR_SERVICE, this.getSearchPath(), taskRun.parameters(), taskRun.options());
            }
            catch (LocalizableException e) {
                this.setStatus(EventStatus.FAILED);
                AgentServiceException ase = e instanceof AgentServiceException ? (AgentServiceException)e : new AgentServiceException(e);
                throw ase;
            }
            catch (Throwable e) {
                this.setStatus(EventStatus.FAILED);
                String msg = "[" + e.getClass().getName() + "] " + e.getLocalizedMessage();
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{msg}, e);
            }
        }
    }

    private boolean isBursting(HumanTaskBuilder humanTaskBuilder) throws AgentServiceException {
        ResultSet rs = this.getResultSet();
        return !(rs instanceof ResultSetPartition);
    }

    @Override
    protected BaseParameter[] getTargetParametersImpl(ParameterValue[] connectionParameters) throws AgentServiceException {
        return AgentHumanTaskTarget.getHumanTaskParameters(this.getBaseHumanTask());
    }

    static BaseParameter[] getHumanTaskParameters(HumanTask wtask) throws AgentServiceException {
        return new BaseParameter[0];
    }

    private ArrayList buildSingleTaskRunFromPartition(HumanTaskBuilder humanTaskBuilder) throws AgentServiceException {
        ArrayList<Object> taskRuns = new ArrayList<Object>();
        try {
            ResultSet rs = this.getResultSet();
            if (!(rs instanceof ResultSetPartition)) {
                ResultSetSinglePartition singlePartition = new ResultSetSinglePartition(rs);
                ((ResultSetPartitionIterator)singlePartition).next();
                rs = ((ResultSetPartitionIterator)singlePartition).partition();
            }
            humanTaskBuilder.setPartition((ResultSetPartition)rs);
            ParameterValue[] parameters = humanTaskBuilder.getParameters();
            taskRuns.add(new TaskRunInfo(ResolveOptionsUtil.resolveOptions(this), parameters));
        }
        catch (Throwable e) {
            taskRuns.add(e);
        }
        return taskRuns;
    }

    private ArrayList buildMultipleTaskRuns(HumanTaskBuilder humanTaskBuilder, ResultSetTopicPartition finalPartition) {
        ArrayList<Object> taskRuns = new ArrayList<Object>();
        try {
            while (null != finalPartition && finalPartition.hasNext()) {
                finalPartition.next();
                ResultSetPartition partition = finalPartition.partition();
                humanTaskBuilder.setPartition(partition);
                ParameterValue[] parameters = humanTaskBuilder.getParameters();
                taskRuns.add(new TaskRunInfo(ResolveOptionsUtil.resolveOptions(this), parameters));
            }
        }
        catch (Exception e) {
            taskRuns.add(e);
        }
        return taskRuns;
    }

    private void addTSECommandSpecs(HumanTaskBuilder humanTaskBuilder) {
        CmdSpec[] cmdSpec = humanTaskBuilder.getReportVariables();
        if (cmdSpec.length > 0 && !this.SaveReportPathCmdExistsForTaskID()) {
            this.addTseCommands(humanTaskBuilder.getReportVariables());
        }
        if (this.getBaseAgent().parentTaskIDExists()) {
            this.addTseCommands(new CmdSpec[]{new SetTaskStateCmdSpec(this.getBaseAgent().getParentTaskID())});
        }
    }

    private ResultSetTopicPartition buildResultSetTopicPartition(HumanTaskBuilder humanTaskBuilder, boolean ignoreIllegalTopics) throws AgentServiceException {
        ResultSetTopicPartition priorityFilter;
        ResultSet rs = this.getResultSet();
        if (rs.isEmpty()) {
            Locale locale = LocaleUtil.getLocale((String)this.getHeaders().getUserPreferenceContentLocale());
            String defaultValue = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_NO_DATA, null, (Locale)LocaleUtil.createContentLocale((String)locale.toString()));
            rs = ResultSetNoEvents.getResultSet(rs, locale, defaultValue);
        }
        if (ignoreIllegalTopics) {
            rs = new ResultSetIgnoreIllegalTopics(rs);
        }
        ResultSetSinglePartition singlePartition = new ResultSetSinglePartition(rs);
        String recipientString = humanTaskBuilder.getUserTopics();
        ResultSetTopicPartition recipientFilter = new ResultSetTopicPartition(singlePartition, rs, recipientString);
        String subjectString = humanTaskBuilder.getSubjectTopics();
        ResultSetTopicPartition subjectFilter = new ResultSetTopicPartition(recipientFilter, rs, subjectString);
        String priorityString = humanTaskBuilder.getPriorityTopics();
        ResultSetTopicPartition finalPartition = priorityFilter = new ResultSetTopicPartition(subjectFilter, rs, priorityString);
        return finalPartition;
    }

    @Override
    public SeverityEnum getMaximumValidationSeverity() {
        return SeverityEnum.error;
    }

    @Override
    public void onStepFailed(AgentAction action) throws AgentServiceException {
        if (this.getTaskType() == TaskRunDescriptor.TASK_TYPE.APPROVAL) {
            while (action.getCurrentAgentTaskIterator().hasNext()) {
                action.getCurrentAgentTaskIterator().next();
            }
        }
    }

    public TaskRunDescriptor.TASK_TYPE getTaskType() throws AgentServiceException {
        if (this.taskType == null) {
            HumanTaskBuilder humanTaskBuilder = new HumanTaskBuilder(this.getParameters(), this.getHeaders(), this.getParent(), this.getStoreID(), false);
            humanTaskBuilder.parse();
            this.taskType = humanTaskBuilder.getType();
        }
        return this.taskType;
    }
}

