/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.ResolveOptionsUtil;
import com.cognos.asv.ResolveParametersUtil;
import com.cognos.asv.actions.AgentAction;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailParameters;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportStatus;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionInt;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseParameter;
import com.cognos.developer.schemas.bibus._3.BaseReport;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.developer.schemas.bibus._3.FormFieldVar;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.InteractiveReport;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ReportView;
import com.cognos.developer.schemas.bibus._3.RoutingInfo;
import com.cognos.developer.schemas.bibus._3.RunOptionBoolean;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.RunOptionSaveAs;
import com.cognos.developer.schemas.bibus._3.RunOptionStringArray;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.jsmcommon.api.SDSServiceException;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.event.EventStatusUtil;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.BatchReportServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class AgentReportTarget
extends BaseAgentTaskTarget {
    public AgentReportTarget(BaseReport report, BaseStepObject jobStep, JobBiBusHeaders headers) {
        super((BaseClass)report, jobStep, headers);
    }

    private BaseReport getBaseReport() {
        return (BaseReport)this.getBaseClass();
    }

    @Override
    public ParameterValue[] getParameters() {
        return this.getBaseReport().getParameters() != null ? this.getBaseReport().getParameters().getValue() : null;
    }

    @Override
    public Option[] getOptions() {
        return null;
    }

    @Override
    public void run(AgentAction action) throws AgentServiceException {
        try {
            if (this.isCancelled()) {
                this.setStatus(EventStatus.CANCELLED);
                return;
            }
            Option[] options = ResolveOptionsUtil.resolveOptions(this);
            ParameterValue[] parameters = new ParameterValue[]{};
            try {
                parameters = ResolveParametersUtil.resolveParameters(this);
                parameters = ResolveParametersUtil.trimToTargetParams(parameters, this, this.getResultSet());
            }
            catch (AgentServiceException agentServiceException) {
                // empty catch block
            }
            if (this.isCancelled()) {
                return;
            }
            AsynchReply reply = null;
            boolean isEmailRequired = this.isEmailRequired(options);
            if (isEmailRequired) {
                options = this.preprocessRunOptions(options);
            }
            if ((reply = action.runAgentTaskTarget(Client.ServiceEnum.MONITOR_SERVICE, this.getSearchPath(), parameters, options)) != null) {
                AsynchReplyStatusEnum replyStatus = reply.getStatus();
                this.setStatus(EventStatusUtil.getEventStatus((AsynchReplyStatusEnum)replyStatus));
            }
        }
        catch (Throwable e) {
            String msg = "[" + e.getClass().getName() + "] " + e.getLocalizedMessage();
            this.setStatus(EventStatus.FAILED);
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{msg}, e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Option[] preprocessRunOptions(Option[] options) {
        ArrayList<Object> optionsList = null;
        optionsList = options != null ? new ArrayList<Option>(Arrays.asList(options)) : new ArrayList();
        boolean hasSaveAsOption = false;
        boolean hasSaveOutputOption = false;
        boolean emailAsAttachment = false;
        RunOptionStringArray outputFormatRunOption = null;
        for (Option option : optionsList) {
            RunOptionStringArray rosaTemp;
            if (option instanceof RunOptionSaveAs) {
                hasSaveAsOption = true;
                continue;
            }
            if (option instanceof RunOptionBoolean) {
                RunOptionBoolean rob = (RunOptionBoolean)option;
                if (rob.getName().equals((Object)RunOptionEnum.saveOutput)) {
                    hasSaveOutputOption = rob.isValue();
                }
                if (!rob.getName().equals((Object)RunOptionEnum.emailAsAttachment)) continue;
                emailAsAttachment = rob.isValue();
                continue;
            }
            if (!(option instanceof RunOptionStringArray) || !(rosaTemp = (RunOptionStringArray)option).getName().equals((Object)RunOptionEnum.outputFormat)) continue;
            outputFormatRunOption = rosaTemp;
        }
        if (!hasSaveAsOption && !hasSaveOutputOption) {
            optionsList.add(this.getSaveOutputOption());
        }
        String string = "HTML";
        try {
            String string2 = LocaleUtil.getUserPreference((String)"format", (BiBusHeader)this.getHeaders().getBiBusHeader());
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug("Cannot obtain format. Will Use HTML format.");
        }
        if (outputFormatRunOption == null) {
            void var8_11;
            outputFormatRunOption = new RunOptionStringArray();
            outputFormatRunOption.setName(RunOptionEnum.outputFormat);
            outputFormatRunOption.setValue(new String[]{var8_11});
            optionsList.add(outputFormatRunOption);
        }
        String[] formats = outputFormatRunOption.getValue();
        for (int j = 0; j < formats.length; ++j) {
            if (!formats[j].equals("HTML")) continue;
            if (this.isActiveReport() || this.isActiveReportView()) {
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug("preprocessRunOptions(): Active report / report view, do not add MHT format. ");
                continue;
            }
            if (!hasSaveAsOption && !hasSaveOutputOption) {
                formats[j] = "MHT";
                continue;
            }
            String[] newFormats = new String[formats.length + 1];
            System.arraycopy(formats, 0, newFormats, 0, formats.length);
            newFormats[formats.length] = "MHT";
            outputFormatRunOption.setValue(newFormats);
            if (!emailAsAttachment) continue;
            this.addHeaderFormFieldNoMht();
        }
        return optionsList.toArray(new Option[optionsList.size()]);
    }

    private void addHeaderFormFieldNoMht() {
        BiBusHeader header = this.getHeaders().getBiBusHeader();
        HdrSession hdrSession = header.getHdrSession();
        if (hdrSession != null) {
            FormFieldVar[] formFieldVars = hdrSession.getFormFieldVars();
            if (formFieldVars == null) {
                formFieldVars = new FormFieldVar[1];
            } else {
                FormFieldVar[] formFieldVarsTmp = new FormFieldVar[formFieldVars.length + 1];
                System.arraycopy(formFieldVars, 0, formFieldVarsTmp, 0, formFieldVars.length);
                formFieldVars = formFieldVarsTmp;
            }
            FormFieldVar formFieldVar = new FormFieldVar();
            formFieldVar.setName("_noEmailMHT");
            formFieldVar.setValue("true");
            formFieldVars[formFieldVars.length - 1] = formFieldVar;
            hdrSession.setFormFieldVars(formFieldVars);
        }
    }

    private boolean isEmailRequired(Option[] options) {
        boolean isEmailRequired = this.getBaseAgent().isReportAttached(this.getBaseTask().getSearchPathStoreID());
        return isEmailRequired;
    }

    private Option getSaveOutputOption() {
        RunOptionBoolean saveOutput = new RunOptionBoolean();
        saveOutput.setName(RunOptionEnum.saveOutput);
        saveOutput.setValue(true);
        return saveOutput;
    }

    @Override
    protected BaseParameter[] getTargetParametersImpl(ParameterValue[] connectionParameters) throws AgentServiceException {
        SearchPathSingleObject searchPath = ObjectModelUtil.makeSearPathSingleObject((String)this.getBaseReport().getSearchPath().getValue());
        return AgentReportTarget.getReportParameters(this.getHeaders(), searchPath, connectionParameters);
    }

    static BaseParameter[] getReportParameters(JobBiBusHeaders headers, SearchPathSingleObject spso, ParameterValue[] connectionParams) throws AgentServiceException {
        BaseParameter[] params;
        block9: {
            params = null;
            BiBusHeader header = headers.getBiBusHeader();
            Tracking tracking = header.getTracking();
            tracking.setConversationContext(null);
            header.setTracking(tracking);
            headers.setBiBusHeader(header);
            BatchReportServiceClientPort reportService = Client.instance().getBatchReportServiceClient(headers);
            RoutingInfo routing = headers.getBiBusHeader().getRouting();
            try {
                AsynchDetail[] ad;
                BiBusUtilities.setRoutingServerGroup((SearchPathSingleObject)spso, (JobBiBusHeaders)headers);
                AsynchOptionInt primaryWaitThreshold = new AsynchOptionInt();
                primaryWaitThreshold.setName(AsynchOptionEnum.primaryWaitThreshold);
                primaryWaitThreshold.setValue(3000);
                RunOptionBoolean prompt = new RunOptionBoolean();
                prompt.setName(RunOptionEnum.prompt);
                prompt.setValue(false);
                RunOptionBoolean connectionParameters = new RunOptionBoolean();
                connectionParameters.setName(RunOptionEnum.credentialParameters);
                connectionParameters.setValue(true);
                Option[] options = new Option[]{primaryWaitThreshold, prompt, connectionParameters};
                AsynchReply reply = reportService.getParameters(spso, null, options);
                reply = AgentReportTarget.doWait(reportService, reply);
                AsynchDetailReportStatusEnum status = AgentReportTarget.getReportStatusEnum(reply);
                if (status != null && status.equals((Object)AsynchDetailReportStatusEnum.prompting)) {
                    reply = reportService.forward(reply.getPrimaryRequest(), connectionParams, options);
                    reply = AgentReportTarget.doWait(reportService, reply);
                }
                if (reply == null || !reply.getStatus().equals((Object)AsynchReplyStatusEnum.conversationComplete) && !reply.getStatus().equals((Object)AsynchReplyStatusEnum.complete) || (ad = reply.getDetails()) == null) break block9;
                for (int i = 0; i < ad.length; ++i) {
                    if (!(ad[i] instanceof AsynchDetailParameters)) continue;
                    params = ((AsynchDetailParameters)ad[i]).getParameters();
                    break;
                }
            }
            catch (EMFSecurityException cse) {
                AuditProperties ap = new AuditProperties("Report", "", "AgentService", "Warning");
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.AGENT_CONSTRUCTION_ERROR, (Map)ap);
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug((Throwable)cse);
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{cse.getLocalizedMessage()});
            }
            catch (SDKClientException sdke) {
                AuditProperties ap = new AuditProperties("Report", "", "AgentService", "Warning");
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.AGENT_CONSTRUCTION_ERROR, (Map)ap);
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug((Throwable)sdke);
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{sdke.getLocalizedMessage()});
            }
            catch (SDSServiceException sdse) {
                AuditProperties ap = new AuditProperties("Report", "", "AgentService", "Warning");
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, sdse.getI18NCode(), sdse.getParams(), (Map)ap);
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug((Throwable)sdse);
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{sdse.getLocalizedMessage()});
            }
            finally {
                reportService.close();
                header.setRouting(routing);
            }
        }
        return params;
    }

    private static AsynchReply doWait(BatchReportServiceClientPort reportService, AsynchReply reply) throws SDKClientException, EMFSecurityException {
        while (reply != null && (reply.getStatus().equals((Object)AsynchReplyStatusEnum.working) || reply.getStatus().equals((Object)AsynchReplyStatusEnum.stillWorking))) {
            reply = reportService.wait(reply.getPrimaryRequest(), null, null);
        }
        return reply;
    }

    private static AsynchDetailReportStatusEnum getReportStatusEnum(AsynchReply reply) {
        AsynchDetailReportStatusEnum result = null;
        AsynchDetail[] ad = reply.getDetails();
        if (ad != null) {
            for (int i = 0; i < ad.length; ++i) {
                if (!(ad[i] instanceof AsynchDetailReportStatus)) continue;
                result = ((AsynchDetailReportStatus)ad[i]).getStatus();
                break;
            }
        }
        return result;
    }

    private boolean isActiveReport() {
        boolean isActiveReport = false;
        try {
            if (this.getBaseReport().getObjectClass() != null && ClassEnum.fromValue((String)"interactiveReport").equals((Object)this.getBaseReport().getObjectClass().getValue())) {
                isActiveReport = true;
            }
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug("isActiveReport(): Excepition : " + ex);
        }
        return isActiveReport;
    }

    private boolean isActiveReportView() {
        boolean isActiveReportView = false;
        BaseReport baseReport = null;
        ReportView baseReportView = null;
        try {
            baseReport = this.getBaseReport();
            if (baseReport != null && baseReport instanceof ReportView) {
                baseReportView = (ReportView)baseReport;
                for (BaseClass bc : baseReportView.getBase().getValue()) {
                    if (bc == null || !(bc instanceof InteractiveReport)) continue;
                    isActiveReportView = true;
                }
            }
        }
        catch (Exception ex) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug("isActiveReportView(): Excepition : " + ex);
        }
        return isActiveReportView;
    }
}

