/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.PreviewResultHandler;
import com.cognos.asv.ResolveOptionsUtil;
import com.cognos.asv.ResolveParametersUtil;
import com.cognos.asv.TaskRun;
import com.cognos.asv.TaskRunInfo;
import com.cognos.asv.actions.AgentAction;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.taskTargets.storedProcedureTask.StoredProcedureTaskRunnable;
import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailParameters;
import com.cognos.developer.schemas.bibus._3.AsynchDetailQueryFrameworkOutput;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportStatus;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionInt;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchSpecification;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseParameter;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.Parameter;
import com.cognos.developer.schemas.bibus._3.ParameterCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.QueryFrameworkSpecification;
import com.cognos.developer.schemas.bibus._3.RunOptionBoolean;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.StoredProcedureTask;
import com.cognos.developer.schemas.bibus._3.Tracking;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.BatchReportServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.AuditProperties;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class AgentSQLTarget
extends BaseAgentTaskTarget {
    public AgentSQLTarget(StoredProcedureTask base, BaseStepObject parent, JobBiBusHeaders headers) {
        super((BaseClass)base, parent, headers);
    }

    public StoredProcedureTask getBaseSQL() {
        return (StoredProcedureTask)this.getBaseClass();
    }

    @Override
    public Option[] getOptions() {
        Option[] opt = new Option[]{};
        return this.getBaseSQL().getOptions() != null && this.getBaseSQL().getOptions().getValue() != null ? this.getBaseSQL().getOptions().getValue() : opt;
    }

    @Override
    public ParameterValue[] getParameters() {
        return this.getBaseSQL().getParameters() != null ? this.getBaseSQL().getParameters().getValue() : null;
    }

    @Override
    public void run(AgentAction action) throws AgentServiceException {
        if (this.isCancelled()) {
            this.setStatus(EventStatus.CANCELLED);
            return;
        }
        Option[] options = ResolveOptionsUtil.resolveOptions(this);
        ParameterValue[] parameters = ResolveParametersUtil.resolveParameters(this);
        parameters = ResolveParametersUtil.trimToTargetParams(parameters, this, this.getResultSet());
        this.makeParametersEqualLength(parameters);
        try {
            action.runAgentTaskTarget(Client.ServiceEnum.MONITOR_SERVICE, this.getSearchPath(), parameters, options);
        }
        catch (LocalizableException ase) {
            throw new AgentServiceException(ase);
        }
    }

    @Override
    public void preview(PreviewResultHandler previewResult) throws AgentServiceException {
        Option[] options = ResolveOptionsUtil.resolveOptions(this);
        ParameterValue[] parameters = ResolveParametersUtil.resolveParameters(this);
        parameters = ResolveParametersUtil.trimToTargetParams(parameters, this, this.getResultSet());
        this.makeParametersEqualLength(parameters);
        previewResult.addTaskRun(new TaskRun((BaseStepObject)this, new TaskRunInfo[]{new TaskRunInfo(options, parameters)}));
    }

    @Override
    public void validate(ValidationResultHandler validateResult) throws AgentServiceException {
        super.validate(validateResult);
        if (validateResult.getMessages().length > 0 && this.getResultSet().isEmpty()) {
            return;
        }
        StoredProcedureTaskRunnable runnable = new StoredProcedureTaskRunnable((StoredProcedureTask)this.getBaseClass(), null, this.getHeaders());
        Option[] options = ResolveOptionsUtil.resolveOptions(this);
        ParameterValue[] parameters = ResolveParametersUtil.resolveParameters(this);
        parameters = ResolveParametersUtil.trimToTargetParams(parameters, this, this.getResultSet());
        this.makeParametersEqualLength(parameters);
        runnable.setSubmitOptions(options);
        runnable.setSubmitParameters(parameters);
        ((BaseStepObject)runnable).validate(validateResult);
    }

    @Override
    public SeverityEnum getMaximumValidationSeverity() {
        return SeverityEnum.error;
    }

    @Override
    protected BaseParameter[] getTargetParametersImpl(ParameterValue[] connectionParameters) throws AgentServiceException {
        return AgentSQLTarget.getStoredProcedureParameters(this.getHeaders(), this.getBaseSQL(), connectionParameters);
    }

    static BaseParameter[] getStoredProcedureParameters(JobBiBusHeaders headers, StoredProcedureTask procedure, ParameterValue[] connectionParams) throws AgentServiceException {
        BaseParameter[] params;
        block13: {
            params = null;
            QueryFrameworkSpecification spec = StoredProcedureTaskRunnable.getQueryFrameworkSpecReq(headers, procedure, "update");
            BiBusHeader header = headers.getBiBusHeader();
            Tracking tracking = header.getTracking();
            tracking.setConversationContext(null);
            header.setTracking(tracking);
            headers.setBiBusHeader(header);
            BatchReportServiceClientPort reportService = Client.instance().getBatchReportServiceClient(headers);
            try {
                AsynchDetail[] ad;
                AsynchOptionInt primaryWaitThreshold = new AsynchOptionInt();
                primaryWaitThreshold.setName(AsynchOptionEnum.primaryWaitThreshold);
                primaryWaitThreshold.setValue(3000);
                RunOptionBoolean prompt = new RunOptionBoolean();
                prompt.setName(RunOptionEnum.prompt);
                prompt.setValue(false);
                RunOptionBoolean connectionParameters = new RunOptionBoolean();
                connectionParameters.setName(RunOptionEnum.credentialParameters);
                connectionParameters.setValue(true);
                Option[] options = new Option[]{primaryWaitThreshold, prompt, connectionParameters};
                AsynchReply reply = reportService.getParametersSpecification((AsynchSpecification)spec, null, options);
                reply = AgentSQLTarget.doWait(reportService, reply);
                AsynchDetailReportStatusEnum status = AgentSQLTarget.getReportStatusEnum(reply);
                if (status != null && status.equals((Object)AsynchDetailReportStatusEnum.prompting)) {
                    reply = reportService.forward(reply.getPrimaryRequest(), connectionParams, options);
                    reply = AgentSQLTarget.doWait(reportService, reply);
                }
                if (reply == null || !reply.getStatus().equals((Object)AsynchReplyStatusEnum.conversationComplete) || (ad = reply.getDetails()) == null) break block13;
                for (int i = 0; i < ad.length; ++i) {
                    BaseParameter[] bp;
                    AsynchDetailQueryFrameworkOutput details;
                    if (ad[i] instanceof AsynchDetailQueryFrameworkOutput) {
                        XmlEncodedXML output;
                        details = (AsynchDetailQueryFrameworkOutput)ad[i];
                        if (details == null || (output = details.getOutput()) == null) continue;
                        SAXReader reader = new SAXReader();
                        StringReader xmlReader = new StringReader(output.get_value());
                        Document doc = null;
                        List items = null;
                        try {
                            doc = reader.read((Reader)xmlReader);
                            if (doc != null) {
                                items = doc.selectNodes("/response/parameters/item");
                            }
                        }
                        catch (DocumentException documentException) {
                            // empty catch block
                        }
                        if (items == null || items.size() <= 0) continue;
                        BaseParameter[] bp2 = new BaseParameter[items.size()];
                        Iterator it = items.iterator();
                        int ii = 0;
                        while (it.hasNext()) {
                            Element e = (Element)it.next();
                            Node name = e.selectSingleNode("./name");
                            Node type = e.selectSingleNode("./type");
                            if (name == null || type == null) continue;
                            Parameter p = new Parameter();
                            p.setName(name.getText());
                            p.setType(ObjectModelUtil.getParameterType((String)type.getText()));
                            ParameterCapabilityEnum[] pce = new ParameterCapabilityEnum[]{ParameterCapabilityEnum.discreteValue};
                            p.setCapabilities(pce);
                            bp2[ii++] = p;
                        }
                        params = bp2;
                        continue;
                    }
                    if (!(ad[i] instanceof AsynchDetailParameters) || (details = (AsynchDetailParameters)ad[i]) == null || (bp = details.getParameters()) == null || bp.length <= 0) continue;
                    params = bp;
                }
            }
            catch (EMFSecurityException cse) {
                AuditProperties ap = new AuditProperties("Report", "", "AgentService", "Warning");
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.AGENT_CONSTRUCTION_ERROR, (Map)ap);
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug((Throwable)cse);
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{cse.getLocalizedMessage()});
            }
            catch (SDKClientException sdke) {
                AuditProperties ap = new AuditProperties("Report", "", "AgentService", "Warning");
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, I18NCode.AGENT_CONSTRUCTION_ERROR, (Map)ap);
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug((Throwable)sdke);
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{sdke.getLocalizedMessage()});
            }
            finally {
                reportService.close();
            }
        }
        return params;
    }

    private void makeParametersEqualLength(ParameterValue[] parameters) throws AgentServiceException {
        int length;
        int i;
        int totalRowsCount = 0;
        for (i = 0; i < parameters.length; ++i) {
            length = parameters[i].getValue().length;
            if (length <= totalRowsCount) continue;
            totalRowsCount = length;
        }
        for (i = 0; i < parameters.length; ++i) {
            length = parameters[i].getValue().length;
            ParmValueItem[] oldParamValues = parameters[i].getValue();
            ParmValueItem[] paramValues = new ParmValueItem[totalRowsCount];
            for (int j = 0; j < totalRowsCount; ++j) {
                if (j < length) {
                    paramValues[j] = oldParamValues[j];
                    continue;
                }
                if (length == 0) {
                    paramValues[j] = new SimpleParmValueItem();
                    continue;
                }
                if (length == 1) {
                    paramValues[j] = oldParamValues[0];
                    continue;
                }
                if (length <= 1 || length >= totalRowsCount) continue;
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_TASK_FAILED);
            }
            parameters[i].setValue(paramValues);
        }
    }

    private static AsynchReply doWait(BatchReportServiceClientPort reportService, AsynchReply reply) throws SDKClientException, EMFSecurityException {
        while (reply != null && (reply.getStatus().equals((Object)AsynchReplyStatusEnum.working) || reply.getStatus().equals((Object)AsynchReplyStatusEnum.stillWorking))) {
            reply = reportService.wait(reply.getPrimaryRequest(), null, null);
        }
        return reply;
    }

    private static AsynchDetailReportStatusEnum getReportStatusEnum(AsynchReply reply) {
        AsynchDetailReportStatusEnum result = null;
        AsynchDetail[] ad = reply.getDetails();
        if (ad != null) {
            for (int i = 0; i < ad.length; ++i) {
                if (!(ad[i] instanceof AsynchDetailReportStatus)) continue;
                result = ((AsynchDetailReportStatus)ad[i]).getStatus();
                break;
            }
        }
        return result;
    }
}

