/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets;

import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartAgentObject;
import com.cognos.developer.schemas.bibus._3.MemoPartObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;

public final class AttachmentExtract {
    private String m_searchPath;
    private String m_name;
    private String m_format;
    private String m_locale;

    private AttachmentExtract(MemoPartObject mpo, String locale, String format) {
        this.m_name = mpo.getName();
        this.m_format = format;
        this.m_locale = locale;
        SearchPathSingleObject spso = mpo.getSearchPath();
        if (spso != null) {
            this.m_searchPath = spso.get_value();
            if (this.m_searchPath == null) {
                // empty if block
            }
        }
    }

    private AttachmentExtract(MemoPartAgentObject mpao, String locale, String format) {
        this.m_name = mpao.getName();
        this.m_format = mpao.getFormat() != null && mpao.getFormat().length() > 0 ? mpao.getFormat() : format;
        this.m_locale = mpao.getLocale() != null && mpao.getLocale().length() > 0 ? mpao.getLocale() : locale;
        SearchPathSingleObject spso = mpao.getSearchPath();
        if (spso != null) {
            this.m_searchPath = spso.get_value();
            if (this.m_searchPath == null) {
                // empty if block
            }
        }
    }

    public String getName() {
        return this.m_name;
    }

    public String getPath() {
        return this.m_searchPath;
    }

    public String getFormat() {
        return this.m_format;
    }

    public String getLocale() {
        return this.m_locale;
    }

    public static AttachmentExtract getAttachmentValidation(MemoPart memoPart, String locale, String format) {
        AttachmentExtract result = null;
        if (memoPart instanceof MemoPartObject) {
            result = new AttachmentExtract((MemoPartObject)memoPart, locale, format);
        } else if (memoPart instanceof MemoPartAgentObject) {
            result = new AttachmentExtract((MemoPartAgentObject)memoPart, locale, format);
        }
        return result;
    }
}

