/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets;

import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.BaseStepObjectContainer;
import com.cognos.asv.agent.Agent;
import com.cognos.asv.taskTargets.AgentMemoTarget;
import com.cognos.asv.taskTargets.AgentReportTarget;
import com.cognos.asv.taskTargets.ReportAttachmentChecker;
import com.cognos.developer.schemas.bibus._3.AgentTaskDefinition;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionMemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartComposite;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.OptionArrayProp;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.RunOptionLanguageArray;
import com.cognos.developer.schemas.bibus._3.RunOptionStringArray;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.dls.i18n.DlsI18NCode;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.util.LocaleUtil;
import java.util.ArrayList;
import java.util.List;

public final class AttachmentValidator {
    private Option[] m_options;
    private BaseAgentTaskTarget m_batt;
    private ReportAttachmentChecker m_reportAttachmentChecker;

    public AttachmentValidator(AgentMemoTarget amt, Option[] options) {
        this.m_options = options;
        this.m_batt = amt;
        String contentLocale = amt.getHeaders().getUserPreferenceContentLocale();
        String format = "HTML";
        try {
            format = LocaleUtil.getUserPreference((String)"format", (BiBusHeader)amt.getHeaders().getBiBusHeader());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_reportAttachmentChecker = new ReportAttachmentChecker(contentLocale, format);
    }

    public I18NMessage[] validate() {
        I18NMessage[] result = new I18NMessage[]{};
        this.extractReports();
        this.parseMemoPartObjects(this.m_options);
        String[] faultyAttachmentNames = this.m_reportAttachmentChecker.doValidation();
        if (faultyAttachmentNames.length > 0) {
            ArrayList<I18NMessage> messages = new ArrayList<I18NMessage>();
            I18NMessage oneMessage = null;
            for (int counter = 0; counter < faultyAttachmentNames.length; ++counter) {
                oneMessage = new I18NMessage(DlsI18NCode.MSG_DS_OUTPUT_NOT_AVALABLE, new Object[]{faultyAttachmentNames[counter]}, SeverityEnum.warn);
                messages.add(oneMessage);
            }
            result = messages.toArray(result);
        }
        return result;
    }

    private void parseMemoPartObjects(Option[] options) {
        DeliveryOptionMemoPart doMemoPart = null;
        for (int counter = 0; counter < options.length; ++counter) {
            if (!(options[counter] instanceof DeliveryOptionMemoPart)) continue;
            doMemoPart = (DeliveryOptionMemoPart)options[counter];
            MemoPart memoPart = doMemoPart.getValue();
            this.parseMemo(new MemoPart[]{memoPart});
        }
    }

    private void parseMemo(MemoPart[] memos) {
        for (int i = 0; i < memos.length; ++i) {
            MemoPart memoPart = memos[i];
            if (memoPart instanceof MemoPartComposite) {
                MemoPartComposite theComposite = (MemoPartComposite)memoPart;
                MemoPart[] theMemos = theComposite.getParts();
                this.parseMemo(theMemos);
                continue;
            }
            this.m_reportAttachmentChecker.addMemoPart(memoPart);
        }
    }

    private void populateReportList(List subSteps, ArrayList reportList) {
        Object oneObj2 = null;
        for (Object oneObj2 : subSteps) {
            if (oneObj2 instanceof BaseStepObjectContainer) {
                List<BaseStepObject> lowerSteps = ((BaseStepObjectContainer)oneObj2).getSubSteps();
                this.populateReportList(lowerSteps, reportList);
                continue;
            }
            if (!(oneObj2 instanceof AgentReportTarget)) continue;
            reportList.add(oneObj2);
        }
    }

    private void extractReports() {
        ArrayList reportList = new ArrayList();
        BaseStepObject bso = this.m_batt.getParent();
        boolean parentIsFound = false;
        while (!parentIsFound) {
            if (bso.getParent() == null) {
                parentIsFound = true;
                continue;
            }
            bso = bso.getParent();
        }
        if (bso instanceof Agent) {
            Agent theAgent = (Agent)bso;
            List<BaseStepObject> subSteps = theAgent.getSubSteps();
            this.populateReportList(subSteps, reportList);
            this.extractAttachableParts(reportList);
        }
    }

    private void extractParts(AgentReportTarget art) {
        if (art == null) {
            return;
        }
        BaseStepObject bso = art.getParent();
        AgentTaskDefinition reportTaskDefinition = (AgentTaskDefinition)bso.getBaseClass();
        OptionArrayProp oap = reportTaskDefinition.getOptions();
        if (oap != null && oap.getValue() != null) {
            RunOptionStringArray aosa = null;
            RunOptionLanguageArray rola = null;
            String defaultFormat = "";
            String locale = "";
            try {
                defaultFormat = LocaleUtil.getUserPreference((String)"format", (BiBusHeader)this.m_batt.getHeaders().getBiBusHeader());
                locale = this.m_batt.getHeaders().getUserPreferenceContentLocale();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String[] supportedFormats = new String[]{defaultFormat};
            String[] supportedLocales = new String[]{locale};
            Option[] reportOptions = oap.getValue();
            for (int counter = 0; counter < reportOptions.length; ++counter) {
                if (reportOptions[counter] instanceof RunOptionStringArray) {
                    aosa = (RunOptionStringArray)reportOptions[counter];
                    if (!RunOptionEnum.outputFormat.equals((Object)aosa.getName())) continue;
                    supportedFormats = aosa.getValue() == null ? supportedFormats : aosa.getValue();
                    continue;
                }
                if (!(reportOptions[counter] instanceof RunOptionLanguageArray) || !RunOptionEnum.outputLocale.equals((Object)(rola = (RunOptionLanguageArray)reportOptions[counter]).getName())) continue;
                supportedLocales = rola.getValue() == null ? supportedLocales : rola.getValue();
            }
            StringProp sp = reportTaskDefinition.getSearchPath();
            if (sp != null) {
                String reportName = null;
                TokenProp tp = reportTaskDefinition.getDefaultName();
                if (tp != null) {
                    reportName = tp.getValue();
                }
                String searchPath = sp.getValue();
                if (searchPath != null) {
                    this.m_reportAttachmentChecker.addPathMap(searchPath, supportedLocales, supportedFormats, reportName);
                }
            }
        }
    }

    private void extractAttachableParts(ArrayList reportList) {
        if (reportList.size() < 1) {
            return;
        }
        AgentReportTarget[] artArray = reportList.toArray(new AgentReportTarget[0]);
        for (int counter = 0; counter < artArray.length; ++counter) {
            this.extractParts(artArray[counter]);
        }
    }
}

