/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets;

import com.cognos.asv.i18n.AgsI18NCode;
import com.cognos.asv.taskTargets.AttachmentExtract;
import com.cognos.asv.taskTargets.ReportExtract;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.util.LocaleUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public final class ReportAttachmentChecker {
    private static String eventOutputSearchPath = "eventOutput";
    private HashMap m_pathToFormatMap;
    private ArrayList m_attachments;
    private String m_contentLocale;
    private String m_format;

    public ReportAttachmentChecker(String contentLocale, String format) {
        this.m_contentLocale = contentLocale;
        this.m_format = format;
        this.m_pathToFormatMap = new HashMap();
        this.m_attachments = new ArrayList();
    }

    public void addPathMap(String searchPath, String[] locales, String[] formats, String reportName) {
        if (locales == null || locales.length == 0) {
            locales = new String[]{this.m_contentLocale};
        }
        ReportExtract reportExtract = new ReportExtract(locales, formats, reportName);
        this.m_pathToFormatMap.put(searchPath, reportExtract);
    }

    public void addMemoPart(MemoPart memoPart) {
        AttachmentExtract oneAV = AttachmentExtract.getAttachmentValidation(memoPart, this.m_contentLocale, this.m_format);
        if (oneAV != null) {
            this.m_attachments.add(oneAV);
        }
    }

    private boolean isOutputSupported(AttachmentExtract oneAv) {
        boolean result = false;
        if (this.m_pathToFormatMap.containsKey(oneAv.getPath())) {
            ReportExtract reportExtract = (ReportExtract)this.m_pathToFormatMap.get(oneAv.getPath());
            result = reportExtract.supportsOutput(oneAv);
        } else {
            result = ReportExtract.compareText(eventOutputSearchPath, oneAv.getPath()) == 0;
        }
        return result;
    }

    private String getReportName(String searchPath) {
        String result = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_REPORT_TASK_MISSING, null, (Locale)LocaleUtil.createContentLocale((String)this.m_contentLocale));
        if (this.m_pathToFormatMap.containsKey(searchPath)) {
            ReportExtract reportExtract = (ReportExtract)this.m_pathToFormatMap.get(searchPath);
            result = reportExtract.getName();
        }
        return result;
    }

    public String[] doValidation() {
        String[] result = new String[]{};
        ArrayList<String> faultyOnes = new ArrayList<String>();
        AttachmentExtract oneAv2 = null;
        for (AttachmentExtract oneAv2 : this.m_attachments) {
            if (this.isOutputSupported(oneAv2)) continue;
            faultyOnes.add(oneAv2.getName() + ":" + this.getReportName(oneAv2.getPath()));
        }
        if (faultyOnes.size() > 0) {
            result = faultyOnes.toArray(result);
        }
        return result;
    }
}

