/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets;

import com.cognos.asv.taskTargets.AttachmentExtract;
import java.text.Collator;
import java.util.Locale;

public final class ReportExtract {
    private String[] m_formats;
    private String[] m_locales;
    private String m_reportName;
    private static Collator itsTextComparator = Collator.getInstance(Locale.ENGLISH);

    public ReportExtract(String[] locales, String[] formats, String reportName) {
        this.m_formats = formats == null ? new String[]{} : formats;
        this.m_locales = locales == null ? new String[]{} : locales;
        this.m_reportName = reportName;
    }

    public String getName() {
        return this.m_reportName;
    }

    private boolean supportsFormat(String format) {
        boolean result = false;
        if (format == null) {
            return result;
        }
        for (int counter = this.m_formats.length - 1; counter >= 0; --counter) {
            if (ReportExtract.compareText(this.m_formats[counter], format) != 0) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean supportsLocale(String locale) {
        boolean result = false;
        if (locale == null) {
            return result;
        }
        for (int counter = this.m_locales.length - 1; counter >= 0; --counter) {
            if (ReportExtract.compareText(this.m_locales[counter], locale) != 0) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean supportsOutput(AttachmentExtract oneAv) {
        boolean result = false;
        result = this.supportsLocale(oneAv.getLocale()) && this.supportsFormat(oneAv.getFormat());
        return result;
    }

    static int compareText(String source, String target) {
        return itsTextComparator.compare(source, target);
    }

    static {
        itsTextComparator.setStrength(0);
    }
}

