/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets.humanTask;

import com.cognos.asv.AgentServiceException;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.taskTargets.humanTask.HTSValidator;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;

public class HTSNotificationValidator
extends HTSValidator {
    private static final String HTS_RECIPIENT = "RECIPIENT";

    public HTSNotificationValidator(Document humanTaskXMLDoc, ValidationResultHandler validationResult, JobBiBusHeaders jobHeaders) throws AgentServiceException {
        super(humanTaskXMLDoc, validationResult, jobHeaders);
        Node subjectNode = this.getHumanTaskDocument().selectSingleNode("//*[local-name()='manualTask']/*[local-name()='subject']");
        this.setSubject(subjectNode);
        Node bodyTextNode = this.getHumanTaskDocument().selectSingleNode("//*[local-name()='manualTask']/*[local-name()='description' and @contentType='text/plain']");
        this.setBody(bodyTextNode);
        Node priorityTextNode = this.getHumanTaskDocument().selectSingleNode("//*[local-name()='beplNotification' or local-name()='beplTask']/*[local-name()='priority']");
        this.setPriority(priorityTextNode);
        List recipsUsersNode = this.getHumanTaskDocument().selectNodes("//*[local-name()='beplNotification']/*[local-name()='peopleAssignments']/*[local-name()='recipients']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='users']/*[local-name()='user']");
        List recipsGroupsNode = this.getHumanTaskDocument().selectNodes("//*[local-name()='beplNotification']/*[local-name()='peopleAssignments']/*[local-name()='recipients']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='groups']/*[local-name()='group']");
        this.setOrganizationalEntities(recipsUsersNode, HTSValidator.ENTITY_TYPE.USER, HTSValidator.ROLES.RECIPIENT);
        this.setOrganizationalEntities(recipsGroupsNode, HTSValidator.ENTITY_TYPE.GROUP, HTSValidator.ROLES.RECIPIENT);
        List stakeGroupsNode = this.getHumanTaskDocument().selectNodes("//*[local-name()='beplNotification' or local-name()='beplTask']/*[local-name()='peopleAssignments']/*[local-name()='taskStakeholders']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='groups']/*[local-name()='group']");
        List stakeUsersNode = this.getHumanTaskDocument().selectNodes("//*[local-name()='beplNotification' or local-name()='beplTask']/*[local-name()='peopleAssignments']/*[local-name()='taskStakeholders']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='users']/*[local-name()='user']");
        this.setOrganizationalEntities(stakeGroupsNode, HTSValidator.ENTITY_TYPE.GROUP, HTSValidator.ROLES.STAKE_HOLDER);
        this.setOrganizationalEntities(stakeUsersNode, HTSValidator.ENTITY_TYPE.USER, HTSValidator.ROLES.STAKE_HOLDER);
    }

    @Override
    public void validate() {
        super.validate();
        List<HTSValidator.Entity> entities = this.getOrganizationalEntities();
        if (!super.hasRole(entities, HTS_RECIPIENT)) {
            this.getHandler().addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_RECIPIENT_MISSING, new Object[0], SeverityEnum.warn));
        }
    }
}

