/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets.humanTask;

import com.cognos.asv.AgentServiceException;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.taskTargets.humanTask.HTSValidator;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import org.dom4j.Document;
import org.dom4j.Node;

public class HTSTaskValidator
extends HTSValidator {
    public HTSTaskValidator(Document humanTaskXMLDoc, ValidationResultHandler validationResult, JobBiBusHeaders jobHeaders) throws AgentServiceException {
        super(humanTaskXMLDoc, validationResult, jobHeaders);
        Node subjectNode = this.getHumanTaskDocument().selectSingleNode("//*[local-name()='manualTask']/*[local-name()='subject']");
        this.setSubject(subjectNode);
        Node bodyTextNode = this.getHumanTaskDocument().selectSingleNode("//*[local-name()='manualTask']/*[local-name()='description' and @contentType='text/plain']");
        this.setBody(bodyTextNode);
        try {
            Node startDeadline = this.getHumanTaskDocument().selectSingleNode("//*[local-name()='manualTask']/*[local-name()='startFor']");
            this.setStartDeadline(startDeadline);
            Node completeDeadline = this.getHumanTaskDocument().selectSingleNode("//*[local-name()='manualTask']/*[local-name()='completeFor']");
            this.setCompleteDeadline(completeDeadline);
        }
        catch (DatatypeConfigurationException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_VALIDATION_FAIL, new Object[]{e.getMessage()});
        }
        Node priorityTextNode = this.getHumanTaskDocument().selectSingleNode("//*[local-name()='beplNotification' or local-name()='beplTask']/*[local-name()='priority']");
        this.setPriority(priorityTextNode);
        List potUsersNode = this.getHumanTaskDocument().selectNodes("//*[local-name()='beplTask']/*[local-name()='peopleAssignments']/*[local-name()='potentialOwners']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='users']/*[local-name()='user']");
        List potGroupsNode = this.getHumanTaskDocument().selectNodes("//*[local-name()='beplTask']/*[local-name()='peopleAssignments']/*[local-name()='potentialOwners']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='groups']/*[local-name()='group']");
        this.setOrganizationalEntities(potGroupsNode, HTSValidator.ENTITY_TYPE.GROUP, HTSValidator.ROLES.POTENTIAL_OWNER);
        this.setOrganizationalEntities(potUsersNode, HTSValidator.ENTITY_TYPE.USER, HTSValidator.ROLES.POTENTIAL_OWNER);
        List stakeGroupsNode = this.getHumanTaskDocument().selectNodes("//*[local-name()='beplNotification' or local-name()='beplTask']/*[local-name()='peopleAssignments']/*[local-name()='taskStakeholders']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='groups']/*[local-name()='group']");
        List stakeUsersNode = this.getHumanTaskDocument().selectNodes("//*[local-name()='beplNotification' or local-name()='beplTask']/*[local-name()='peopleAssignments']/*[local-name()='taskStakeholders']/*[local-name()='from']/*[local-name()='literal']/*[local-name()='organizationalEntity']/*[local-name()='users']/*[local-name()='user']");
        this.setOrganizationalEntities(stakeGroupsNode, HTSValidator.ENTITY_TYPE.GROUP, HTSValidator.ROLES.STAKE_HOLDER);
        this.setOrganizationalEntities(stakeUsersNode, HTSValidator.ENTITY_TYPE.USER, HTSValidator.ROLES.STAKE_HOLDER);
    }

    @Override
    public void validate() {
        List<HTSValidator.Entity> stakeholders;
        ValidationResultHandler validationResults = super.getHandler();
        List<HTSValidator.Entity> entities = super.getOrganizationalEntities();
        if (!entities.isEmpty() && (stakeholders = super.getOrganizationalEntitiesByRole(HTSValidator.ROLES.STAKE_HOLDER)).isEmpty()) {
            validationResults.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_STAKEHOLDER_MISSING, new Object[0], SeverityEnum.error));
        }
        super.validate();
    }
}

