/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets.humanTask;

import com.cognos.asv.AgentServiceException;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.util.DataTypeUtil;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryReply;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.Duration;
import org.dom4j.Document;
import org.dom4j.Node;

public abstract class HTSValidator {
    private Document m_humanTaskXMLDoc;
    private ValidationResultHandler m_validationResult;
    private Map<ROLES, List<Entity>> m_entities;
    private BiBusHeader m_header;
    private String m_subject = "";
    private String m_body = "";
    private String m_priority = "";
    private Duration m_startFor;
    private Duration m_completeFor;
    private static final String HTS_POTENTIAL_OWNER = "POTENTIAL_OWNER";

    public HTSValidator(Document humanTaskXMLDoc, ValidationResultHandler validationResult, JobBiBusHeaders jobHeaders) {
        this.m_humanTaskXMLDoc = humanTaskXMLDoc;
        this.m_validationResult = validationResult;
        this.m_header = jobHeaders.getBiBusHeader();
    }

    public void setOrganizationalEntities(List<Node> orgEnts, ENTITY_TYPE type, ROLES role) throws AgentServiceException {
        QueryReply[] replies;
        if (this.m_entities == null) {
            this.m_entities = new HashMap<ROLES, List<Entity>>();
        }
        ArrayList<Entity> entities = new ArrayList<Entity>(orgEnts.size());
        try {
            replies = this.getOrganizationalEntitiesFromCM(orgEnts);
        }
        catch (SDKClientException ex) {
            String msg = "[" + ((Object)((Object)ex)).getClass().getName() + "] " + ex.getLocalizedMessage();
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_VALIDATION_FAIL, new Object[]{msg}, ex, SeverityEnum.error);
        }
        catch (EMFSecurityException ex) {
            String msg = "[" + ((Object)((Object)ex)).getClass().getName() + "] " + ex.getLocalizedMessage();
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_VALIDATION_FAIL, new Object[]{msg}, ex, SeverityEnum.error);
        }
        for (int i = 0; i < replies.length; ++i) {
            QueryReply reply = replies[i];
            BaseClass[] result = reply.getQueryResult();
            Entity orgEntity = new Entity();
            orgEntity.setSearchPath(orgEnts.get(i).getStringValue());
            orgEntity.setEntity(result);
            orgEntity.setEntityType(type);
            orgEntity.setRole(role);
            entities.add(orgEntity);
        }
        if (this.m_entities.containsKey((Object)role)) {
            List<Entity> existingEntityList = this.m_entities.get((Object)role);
            existingEntityList.addAll(entities);
        } else {
            this.m_entities.put(role, entities);
        }
    }

    public void setSubject(Node subjectNode) {
        if (subjectNode != null) {
            this.m_subject = subjectNode.getStringValue();
        }
    }

    String getSubject() {
        return this.m_subject;
    }

    public void setPriority(Node priorityNode) {
        if (priorityNode != null) {
            this.m_priority = priorityNode.getStringValue();
        }
    }

    String getPriority() {
        return this.m_priority;
    }

    public void setStartDeadline(Node start) throws DatatypeConfigurationException {
        if (start != null) {
            this.m_startFor = DataTypeUtil.getDataTypeFactory().newDuration(start.getStringValue());
        }
    }

    Duration getStartDeadline() {
        return this.m_startFor;
    }

    public void setCompleteDeadline(Node complete) throws DatatypeConfigurationException {
        if (complete != null) {
            this.m_completeFor = DataTypeUtil.getDataTypeFactory().newDuration(complete.getStringValue());
        }
    }

    Duration getCompleteDeadline() {
        return this.m_completeFor;
    }

    public void setBody(Node body) {
        if (body != null) {
            this.m_body = body.getStringValue();
        }
    }

    String getBody() {
        return this.m_body;
    }

    Document getHumanTaskDocument() {
        return this.m_humanTaskXMLDoc;
    }

    ValidationResultHandler getHandler() {
        return this.m_validationResult;
    }

    List<Entity> getOrganizationalEntities() {
        ArrayList<Entity> entsList = new ArrayList<Entity>();
        Collection<List<Entity>> values = this.m_entities.values();
        for (List<Entity> list : values) {
            entsList.addAll(list);
        }
        return entsList;
    }

    List<Entity> getOrganizationalEntitiesByRole(ROLES role) {
        List<Entity> entities = new ArrayList<Entity>();
        if (this.m_entities.containsKey((Object)role)) {
            entities = this.m_entities.get((Object)role);
        }
        return entities;
    }

    List<Entity> getOrganizationalEntitiesByType(boolean group, ROLES role) {
        ArrayList<Entity> found = new ArrayList<Entity>();
        if (this.m_entities.containsKey((Object)role)) {
            for (Entity orgEnt : this.m_entities.get((Object)role)) {
                if (group && orgEnt.isGroup()) {
                    found.add(orgEnt);
                    continue;
                }
                if (group || orgEnt.isGroup()) continue;
                found.add(orgEnt);
            }
        }
        return found;
    }

    public void validate() {
        String priority;
        String body;
        List<Entity> entities = this.getOrganizationalEntities();
        if (entities.isEmpty()) {
            this.m_validationResult.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_NO_USERS_OR_GROUPS, new Object[0], SeverityEnum.error));
        } else {
            for (Entity entity : entities) {
                if (entity.isValidCMObject()) continue;
                String searchPath = entity.getSearchPath();
                this.m_validationResult.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_INVALID_CM_OBJECT, new Object[]{searchPath}, SeverityEnum.error));
            }
        }
        this.checkDeadlines();
        String subject = this.getSubject();
        if (subject.length() == 0) {
            this.m_validationResult.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_NO_SUBJECT, new Object[0], SeverityEnum.error));
        }
        if ((body = this.getBody()).length() == 0) {
            this.m_validationResult.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_NO_BODY_TEXT, new Object[0], SeverityEnum.warn));
        }
        if ((priority = this.getPriority()).length() == 0) {
            this.m_validationResult.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_NO_PRIORITY_TEXT, new Object[0], SeverityEnum.error));
        } else {
            int priorityValue = -1;
            try {
                priorityValue = Integer.parseInt(priority);
                if (priorityValue < 1 || priorityValue > 5) {
                    this.m_validationResult.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_PRIORITY_INVALID_VALUE, new Object[0], SeverityEnum.error));
                }
            }
            catch (NumberFormatException e) {
                this.m_validationResult.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_PRIORITY_NOT_NUMERIC, new Object[0], SeverityEnum.info));
            }
        }
    }

    protected boolean hasRole(List<Entity> entities, String roleStr) {
        boolean hasRecipient = false;
        for (Entity entity : entities) {
            if (!entity.getRole().name().equals(roleStr)) continue;
            hasRecipient = true;
            break;
        }
        return hasRecipient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryReply[] getOrganizationalEntitiesFromCM(List<Node> searchPaths) throws SDKClientException, EMFSecurityException {
        ContentManagerServiceClientPort contentManager = null;
        QueryReply[] replies = new QueryReply[]{};
        if (!searchPaths.isEmpty()) {
            JobBiBusHeaders jobBusHeaders = new JobBiBusHeaders(this.m_header);
            ArrayList<QueryRequest> requests = new ArrayList<QueryRequest>();
            try {
                contentManager = Client.instance().getContentManagerServiceClient(jobBusHeaders);
                Iterator<Node> iterator = searchPaths.iterator();
                while (iterator.hasNext()) {
                    String searchPath = iterator.next().getStringValue();
                    QueryRequest request = new QueryRequest(null, new PropEnum[]{PropEnum.defaultName}, searchPath, null);
                    requests.add(request);
                }
                QueryRequest[] requestsArr = requests.toArray(new QueryRequest[requests.size()]);
                replies = contentManager.queryMultiple(requestsArr);
            }
            finally {
                if (contentManager != null) {
                    contentManager.close();
                }
            }
        }
        return replies;
    }

    private void checkDeadlines() {
        boolean shouldCheck;
        Duration start = this.getStartDeadline();
        Duration complete = this.getCompleteDeadline();
        boolean bl = shouldCheck = start != null && complete != null;
        if (shouldCheck && (complete.compare(start) == -1 || complete.compare(start) == 0)) {
            this.m_validationResult.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_INVALID_DEADLINES, new Object[0], SeverityEnum.warn));
        }
    }

    public class Entity {
        private ROLES m_role;
        private BaseClass[] m_entity;
        private ENTITY_TYPE m_entityType;
        private String m_searchPath;

        public BaseClass[] getEntity() {
            return this.m_entity;
        }

        public void setSearchPath(String stringValue) {
            this.m_searchPath = stringValue;
        }

        public String getSearchPath() {
            return this.m_searchPath;
        }

        public void setEntity(BaseClass[] entity) {
            this.m_entity = entity;
        }

        public void setRole(ROLES role) {
            this.m_role = role;
        }

        public ROLES getRole() {
            return this.m_role;
        }

        public void setEntityType(ENTITY_TYPE entityType) {
            this.m_entityType = entityType;
        }

        public boolean isGroup() {
            return this.m_entityType.equals((Object)ENTITY_TYPE.GROUP);
        }

        public boolean isValidCMObject() {
            return this.m_entity.length > 0;
        }
    }

    public static enum ENTITY_TYPE {
        USER,
        GROUP;

    }

    public static enum ROLES {
        STAKE_HOLDER,
        RECIPIENT,
        POTENTIAL_OWNER;

    }
}

