/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets.memo;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentTask;
import com.cognos.asv.BaseAgentTaskTarget;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.BaseStepObjectContainer;
import com.cognos.asv.agent.BaseAgent;
import com.cognos.asv.formatters.HTMLDecodeFormatter;
import com.cognos.asv.formatters.HTMLEncodeFormatter;
import com.cognos.asv.i18n.AgsI18NCode;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.resultset.ResultSetKey;
import com.cognos.asv.resultset.ResultSetLineBuilder;
import com.cognos.asv.resultset.ResultSetMessageBuilder;
import com.cognos.asv.resultset.ResultSetNoEvents;
import com.cognos.asv.resultset.ResultSetPartition;
import com.cognos.asv.resultset.ResultSetTypeEnum;
import com.cognos.asv.xhtml.XHTML;
import com.cognos.asv.xhtml.XHTMLNode;
import com.cognos.asv.xhtml.XHTMLSAXHandler;
import com.cognos.asv.xhtml.XHTMLTag;
import com.cognos.asv.xhtml.XHTML_HTMLVisitor;
import com.cognos.developer.schemas.bibus._3.AddressSMTP;
import com.cognos.developer.schemas.bibus._3.AnyURIProp;
import com.cognos.developer.schemas.bibus._3.BaseAgentDefinition;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BasePowerPlay8Report;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.BooleanProp;
import com.cognos.developer.schemas.bibus._3.DeliveryOption;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionAddressSMTPArray;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionEnum;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionMemoPart;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionSearchPathMultipleObjectArray;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionSearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionString;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.MemoPart;
import com.cognos.developer.schemas.bibus._3.MemoPartAgentObject;
import com.cognos.developer.schemas.bibus._3.MemoPartAgentObjectLinks;
import com.cognos.developer.schemas.bibus._3.MemoPartComposite;
import com.cognos.developer.schemas.bibus._3.MemoPartMIMEAttachment;
import com.cognos.developer.schemas.bibus._3.MemoPartObject;
import com.cognos.developer.schemas.bibus._3.MemoPartObjectLinks;
import com.cognos.developer.schemas.bibus._3.MemoPartString;
import com.cognos.developer.schemas.bibus._3.ObjectLink;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.SmtpContentDispositionEnum;
import com.cognos.developer.schemas.bibus._3.URL;
import com.cognos.dls.DeliveryOptionsBuilder;
import com.cognos.dls.DeliveryOptionsBuilderException;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.tse.run.commands.CmdSpec;
import com.cognos.jsmcommon.tse.run.commands.SaveReportPathCmdSpec;
import com.cognos.jsmcommon.tse.run.commands.SetParameterCmdSpec;
import com.cognos.jsmcommon.util.CafUtilities;
import com.cognos.jsmcommon.util.DataSizeChecker;
import com.cognos.jsmcommon.util.LocaleUtil;
import com.cognos.jsmcommon.util.ObjectCopyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

public class ResultSetDeliveryOptionsBuilder
extends DeliveryOptionsBuilder {
    public static String EVENT_OUTPUT_ID = "eventOutput";
    private static Pattern htmlBodyTagstart = Pattern.compile(".*<[bB][oO][dD][yY].*");
    private static Pattern htmlBodyTagstop = Pattern.compile(".*</[bB][oO][dD][yY].*");
    private List m_deliveryOptions;
    private ResultSetPartition m_partition;
    private List m_attachments = new ArrayList();
    private HashMap reportVariables = new HashMap();
    private BaseStepObject m_parent = null;
    JobBiBusHeaders m_headers = null;
    private String m_subject = "";
    private StringBuffer m_recipients = new StringBuffer();
    private SearchPathMultipleObject[] m_to_cm_paths = null;
    private SearchPathMultipleObject[] m_cc_cm_paths = null;
    private SearchPathMultipleObject[] m_bcc_cm_paths = null;
    private AddressSMTP[] m_to_address_smtps = null;
    private AddressSMTP[] m_cc_address_smtps = null;
    private AddressSMTP[] m_bcc_address_smtps = null;
    private Guid m_memoStoreId;
    private DeliveryOptionMemoPart m_bodyMemoPart;
    private boolean m_notPreview;
    private static final String CAM_IDENTIFIER = "CAMID(";

    public ResultSetDeliveryOptionsBuilder(Option[] options, ResultSetPartition partition, JobBiBusHeaders headers, BaseStepObject parent, Guid memoStoreId, boolean notPreview) {
        this.m_memoStoreId = memoStoreId;
        this.m_notPreview = notPreview;
        this.m_deliveryOptions = new ArrayList();
        MemoPartString mps = new MemoPartString();
        mps.setName(DeliveryOptionEnum.memoPart.toString());
        mps.setText("");
        this.m_bodyMemoPart = new DeliveryOptionMemoPart();
        this.m_bodyMemoPart.setName(DeliveryOptionEnum.memoPart);
        this.m_bodyMemoPart.setValue((MemoPart)mps);
        this.m_parent = parent;
        this.m_partition = partition;
        this.m_headers = headers;
        this.process(options);
    }

    protected void buildCMRecipients() throws DeliveryOptionsBuilderException {
        if (this.m_partition == null) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_CREATE_ERROR);
            throw new DeliveryOptionsBuilderException(I18NCode.MSG_CREATE_ERROR);
        }
        SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug("Building Content Manager recipients");
        if (this.m_to_cm_paths != null && this.m_to_cm_paths.length > 0) {
            this.buildCMRecipientList(this.m_to_cm_paths, DeliveryOptionEnum.to);
        }
        if (this.m_cc_cm_paths != null && this.m_cc_cm_paths.length > 0) {
            this.buildCMRecipientList(this.m_cc_cm_paths, DeliveryOptionEnum.cc);
        }
        if (this.m_bcc_cm_paths != null && this.m_bcc_cm_paths.length > 0) {
            this.buildCMRecipientList(this.m_bcc_cm_paths, DeliveryOptionEnum.bcc);
        }
        this.buildSubscriptionRecipients();
        SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug("Finished building Content Manager recipients");
    }

    protected void buildSubscriptionRecipients() {
        DeliveryOptionSearchPathSingleObject notificationListOption = this.getNotificationListOption();
        if (notificationListOption != null) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug("Building subscription recipients");
            this.m_deliveryOptions.add(notificationListOption);
            SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug("Finished building subscription recipients");
        }
    }

    private DeliveryOptionSearchPathSingleObject getNotificationListOption() {
        BaseAgentDefinition agentDefinition;
        BooleanProp doNotification;
        DeliveryOptionSearchPathSingleObject notificationListOption = null;
        BaseClass bc = this.getParentTasksContainer(this.m_parent).getBaseClass();
        if (bc instanceof BaseAgentDefinition && (doNotification = (agentDefinition = (BaseAgentDefinition)bc).getAllowNotification()) != null && doNotification.isValue() && agentDefinition.getNotificationListIsEmpty() != null && !agentDefinition.getNotificationListIsEmpty().isValue()) {
            notificationListOption = new DeliveryOptionSearchPathSingleObject();
            notificationListOption.setName(DeliveryOptionEnum.notificationList);
            SearchPathSingleObject spso = new SearchPathSingleObject();
            spso.set_value(agentDefinition.getSearchPath().getValue());
            notificationListOption.setValue(spso);
        }
        return notificationListOption;
    }

    protected void buildExternalRecipients() throws DeliveryOptionsBuilderException {
        if (this.m_partition == null) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_CREATE_ERROR);
            throw new DeliveryOptionsBuilderException(I18NCode.MSG_CREATE_ERROR);
        }
        SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug("Building external recipients");
        if (this.m_to_address_smtps != null && this.m_to_address_smtps.length > 0) {
            this.buildExternalRecipientList(this.m_to_address_smtps, DeliveryOptionEnum.toAddress);
        }
        if (this.m_cc_address_smtps != null && this.m_cc_address_smtps.length > 0) {
            this.buildExternalRecipientList(this.m_cc_address_smtps, DeliveryOptionEnum.ccAddress);
        }
        if (this.m_bcc_address_smtps != null && this.m_bcc_address_smtps.length > 0) {
            this.buildExternalRecipientList(this.m_bcc_address_smtps, DeliveryOptionEnum.bccAddress);
        }
        SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug("Finished building external recipients");
    }

    protected void buildSubject() throws DeliveryOptionsBuilderException {
        ResultSetLineBuilder lineBuilder;
        if (this.m_partition == null) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_CREATE_ERROR);
            throw new DeliveryOptionsBuilderException(I18NCode.MSG_CREATE_ERROR);
        }
        SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug("Building subject");
        String generated_subject = this.m_partition.descriptor();
        ResultSetPartition partition = this.m_partition;
        if (partition.isEmpty()) {
            Locale locale = LocaleUtil.getLocale((String)this.m_headers.getUserPreferenceContentLocale());
            String defaultValue = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_NO_DATA, null, (Locale)LocaleUtil.createContentLocale((String)locale.toString()));
            partition = ResultSetNoEvents.getResultSetPartition(this.m_partition, locale, defaultValue);
        }
        if (!(lineBuilder = new ResultSetLineBuilder(partition, ResultSetTypeEnum.HTML, generated_subject)).isConstant()) {
            Iterator it = partition.getData();
            generated_subject = lineBuilder.buildLine((ResultSetKey)it.next());
        }
        DeliveryOptionString subject = new DeliveryOptionString();
        subject.setName(DeliveryOptionEnum.subject);
        subject.setValue(generated_subject);
        this.m_deliveryOptions.add(subject);
        SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug("Finished building subject");
    }

    protected void buildBody() throws DeliveryOptionsBuilderException {
        if (this.m_partition == null) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_CREATE_ERROR);
            throw new DeliveryOptionsBuilderException(I18NCode.MSG_CREATE_ERROR);
        }
        SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug("Building body");
        MemoPart result = this.buildBodyParts(this.m_bodyMemoPart.getValue());
        if (result == null) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_CREATE_ERROR);
            throw new DeliveryOptionsBuilderException(I18NCode.MSG_CREATE_ERROR);
        }
        DeliveryOptionMemoPart body = new DeliveryOptionMemoPart();
        body.setName(DeliveryOptionEnum.memoPart);
        body.setValue(result);
        this.m_deliveryOptions.add(body);
        SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug("Finished building body");
    }

    public Object[] getAttachments() {
        return this.m_attachments.toArray();
    }

    public DeliveryOption[] getDeliveryOptions() {
        HashMap<DeliveryOptionEnum, Object> delivOptionsMap = new HashMap<DeliveryOptionEnum, Object>();
        ArrayList<Object> delivOptionsList = new ArrayList<Object>();
        for (DeliveryOption option : this.m_deliveryOptions) {
            if (!(option instanceof DeliveryOptionSearchPathMultipleObjectArray)) {
                delivOptionsList.add(option);
                continue;
            }
            if (delivOptionsMap.containsKey(option.getName())) {
                delivOptionsMap.put(option.getName(), this.mergeCmOptions((DeliveryOptionSearchPathMultipleObjectArray)option, (DeliveryOptionSearchPathMultipleObjectArray)delivOptionsMap.get(option.getName())));
                continue;
            }
            delivOptionsMap.put(option.getName(), option);
        }
        delivOptionsList.addAll(delivOptionsMap.values());
        return delivOptionsList.toArray(new DeliveryOption[delivOptionsList.size()]);
    }

    private DeliveryOptionSearchPathMultipleObjectArray mergeCmOptions(DeliveryOptionSearchPathMultipleObjectArray one, DeliveryOptionSearchPathMultipleObjectArray two) {
        DeliveryOptionSearchPathMultipleObjectArray merged;
        if (one == null || two == null || !one.getName().equals((Object)two.getName())) {
            merged = one;
        } else {
            SearchPathMultipleObject[] sps1 = one.getValue();
            SearchPathMultipleObject[] sps2 = two.getValue();
            SearchPathMultipleObject[] spsMerged = new SearchPathMultipleObject[sps1.length + sps2.length];
            System.arraycopy(sps1, 0, spsMerged, 0, sps1.length);
            System.arraycopy(sps2, 0, spsMerged, sps1.length, sps2.length);
            one.setValue(spsMerged);
            merged = one;
        }
        return merged;
    }

    public void setPartition(ResultSetPartition partition) {
        this.m_deliveryOptions.clear();
        this.m_attachments.clear();
        this.m_partition = partition;
    }

    public String getSubject() {
        return this.m_subject == null ? "" : this.m_subject;
    }

    public String getRecipients() {
        return this.m_recipients.toString();
    }

    public static boolean usesEventOutput(Option[] options) {
        boolean uses = false;
        if (options == null) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_TASK_OPTIONS_NULL);
        }
        for (int i = 0; options != null && !uses && i < options.length; ++i) {
            DeliveryOptionMemoPart dom;
            DeliveryOption deliveryOption;
            if (!(options[i] instanceof DeliveryOption) || !(deliveryOption = (DeliveryOption)options[i]).getName().equals((Object)DeliveryOptionEnum.memoPart) || !((dom = (DeliveryOptionMemoPart)deliveryOption).getValue() instanceof MemoPartComposite)) continue;
            uses = ResultSetDeliveryOptionsBuilder.hasEventOutputAttachment((MemoPartComposite)dom.getValue());
        }
        return uses;
    }

    private static boolean hasEventOutputAttachment(MemoPartComposite composite) {
        boolean has = false;
        MemoPart[] parts = composite.getParts();
        for (int i = 0; i < parts.length; ++i) {
            MemoPartAgentObject mpao;
            if (parts[i] instanceof MemoPartComposite) {
                has = ResultSetDeliveryOptionsBuilder.hasEventOutputAttachment((MemoPartComposite)parts[i]);
                continue;
            }
            if (!(parts[i] instanceof MemoPartAgentObject) || !EVENT_OUTPUT_ID.equals((mpao = (MemoPartAgentObject)parts[i]).getSearchPath().get_value())) continue;
            has = true;
            break;
        }
        return has;
    }

    private void process(Option[] option) {
        if (option == null) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, I18NCode.MSG_TASK_OPTIONS_NULL);
        }
        for (int i = 0; null != option && i < option.length; ++i) {
            DeliveryOptionSearchPathMultipleObjectArray cm_recipients;
            DeliveryOptionAddressSMTPArray external_recipients;
            if (!(option[i] instanceof DeliveryOption)) continue;
            DeliveryOption deliveryOption = (DeliveryOption)option[i];
            if (deliveryOption.getName().equals((Object)DeliveryOptionEnum.subject)) {
                DeliveryOptionString subject = (DeliveryOptionString)deliveryOption;
                this.m_subject = subject.getValue();
                continue;
            }
            if (deliveryOption.getName().equals((Object)DeliveryOptionEnum.toAddress)) {
                external_recipients = (DeliveryOptionAddressSMTPArray)deliveryOption;
                this.m_to_address_smtps = external_recipients.getValue();
                this.buildRecipients(this.m_to_address_smtps);
                continue;
            }
            if (deliveryOption.getName().equals((Object)DeliveryOptionEnum.to)) {
                cm_recipients = (DeliveryOptionSearchPathMultipleObjectArray)deliveryOption;
                this.m_to_cm_paths = cm_recipients.getValue();
                this.buildRecipients(this.m_to_cm_paths);
                continue;
            }
            if (deliveryOption.getName().equals((Object)DeliveryOptionEnum.ccAddress)) {
                external_recipients = (DeliveryOptionAddressSMTPArray)deliveryOption;
                this.m_cc_address_smtps = external_recipients.getValue();
                this.buildRecipients(this.m_cc_address_smtps);
                continue;
            }
            if (deliveryOption.getName().equals((Object)DeliveryOptionEnum.cc)) {
                cm_recipients = (DeliveryOptionSearchPathMultipleObjectArray)deliveryOption;
                this.m_cc_cm_paths = cm_recipients.getValue();
                this.buildRecipients(this.m_cc_cm_paths);
                continue;
            }
            if (deliveryOption.getName().equals((Object)DeliveryOptionEnum.bccAddress)) {
                external_recipients = (DeliveryOptionAddressSMTPArray)deliveryOption;
                this.m_bcc_address_smtps = external_recipients.getValue();
                this.buildRecipients(this.m_bcc_address_smtps);
                continue;
            }
            if (deliveryOption.getName().equals((Object)DeliveryOptionEnum.bcc)) {
                cm_recipients = (DeliveryOptionSearchPathMultipleObjectArray)deliveryOption;
                this.m_bcc_cm_paths = cm_recipients.getValue();
                this.buildRecipients(this.m_bcc_cm_paths);
                continue;
            }
            if (!deliveryOption.getName().equals((Object)DeliveryOptionEnum.memoPart)) continue;
            DeliveryOptionMemoPart dom = (DeliveryOptionMemoPart)deliveryOption;
            try {
                this.m_bodyMemoPart = (DeliveryOptionMemoPart)ObjectCopyUtil.deepCopy((Object)dom);
                continue;
            }
            catch (Exception ex) {
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug((Throwable)ex);
            }
        }
    }

    private MemoPart buildBodyParts(MemoPart mpc) throws DeliveryOptionsBuilderException {
        MemoPart generatedResult = null;
        if (mpc instanceof MemoPartComposite) {
            MemoPartComposite composite = (MemoPartComposite)mpc;
            MemoPart[] mps = composite.getParts();
            ArrayList<MemoPart> resultList = new ArrayList<MemoPart>(mps.length);
            for (int j = 0; j < mps.length; ++j) {
                MemoPart result = this.extractParts(mps[j]);
                if (result == null) continue;
                resultList.add(result);
            }
            MemoPartComposite processedComposite = new MemoPartComposite();
            processedComposite.setContentDisposition(composite.getContentDisposition());
            processedComposite.setContentType(composite.getContentType());
            processedComposite.setParts(resultList.toArray(new MemoPart[0]));
            generatedResult = processedComposite;
        } else {
            generatedResult = this.extractParts(mpc);
        }
        return generatedResult;
    }

    private MemoPart extractParts(MemoPart mps) throws DeliveryOptionsBuilderException {
        MemoPart processedMemoPart = mps;
        ResultSetPartition partition = this.m_partition;
        if (partition.isEmpty()) {
            Locale locale = LocaleUtil.getLocale((String)this.m_headers.getUserPreferenceContentLocale());
            String defaultValue = I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_NO_DATA, null, (Locale)LocaleUtil.createContentLocale((String)locale.toString()));
            partition = ResultSetNoEvents.getResultSetPartition(this.m_partition, locale, defaultValue);
        }
        if (mps instanceof MemoPartMIMEAttachment) {
            MemoPartMIMEAttachment mpma = (MemoPartMIMEAttachment)mps;
            if (mpma.getDataType().equals("text/html") && mpma.getContentDisposition().equals((Object)SmtpContentDispositionEnum.inline)) {
                try {
                    processedMemoPart = mpma;
                    String htmlBody = "";
                    if (mpma.getData() != null) {
                        int dataSize = mpma.getData().length;
                        if (DataSizeChecker.isAttachmentSizeOKASV((long)dataSize)) {
                            htmlBody = new String(mpma.getData(), "UTF-8");
                        } else {
                            mpma.setData(new byte[0]);
                            mpma.setDataSize(BigInteger.valueOf(dataSize));
                        }
                    }
                    if (htmlBodyTagstart.matcher(htmlBody).matches() && htmlBodyTagstop.matcher(htmlBody).matches()) {
                        XHTMLSAXHandler handler = new XHTMLSAXHandler();
                        XHTML XHTML_processor = new XHTML(new StringReader(htmlBody), handler);
                        XHTML_processor.parse();
                        XHTMLTag messageRootNode = handler.getRoot();
                        messageRootNode.visit(new XHTML_HTMLVisitor(partition, ResultSetTypeEnum.HTML));
                        String generated_body = ((XHTMLNode)messageRootNode).getText(new HTMLEncodeFormatter(), new HTMLDecodeFormatter()).getText();
                        MemoPartMIMEAttachment mimeAttachment = new MemoPartMIMEAttachment();
                        mimeAttachment.setContentDisposition(mpma.getContentDisposition());
                        mimeAttachment.setDataType(mpma.getDataType());
                        mimeAttachment.setData(generated_body.getBytes("UTF-8"));
                        processedMemoPart = mimeAttachment;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.INFO, (Throwable)e);
                }
            }
        } else if (mps instanceof MemoPartString) {
            String messageBody = ((MemoPartString)mps).getText();
            ResultSetMessageBuilder message_builder = new ResultSetMessageBuilder(partition, ResultSetTypeEnum.HTML, messageBody);
            String generated_body = message_builder.getMessage();
            processedMemoPart = new MemoPartString();
            try {
                int size = generated_body.getBytes("UTF-8").length;
                if (!DataSizeChecker.isAttachmentSizeOKASV((long)size)) {
                    generated_body = "?oversizemarker?" + size;
                }
            }
            catch (UnsupportedEncodingException e) {
                SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.INFO, (Throwable)e);
            }
            ((MemoPartString)processedMemoPart).setText(generated_body);
            processedMemoPart.setContentDisposition(mps.getContentDisposition());
        } else if (mps instanceof MemoPartObject) {
            processedMemoPart = mps;
        } else if (mps instanceof MemoPartComposite) {
            processedMemoPart = this.buildBodyParts(mps);
        } else if (mps instanceof MemoPartAgentObject) {
            processedMemoPart = this.buildMemoPartObject((MemoPartAgentObject)mps);
        } else if (mps instanceof MemoPartObjectLinks) {
            processedMemoPart = mps;
            this.validateLinks(((MemoPartObjectLinks)mps).getLinks());
        } else if (mps instanceof MemoPartAgentObjectLinks) {
            processedMemoPart = mps;
            this.validateLinks(((MemoPartAgentObjectLinks)mps).getLinks());
        }
        return processedMemoPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateLinks(ObjectLink[] links) throws DeliveryOptionsBuilderException {
        for (int i = 0; i < links.length; ++i) {
            if (links[i] == null || links[i].getSearchPath() == null) continue;
            SearchPathSingleObject linkPath = links[i].getSearchPath();
            PropEnum[] queryProps = new PropEnum[]{PropEnum.searchPath, PropEnum.uri};
            ContentManagerServiceClientPort cmPort = null;
            try {
                String uri;
                URL url;
                AnyURIProp uriProp;
                cmPort = Client.instance().getContentManagerServiceClient(this.m_headers);
                QueryRequest theRequest = new QueryRequest();
                theRequest.setSearch(linkPath.get_value());
                theRequest.setProperties(queryProps);
                BaseClass reply = cmPort.query(theRequest);
                if (!(reply instanceof URL) || null == (uriProp = (url = (URL)reply).getUri()) || CafUtilities.isValidURL((String)(uri = uriProp.getValue()))) continue;
                throw new DeliveryOptionsBuilderException(AsvI18NCode.MSG_ASV_URL_LINK_NOT_VALID, new Object[]{uri}, null, SeverityEnum.error);
            }
            catch (EMFSecurityException eMFSecurityException) {
                continue;
            }
            catch (SDKClientException sDKClientException) {
                continue;
            }
            finally {
                if (cmPort != null) {
                    cmPort.close();
                }
            }
        }
    }

    private MemoPart buildMemoPartObject(MemoPartAgentObject mpao) {
        MemoPartAgentObject mp;
        block23: {
            mp = null;
            SearchPathSingleObject searchPath = mpao.getSearchPath();
            BaseStepObjectContainer container = this.getParentTasksContainer(this.m_parent);
            BaseAgent baseAgent = null;
            if (container instanceof BaseAgent) {
                baseAgent = (BaseAgent)container;
            }
            if (EVENT_OUTPUT_ID.equals(searchPath.get_value()) && baseAgent.getEventOutput() != null) {
                try {
                    if (baseAgent != null && this.m_notPreview) {
                        byte[] agentEventOutputData;
                        MemoPartMIMEAttachment mpma = new MemoPartMIMEAttachment();
                        String filename = baseAgent.getEventOutput().getName();
                        mpma.setName(filename);
                        if (baseAgent.getEventOutput() != null && baseAgent.getEventOutput() != null && (agentEventOutputData = IOUtils.toByteArray((InputStream)baseAgent.getEventOutput().getInputStream())) != null) {
                            int dataSizeInt = agentEventOutputData.length;
                            if (!DataSizeChecker.isAttachmentSizeOKASV((long)dataSizeInt)) {
                                mpma.setData(new byte[0]);
                                mpma.setDataSize(BigInteger.valueOf(dataSizeInt));
                            } else {
                                mpma.setData(agentEventOutputData);
                                mpma.setDataSize(BigInteger.valueOf(dataSizeInt));
                            }
                        }
                        mpma.setContentDisposition(SmtpContentDispositionEnum.attachment);
                        mpma.setDataType(baseAgent.getEventOutput().getContentType());
                        mp = mpma;
                        break block23;
                    }
                    mp = mpao;
                }
                catch (IOException e) {
                    SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, (Throwable)e);
                }
            } else {
                BaseAgentTaskTarget attachedTarget = this.getAttachedTarget(searchPath);
                if (attachedTarget != null) {
                    String locale;
                    String format;
                    String reportSPVarName = null;
                    if (this.m_notPreview) {
                        reportSPVarName = this.replaceSearchPathForTSE(mpao, attachedTarget);
                    }
                    if ((format = mpao.getFormat()) == null || format.length() == 0) {
                        BaseClass targetBaseClass = attachedTarget.getBaseClass();
                        if (targetBaseClass instanceof BasePowerPlay8Report) {
                            format = "PDF";
                            mpao.setFormat(format);
                        } else {
                            try {
                                format = LocaleUtil.getUserPreference((String)"format", (BiBusHeader)this.m_headers.getBiBusHeader());
                                mpao.setFormat(format);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                    if (format != null && format.equalsIgnoreCase("HTML")) {
                        format = "MHT";
                        if (this.m_notPreview) {
                            mpao.setFormat(format);
                        }
                    }
                    if ((locale = mpao.getLocale()) == null || locale.length() == 0) {
                        try {
                            locale = this.m_headers.getUserPreferenceContentLocale();
                            mpao.setLocale(locale);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (mpao.getName() == null || mpao.getName().equals("")) {
                        String reportName = attachedTarget.getTargetName(mpao.getLocale());
                        reportName = reportName + "_" + locale;
                        reportName = reportName + "." + format;
                        mpao.setName(reportName);
                    }
                    if (reportSPVarName != null && !this.reportVariables.containsKey(reportSPVarName)) {
                        SetParameterCmdSpec setSPParameterCmd = new SetParameterCmdSpec(baseAgent.getParentTaskID(), reportSPVarName, reportSPVarName, null);
                        this.reportVariables.put(reportSPVarName, setSPParameterCmd);
                    }
                    attachedTarget.addDependentStepId(this.m_memoStoreId);
                }
                mp = mpao;
            }
        }
        return mp;
    }

    private String replaceSearchPathForTSE(MemoPartAgentObject mpao, BaseAgentTaskTarget attachedTarget) {
        String reportSPVarName = null;
        if (!attachedTarget.SaveReportPathCmdExistsForTaskID()) {
            reportSPVarName = attachedTarget.saveOutputToVariable();
        } else {
            SaveReportPathCmdSpec savedSpec = attachedTarget.getSaveReportPathCmdForTaskID();
            reportSPVarName = savedSpec.reportVar;
        }
        SearchPathSingleObject spso = new SearchPathSingleObject();
        spso.set_value("?" + reportSPVarName + "?");
        mpao.setSearchPath(spso);
        return reportSPVarName;
    }

    public CmdSpec[] getReportVariables() {
        return this.reportVariables.values().toArray(new CmdSpec[0]);
    }

    private BaseAgentTaskTarget getAttachedTarget(SearchPathSingleObject searchPath) {
        BaseAgentTaskTarget agentTaskTarget = null;
        if (null != this.m_parent) {
            List<BaseStepObject> steps = this.getParentTasksContainer(this.m_parent).getSubSteps();
            for (BaseStepObject step : steps) {
                if (!(step instanceof AgentTask)) continue;
                AgentTask taskStep = (AgentTask)step;
                if (!searchPath.get_value().equals(taskStep.getSearchPathStoreID()) && !searchPath.get_value().equals(taskStep.getSearchPath()) && !searchPath.get_value().equals(taskStep.getBaseClass().getDefaultName().getValue())) continue;
                List<BaseStepObject> targets = taskStep.getSubSteps();
                BaseStepObject obj = targets.get(0);
                agentTaskTarget = (BaseAgentTaskTarget)obj;
                break;
            }
        }
        return agentTaskTarget;
    }

    private BaseStepObjectContainer getParentTasksContainer(BaseStepObject parent) {
        return (BaseStepObjectContainer)parent.getParent();
    }

    private void buildRecipients(Object[] addresses) {
        block3: {
            block2: {
                if (!(addresses instanceof SearchPathMultipleObject[])) break block2;
                for (int i = 0; i < addresses.length; ++i) {
                    SearchPathMultipleObject searchPath = (SearchPathMultipleObject)addresses[i];
                    String value = searchPath.get_value();
                    if (value == null) continue;
                    this.m_recipients.append(value);
                }
                break block3;
            }
            if (!(addresses instanceof AddressSMTP[])) break block3;
            for (int i = 0; i < addresses.length; ++i) {
                AddressSMTP address = (AddressSMTP)addresses[i];
                String value = address.get_value();
                if (null == value) continue;
                this.m_recipients.append(value);
            }
        }
    }

    private DeliveryOptionSearchPathMultipleObjectArray buildCMRecipientList(SearchPathMultipleObject[] cm_paths, DeliveryOptionEnum name) {
        DeliveryOptionSearchPathMultipleObjectArray cm_recipients = new DeliveryOptionSearchPathMultipleObjectArray();
        cm_recipients.setName(name);
        SearchPathMultipleObject[] paths = new SearchPathMultipleObject[cm_paths.length];
        cm_recipients.setValue(paths);
        for (int i = 0; i < cm_paths.length; ++i) {
            String actualEmail = this.getActualEmail(cm_paths[i].get_value());
            paths[i] = new SearchPathMultipleObject();
            paths[i].set_value(actualEmail);
        }
        SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug("Building Content Manager recipients: " + name.getValue());
        this.m_deliveryOptions.add(cm_recipients);
        return cm_recipients;
    }

    private void buildExternalRecipientList(AddressSMTP[] addresses, DeliveryOptionEnum name) {
        ArrayList<AddressSMTP> ext_addresses = new ArrayList<AddressSMTP>();
        ArrayList<SearchPathMultipleObject> searchPathAddresses = new ArrayList<SearchPathMultipleObject>();
        for (int i = 0; i < addresses.length; ++i) {
            String email = this.getActualEmail(addresses[i].get_value());
            if (email == null || email.length() <= 0) continue;
            if (this.isCamAddress(email)) {
                SearchPathMultipleObject spmo = new SearchPathMultipleObject();
                spmo.set_value(email);
                searchPathAddresses.add(spmo);
                continue;
            }
            AddressSMTP smtpAdd = new AddressSMTP();
            smtpAdd.set_value(email);
            ext_addresses.add(smtpAdd);
        }
        if (!searchPathAddresses.isEmpty()) {
            DeliveryOptionSearchPathMultipleObjectArray cm_recipients = new DeliveryOptionSearchPathMultipleObjectArray();
            cm_recipients.setName(this.convertExternalToInternalName(name));
            cm_recipients.setValue(searchPathAddresses.toArray(new SearchPathMultipleObject[searchPathAddresses.size()]));
            SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug("Building dynamic internal recipients: " + name.getValue());
            this.m_deliveryOptions.add(cm_recipients);
        }
        if (!ext_addresses.isEmpty()) {
            DeliveryOptionAddressSMTPArray external_recipients = new DeliveryOptionAddressSMTPArray();
            external_recipients.setName(name);
            external_recipients.setValue(ext_addresses.toArray(new AddressSMTP[ext_addresses.size()]));
            SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug("Building external recipients: " + name.getValue());
            this.m_deliveryOptions.add(external_recipients);
        }
    }

    private DeliveryOptionEnum convertExternalToInternalName(DeliveryOptionEnum external) {
        DeliveryOptionEnum internal = null;
        if (DeliveryOptionEnum.toAddress.equals((Object)external)) {
            internal = DeliveryOptionEnum.to;
        } else if (DeliveryOptionEnum.ccAddress.equals((Object)external)) {
            internal = DeliveryOptionEnum.cc;
        }
        if (DeliveryOptionEnum.bccAddress.equals((Object)external)) {
            internal = DeliveryOptionEnum.bcc;
        }
        return internal;
    }

    private boolean isCamAddress(String address) {
        boolean isCam = false;
        if (address != null) {
            isCam = address.trim().startsWith(CAM_IDENTIFIER);
        }
        return isCam;
    }

    private String getActualEmail(String emailAddress) {
        ResultSetLineBuilder lineBuilder;
        String email = "";
        ResultSetPartition partition = this.m_partition;
        Locale locale = LocaleUtil.getLocale((String)this.m_headers.getUserPreferenceContentLocale());
        if (this.m_partition.isEmpty()) {
            String defaultValue = "";
            partition = ResultSetNoEvents.getResultSetPartition(this.m_partition, locale, defaultValue);
        }
        if ((lineBuilder = new ResultSetLineBuilder(partition, ResultSetTypeEnum.HTML, emailAddress)).isConstant()) {
            email = emailAddress;
        } else {
            ResultSetKey rsk;
            String rsLine;
            Iterator it = this.m_partition.getData();
            if (it.hasNext() && !(rsLine = lineBuilder.buildLine(rsk = (ResultSetKey)it.next())).equals(I18NUtil.getMessage((I18NCode)AgsI18NCode.MSG_AGS_NO_DATA, null, (Locale)LocaleUtil.createContentLocale((String)locale.toString())))) {
                email = rsLine;
            }
        }
        return email;
    }
}

