/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets.storedProcedureTask;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentMonitorUtil;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.PreviewResultHandler;
import com.cognos.asv.ResolveOptionsUtil;
import com.cognos.asv.TaskRun;
import com.cognos.asv.TaskRunInfo;
import com.cognos.asv.actions.AgentAction;
import com.cognos.asv.history.AgentHistoryDetail;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailQueryFrameworkOutput;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportStatus;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionInt;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.CAM;
import com.cognos.developer.schemas.bibus._3.CAMPassport;
import com.cognos.developer.schemas.bibus._3.Guid;
import com.cognos.developer.schemas.bibus._3.MetadataModelItemName;
import com.cognos.developer.schemas.bibus._3.MetadataModelItemNameProp;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryFrameworkSpecification;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.RunOptionBoolean;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.Specification;
import com.cognos.developer.schemas.bibus._3.StoredProcedureTask;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.jsmcommon.event.EventStatus;
import com.cognos.jsmcommon.event.EventStatusUtil;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.i18n.LocalizableException;
import com.cognos.jsmcommon.lock.ResourceLock;
import com.cognos.jsmcommon.lock.ResourceLockException;
import com.cognos.jsmcommon.lock.database.SdsInstanceAwareResourceLockManager;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CMProperties;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.AsyncConversation;
import com.cognos.jsmcommon.soap.util.AsyncConversationStatusListener;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.JSMCommonCategory;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.SAXReader;

public class StoredProcedureTaskRunnable
extends BaseStepObject
implements AsyncConversationStatusListener {
    private static final String RUN_COMMAND = "update";
    private static final String VALIDATE_COMMAND = "validate";
    private int max_batched_updates;
    private static final int m_DEFAULT_BATCHED_UPDATES = 200;
    private AsyncConversation m_conversation = new AsyncConversation();

    public StoredProcedureTaskRunnable(StoredProcedureTask spTask, BaseStepObject parent, JobBiBusHeaders headers) {
        super((BaseClass)spTask, parent, headers);
    }

    public StoredProcedureTask getStoredProcedureTask() {
        return (StoredProcedureTask)this.getBaseClass();
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.m_conversation != null) {
            this.m_conversation.cancel();
        }
    }

    public void updateConversationStatus(AsynchReply reply, AsynchReplyStatusEnum status) throws LocalizableException {
        this.setStatus(EventStatusUtil.getEventStatus((AsynchReplyStatusEnum)status));
    }

    public void onConversationCancel() {
    }

    @Override
    public ParameterValue[] getParameters() {
        return this.getSubmitParameters();
    }

    @Override
    public Option[] getOptions() {
        return this.getStoredProcedureTask().getOptions() != null ? this.getStoredProcedureTask().getOptions().getValue() : new Option[]{};
    }

    @Override
    public void run(AgentAction action) throws AgentServiceException {
        if (this.isCancelled()) {
            this.setStatus(EventStatus.CANCELLED);
            return;
        }
        try {
            Option[] opt = ResolveOptionsUtil.resolveOptions(this);
            opt = OptionUtils.removeOption((Option[])opt, (String)RunOptionEnum.saveOutput.getValue());
            I18NMessage[] messages = this.execute(RUN_COMMAND, opt);
            AgentHistoryDetail detail = new AgentHistoryDetail(this);
            detail.addMessages(messages);
        }
        catch (SDKClientException e) {
            this.setStatus(EventStatus.FAILED);
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e});
        }
        catch (EMFSecurityException e) {
            this.setStatus(EventStatus.FAILED);
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e});
        }
        catch (AgentServiceException e) {
            this.setStatus(EventStatus.FAILED);
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e});
        }
        catch (Throwable t) {
            this.setStatus(EventStatus.FAILED);
            String msg = "[" + t.getClass().getName() + "] " + t.getLocalizedMessage();
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{msg}, t);
        }
    }

    @Override
    public void preview(PreviewResultHandler previewResult) throws AgentServiceException {
        TaskRunInfo taskRunInfo = new TaskRunInfo(ResolveOptionsUtil.resolveOptions(this), this.getParameters());
        previewResult.addTaskRun(new TaskRun((BaseStepObject)this, new TaskRunInfo[]{taskRunInfo}));
    }

    @Override
    public void validate(ValidationResultHandler validateResult) throws AgentServiceException {
        RunOptionBoolean prompt = new RunOptionBoolean();
        prompt.setName(RunOptionEnum.prompt);
        prompt.setValue(false);
        ArrayList<I18NMessage> validations = new ArrayList<I18NMessage>();
        AsynchOptionInt doNotWait = new AsynchOptionInt();
        doNotWait.setName(AsynchOptionEnum.primaryWaitThreshold);
        doNotWait.setValue(0);
        Option[] options = new Option[]{doNotWait, prompt};
        I18NMessage[] errors = this.validateProcName();
        if (errors.length > 0) {
            validations.addAll(Arrays.asList(errors));
        } else {
            try {
                validations.addAll(Arrays.asList(this.execute(VALIDATE_COMMAND, options)));
            }
            catch (SDKClientException e) {
                String msg = "[" + ((Object)((Object)e)).getClass().getName() + "] " + e.getLocalizedMessage();
                validations.add(new I18NMessage(AsvI18NCode.MSG_ASV_STORED_PROCEDURE_INVALID, new Object[]{msg}, SeverityEnum.warn));
            }
            catch (EMFSecurityException camEx) {
                String msg = "[" + ((Object)((Object)camEx)).getClass().getName() + "] " + camEx.getLocalizedMessage();
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_VALIDATION_FAIL, new Object[]{msg}, camEx, SeverityEnum.warn);
            }
            catch (AgentServiceException e) {
                String msg = "[" + ((Object)((Object)e)).getClass().getName() + "] " + e.getLocalizedMessage();
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_VALIDATION_FAIL, new Object[]{msg}, (Throwable)((Object)e), SeverityEnum.warn);
            }
            catch (Throwable t) {
                String msg = "[" + t.getClass().getName() + "] " + t.getLocalizedMessage();
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_VALIDATION_FAIL, new Object[]{msg}, t, SeverityEnum.warn);
            }
        }
        validateResult.addValidationMessages(validations.toArray(new I18NMessage[0]));
    }

    private I18NMessage[] execute(String command, Option[] options) throws EMFSecurityException, SDKClientException, AgentServiceException, Throwable {
        ArrayList responses = new ArrayList();
        QueryFrameworkSpecification spec = StoredProcedureTaskRunnable.getQueryFrameworkSpecReq(this.getHeaders(), this.getStoredProcedureTask(), command);
        ParameterValue[] taskParams = this.getParameters();
        int totalRowsCount = taskParams.length > 0 ? taskParams[0].getValue().length : 0;
        totalRowsCount = VALIDATE_COMMAND.equals(command) && totalRowsCount > 0 ? 1 : totalRowsCount;
        CRNProperties properites = CRNProperties.getInstance();
        this.max_batched_updates = 200;
        String batched_updates = null;
        batched_updates = properites.getProperty("max.batched.updates");
        if (batched_updates != null && batched_updates.length() > 0) {
            try {
                this.max_batched_updates = Integer.parseInt(batched_updates);
                this.max_batched_updates = this.max_batched_updates < 0 ? 200 : this.max_batched_updates;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ParameterValue[] runParams = new ParameterValue[taskParams.length];
        int row = 0;
        if (totalRowsCount == 0) {
            AsynchReply response = this.runProcedure(spec, runParams, options);
            responses = this.getResponse(response, command, new ArrayList());
        }
        while (row < totalRowsCount) {
            int runRows = totalRowsCount - row;
            if (runRows > this.max_batched_updates) {
                runRows = this.max_batched_updates;
            }
            for (int i = 0; i < taskParams.length; ++i) {
                ParmValueItem[] values = taskParams[i].getValue();
                ParmValueItem[] runValues = new ParmValueItem[runRows];
                for (int j = 0; j < runRows; ++j) {
                    runValues[j] = (SimpleParmValueItem)values[row + j];
                }
                runParams[i] = new ParameterValue();
                runParams[i].setName(taskParams[i].getName());
                runParams[i].setValue(runValues);
            }
            row += runRows;
            AsynchReply response = this.runProcedure(spec, runParams, options);
            responses = this.getResponse(response, command, responses);
        }
        return responses.toArray(new I18NMessage[0]);
    }

    private ArrayList getResponse(AsynchReply response, String command, ArrayList responses) throws AgentServiceException, Throwable {
        AsynchDetail[] details = response.getDetails();
        for (int k = 0; k < details.length; ++k) {
            AsynchDetailQueryFrameworkOutput detail;
            if (details[k] instanceof AsynchDetailQueryFrameworkOutput) {
                I18NMessage error;
                detail = (AsynchDetailQueryFrameworkOutput)details[k];
                if (!VALIDATE_COMMAND.equals(command) || detail == null || detail.getOutput() == null || detail.getOutput().get_value() == null || (error = this.getErrorMessage(detail.getOutput())) == null) continue;
                responses.add(error);
                continue;
            }
            if (!(details[k] instanceof AsynchDetailReportStatus) || (detail = (AsynchDetailReportStatus)details[k]).getStatus().getValue() != "prompting") continue;
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_STORED_PROCEDURE_LOGON_INVALID, new Object[0]);
        }
        return responses;
    }

    private I18NMessage getErrorMessage(XmlEncodedXML xml) throws Throwable {
        SAXReader reader = new SAXReader();
        StringReader xmlReader = new StringReader(xml.get_value());
        Document doc = reader.read((Reader)xmlReader);
        Node responseNode = doc.selectSingleNode("/response/messageFolder/message[@code]");
        String response = responseNode != null ? responseNode.getStringValue() : null;
        return response == null ? null : new I18NMessage(AsvI18NCode.MSG_ASV_STORED_PROCEDURE_INVALID, new Object[]{response}, SeverityEnum.warn);
    }

    private I18NMessage[] validateProcName() {
        I18NMessage[] messages = new I18NMessage[]{};
        StoredProcedureTask procedure = this.getStoredProcedureTask();
        String procName = null;
        boolean invalid = false;
        if (procedure == null) {
            invalid = true;
        } else {
            MetadataModelItemNameProp mminp = procedure.getStoredProcedureName();
            if (mminp == null) {
                invalid = true;
            } else {
                MetadataModelItemName mmin = mminp.getValue();
                if (mmin == null) {
                    invalid = true;
                } else {
                    procName = mmin.get_value();
                    if (procName == null) {
                        invalid = true;
                    }
                }
            }
            if (!invalid) {
                BaseClassArrayProp bcap = procedure.getMetadataModel();
                if (bcap == null) {
                    bcap = procedure.getMetadataModelPackage();
                }
                if (null != bcap) {
                    BaseClass[] bcArray = bcap.getValue();
                    if (bcArray != null && bcArray.length > 0) {
                        StringProp searchPath = bcArray[0].getSearchPath();
                        if (searchPath == null) {
                            invalid = true;
                        }
                    } else {
                        invalid = true;
                    }
                } else {
                    invalid = true;
                }
            }
        }
        if (invalid) {
            messages = new I18NMessage[]{new I18NMessage(AsvI18NCode.MSG_ASV_STORED_PROCEDURE_INVALID, (Object[])new String[]{""}, SeverityEnum.error)};
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AsynchReply runProcedure(QueryFrameworkSpecification spec, ParameterValue[] params, Option[] options) throws LocalizableException {
        if (this.isCancelled()) {
            this.setStatus(EventStatus.CANCELLED);
            return null;
        }
        ResourceLock historyLock = null;
        String resource = this.getLockResourceKey(this.getStoreID());
        try {
            if (resource != null) {
                while (historyLock == null || !historyLock.isLocked()) {
                    try {
                        historyLock = SdsInstanceAwareResourceLockManager.instance().getResourceLock(resource);
                        historyLock.lock();
                    }
                    catch (ResourceLockException e) {
                        SDSLogger.getLogger((SDSCategory)JSMCommonCategory.AUDIT).debug((Throwable)e);
                    }
                }
            }
            AsynchReply asynchReply = AgentMonitorUtil.runSpecification(this.m_conversation, Client.ServiceEnum.BATCH_REPORT, spec, this.getHeaders(), this.getBaseClass(), params, options);
            return asynchReply;
        }
        finally {
            if (historyLock != null) {
                try {
                    historyLock.unlock();
                }
                catch (ResourceLockException e) {
                    SDSLogger.getLogger((SDSCategory)JSMCommonCategory.AUDIT).debug("error unlocking " + this.getStoreID().get_value());
                }
            }
        }
    }

    private String getLockResourceKey(Guid storeId) {
        boolean doLock = false;
        try {
            doLock = Boolean.valueOf(CRNProperties.getInstance().getProperty("advanced.history.write.lock"));
        }
        catch (PropertiesException propertiesException) {
            // empty catch block
        }
        if (doLock && storeId != null) {
            return storeId.get_value();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        BiBusHeader rawHeader = null;
        ICCLConfiguration icclconfig = CCLConfigurationFactory.createConfiguration();
        try {
            icclconfig.init();
        }
        catch (CCLConfigurationException e2) {
            e2.printStackTrace();
        }
        CRNProperties crnConfig = CRNProperties.getInstance();
        crnConfig.init(icclconfig);
        CMProperties cmConfig = CMProperties.getInstance();
        cmConfig.init(icclconfig);
        CAM cam = new CAM();
        rawHeader = new BiBusHeader();
        CAMPassport passport = new CAMPassport();
        passport.setId("110:a3987e7a-bd6d-11d9-a59a-aee4a3bc30b4:0003245715");
        cam.setCAMPassport(passport);
        rawHeader.setCAM(cam);
        JobBiBusHeaders headers = new JobBiBusHeaders(rawHeader);
        StoredProcedureTask spTask = null;
        ContentManagerServiceClientPort contentManager = null;
        try {
            contentManager = Client.instance().getContentManagerServiceClient(headers);
            BaseClass[] baseClasses = contentManager.query("/content/package[@name='go sales']/agentDefinition[@name='agent running prompted order details report']/storedProcedureTask[@name='new sql']", new PropEnum[]{PropEnum.storedProcedureName, PropEnum.metadataModel, PropEnum.searchPath, PropEnum.parameters, PropEnum.parameterAssignments, PropEnum.options}, new Sort[0], new QueryOptions());
            if (baseClasses != null && baseClasses.length == 1 && baseClasses[0].getSearchPath().getValue() != null) {
                spTask = (StoredProcedureTask)baseClasses[0];
            }
        }
        catch (SDKClientException e) {
            e.printStackTrace();
        }
        catch (EMFSecurityException e1) {
            e1.printStackTrace();
        }
        finally {
            if (contentManager != null) {
                contentManager.close();
            }
        }
        StoredProcedureTaskRunnable task = new StoredProcedureTaskRunnable(spTask, null, headers);
        try {
            ValidationResultHandler validateResult = new ValidationResultHandler(headers, SeverityEnum.warn);
            task.validate(validateResult);
            I18NMessage[] messages = validateResult.getMessages();
            if (messages != null && messages.length > 0) {
                System.out.println(messages[0].getMessage(Locale.getDefault()));
            } else {
                System.out.println("ok");
            }
            ParameterValue[] pv = task.getParameters();
            if (pv != null && pv.length > 0) {
                System.out.println(pv.toString());
            } else {
                System.out.println("No parameter values.");
            }
        }
        catch (AgentServiceException e) {
            System.out.println(e.getLocalizedMessage());
        }
    }

    public static QueryFrameworkSpecification getQueryFrameworkSpecReq(JobBiBusHeaders header, StoredProcedureTask procedure, String command) throws AgentServiceException {
        StringBuffer request = new StringBuffer();
        String QS_NAMESPACE = "http://developer.cognos.com/schemas/qf_xml_api/3/";
        String QS_FRAMEWORKSERVICE = "QueryFrameworkService";
        String CM_URI = null;
        try {
            CM_URI = CMProperties.getInstance().getProperty("contentManager");
        }
        catch (PropertiesException e) {
            throw new AgentServiceException(I18NCode.MSG_CONFIG_PROPERTY_EXCP, (Object[])new String[]{"contentManager"}, e);
        }
        String _locale = "en-us";
        if (procedure.getStoredProcedureName() == null || procedure.getStoredProcedureName().getValue() == null || procedure.getStoredProcedureName() != null && procedure.getStoredProcedureName().getValue().get_value().trim().length() < 1) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_STORED_PROCEDURE_INVALID, new String[]{procedure.getDefaultName().getValue()});
        }
        String procName = procedure.getStoredProcedureName().getValue().get_value();
        String procModel = null;
        if (procedure.getMetadataModel() != null && procedure.getMetadataModel().getValue() != null) {
            procModel = procedure.getMetadataModel().getValue()[0].getSearchPath().getValue();
        } else if (procedure.getMetadataModelPackage() != null && procedure.getMetadataModelPackage().getValue() != null) {
            procModel = procedure.getMetadataModelPackage().getValue()[0].getSearchPath().getValue() + "/model[last()]";
        }
        if (procModel == null) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_STORED_PROCEDURE_MODEL_INVALID, new String[]{procedure.getDefaultName().getValue()});
        }
        Document document = DocumentHelper.createDocument();
        Element commandElement = document.addElement(new QName("command", new Namespace("qs", QS_NAMESPACE)));
        Element connectionElement = commandElement.addElement("connection");
        Element dataSourceTypeElement = connectionElement.addElement("QFProviderType");
        dataSourceTypeElement.addAttribute("value", QS_FRAMEWORKSERVICE);
        Element runLocaleElement = connectionElement.addElement("runLocale");
        runLocaleElement.addAttribute("value", "en-us");
        Element productLocaleElement = connectionElement.addElement("productLocale");
        productLocaleElement.addAttribute("value", "en");
        try {
            Element camPassport = connectionElement.addElement("CAMPassport");
            String passport = header.getBiBusHeader().getCAM().getCAMPassport().getId();
            camPassport.addAttribute("value", passport);
        }
        catch (NullPointerException camPassport) {
            // empty catch block
        }
        Element cmURIElement = connectionElement.addElement("contentManagerURI");
        cmURIElement.addAttribute("value", CM_URI);
        Element updateElement = commandElement.addElement(command);
        Element updateSetElement = updateElement.addElement("updateSet");
        Element modelPathElement = updateSetElement.addElement("modelPath");
        modelPathElement.addText(procModel);
        Element updateSubjectElement = updateSetElement.addElement("updateSubject");
        updateSubjectElement.addAttribute("name", "subject1");
        updateSubjectElement.setText(procName);
        request.append(document.asXML());
        SDSLogger.getLogger((SDSCategory)ASVCategory.TRACE).debug(request.toString());
        QueryFrameworkSpecification queryspec = new QueryFrameworkSpecification();
        queryspec.setValue(new Specification(request.toString()));
        return queryspec;
    }
}

