/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets.webServiceTask;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.ASVComplexTypeHolder;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.IAGSWSDLConstants;
import com.cognos.asv.WSClassLoader;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.taskTargets.webServiceTask.ASVWebServiceResult;
import com.cognos.developer.schemas.bibus._3.AsynchOptionStringArray;
import com.cognos.developer.schemas.bibus._3.BaseParameter;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterCapabilityEnum;
import com.cognos.developer.schemas.bibus._3.ParameterDataTypeEnum;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.util.BiBusUtilities;
import com.cognos.jsmcommon.util.JAXPUtils;
import com.cognos.jsmcommon.util.TimeUtils;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import com.cognos.pogo.pdk.BIBusEnvelope;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.xml.WSDLLocator;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis.AxisFault;
import org.apache.axis.soap.SOAP11Constants;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.utils.XMLUtils;
import org.apache.axis.wsdl.toJava.Utils;
import org.apache.wsif.WSIFException;
import org.apache.wsif.WSIFMessage;
import org.apache.wsif.WSIFOperation;
import org.apache.wsif.WSIFPort;
import org.apache.wsif.WSIFService;
import org.apache.wsif.WSIFServiceFactory;
import org.apache.wsif.providers.ProviderUtils;
import org.apache.wsif.schema.Parser;
import org.apache.wsif.util.WSIFUtils;
import org.apache.wsif.wsdl.WSIFWSDLLocatorImpl;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ASVWebServiceRequest
implements IAGSWSDLConstants {
    private URL m_wsdlLocation;
    private Definition m_def;
    private String m_portName;
    private String m_serviceName;
    private String m_operationName;
    private Service m_service;
    private PortType m_portType;
    private Port m_port;
    private Input m_opInput = null;
    private Output m_opOutput = null;
    private String m_wsdlNamespace;
    private ArrayList m_complexTypes = new ArrayList();
    private String m_taskName;
    private Document m_doc;
    private Map instAtts;
    private Map instParams;

    public ASVWebServiceRequest(String taskName) {
        this.m_taskName = taskName;
    }

    public void validate(Map instAtts, Map instParams, ValidationResultHandler validateResult) throws AgentServiceException {
        try {
            this.initialiseRequest(instAtts, instParams);
            for (String name : instParams.keySet()) {
                if (!this.checkInstParamEmpty(instParams.get(name))) continue;
                validateResult.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_UNRESOLVED_PARAMETER, new Object[]{this.m_taskName, name}, SeverityEnum.warn));
            }
        }
        catch (Exception e) {
            validateResult.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_WS_MISSING_TARGET_ERROR, new Object[]{this.m_taskName}, SeverityEnum.warn));
        }
    }

    public boolean checkInstParamEmpty(Object param) {
        boolean isEmpty = true;
        if (param instanceof String) {
            isEmpty = "".equals(param);
        } else if (param instanceof String[]) {
            String[] straray = (String[])param;
            for (int i = 0; i < straray.length; ++i) {
                isEmpty = straray[i] == null || "".equals(straray[i]);
            }
        }
        return isEmpty;
    }

    public void initialiseRequest(Map instAtts, Map instParams) throws AgentServiceException {
        Service s;
        this.instAtts = instAtts;
        this.instParams = instParams;
        String target = (String)instAtts.get("target");
        if (target == null || target.length() == 0) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_WS_MISSING_TARGET_ERROR, new Object[]{this.m_taskName});
        }
        try {
            this.m_wsdlLocation = new URL(target);
        }
        catch (MalformedURLException e1) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_WS_URI_ERROR, new Object[]{this.m_taskName});
        }
        ClassLoader cl = this.getClass().getClassLoader();
        WSIFWSDLLocatorImpl loc = new WSIFWSDLLocatorImpl(null, this.m_wsdlLocation.toString(), cl);
        try {
            this.m_def = WSIFUtils.readWSDL(null, (String)this.m_wsdlLocation.toString());
        }
        catch (WSDLException e2) {
            Throwable t = e2.getTargetException();
            if (t instanceof ConnectException) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_WS_URI_ERROR, new Object[]{target});
            }
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_WS_MISSING_TARGET_ERROR, new Object[]{target});
        }
        catch (RuntimeException e3) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e3.getLocalizedMessage()});
        }
        this.m_portName = this.getParameter("portname", instParams);
        this.m_serviceName = this.getParameter("servicename", instParams);
        this.m_operationName = this.getParameter("operationname", instParams);
        int foundNewType = this.m_operationName.indexOf("_[opr]_");
        if (foundNewType > 0) {
            this.m_operationName = this.m_operationName.substring(0, foundNewType);
        }
        QName serviceQName = null;
        Map sm = WSIFUtils.getAllItems((Definition)this.m_def, (String)"Service");
        Iterator services = sm.values().iterator();
        while (services.hasNext() && !(serviceQName = (s = (Service)services.next()).getQName()).getLocalPart().equalsIgnoreCase(this.m_serviceName)) {
        }
        this.m_service = this.m_def.getService(serviceQName);
        if (this.m_service == null) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_WS_OPR_FAIL_ERROR, new Object[]{target});
        }
        Map ports = this.m_service.getPorts();
        if (ports.get(this.m_portName) == null) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_WS_OPR_FAIL_ERROR, new Object[]{target});
        }
        this.m_port = this.m_service.getPort(this.m_portName);
        if (this.m_port == null) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_WS_OPR_FAIL_ERROR, new Object[]{target});
        }
        Binding binding = this.m_port.getBinding();
        this.m_portType = binding.getPortType();
        List operations = this.m_portType.getOperations();
        Operation op2 = null;
        for (Operation op2 : operations) {
            if (op2.getName().compareToIgnoreCase(this.m_operationName) != 0) continue;
            this.m_opInput = op2.getInput();
            this.m_opOutput = op2.getOutput();
            this.m_wsdlNamespace = this.m_opInput.getMessage().getQName().getNamespaceURI();
            break;
        }
        if (op2 == null || this.m_opInput == null || this.m_opOutput == null) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_WS_OPR_ERROR, new Object[]{target});
        }
        try {
            Parser.getAllSchemaTypes((Definition)this.m_def, (List)this.m_complexTypes, (WSDLLocator)loc);
        }
        catch (WSIFException e1) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e1.getLocalizedMessage()});
        }
    }

    public ASVWebServiceResult execute(Reader body, boolean addRunContext) throws AgentServiceException {
        ASVWebServiceResult result;
        block32: {
            result = null;
            Class[] outTypes = null;
            String[] outNames = null;
            WSIFMessage output = null;
            try {
                List p;
                WSIFMessage input;
                QName roleQName;
                SOAP11Constants soapConstants;
                Element o;
                ByteArrayInputStream sourceStream2;
                org.w3c.dom.Document doc2;
                WSIFServiceFactory factory = WSIFServiceFactory.newInstance();
                factory.setFeature("org.apache.wsif.automaptypes", (Object)Boolean.TRUE);
                WSIFService dpf = factory.getService(this.m_def, this.m_service, this.m_portType);
                WSIFPort thePort = dpf.getPort(this.m_port.getName());
                WSIFOperation operation = thePort.createOperation(this.m_operationName, null, null);
                output = operation.createOutputMessage();
                WSIFMessage fault = operation.createFaultMessage();
                WSIFMessage m = operation.getContext();
                ArrayList<Element> soapHeader = new ArrayList<Element>();
                if (this.instAtts.get("BIBUS_HEADER") != null) {
                    BiBusHeader bibusHeader = (BiBusHeader)this.instAtts.get("BIBUS_HEADER");
                    try {
                        doc2 = this.getAsW3cDocument(bibusHeader);
                        Element headerElem = doc2.getDocumentElement();
                        SOAP11Constants soapConstants2 = SOAPConstants.SOAP11_CONSTANTS;
                        QName roleQName2 = soapConstants2.getRoleAttributeQName();
                        headerElem.setAttributeNS(roleQName2.getNamespaceURI(), roleQName2.getLocalPart(), "http://schemas.xmlsoap.org/soap/actor/next");
                        soapHeader.add(headerElem);
                    }
                    catch (Exception doc2) {
                        // empty catch block
                    }
                }
                if (this.instAtts.get("WSA_HEADER") != null) {
                    String wsaHeader = (String)this.instAtts.get("WSA_HEADER");
                    doc2 = null;
                    try {
                        sourceStream2 = new ByteArrayInputStream(wsaHeader.toString().getBytes("UTF-8"));
                        doc2 = XMLUtils.newDocument((InputStream)sourceStream2);
                        o = doc2.getDocumentElement();
                        soapConstants = SOAPConstants.SOAP11_CONSTANTS;
                        roleQName = soapConstants.getRoleAttributeQName();
                        o.setAttributeNS(roleQName.getNamespaceURI(), roleQName.getLocalPart(), "http://schemas.xmlsoap.org/soap/actor/next");
                        soapHeader.add(o);
                    }
                    catch (Exception sourceStream2) {
                        // empty catch block
                    }
                }
                if (this.instAtts.get("PREVIEW_HEADER") != null) {
                    String previewHeader = (String)this.instAtts.get("PREVIEW_HEADER");
                    doc2 = null;
                    try {
                        sourceStream2 = new ByteArrayInputStream(previewHeader.toString().getBytes("UTF-8"));
                        doc2 = XMLUtils.newDocument((InputStream)sourceStream2);
                        o = doc2.getDocumentElement();
                        soapConstants = SOAPConstants.SOAP11_CONSTANTS;
                        roleQName = soapConstants.getRoleAttributeQName();
                        o.setAttributeNS(roleQName.getNamespaceURI(), roleQName.getLocalPart(), "http://schemas.xmlsoap.org/soap/actor/next");
                        soapHeader.add(o);
                    }
                    catch (Exception sourceStream3) {
                        // empty catch block
                    }
                }
                if (addRunContext) {
                    Option[] option;
                    if (this.instAtts.get("CONTEXT_HEADER") != null && (option = (Option[])this.instAtts.get("CONTEXT_HEADER")) != null) {
                        StringBuffer event = new StringBuffer(1000);
                        String runContext = "runContext";
                        event.append("<" + runContext + ">");
                        for (int i = 0; i < option.length; ++i) {
                            String[] ids;
                            AsynchOptionStringArray aosa;
                            if (!(option[i] instanceof AsynchOptionStringArray) || (aosa = (AsynchOptionStringArray)option[i]).getName().getValue().compareToIgnoreCase(runContext) != 0 || (ids = aosa.getValue()) == null) continue;
                            for (int j = 0; j < ids.length; ++j) {
                                event.append("<id");
                                String number = Integer.toString(j + 1);
                                event.append(number);
                                event.append(">");
                                event.append(ids[j]);
                                event.append("</id");
                                event.append(number);
                                event.append(">");
                            }
                        }
                        event.append("</" + runContext + ">");
                        org.w3c.dom.Document doc3 = null;
                        try {
                            ByteArrayInputStream sourceStream4 = new ByteArrayInputStream(event.toString().getBytes("UTF-8"));
                            doc3 = XMLUtils.newDocument((InputStream)sourceStream4);
                            Element o2 = doc3.getDocumentElement();
                            SOAP11Constants soapConstants3 = SOAPConstants.SOAP11_CONSTANTS;
                            QName roleQName3 = soapConstants3.getRoleAttributeQName();
                            o2.setAttributeNS(roleQName3.getNamespaceURI(), roleQName3.getLocalPart(), "http://schemas.xmlsoap.org/soap/actor/next");
                            soapHeader.add(o2);
                        }
                        catch (ParserConfigurationException sourceStream4) {
                        }
                        catch (SAXException sourceStream4) {
                        }
                        catch (IOException sourceStream4) {
                            // empty catch block
                        }
                    }
                    if (soapHeader.size() > 0) {
                        m.setObjectPart("org.apache.wsif.soap.RequestHeaders", soapHeader);
                        operation.setContext(m);
                    }
                }
                if (operation.executeRequestResponseOperation(input = this.getInputMessageWithParameters(p = this.getInputParameters(this.instParams), operation), output, fault)) {
                    List parts = this.m_opOutput.getMessage().getOrderedParts(null);
                    int count = parts.size();
                    outNames = new String[count];
                    outTypes = new Class[count];
                    try {
                        ASVWebServiceRequest.retrieveSignature(parts, outNames, outTypes);
                    }
                    catch (ClassNotFoundException e) {
                        outNames = new String[]{"CannotHandleComplexResponse"};
                        outTypes = new Class[]{String.class};
                    }
                    result = new ASVWebServiceResult(outNames, outTypes, output);
                    break block32;
                }
                Object o3 = fault.getObjectPart("org.apache.wsif.soap.fault.object");
                String[] faultDetails = null;
                if (o3 != null && o3 instanceof AxisFault) {
                    AxisFault f = (AxisFault)((Object)o3);
                    Element[] e = f.getFaultDetails();
                    if (e != null) {
                        faultDetails = new String[e.length];
                        for (int i = 0; i < e.length; ++i) {
                            StringWriter out = new StringWriter();
                            try {
                                JAXPUtils.printNode((Node)e[i], (Writer)out, (boolean)true);
                                faultDetails[i] = out.toString();
                                continue;
                            }
                            catch (IOException e1) {
                                faultDetails[i] = "";
                            }
                        }
                    }
                } else {
                    Message wsdlFaultMsg = fault.getMessageDefinition();
                    Map parts = wsdlFaultMsg.getParts();
                    Part wsdlFaultPart = (Part)parts.values().iterator().next();
                    Element faultElement = (Element)fault.getObjectPart(wsdlFaultPart.getName());
                    StringWriter out = new StringWriter();
                    faultDetails = new String[1];
                    try {
                        JAXPUtils.printNode((Node)faultElement, (Writer)out, (boolean)true);
                        faultDetails[0] = out.toString();
                    }
                    catch (IOException e1) {
                        faultDetails[0] = "";
                    }
                }
                result = new ASVWebServiceResult(faultDetails);
            }
            catch (WSIFException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_WS_OPR_FAIL_ERROR, new Object[]{e}, SeverityEnum.warn);
            }
            catch (RuntimeException e) {
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_WS_OPR_FAILED_ERROR, new Object[]{e}, SeverityEnum.warn);
            }
        }
        return result;
    }

    private WSIFMessage getInputMessageWithParameters(List result, WSIFOperation operation) throws WSIFException, AgentServiceException {
        int resultLength;
        WSIFMessage m = operation.createInputMessage();
        int n = resultLength = result != null ? result.size() : 0;
        if (resultLength > 0) {
            List parts = this.m_doc.selectNodes("//Parameter");
            for (org.dom4j.Element x : parts) {
                String theName = x.attributeValue("Name");
                String type = x.attributeValue("Type");
                if (x.getName().compareToIgnoreCase("Parameter") != 0) continue;
                if (type.equalsIgnoreCase("int")) {
                    m.setIntPart(theName, Integer.parseInt(x.getStringValue()));
                    continue;
                }
                if (type.equalsIgnoreCase("integer")) {
                    m.setObjectPart(theName, (Object)new BigInteger(x.getStringValue()));
                    continue;
                }
                if (type.equalsIgnoreCase("float")) {
                    m.setFloatPart(theName, Float.parseFloat(x.getStringValue()));
                    continue;
                }
                if (type.equalsIgnoreCase("double")) {
                    m.setDoublePart(theName, Double.parseDouble(x.getStringValue()));
                    continue;
                }
                if (type.equalsIgnoreCase("boolean")) {
                    m.setBooleanPart(theName, Boolean.valueOf(x.getStringValue()).booleanValue());
                    continue;
                }
                if (type.equalsIgnoreCase("long")) {
                    m.setLongPart(theName, Long.parseLong(x.getStringValue()));
                    continue;
                }
                if (type.equalsIgnoreCase("string")) {
                    m.setObjectPart(theName, (Object)x.getStringValue());
                    continue;
                }
                if (type.equalsIgnoreCase("decimal")) {
                    m.setObjectPart(theName, (Object)new BigDecimal(x.getStringValue()));
                    continue;
                }
                if (type.equalsIgnoreCase("time") || type.equalsIgnoreCase("date") || type.equalsIgnoreCase("dateTime")) {
                    m.setObjectPart(theName, (Object)this.parseCalendarString(x.getStringValue()));
                    continue;
                }
                String thePackage = Utils.makePackageName((String)x.attributeValue("Namespace"));
                String fullyQualifiedClassName = type;
                if (thePackage == null || thePackage.length() <= 0) continue;
                fullyQualifiedClassName = fullyQualifiedClassName.substring(0, 1).toUpperCase() + fullyQualifiedClassName.substring(1);
                fullyQualifiedClassName = thePackage + "." + fullyQualifiedClassName;
                Class c = ASVWebServiceRequest.getClass(fullyQualifiedClassName);
                if (c == null) {
                    throw new AgentServiceException(AsvI18NCode.MSG_ASV_WS_PARAM_OBJ_NF_ERROR, new Object[]{fullyQualifiedClassName});
                }
                try {
                    Object fred = c.newInstance();
                    for (int jj = 0; jj < result.size(); ++jj) {
                        org.dom4j.Element y = (org.dom4j.Element)result.get(jj);
                        String fieldName = y.attributeValue("Name");
                        String fieldValue = y.getText();
                        String fieldType = y.attributeValue("Type");
                        this.updateField(fullyQualifiedClassName, c, fred, fieldName, fieldValue, fieldType);
                    }
                    m.setObjectPart(theName, fred);
                }
                catch (InstantiationException e) {
                    throw new WSIFException("(cannot instantiate class " + fullyQualifiedClassName + ")");
                }
                catch (IllegalAccessException e) {
                    throw new WSIFException("(cannot access class " + fullyQualifiedClassName + ")");
                }
            }
        }
        return m;
    }

    public BaseParameter[] createParameters(Map instAtts, Map instParams) throws AgentServiceException {
        this.initialiseRequest(instAtts, instParams);
        BaseParameter[] parameterResult = null;
        try {
            int resultLength;
            List result = this.getInputParameters(instParams);
            int n = resultLength = result != null ? result.size() : 0;
            if (resultLength > 0) {
                parameterResult = new BaseParameter[resultLength];
                for (int pos = 0; pos < resultLength; ++pos) {
                    org.dom4j.Element x = (org.dom4j.Element)result.get(pos);
                    com.cognos.developer.schemas.bibus._3.Parameter theParam = new com.cognos.developer.schemas.bibus._3.Parameter();
                    theParam.setName(this.getXPathName(x, null));
                    ParameterCapabilityEnum[] pce = new ParameterCapabilityEnum[]{ParameterCapabilityEnum.discreteValue};
                    theParam.setCapabilities(pce);
                    Attribute typeName = x.attribute("Type");
                    String type = typeName.getValue();
                    if (type.equalsIgnoreCase("int")) {
                        theParam.setType(ParameterDataTypeEnum.xsdInt);
                    } else if (type.equalsIgnoreCase("integer")) {
                        theParam.setType(ParameterDataTypeEnum.xsdInt);
                    } else if (type.equalsIgnoreCase("float")) {
                        theParam.setType(ParameterDataTypeEnum.xsdFloat);
                    } else if (type.equalsIgnoreCase("double")) {
                        theParam.setType(ParameterDataTypeEnum.xsdDouble);
                    } else if (type.equalsIgnoreCase("decimal")) {
                        theParam.setType(ParameterDataTypeEnum.xsdDecimal);
                    } else if (type.equalsIgnoreCase("boolean")) {
                        theParam.setType(ParameterDataTypeEnum.xsdShort);
                    } else if (type.equalsIgnoreCase("long")) {
                        theParam.setType(ParameterDataTypeEnum.xsdLong);
                    } else if (type.equalsIgnoreCase("time")) {
                        theParam.setType(ParameterDataTypeEnum.xsdTime);
                    } else if (type.equalsIgnoreCase("date")) {
                        theParam.setType(ParameterDataTypeEnum.xsdDate);
                    } else if (type.equalsIgnoreCase("dateTime")) {
                        theParam.setType(ParameterDataTypeEnum.xsdDateTime);
                    } else {
                        theParam.setType(ParameterDataTypeEnum.xsdString);
                    }
                    parameterResult[pos] = theParam;
                }
            }
        }
        catch (WSIFException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_WS_OPR_FAIL_ERROR, new Object[]{e});
        }
        return parameterResult;
    }

    private String getXPathName(org.dom4j.Element x, String name) {
        String result = name;
        if (null != x && null != x.attribute("Name")) {
            String simpleJava;
            String nodeName = x.attribute("Name") != null ? x.attribute("Name").getValue() : null;
            String string = simpleJava = x.attribute("SimpleJavaType") != null ? x.attribute("SimpleJavaType").getValue() : null;
            if (!(null == nodeName || simpleJava == null || nodeName.equals("parameters") && simpleJava.equals("false"))) {
                result = null != name ? nodeName + "/" + name : nodeName;
            }
            if (null != x.getParent()) {
                result = this.getXPathName(x.getParent(), result);
            }
        }
        return result;
    }

    private String getParameter(String name, Map instParams) {
        String[] values = (String[])instParams.get(name);
        if (values != null) {
            return values[0];
        }
        return "";
    }

    private List getInputParameters(Map instParams) throws AgentServiceException, WSIFException {
        int numInputParams;
        List items = this.getParametersAsList(this.m_opInput);
        int n = numInputParams = items != null ? items.size() : 0;
        if (numInputParams > 0) {
            for (org.dom4j.Element aParameter : items) {
                String id = aParameter.attributeValue("Name");
                if (aParameter.getName().compareTo("Parameter") != 0) {
                    org.dom4j.Element parent = aParameter.getParent();
                    while (parent.getName().compareTo("OPERATION") != 0) {
                        id = parent.attributeValue("Name") + "/" + id;
                        parent = parent.getParent();
                    }
                }
                aParameter.setText(this.getParameter(id, instParams));
            }
        }
        return items;
    }

    private List getParametersAsList(Input opInput) {
        List parts = opInput.getMessage().getOrderedParts(null);
        List items = null;
        try {
            this.unWrapIfWrappedDocLit(parts, this.m_operationName, this.m_def);
        }
        catch (WSIFException wSIFException) {
            // empty catch block
        }
        StringBuffer resultStartBuf = new StringBuffer(100);
        resultStartBuf.append("<?xml version=\"1.0\"?><OPERATION>");
        for (Part type : parts) {
            ASVComplexTypeHolder param = new ASVComplexTypeHolder(type, (List)this.m_complexTypes);
            param.appendParameter(resultStartBuf);
        }
        resultStartBuf.append("</OPERATION>");
        SAXReader reader = new SAXReader();
        StringReader xmlReader = new StringReader(resultStartBuf.toString());
        try {
            this.m_doc = reader.read((Reader)xmlReader);
            if (this.m_doc != null) {
                items = this.m_doc.selectNodes("//Parameter[@SimpleJavaType='true'] | //Datatype[@SimpleJavaType='true']");
            }
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
        return items;
    }

    private Date parseCalendarString(String theCalendarString) {
        Date date = null;
        date = TimeUtils.stringToDate((String)theCalendarString, null);
        if (date == null) {
            return new Date();
        }
        return date;
    }

    private static void retrieveSignature(List parts, String[] names, Class[] types) throws ClassNotFoundException {
        for (int i = 0; i < names.length; ++i) {
            Part part = (Part)parts.get(i);
            names[i] = part.getName();
            QName partType = part.getTypeName();
            if (partType == null) {
                partType = part.getElementName();
            }
            if (partType == null) {
                throw new RuntimeException("part " + names[i] + " must have type name declared");
            }
            String localClassName = partType.getLocalPart();
            if ("string".equals(localClassName)) {
                types[i] = String.class;
                continue;
            }
            if ("double".equals(localClassName)) {
                types[i] = Double.TYPE;
                continue;
            }
            if ("float".equals(localClassName)) {
                types[i] = Float.TYPE;
                continue;
            }
            if ("int".equals(localClassName)) {
                types[i] = Integer.TYPE;
                continue;
            }
            if ("boolean".equals(localClassName)) {
                types[i] = Boolean.TYPE;
                continue;
            }
            if ("time".equals(localClassName) || "date".equals(localClassName) || "dateTime".equals(localClassName)) {
                types[i] = Calendar.class;
                continue;
            }
            String thePackage = Utils.makePackageName((String)partType.getNamespaceURI());
            String fullyQualifiedClassName = localClassName = localClassName.substring(0, 1).toUpperCase() + localClassName.substring(1);
            if (thePackage == null || thePackage.length() <= 0) continue;
            fullyQualifiedClassName = thePackage + "." + fullyQualifiedClassName;
            Class c = ASVWebServiceRequest.getClass(fullyQualifiedClassName);
            if (c != null) {
                types[i] = c;
                continue;
            }
            throw new ClassNotFoundException(fullyQualifiedClassName);
        }
    }

    private void unWrapIfWrappedDocLit(List parts, String operationName, Definition def) throws WSIFException {
        List unWrappedParts;
        Part p = ProviderUtils.getWrapperPart((List)parts, (String)operationName);
        if (p != null && (unWrappedParts = ProviderUtils.unWrapPart((Part)p, (Definition)def)) != null && unWrappedParts.size() > 0) {
            parts.remove(p);
            parts.addAll(unWrappedParts);
        }
    }

    private org.w3c.dom.Document getAsW3cDocument(BiBusHeader biBusHeader) {
        org.w3c.dom.Document w3cDoc = null;
        BIBusEnvelope biBusEnv = BiBusUtilities.getHeadedEnvelope((BiBusHeader)biBusHeader);
        org.dom4j.Element headerElement = biBusEnv.getHeader();
        org.dom4j.Element biBusElement = (org.dom4j.Element)headerElement.selectSingleNode("//*[local-name()='biBusHeader']");
        String headerAsString = biBusElement.asXML();
        try {
            ByteArrayInputStream sourceStream = new ByteArrayInputStream(headerAsString.getBytes("UTF-8"));
            w3cDoc = XMLUtils.newDocument((InputStream)sourceStream);
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug((Throwable)e);
        }
        return w3cDoc;
    }

    private static Class getClass(String className) {
        Class c = null;
        try {
            WSClassLoader wcl = new WSClassLoader(new URL[0]);
            c = wcl.loadClass(className, false);
        }
        catch (Exception e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).debug((Throwable)e);
        }
        return c;
    }

    private void updateField(String fullyQualifiedClassName, Class c, Object fred, String fieldName, String fieldValue, String fieldType) throws IllegalAccessException, WSIFException {
        block18: {
            try {
                Method[] mm = c.getMethods();
                Method theMethod = null;
                for (int ii = 0; ii < mm.length; ++ii) {
                    if (mm[ii].getName().compareToIgnoreCase("set" + fieldName) != 0) continue;
                    theMethod = mm[ii];
                    break;
                }
                if (theMethod != null) {
                    if (fieldType.compareTo("string") == 0) {
                        theMethod.invoke(fred, fieldValue);
                    } else if (fieldType.compareTo("long") == 0) {
                        theMethod.invoke(fred, Long.valueOf(fieldValue));
                    } else if (fieldType.compareTo("double") == 0) {
                        theMethod.invoke(fred, Double.valueOf(fieldValue));
                    } else if (fieldType.compareTo("float") == 0) {
                        theMethod.invoke(fred, Float.valueOf(fieldValue));
                    } else if (fieldType.compareTo("int") == 0) {
                        theMethod.invoke(fred, Integer.valueOf(fieldValue));
                    } else if (fieldType.compareTo("boolean") == 0) {
                        theMethod.invoke(fred, Boolean.valueOf(fieldValue));
                    } else if (fieldType.compareTo("date") == 0 || fieldType.compareTo("dateTime") == 0) {
                        theMethod.invoke(fred, this.parseCalendarString(fieldValue));
                    }
                    break block18;
                }
                throw new WSIFException("(cannot update class " + fullyQualifiedClassName + " using 'set" + fieldName + "' method 1)");
            }
            catch (IllegalArgumentException e) {
                throw new WSIFException("(cannot update class " + fullyQualifiedClassName + " using 'set" + fieldName + "' method 2)");
            }
            catch (InvocationTargetException e) {
                throw new WSIFException("(cannot update class " + fullyQualifiedClassName + " using 'set" + fieldName + "' method 3)");
            }
        }
    }

    public static void main(String[] args) {
        String operation = "doSimpleOprWithPrimitiveTypes_[opr]_parameters.userId.fileName.datetime.integer.floatdata.stringdata.true_false.";
        int foundNewType = operation.indexOf("_[opr]_");
        if (foundNewType > 0) {
            operation = operation.substring(0, foundNewType);
        }
        System.out.println(operation);
    }

    public String getWsdlNamespace() {
        return this.m_wsdlNamespace;
    }

    public class Parameter {
        protected Object value;
        protected String name;

        public Parameter(String name_, Object value_) {
            this.name = name_;
            this.value = value_;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

