/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.taskTargets.webServiceTask;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.AgentPreviewBuilder;
import com.cognos.asv.AgentServiceException;
import com.cognos.asv.BaseStepObject;
import com.cognos.asv.IAGSWSDLConstants;
import com.cognos.asv.PreviewResultHandler;
import com.cognos.asv.ResolveOptionsUtil;
import com.cognos.asv.TaskRun;
import com.cognos.asv.TaskRunInfo;
import com.cognos.asv.actions.AgentAction;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.asv.taskTargets.webServiceTask.ASVWebServiceRequest;
import com.cognos.asv.taskTargets.webServiceTask.ASVWebServiceResult;
import com.cognos.developer.schemas.bibus._3.AnyURIProp;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionStringArray;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.EnvironmentVar;
import com.cognos.developer.schemas.bibus._3.HdrSession;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.UserPreferenceVar;
import com.cognos.developer.schemas.bibus._3.WebServiceTask;
import com.cognos.jsmcommon.i18n.I18NMessage;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLevel;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.property.CRNProperties;
import com.cognos.jsmcommon.property.PropertiesException;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.CafUtilities;
import com.cognos.jsmcommon.util.OptionUtils;
import com.cognos.jsmcommon.util.ValidationResultHandler;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

public class WebServiceTaskRunnable
extends BaseStepObject
implements IAGSWSDLConstants {
    public static final String AGS_WS_OPRN_CONST = "_[opr]_";
    public static String WS_ADDRESSING_HEADER_NAME = "US-ADDRESSING";
    private static final String HTTP_HOST = "HTTP_HOST";
    private static final String SERVER_NAME = "SERVER_NAME";
    private static final String SCRIPT_NAME = "SCRIPT_NAME";
    private static final String SERVER_PORT = "SERVER_PORT";
    private static final String HTS_WSDL = "http://www.ibm.com/xmlns/prod/cognos/internal/hts/createtask/rpc/_1";

    public WebServiceTaskRunnable(WebServiceTask webTask, BaseStepObject parent, JobBiBusHeaders headers) {
        super((BaseClass)webTask, parent, headers);
    }

    public WebServiceTask getWebDefintion() {
        return (WebServiceTask)this.getBaseClass();
    }

    @Override
    public ParameterValue[] getParameters() {
        int i;
        ParameterValue[] taskParams = this.getSubmitParameters();
        int totalRowsCount = 1;
        for (i = 0; i < taskParams.length; ++i) {
            int length = taskParams[i].getValue().length;
            if (length <= totalRowsCount) continue;
            totalRowsCount = length;
        }
        for (i = 0; i < taskParams.length; ++i) {
            ParmValueItem[] pvi = taskParams[i].getValue();
            if (pvi.length <= 0 || pvi.length >= totalRowsCount) continue;
            ParmValueItem[] npvi = new ParmValueItem[totalRowsCount];
            for (int j = 0; j < totalRowsCount; ++j) {
                npvi[j] = pvi[0];
            }
            taskParams[i].setValue(npvi);
        }
        return taskParams;
    }

    @Override
    public Option[] getOptions() {
        return this.getWebDefintion().getOptions() != null ? this.getWebDefintion().getOptions().getValue() : new Option[]{};
    }

    @Override
    public void preview(PreviewResultHandler previewResult) throws AgentServiceException {
        TaskRunInfo taskRunInfo = new TaskRunInfo(ResolveOptionsUtil.resolveOptions(this), this.getParameters());
        previewResult.addTaskRun(new TaskRun((BaseStepObject)this, new TaskRunInfo[]{taskRunInfo}));
    }

    @Override
    public void validate(ValidationResultHandler validateResult) throws AgentServiceException {
        I18NMessage[] errors = new I18NMessage[]{};
        try {
            this.validateAndRun(validateResult);
        }
        catch (AgentServiceException ase) {
            errors = new I18NMessage[]{new I18NMessage(ase.getI18NCode(), ase.getParams(), SeverityEnum.warn)};
        }
        validateResult.addValidationMessages(errors);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void validateAndRun(ValidationResultHandler validateResult) throws AgentServiceException {
        try {
            WebServiceTask wtask = this.getWebDefintion();
            String targetURL = null;
            AnyURIProp uriP = wtask.getUri();
            if (uriP == null) throw new MalformedURLException();
            URL url = new URL(uriP.getValue());
            targetURL = url.toString();
            if (!CafUtilities.isValidURL((String)targetURL)) {
                if (validateResult == null) throw new AgentServiceException(AsvI18NCode.MSG_ASV_WS_URI_INVALID, new Object[]{targetURL});
                validateResult.addValidationMessage(new I18NMessage(AsvI18NCode.MSG_ASV_WS_URI_INVALID, new Object[]{targetURL}, SeverityEnum.error));
            }
            BiBusHeader header = this.getHeaders().getBiBusHeader();
            String name = wtask.getDefaultName() != null ? wtask.getDefaultName().getValue() : "";
            ASVWebServiceRequest asvWebServiceReq = new ASVWebServiceRequest(name);
            HashMap<String, Object> wsifAttrMap = new HashMap<String, Object>();
            wsifAttrMap.put("BIBUS_HEADER", header);
            Option[] opt = ResolveOptionsUtil.resolveOptions(this);
            wsifAttrMap.put("CONTEXT_HEADER", opt);
            ASVWebServiceResult result = null;
            HashMap<String, String[]> wsifParmMap = new HashMap<String, String[]>();
            wsifAttrMap.put("target", targetURL);
            wsifParmMap.put("portname", new String[]{wtask.getBindingName().getValue()});
            wsifParmMap.put("servicename", new String[]{wtask.getServiceName().getValue()});
            String operation = wtask.getOperationName().getValue();
            int n = operation.indexOf(AGS_WS_OPRN_CONST);
            if (n > 0) {
                operation = operation.substring(0, n);
            }
            wsifParmMap.put("operationname", new String[]{operation});
            ParameterValue[] taskParams = this.getParameters();
            int noOfParams = taskParams.length;
            wsifParmMap.put("numberOfParameters", new String[]{String.valueOf(noOfParams)});
            int totalRowsCount = noOfParams > 0 ? taskParams[0].getValue().length : 1;
            for (int i = 0; i < totalRowsCount; ++i) {
                ParameterValue[] processedParameters = new ParameterValue[noOfParams];
                for (int j = 0; j < noOfParams; ++j) {
                    ParmValueItem[] values = taskParams[j].getValue();
                    SimpleParmValueItem item = (SimpleParmValueItem)values[i];
                    processedParameters[j] = new ParameterValue();
                    processedParameters[j].setName(taskParams[j].getName());
                    processedParameters[j].setValue(new ParmValueItem[]{item});
                    wsifParmMap.put(processedParameters[j].getName(), new String[]{item.getUse()});
                }
                if (validateResult != null) {
                    asvWebServiceReq.validate(wsifAttrMap, wsifParmMap, validateResult);
                    return;
                }
                asvWebServiceReq.initialiseRequest(wsifAttrMap, wsifParmMap);
                boolean addRunContext = true;
                if (this.isUserServiceCall(asvWebServiceReq, wsifParmMap)) {
                    String agentEventId = this.extractParentEventIDfromOptions(this.getSubmitOptions());
                    String eventId = this.extractEventIDfromOptions(this.getSubmitOptions());
                    wsifAttrMap.put("WSA_HEADER", this.generateWSAddressingHeader(eventId, agentEventId));
                    wsifAttrMap.put("PREVIEW_HEADER", this.getPreviewXML(agentEventId, (BiBusHeader)wsifAttrMap.get("BIBUS_HEADER")));
                } else {
                    addRunContext = this.includeRunContext();
                }
                result = asvWebServiceReq.execute(null, addRunContext);
                if (!result.isFaulted()) continue;
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_WS_OPR_FAILED_ERROR, new Object[]{result.getFault()});
            }
            return;
        }
        catch (Throwable e) {
            AgentServiceException ase = e instanceof AgentServiceException ? (AgentServiceException)((Object)e) : new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e});
            throw ase;
        }
    }

    private boolean includeRunContext() {
        boolean result = true;
        try {
            String booleanStr = CRNProperties.getInstance().getProperty("asv.webservice.useRunContext");
            result = Boolean.parseBoolean(booleanStr);
        }
        catch (Throwable t) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.WARN, AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{t.getMessage()});
        }
        return result;
    }

    private boolean isUserServiceCall(ASVWebServiceRequest asvWebServiceReq, HashMap wsifParamMap) throws AgentServiceException {
        return HTS_WSDL.equals(asvWebServiceReq.getWsdlNamespace());
    }

    private String generateWSAddressingHeader(String eventId, String agentEventId) throws PropertiesException {
        String urlString = CRNProperties.getInstance().getProperty("internalDispatcher");
        String responseAction = "http://www.ibm.com/xmlns/prod/cognos/internal/hts/_1";
        String addressingHeader = "<wsa:ReplyTo xmlns:ext='http://www.ibm.com/xmlns/prod/cognos/WS-HT/ext' xmlns:wsa='http://www.w3.org/2005/08/addressing' xmlns:ns1='" + responseAction + "'>" + "<wsa:Address>" + urlString + "</wsa:Address>" + "<wsa:ReferenceParameters>" + "<ns1:eventId>" + eventId + "</ns1:eventId>" + "<ns1:parentEventId>" + agentEventId + "</ns1:parentEventId>" + "</wsa:ReferenceParameters>" + "<wsa:Metadata>" + " <ext:responseAction>" + responseAction + "</ext:responseAction>" + "</wsa:Metadata>" + "</wsa:ReplyTo>";
        return addressingHeader;
    }

    private String getPreviewXML(String eventId, BiBusHeader header) {
        String previewXml = "";
        try {
            JobBiBusHeaders headers = new JobBiBusHeaders(header);
            AgentPreviewBuilder builder = new AgentPreviewBuilder(headers);
            previewXml = builder.getAgentPreview(eventId);
            previewXml = "<tsePreview>" + previewXml + "</tsePreview>";
        }
        catch (AgentServiceException e) {
            SDSLogger.getLogger((SDSCategory)ASVCategory.RUNTIME).log(SDSLevel.ERROR, AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e.getLocalizedMessage()});
        }
        return previewXml;
    }

    private String extractEventIDfromOptions(Option[] options) {
        AsynchOptionStringArray aosa;
        String[] ids;
        String eventID = null;
        Option o = OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)AsynchOptionEnum.runContext);
        if (o != null && o instanceof AsynchOptionStringArray && (ids = (aosa = (AsynchOptionStringArray)o).getValue()) != null && ids.length > 1) {
            eventID = ids[ids.length - 1];
        }
        return eventID;
    }

    private String extractParentEventIDfromOptions(Option[] options) {
        AsynchOptionStringArray aosa;
        String[] ids;
        String eventID = null;
        Option o = OptionUtils.findFirstOptionWithNameEnum((Option[])options, (Object)AsynchOptionEnum.runContext);
        if (o != null && o instanceof AsynchOptionStringArray && (ids = (aosa = (AsynchOptionStringArray)o).getValue()) != null && ids.length > 1) {
            int index = ids.length - 2 < 0 ? 0 : ids.length - 2;
            eventID = ids[index];
        }
        return eventID;
    }

    public static String getEnvVar(BiBusHeader header, String name) {
        String value = "";
        HdrSession hdrSession = header.getHdrSession();
        if (hdrSession != null) {
            EnvironmentVar[] envVars = hdrSession.getEnvironmentVars();
            for (int i = 0; i < envVars.length; ++i) {
                if (!envVars[i].getName().equals(name)) continue;
                value = envVars[i].getValue();
                break;
            }
        }
        return value;
    }

    public static void setUserPrefVar(BiBusHeader header, String name, String value) {
        UserPreferenceVar[] userPrefVars = header.getUserPreferenceVars();
        UserPreferenceVar[] userPrefVars2 = new UserPreferenceVar[userPrefVars.length + 1];
        System.arraycopy(userPrefVars, 0, userPrefVars2, 1, userPrefVars.length);
        userPrefVars2[0] = new UserPreferenceVar();
        userPrefVars2[0].setName(name);
        userPrefVars2[0].setValue(value);
        header.setUserPreferenceVars(userPrefVars2);
    }

    @Override
    public void run(AgentAction action) throws AgentServiceException {
        this.validateAndRun(null);
    }
}

