/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.util;

import com.cognos.asv.ASVCategory;
import com.cognos.asv.TaskRunInfo;
import com.cognos.asv.i18n.AgsI18NCode;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.ClassEnum;
import com.cognos.developer.schemas.bibus._3.DeliveryOption;
import com.cognos.developer.schemas.bibus._3.DeliveryOptionEnum;
import com.cognos.developer.schemas.bibus._3.MemoPartAgentObject;
import com.cognos.developer.schemas.bibus._3.ObjectLink;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryRequest;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.SmtpContentDispositionEnum;
import com.cognos.jsmcommon.i18n.I18NCode;
import com.cognos.jsmcommon.i18n.I18NUtil;
import com.cognos.jsmcommon.logging.SDSCategory;
import com.cognos.jsmcommon.logging.SDSLogger;
import com.cognos.jsmcommon.security.EMFSecurityException;
import com.cognos.jsmcommon.soap.client.Client;
import com.cognos.jsmcommon.soap.client.SDKClientException;
import com.cognos.jsmcommon.soap.client.ports.ContentManagerServiceClientPort;
import com.cognos.jsmcommon.soap.util.JobBiBusHeaders;
import com.cognos.jsmcommon.util.MemoOptionsBuilder;
import com.cognos.jsmcommon.util.ObjectModelUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class HumanTaskPreviewHelper {
    private DatatypeFactory m_dataTypeFactory;
    private String m_subject;
    private String m_htmlBodyText;
    private List<String> m_to;
    private List<String> m_cc;
    private String m_plainBodyText;
    private List<ParameterValue> m_parameters = new ArrayList<ParameterValue>();
    private Document m_document;
    private List<MemoPartAgentObject> m_attachments = new ArrayList<MemoPartAgentObject>();
    private List<ObjectLink> m_links = new ArrayList<ObjectLink>();
    private Locale m_productLocale;
    private JobBiBusHeaders m_headers;

    public HumanTaskPreviewHelper(Locale productLocale, JobBiBusHeaders headers) {
        this.m_productLocale = productLocale;
        this.m_headers = headers;
    }

    public void process(TaskRunInfo taskRunInfo) {
        Element humanTaskElement = null;
        this.m_document = this.getHumanTaskDocument(taskRunInfo);
        if (this.m_document != null) {
            this.addParameterValue("startFor", this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_START_DEADLINE), Date.class);
            this.addParameterValue("completeFor", this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_COMPLETE_DEADLINE), Date.class);
            this.processPriority();
            humanTaskElement = (Element)this.m_document.selectSingleNode("//*[local-name()='beplNotification']");
            if (humanTaskElement != null) {
                this.previewNotification(humanTaskElement);
            } else {
                humanTaskElement = (Element)this.m_document.selectSingleNode("//*[local-name()='beplTask']");
                if (humanTaskElement != null) {
                    this.previewApproval(humanTaskElement);
                }
            }
            this.processLinksAndattachments();
        }
        this.updateTaskRunInfo(taskRunInfo);
    }

    private void processPriority() {
        Element priority = (Element)this.m_document.selectSingleNode("//*[local-name()='beplNotification' or local-name()='beplTask']/*[local-name()='priority']");
        String value = "";
        if (priority != null) {
            int priorityInt = Integer.valueOf(priority.getStringValue());
            switch (priorityInt) {
                case 1: {
                    value = this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_PRIORITY_HIGH);
                    break;
                }
                case 3: {
                    value = this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_PRIORITY_NORMAL);
                    break;
                }
                case 5: {
                    value = this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_PRIORITY_LOW);
                    break;
                }
            }
            if (value.length() > 0) {
                SimpleParmValueItem parmValueItem = new SimpleParmValueItem(true, null, value);
                String localisedName = this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_PRIORITY);
                ParameterValue paramValue = new ParameterValue(localisedName, new ParmValueItem[]{parmValueItem});
                this.m_parameters.add(paramValue);
            }
        }
    }

    private void updateTaskRunInfo(TaskRunInfo taskRunInfo) {
        if (this.m_document != null) {
            MemoOptionsBuilder mb = new MemoOptionsBuilder();
            try {
                for (String toAddr : this.m_to) {
                    mb.addExternalAddress(toAddr, DeliveryOptionEnum.toAddress);
                }
                for (String ccAddr : this.m_cc) {
                    mb.addExternalAddress(ccAddr, DeliveryOptionEnum.ccAddress);
                }
                mb.addBody(this.m_subject, this.m_plainBodyText, this.m_htmlBodyText);
                taskRunInfo.setParameters(this.getParameters(), false);
                for (MemoPartAgentObject attachment : this.m_attachments) {
                    mb.addAttachment(attachment);
                }
                for (ObjectLink link : this.m_links) {
                    mb.addLink(link);
                }
                DeliveryOption[] options = mb.getOptionsArray();
                taskRunInfo.setOptions(options, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private ParameterValue[] getParameters() {
        return this.m_parameters.toArray(new ParameterValue[this.m_parameters.size()]);
    }

    private void previewNotification(Element notificationTask) {
        this.m_subject = this.getValueFromNode(notificationTask.selectSingleNode("//*[local-name()='manualTask']/*[local-name()='subject']"));
        this.m_htmlBodyText = this.getHTMLValueFromNode(notificationTask.selectSingleNode("//*[local-name()='manualTask']/*[local-name()='description' and @contentType='text/html']"));
        this.m_plainBodyText = this.getValueFromNode(notificationTask.selectSingleNode("//*[local-name()='manualTask']/*[local-name()='description' and @contentType='text/plain']"));
        this.m_to = this.getGroupsOrUsers((Node)notificationTask, "//*[local-name()='recipients']/*[local-name()='from']//*[local-name()='%PARAM1%']/*[local-name()='%PARAM2%']");
        this.m_cc = this.getGroupsOrUsers((Node)notificationTask, "//*[local-name()='taskStakeholders']/*[local-name()='from']//*[local-name()='%PARAM1%']/*[local-name()='%PARAM2%']");
        this.addParameterValue("recordReadReceipt", this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_RECORD_READ_RECEIPT), Boolean.class);
        this.addParameterValue("notifyOnCreation", this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_NOTIFY_ON_CREATION), Boolean.class);
    }

    private void previewApproval(Element approvalTask) {
        this.m_subject = this.getValueFromNode(approvalTask.selectSingleNode("//*[local-name()='manualTask']/*[local-name()='subject']"));
        this.m_htmlBodyText = this.getValueFromNode(approvalTask.selectSingleNode("//*[local-name()='manualTask']/*[local-name()='description' and @contentType='text/html']"));
        this.m_plainBodyText = this.getValueFromNode(approvalTask.selectSingleNode("//*[local-name()='manualTask']/*[local-name()='description' and @contentType='text/plain']"));
        this.m_to = this.getGroupsOrUsers((Node)approvalTask, "//*[local-name()='potentialOwners']/*[local-name()='from']//*[local-name()='%PARAM1%']/*[local-name()='%PARAM2%']");
        this.m_cc = this.getGroupsOrUsers((Node)approvalTask, "//*[local-name()='taskStakeholders']/*[local-name()='from']//*[local-name()='%PARAM1%']/*[local-name()='%PARAM2%']");
        this.addParameterValue("approveText", this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_APPROVE_TEXT), String.class);
        this.addParameterValue("rejectText", this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_REJECT_TEXT), String.class);
        this.addParameterValue("notifyOnCreation", this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_NOTIFY_ON_CREATION), Boolean.class);
        this.addParameterValue("notifyNotCompleted", this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_NOTIFY_NOT_COMPLETED), Boolean.class);
        this.addParameterValue("notifyNotStarted", this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_NOTIFY_NOT_STARTED), Boolean.class);
        this.addParameterValue("stateChangeStarted", this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_NOTIFY_STARTED), Boolean.class);
        this.addParameterValue("stateChangeOwner", this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_NOTIFY_OWNER_CHANGED), Boolean.class);
        this.addParameterValue("stateChangeSuspended", this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_NOTIFY_SUSPENDED), Boolean.class);
        this.addParameterValue("stateChangeCompleted", this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_NOTIFY_COMPLETED), Boolean.class);
        this.addParameterValue("stateChangeFailed", this.getMessage(AgsI18NCode.MSG_AGS_PREVIEW_NOTIFY_FAILED), Boolean.class);
    }

    private void processLinksAndattachments() {
        List attachmentNodes = this.m_document.selectNodes("//*[local-name()='manualTask']/*[local-name()='taskLinksList']/*[local-name()='taskLink']");
        for (Node node : attachmentNodes) {
            String attId = this.getValueFromNode(node.selectSingleNode("./*[local-name()='id']"));
            String attName = this.getValueFromNode(node.selectSingleNode("./*[local-name()='display']"));
            attName = attName == "" ? attId : attName;
            String attFormat = this.getValueFromNode(node.selectSingleNode("./*[local-name()='format']"));
            String attLocale = this.getValueFromNode(node.selectSingleNode("./*[local-name()='locale']"));
            MemoPartAgentObject attachment = new MemoPartAgentObject();
            attachment.setContentDisposition(SmtpContentDispositionEnum.attachment);
            attachment.setFormat(attFormat);
            attachment.setLocale(attLocale);
            attachment.setName(attName);
            attachment.setSearchPath(new SearchPathSingleObject(attId));
            this.m_attachments.add(attachment);
        }
        List linkNodes = this.m_document.selectNodes("//*[local-name()='manualTask']/*[local-name()='linksList']/*[local-name()='link']");
        for (Node node : linkNodes) {
            String linkId = this.getValueFromNode(node.selectSingleNode("./*[local-name()='id']"));
            String linkName = this.getValueFromNode(node.selectSingleNode("./*[local-name()='display']"));
            String linkClass = this.getValueFromNode(node.selectSingleNode("./*[local-name()='objectClass']"));
            ObjectLink link = new ObjectLink();
            link.setLabel(linkName);
            link.setObjectClass(ClassEnum.fromString((String)linkClass));
            link.setSearchPath(new SearchPathSingleObject(linkId));
            this.m_links.add(link);
        }
    }

    private void addParameterValue(String propName, String localisedName, Class theClass) {
        boolean addIt = true;
        ParameterValue paramValue = null;
        String xpath = ".//*[local-name()='manualTask']/*[local-name()='%PARAM1%']";
        Node propNode = this.m_document.selectSingleNode(xpath = xpath.replaceFirst("%PARAM1%", propName));
        if (propNode != null) {
            String value = propNode.getStringValue();
            if (theClass.equals(Boolean.class)) {
                addIt = Boolean.valueOf(value);
                value = Boolean.valueOf(value).toString();
            } else if (theClass.equals(Date.class)) {
                addIt = (value = this.getTimeFor(value)).length() > 0;
            }
            SimpleParmValueItem parmValueItem = new SimpleParmValueItem(true, null, value);
            paramValue = new ParameterValue(localisedName, new ParmValueItem[]{parmValueItem});
            if (addIt) {
                this.m_parameters.add(paramValue);
            }
        }
    }

    private List<String> getGroupsOrUsers(Node task, String xpathTemplate) {
        ArrayList<String> accounts = new ArrayList<String>();
        String userXpath = xpathTemplate.replaceAll("%PARAM1%", "users");
        List groupsOrUsers = task.selectNodes(userXpath = userXpath.replaceAll("%PARAM2%", "user"));
        if (!groupsOrUsers.isEmpty()) {
            for (Node userOrGroup : groupsOrUsers) {
                String searchPath = userOrGroup.getStringValue();
                String defaultName = this.getAccountDetails(searchPath);
                if (defaultName.length() <= 0) continue;
                accounts.add(defaultName);
            }
        } else {
            String groupXpath = xpathTemplate.replaceAll("%PARAM%", "group");
            groupsOrUsers = task.selectNodes(groupXpath);
            for (Node groupOrUser : groupsOrUsers) {
                String searchPath = groupOrUser.getStringValue();
                accounts.add(searchPath);
            }
        }
        return accounts;
    }

    private String getValueFromNode(Node node) {
        String value = "";
        if (node != null) {
            value = node.getStringValue();
        }
        return value;
    }

    private String getHTMLValueFromNode(Node node) {
        List nodesList;
        String value = "";
        if (node != null && (nodesList = ((Element)node).elements()) != null && nodesList.size() > 0) {
            value = ((Node)nodesList.get(0)).asXML();
        }
        return value;
    }

    private Document getHumanTaskDocument(TaskRunInfo taskRunInfo) {
        String htsValue;
        Document beplXMLDoc = null;
        ParameterValue[] paramValueArr = taskRunInfo.parameters();
        ParameterValue paramValue = ObjectModelUtil.findParameter((ParameterValue[])paramValueArr, (String)"hts");
        ParmValueItem[] valueItem = paramValue.getValue();
        if (paramValue != null && valueItem.length > 0 && (htsValue = ObjectModelUtil.getParameterValue((ParmValueItem)valueItem[0])) != null && htsValue.length() > 0) {
            try {
                beplXMLDoc = DocumentHelper.parseText((String)htsValue);
            }
            catch (DocumentException ex) {
                SDSLogger.getLogger((SDSCategory)ASVCategory.AUDIT).debug("cannot retrieve the human task document for preview: " + ex.getMessage());
            }
        }
        return beplXMLDoc;
    }

    private String getMessage(I18NCode msgCode) {
        return I18NUtil.getMessage((I18NCode)msgCode, (Locale)this.m_productLocale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAccountDetails(String searchPath) {
        String result = "";
        ContentManagerServiceClientPort cmPort = null;
        QueryRequest request = null;
        if (null != searchPath && searchPath.length() > 0) {
            request = new QueryRequest();
            request.setSearch(searchPath);
            request.setProperties(new PropEnum[]{PropEnum.defaultName});
        }
        if (null != request) {
            try {
                cmPort = Client.instance().getContentManagerServiceClient(this.m_headers);
                BaseClass reply = cmPort.query(request);
                if (reply != null) {
                    String name;
                    result = name = reply.getDefaultName().getValue();
                }
            }
            catch (SDKClientException e) {
                e.printStackTrace();
            }
            catch (EMFSecurityException e) {
                e.printStackTrace();
            }
            finally {
                if (cmPort != null) {
                    cmPort.close();
                }
            }
        }
        return result;
    }

    private String getTimeFor(String durationString) {
        Date date = null;
        try {
            if (this.m_dataTypeFactory == null) {
                this.m_dataTypeFactory = DatatypeFactory.newInstance();
            }
            Duration duration = this.m_dataTypeFactory.newDuration(durationString);
            Calendar cal = Calendar.getInstance();
            duration.addTo(cal);
            date = cal.getTime();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return date == null ? "" : date.toString();
    }
}

