/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.asv.util;

import com.cognos.asv.AgentServiceException;
import com.cognos.asv.i18n.AsvI18NCode;
import com.cognos.developer.schemas.bibus._3.SeverityEnum;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.soap.SOAPException;
import org.apache.axis.attachments.AttachmentPart;
import org.apache.commons.io.IOUtils;

public class ManagedAttachmentPart {
    private File m_temporaryFile;

    public ManagedAttachmentPart(AttachmentPart attachmentPart) throws AgentServiceException {
        this.processAttachmentPart(attachmentPart);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processAttachmentPart(AttachmentPart attachmentPart) throws AgentServiceException {
        FilterOutputStream bos = null;
        try {
            this.m_temporaryFile = File.createTempFile("ASV", ".att");
            this.m_temporaryFile.deleteOnExit();
            bos = new BufferedOutputStream(new FileOutputStream(this.m_temporaryFile));
            IOUtils.copy((InputStream)attachmentPart.getDataHandler().getInputStream(), (OutputStream)bos);
            bos.close();
            if (bos == null) return;
        }
        catch (SOAPException e) {
            try {
                if (this.m_temporaryFile != null) {
                    this.m_temporaryFile.delete();
                }
                throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e}, e, SeverityEnum.warn);
                catch (IOException e2) {
                    if (this.m_temporaryFile != null) {
                        this.m_temporaryFile.delete();
                    }
                    throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e2}, e2, SeverityEnum.warn);
                }
            }
            catch (Throwable throwable) {
                if (bos == null) throw throwable;
                try {
                    bos.close();
                    throw throwable;
                }
                catch (IOException e3) {
                    throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e3}, e3, SeverityEnum.info);
                }
            }
        }
        try {
            bos.close();
            return;
        }
        catch (IOException e) {
            throw new AgentServiceException(AsvI18NCode.MSG_ASV_GENERAL_ERROR, new Object[]{e}, e, SeverityEnum.info);
        }
    }

    public InputStream getInputStream() throws IOException {
        return new ManagedFileInputStream();
    }

    private class ManagedFileInputStream
    extends FileInputStream {
        public ManagedFileInputStream() throws IOException {
            super(ManagedAttachmentPart.this.m_temporaryFile);
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (ManagedAttachmentPart.this.m_temporaryFile != null) {
                ManagedAttachmentPart.this.m_temporaryFile.delete();
            }
        }
    }
}

